/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.translation.simulink;

import com.engisis.sysphs.language.simscape.SBranch;
import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SComponentReference;
import com.engisis.sysphs.language.simscape.SConnection;
import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SDomain;
import com.engisis.sysphs.language.simscape.SEquation;
import com.engisis.sysphs.language.simscape.SInput;
import com.engisis.sysphs.language.simscape.SLocation;
import com.engisis.sysphs.language.simscape.SMember;
import com.engisis.sysphs.language.simscape.SMemberAccess;
import com.engisis.sysphs.language.simscape.SMemberAssignment;
import com.engisis.sysphs.language.simscape.SMemberPath;
import com.engisis.sysphs.language.simscape.SNode;
import com.engisis.sysphs.language.simscape.SOutput;
import com.engisis.sysphs.language.simscape.SPackage;
import com.engisis.sysphs.language.simscape.SParameter;
import com.engisis.sysphs.language.simscape.SPhysicalBlock;
import com.engisis.sysphs.language.simscape.SPhysicalConnectionPoint;
import com.engisis.sysphs.language.simscape.SPhysicalLine;
import com.engisis.sysphs.language.simscape.SVariable;
import com.engisis.sysphs.language.simscape.SimscapeFactory;
import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SConnectionPoint;
import com.engisis.sysphs.language.simulink.SDataValue;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.simulink.SFContinuousStateVariable;
import com.engisis.sysphs.language.simulink.SFDWorkVariable;
import com.engisis.sysphs.language.simulink.SFDiscreteStateVariable;
import com.engisis.sysphs.language.simulink.SFInputVariable;
import com.engisis.sysphs.language.simulink.SFOutputVariable;
import com.engisis.sysphs.language.simulink.SFParameter;
import com.engisis.sysphs.language.simulink.SFVariable;
import com.engisis.sysphs.language.simulink.SFVariableAssignment;
import com.engisis.sysphs.language.simulink.SFunction1;
import com.engisis.sysphs.language.simulink.SFunction1Block;
import com.engisis.sysphs.language.simulink.SFunction2;
import com.engisis.sysphs.language.simulink.SFunction2Block;
import com.engisis.sysphs.language.simulink.SFunctionBlock;
import com.engisis.sysphs.language.simulink.SInport;
import com.engisis.sysphs.language.simulink.SInterface;
import com.engisis.sysphs.language.simulink.SLibrary;
import com.engisis.sysphs.language.simulink.SLine;
import com.engisis.sysphs.language.simulink.SModel;
import com.engisis.sysphs.language.simulink.SNamedElement;
import com.engisis.sysphs.language.simulink.SOutport;
import com.engisis.sysphs.language.simulink.SReference;
import com.engisis.sysphs.language.simulink.SSubsystem;
import com.engisis.sysphs.language.simulink.SSystem;
import com.engisis.sysphs.language.simulink.SSystemParameter;
import com.engisis.sysphs.language.simulink.SSystemParameterAssignment;
import com.engisis.sysphs.language.simulink.SimulinkFactory;
import com.engisis.sysphs.language.stateflow.SChart;
import com.engisis.sysphs.language.stateflow.SChartBlock;
import com.engisis.sysphs.language.stateflow.SChartSystem;
import com.engisis.sysphs.language.stateflow.SConnectNode;
import com.engisis.sysphs.language.stateflow.SData;
import com.engisis.sysphs.language.stateflow.SDataScope;
import com.engisis.sysphs.language.stateflow.SInstance;
import com.engisis.sysphs.language.stateflow.SJunction;
import com.engisis.sysphs.language.stateflow.SMachine;
import com.engisis.sysphs.language.stateflow.SState;
import com.engisis.sysphs.language.stateflow.SStateType;
import com.engisis.sysphs.language.stateflow.SStateflow;
import com.engisis.sysphs.language.stateflow.STarget;
import com.engisis.sysphs.language.stateflow.STransition;
import com.engisis.sysphs.language.stateflow.STreeNode;
import com.engisis.sysphs.language.stateflow.StateflowFactory;
import com.engisis.sysphs.serialization.simulink.SimulinkSerializer;
import com.engisis.sysphs.translation.simulink.ExpressionLanguageToMatlabTranslator;
import com.engisis.sysphs.translation.simulink.SimscapeUtil;
import com.engisis.sysphs.translation.simulink.SimulinkUtil;
import com.engisis.sysphs.util.Configuration;
import com.engisis.sysphs.util.ExpressionLanguageToSimulation;
import com.engisis.sysphs.util.SysMLToSimulationTranslator;
import com.engisis.sysphs.util.SysMLUtil;
import com.engisis.sysphs.util.UMLModelErrorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.VisibilityKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysMLToSimulinkTranslator
extends SysMLToSimulationTranslator {
    private static final Logger log = Logger.getLogger(SysMLToSimulinkTranslator.class);
    public static final String SF2_BLOCK_NAME = "block";
    private Hashtable<SysMLToSimulationTranslator.ReferenceKey, SElement> refs = new Hashtable();
    private Stack<SysMLToSimulationTranslator.ReferenceKey> toProcess = new Stack();
    private Stack<SysMLToSimulationTranslator.ReferenceKey> toProcessForConnectors = new Stack();
    private SModel smodel;
    private SLibrary slibrary;
    private SStateflow sstateflow;
    private SysMLUtil sysmlutil;
    private SPackage spackage;
    private SFunction sfmode = SFunction.Level2;
    private Domains domains = Domains.REUSE;
    private Format format = Format.XML;
    private ExpressionLanguageToMatlabTranslator el2m = new ExpressionLanguageToMatlabTranslator();

    public SysMLToSimulinkTranslator() {
    }

    public SysMLToSimulinkTranslator(Set<Object> options) {
        this.loadOptions(options);
    }

    @Override
    public void loadOptions(Set<Object> options) {
        super.loadOptions(options);
        if (options == null) {
            return;
        }
        block0: for (Object option : options) {
            for (SFunction sFunction : SFunction.values()) {
                if (!sFunction.equals(option)) continue;
                log.info("Option " + option + " recognized");
                this.sfmode = sFunction;
                continue block0;
            }
            for (Enum enum_ : Domains.values()) {
                if (!enum_.equals(option)) continue;
                log.info("Option " + option + " recognized");
                this.domains = enum_;
                continue block0;
            }
            for (Enum enum_ : Format.values()) {
                if (!enum_.equals(option)) continue;
                log.info("Option " + option + " recognized");
                this.format = enum_;
                continue block0;
            }
            log.error("Option " + option + " not recognized");
        }
    }

    @Override
    public Set<java.lang.Class<?>> getOptions() {
        HashSet res = new HashSet();
        res.add(SFunction.class);
        res.add(Domains.class);
        res.add(Format.class);
        return res;
    }

    @Override
    protected ExpressionLanguageToSimulation getExpressionTranslator() {
        return this.el2m;
    }

    @Override
    public void reset() {
        this.refs.clear();
        this.smodel = null;
        this.sstateflow = null;
        this.spackage = null;
        this.slibrary = null;
    }

    public TranslatedType getTranslatedType(NamedElement unamedelement) {
        if (unamedelement == null) {
            throw new IllegalArgumentException("A named element must be provided");
        }
        if (unamedelement.isStereotypeApplied(this.sysmlutil.getBlock()) || unamedelement.isStereotypeApplied(this.sysmlutil.getInterfaceBlock())) {
            Class uclass = (Class)unamedelement;
            if (this.sfmode == SFunction.Simscape && this.hasConservedVariable(uclass)) {
                return TranslatedType.DOMAIN;
            }
            List<Property> simprops = this.sysmlutil.getAllPhSProperties(uclass);
            if (simprops.size() == 0) {
                Behavior ubehavior = this.sysmlutil.getClassifierBehavior(uclass);
                if (ubehavior != null && ubehavior instanceof StateMachine) {
                    return TranslatedType.CHART;
                }
                int nbBindingConnectors = 0;
                boolean hasComponentGeneral = false;
                boolean hasInoutFlowProperty = false;
                int nbConstraintBlock = 0;
                for (Property uproperty : SysMLUtil.getAllCorrectedAttributes(uclass)) {
                    Type utype;
                    if (uproperty instanceof Port && uproperty.getType() instanceof Classifier && !hasInoutFlowProperty) {
                        List<Property> phsprops = this.sysmlutil.getAllPhSProperties((Classifier)uproperty.getType());
                        for (Property phsprop : phsprops) {
                            if ((EnumerationLiteral)phsprop.getValue(this.sysmlutil.getFlowProperty(), "direction") != this.sysmlutil.getFlowPropertyInout()) continue;
                            hasInoutFlowProperty = true;
                        }
                    }
                    if (!((utype = uproperty.getType()) instanceof Class) || !utype.isStereotypeApplied(this.sysmlutil.getConstraintBlock())) continue;
                    ++nbConstraintBlock;
                }
                TreeIterator<EObject> tieo = this.r.getAllContents();
                while (tieo.hasNext()) {
                    Class cl;
                    EObject eo = (EObject)tieo.next();
                    if (!(eo instanceof Namespace)) {
                        tieo.prune();
                        continue;
                    }
                    if (!(eo instanceof Class) || !(cl = (Class)eo).getGenerals().contains(uclass)) continue;
                    for (Property uproperty : cl.getAttributes()) {
                        if (!uproperty.getType().isStereotypeApplied(this.sysmlutil.getConstraintBlock())) continue;
                        ++nbConstraintBlock;
                    }
                }
                for (Classifier ugeneral : uclass.getGenerals()) {
                    if (this.getTranslatedType(ugeneral) != TranslatedType.COMPONENT) continue;
                    hasComponentGeneral = true;
                    break;
                }
                for (Connector uconnector : SysMLUtil.getAllConnectors(uclass)) {
                    if (!uconnector.isStereotypeApplied(this.sysmlutil.getBindingConnector())) continue;
                    ++nbBindingConnectors;
                }
                if (this.sfmode == SFunction.Simscape) {
                    if (nbConstraintBlock != 0 || nbBindingConnectors != 0 || hasComponentGeneral) {
                        return TranslatedType.COMPONENT;
                    }
                    return TranslatedType.SYSTEM;
                }
                return TranslatedType.SYSTEM;
            }
            if (simprops.size() == 1 && simprops.get(0).getType() instanceof DataType) {
                EnumerationLiteral lit = (EnumerationLiteral)simprops.get(0).getValue(this.sysmlutil.getFlowProperty(), "direction");
                if ("in".equals(lit.getName())) {
                    return TranslatedType.INPORT;
                }
                if ("out".equals(lit.getName())) {
                    return TranslatedType.OUTPORT;
                }
                log.warn("The simulink translator does not support inout flow properties in a non-Simscape mode");
            }
            log.warn("Can't translate a type that has several simproperties or not one simvariable:" + SysMLToSimulinkTranslator.print(unamedelement));
            return TranslatedType.NONE;
        }
        if (unamedelement.isStereotypeApplied(this.sysmlutil.getConstraintBlock())) {
            if (this.sfmode == SFunction.Simscape) {
                return TranslatedType.COMPONENT;
            }
            return TranslatedType.SFUNCTION;
        }
        if (unamedelement instanceof DataType && !Collections.disjoint(SysMLUtil.getAllCompatibleTypes((DataType)unamedelement), Arrays.asList(this.sysmlutil.getUMLBoolean(), this.sysmlutil.getUMLInteger(), this.sysmlutil.getUMLDouble(), this.sysmlutil.getSysMLBoolean(), this.sysmlutil.getSysMLInteger(), this.sysmlutil.getSysMLDouble()))) {
            return TranslatedType.DATATYPE;
        }
        return TranslatedType.NONE;
    }

    private boolean hasConservedVariable(Class uclass) {
        for (Property uproperty : this.sysmlutil.getAllPhSProperties(uclass)) {
            if (!(uproperty.getType() instanceof Class)) continue;
            Class utype = (Class)uproperty.getType();
            for (Property uproperty2 : SysMLUtil.getAllCorrectedAttributes(utype)) {
                if (!uproperty2.isStereotypeApplied(this.sysmlutil.getPhSVariable()) || !((Boolean)uproperty2.getValue(this.sysmlutil.getPhSVariable(), "isConserved")).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static TranslatedVertex getTranslatedVertex(Vertex uvertex) {
        if (uvertex instanceof State) {
            return TranslatedVertex.STATE;
        }
        if (uvertex instanceof Transition) {
            return TranslatedVertex.TRANSITION;
        }
        if (uvertex instanceof Pseudostate && ((Pseudostate)uvertex).getKind() == PseudostateKind.INITIAL_LITERAL) {
            return TranslatedVertex.INITIAL;
        }
        return TranslatedVertex.NONE;
    }

    private void init() {
        if (this.sfmode == SFunction.Simscape && this.domains == Domains.REUSE) {
            SimscapeUtil.mapDomains(this.r, this.refs);
        }
    }

    @Override
    public void execute(Class urootblock, Resource r, File outputdirectory) throws UMLModelErrorException, IOException {
        SElement selement;
        SysMLToSimulationTranslator.ReferenceKey rk;
        TranslatedType tt;
        if (urootblock == null) {
            throw new IllegalArgumentException("You must provide a root block");
        }
        if (r == null) {
            throw new IllegalArgumentException("You must provide a resouce");
        }
        this.r = r;
        this.init();
        log.debug("Starting translation, mode=" + (Object)((Object)this.format) + "/" + (Object)((Object)this.sfmode) + "/" + (Object)((Object)this.domains));
        this.sysmlutil = new SysMLUtil(r.getResourceSet());
        String urootblockname = SysMLUtil.getName(urootblock) + this.getModelNameSuffix();
        log.debug("Creating the root library");
        this.slibrary = SimulinkFactory.eINSTANCE.createSLibrary();
        String slibraryname = urootblockname + "Library";
        SimulinkUtil.setName(this.slibrary, slibraryname);
        SSystem slibrarysystem = SimulinkFactory.eINSTANCE.createSSystem();
        this.slibrary.setSystem(slibrarysystem);
        SimulinkUtil.setName(slibrarysystem, slibraryname);
        log.debug("Creating the root model");
        this.smodel = SimulinkFactory.eINSTANCE.createSModel();
        SimulinkUtil.setName(this.smodel, urootblockname);
        SSystem smodelsystem = SimulinkFactory.eINSTANCE.createSSystem();
        this.smodel.setSystem(smodelsystem);
        if (this.sfmode == SFunction.Simscape) {
            this.spackage = SimscapeFactory.eINSTANCE.createSPackage();
            SimulinkUtil.setName(this.spackage, slibraryname + this.getFileNameSuffix());
            this.spackage.setGenerated(true);
        }
        if ((tt = this.getTranslatedType(urootblock)) == TranslatedType.SYSTEM) {
            SysMLToSimulationTranslator.ReferenceKey rkmodelsystem = SysMLToSimulinkTranslator.getKey(urootblock);
            this.refs.put(rkmodelsystem, smodelsystem);
            this.toProcess.add(rkmodelsystem);
        } else if (tt == TranslatedType.COMPONENT) {
            this.createComponent(urootblock);
        } else {
            log.warn("Aborting generation, the root block is not a system not a chart: " + (Object)((Object)tt));
            return;
        }
        if (urootblock.getVisibility() != VisibilityKind.PUBLIC_LITERAL) {
            log.warn("Aborting generation, the root block is not public");
            return;
        }
        this.sstateflow = StateflowFactory.eINSTANCE.createSStateflow();
        SMachine smachine = StateflowFactory.eINSTANCE.createSMachine();
        this.sstateflow.setMachine(smachine);
        smachine.setID();
        SimulinkUtil.setName(smachine, slibraryname);
        STarget starget = StateflowFactory.eINSTANCE.createSTarget();
        starget.setOwningMachine(smachine);
        starget.setID();
        while (this.toProcess.size() != 0) {
            rk = this.toProcess.pop();
            log.debug("Treating " + SysMLToSimulinkTranslator.print(rk));
            selement = this.refs.get(rk);
            if (selement == null) {
                throw new IllegalStateException("Unable to process an element that is not referenced: " + SysMLToSimulinkTranslator.print(rk));
            }
            if (selement instanceof SChartSystem) {
                this.processChartSystem((Class)rk.getKey()[0]);
                this.toProcessForConnectors.push(rk);
                continue;
            }
            if (selement instanceof SComponent) {
                SComponent scomponent = this.processComponent((Class)rk.getKey()[0]);
                if (rk.getKey()[0].isStereotypeApplied(this.sysmlutil.getConstraintBlock())) continue;
                scomponent.setOwningPackage(this.spackage);
                continue;
            }
            if (selement instanceof SDomain) {
                this.processDomain((Class)rk.getKey()[0]).setOwningPackage(this.spackage);
                continue;
            }
            if (selement instanceof SFunction1) {
                this.processSFunction1((Class)rk.getKey()[0], (Class)rk.getKey()[1], (Property)rk.getKey()[2]);
                this.toProcessForConnectors.add(rk);
                continue;
            }
            if (selement instanceof SFunction2) {
                this.processSFunction2((Class)rk.getKey()[0], (Class)rk.getKey()[1], (Property)rk.getKey()[2]);
                this.toProcessForConnectors.add(rk);
                continue;
            }
            if (selement instanceof SSystem) {
                this.processSystem((Class)rk.getKey()[0]);
                this.toProcessForConnectors.push(rk);
                continue;
            }
            if (selement instanceof STreeNode) {
                this.processRegion2((Class)rk.getKey()[0], (Region)rk.getKey()[1]);
                continue;
            }
            log.warn("Unprocessed element: " + selement);
        }
        while (this.toProcessForConnectors.size() != 0) {
            rk = this.toProcessForConnectors.pop();
            log.debug("Treating " + SysMLToSimulinkTranslator.print(rk));
            selement = this.refs.get(rk);
            if (selement instanceof SComponent) {
                this.processComponent2((Class)rk.getKey()[0]);
                continue;
            }
            if (selement instanceof SFunction1) {
                this.processSFunction12((Class)rk.getKey()[0], (Class)rk.getKey()[1], (Property)rk.getKey()[2]);
                continue;
            }
            if (selement instanceof SFunction2) {
                this.processSFunction22((Class)rk.getKey()[0], (Class)rk.getKey()[1], (Property)rk.getKey()[2]);
                continue;
            }
            if (!(selement instanceof SSystem)) continue;
            this.processSystemForConnectors((Class)rk.getKey()[0]);
        }
        if (tt == TranslatedType.COMPONENT) {
            SComponent sc1 = this.createComponent(urootblock);
            sc1.setHidden(false);
            SPhysicalBlock spb1 = SimscapeFactory.eINSTANCE.createSPhysicalBlock();
            spb1.setOwningSystem(smodelsystem);
            SimulinkUtil.setName(spb1, sc1.getName().toLowerCase());
            spb1.setComponent(sc1);
            spb1.setSID();
            SNode sn1 = null;
            if (sc1.getNodes().size() == 0) {
                if (sc1.getOwnedConnections().size() == 0) {
                    log.error("Couldn't find an connection in the root component");
                    return;
                }
                SNamedElement scopiednode = null;
                SConnection scopiedconn = null;
                block2: for (SConnection sconn : sc1.getOwnedConnections()) {
                    for (SMemberPath smp : sconn.getPoints()) {
                        SMember sml;
                        EList<SMember> path = smp.getPath();
                        if (path.size() == 0 || !((sml = (SMember)path.get(path.size() - 1)) instanceof SNode)) continue;
                        scopiednode = (SNode)sml;
                        scopiedconn = sconn;
                        break block2;
                    }
                }
                if (scopiednode == null) {
                    log.error("Couldn't find an internal node to copy in the root component");
                    return;
                }
                sn1 = SimscapeFactory.eINSTANCE.createSNode();
                sc1.getOwnedMembers().add(sn1);
                SimulinkUtil.setName(sn1, scopiednode.getName());
                sn1.setDomain(((SNode)scopiednode).getDomain());
                sn1.setLocation(SLocation.LEFT);
                SysMLToSimulinkTranslator.createConnectionPortBlock(sn1, SLocation.LEFT).setOwningSystem(sc1);
                SMemberPath smp = SimscapeFactory.eINSTANCE.createSMemberPath();
                smp.getPath().add(sn1);
                scopiedconn.getPoints().add(smp);
            } else {
                sn1 = sc1.getNodes().get(0);
            }
            SConnectionPortBlock scpb1 = sn1.getConnectionPortBlock();
            SComponent sc2 = SimscapeFactory.eINSTANCE.createSComponent();
            sc2.setOwningPackage(this.spackage);
            SimulinkUtil.setName(sc2, sn1.getDomain().getName() + "Dummy");
            sc2.setHidden(false);
            SNode sn2 = SimscapeFactory.eINSTANCE.createSNode();
            sc2.getOwnedMembers().add(sn2);
            SimulinkUtil.setName(sn2, sn1.getName());
            sn2.setDomain(sn1.getDomain());
            sn2.setLocation(SLocation.LEFT);
            SConnectionPortBlock scpb2 = SysMLToSimulinkTranslator.createConnectionPortBlock(sn2, SLocation.LEFT);
            scpb2.setOwningSystem(sc2);
            for (SVariable svar : sn1.getDomain().getVariables()) {
                SVariable svar2;
                if (!svar.isBalancing()) {
                    svar2 = SimscapeFactory.eINSTANCE.createSVariable();
                    sc2.getOwnedMembers().add(svar2);
                    SimulinkUtil.setName(svar2, svar.getName());
                    svar2.setUnit(svar.getUnit());
                    SEquation seq = SimscapeFactory.eINSTANCE.createSEquation();
                    seq.setExpression(svar2.getName() + "==" + sn2.getName() + "." + svar.getName());
                    sc2.getOwnedEquations().add(seq);
                    continue;
                }
                svar2 = SimscapeFactory.eINSTANCE.createSVariable();
                sc2.getOwnedMembers().add(svar2);
                SimulinkUtil.setName(svar2, svar.getName());
                svar2.setUnit(svar.getUnit());
                SBranch sbranch = SimscapeFactory.eINSTANCE.createSBranch();
                sbranch.setVariable(svar2);
                SMemberPath smp = SimscapeFactory.eINSTANCE.createSMemberPath();
                smp.getPath().add(sn1);
                smp.getPath().add(svar);
                sbranch.setFrom(smp);
                sc2.getBranches().add(sbranch);
                SEquation seq = SimscapeFactory.eINSTANCE.createSEquation();
                seq.setExpression(svar2.getName() + "==0");
                sc2.getOwnedEquations().add(seq);
            }
            SPhysicalBlock spb2 = SimscapeFactory.eINSTANCE.createSPhysicalBlock();
            spb2.setOwningSystem(smodelsystem);
            SimulinkUtil.setName(spb2, sc2.getName().toLowerCase());
            spb2.setComponent(sc2);
            spb2.setSID();
            SPhysicalLine spl = SimscapeFactory.eINSTANCE.createSPhysicalLine();
            SPhysicalConnectionPoint spcp1 = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
            spcp1.setBlock(spb1);
            spcp1.setPort(scpb1);
            SPhysicalConnectionPoint spcp2 = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
            spcp2.setBlock(spb2);
            spcp2.setPort(scpb2);
            spl.getPoints().add(spcp1);
            spl.getPoints().add(spcp2);
            smodelsystem.getOwnedLines().add(spl);
        }
        block5: for (SLine sl : smodelsystem.getOwnedLines()) {
            if (!(sl instanceof SPhysicalLine)) continue;
            SPhysicalLine spl = (SPhysicalLine)sl;
            for (SPhysicalConnectionPoint spc : new ArrayList<SPhysicalConnectionPoint>(spl.getPoints())) {
                if (spc.getPort() == null) continue;
                SPhysicalBlock spb = SimscapeFactory.eINSTANCE.createSPhysicalBlock();
                spb.setOwningSystem(smodelsystem);
                SimulinkUtil.setName(spb, SimscapeUtil.getSolverConfiguration().getName());
                spb.setComponent(SimscapeUtil.getSolverConfiguration());
                spb.setSID();
                SPhysicalConnectionPoint spc2 = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
                spc2.setBlock(spb);
                spc2.setPort(SimscapeUtil.getSolverConfiguration().getRConnectionPorts().get(0));
                spl.getPoints().add(spc2);
                break block5;
            }
        }
        SimulinkSerializer ss = new SimulinkSerializer();
        if (outputdirectory != null) {
            this.outputfilename = ss.serialize(outputdirectory.getAbsolutePath(), this.smodel, this.slibrary, this.sstateflow, this.spackage, this.format);
        } else {
            String dir = r.getURI().trimFileExtension().trimSegments(1).toFileString();
            this.outputfilename = ss.serialize(dir, this.smodel, this.slibrary, this.sstateflow, this.spackage, this.format);
        }
    }

    private SSystem createSystem(Class ublock) {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(ublock);
        SElement selement = this.refs.get(rk);
        if (selement != null) {
            if (selement instanceof SSystem) {
                return (SSystem)selement;
            }
            throw new IllegalArgumentException("The element " + SysMLToSimulinkTranslator.print(rk) + " should be a system: " + selement.getClass());
        }
        log.debug("Creating system " + SysMLToSimulinkTranslator.print(rk));
        SSystem ssystem = SimulinkFactory.eINSTANCE.createSSystem();
        if (!ublock.isStereotypeApplied(this.sysmlutil.getSimulinkBlock())) {
            SSubsystem ssubsystem = SimulinkFactory.eINSTANCE.createSSubsystem();
            ssubsystem.setSystem(ssystem);
            ssubsystem.setOwningSystem(this.slibrary.getSystem());
            ssubsystem.setSID();
        }
        this.refs.put(rk, ssystem);
        this.toProcess.add(rk);
        return ssystem;
    }

    private SChartSystem createChartSystem(Class ublock) {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(ublock);
        SElement selement = this.refs.get(rk);
        if (selement != null) {
            if (selement instanceof SChartSystem) {
                return (SChartSystem)selement;
            }
            throw new IllegalArgumentException("The element " + SysMLToSimulinkTranslator.print(rk) + " should be a chart system: " + selement.getClass());
        }
        log.debug("Creating chart system " + SysMLToSimulinkTranslator.print(rk));
        SChartSystem schartsystem = StateflowFactory.eINSTANCE.createSChartSystem();
        SChartBlock ssubsystem = StateflowFactory.eINSTANCE.createSChartBlock();
        ssubsystem.setSystem(schartsystem);
        ssubsystem.setOwningSystem(this.slibrary.getSystem());
        ssubsystem.setSID();
        this.refs.put(rk, schartsystem);
        this.toProcess.add(rk);
        this.createChart(ublock, (StateMachine)this.sysmlutil.getClassifierBehavior(ublock));
        return schartsystem;
    }

    private SBlock createBlock(Class ublock, Property uproperty) {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(ublock, uproperty);
        SElement selement = this.refs.get(rk);
        if (selement != null) {
            if (!(selement instanceof SBlock)) {
                throw new IllegalArgumentException("The element " + SysMLToSimulinkTranslator.print(rk) + " should be a block: " + selement.getClass());
            }
            return (SBlock)selement;
        }
        if (uproperty.getVisibility() != VisibilityKind.PUBLIC_LITERAL) {
            log.warn("Skipping non-public property " + SysMLToSimulinkTranslator.print(uproperty));
            return null;
        }
        boolean conjugated = uproperty instanceof Port && ((Port)uproperty).isConjugated();
        Type utype = uproperty.getType();
        if (utype == null) {
            log.warn("Skipping property " + SysMLToSimulinkTranslator.print(uproperty) + " because it has no type");
            return null;
        }
        SBlock sblock = null;
        switch (this.getTranslatedType(utype)) {
            case SYSTEM: {
                if (utype.isStereotypeApplied(this.sysmlutil.getSimulinkBlock())) {
                    SInterface sinterface = SimulinkFactory.eINSTANCE.createSInterface();
                    sinterface.setSystem(this.createSystem((Class)utype));
                    sblock = sinterface;
                    break;
                }
                SReference sreference = SimulinkFactory.eINSTANCE.createSReference();
                sreference.setSystem(this.createSystem((Class)utype));
                sblock = sreference;
                break;
            }
            case CHART: {
                SReference sreference = SimulinkFactory.eINSTANCE.createSReference();
                sreference.setSystem(this.createChartSystem((Class)utype));
                sblock = sreference;
                break;
            }
            case SFUNCTION: {
                SFunctionBlock sfunctionblock;
                if (this.sfmode == SFunction.Level1) {
                    sfunctionblock = SimulinkFactory.eINSTANCE.createSFunction1Block();
                    ((SFunction1Block)sfunctionblock).setSfunction(this.createSFunction1((Class)utype, ublock, uproperty));
                    sblock = sfunctionblock;
                    break;
                }
                sfunctionblock = SimulinkFactory.eINSTANCE.createSFunction2Block();
                ((SFunction2Block)sfunctionblock).setSfunction(this.createSFunction2((Class)utype, ublock, uproperty));
                sblock = sfunctionblock;
                break;
            }
            case INPORT: {
                SOutport soutport;
                SConnectionPortBlock scpb;
                if (this.sfmode == SFunction.Simscape) {
                    scpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
                    scpb.setComponent(SimscapeUtil.getConnectionPortComponent());
                    if (conjugated) {
                        scpb.setLocation(SLocation.RIGHT);
                    } else {
                        scpb.setLocation(SLocation.LEFT);
                    }
                    sblock = scpb;
                    break;
                }
                if (conjugated) {
                    soutport = SimulinkFactory.eINSTANCE.createSOutport();
                    soutport.setUnit(this.getUnitFromType(this.sysmlutil.getAllPhSProperties((Classifier)utype).get(0).getType()));
                    sblock = soutport;
                    break;
                }
                SInport sinport = SimulinkFactory.eINSTANCE.createSInport();
                sinport.setUnit(this.getUnitFromType(this.sysmlutil.getAllPhSProperties((Classifier)utype).get(0).getType()));
                sblock = sinport;
                break;
            }
            case OUTPORT: {
                SInport sinport;
                SConnectionPortBlock scpb;
                if (this.sfmode == SFunction.Simscape) {
                    scpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
                    scpb.setComponent(SimscapeUtil.getConnectionPortComponent());
                    if (conjugated) {
                        scpb.setLocation(SLocation.LEFT);
                    } else {
                        scpb.setLocation(SLocation.RIGHT);
                    }
                    sblock = scpb;
                    break;
                }
                if (conjugated) {
                    sinport = SimulinkFactory.eINSTANCE.createSInport();
                    sinport.setUnit(this.getUnitFromType(this.sysmlutil.getAllPhSProperties((Classifier)utype).get(0).getType()));
                    sblock = sinport;
                    break;
                }
                SOutport soutport = SimulinkFactory.eINSTANCE.createSOutport();
                soutport.setUnit(this.getUnitFromType(this.sysmlutil.getAllPhSProperties((Classifier)utype).get(0).getType()));
                sblock = soutport;
                break;
            }
            case DATATYPE: {
                if (uproperty.isStereotypeApplied(this.sysmlutil.getPhSConstant()) && uproperty.getDefaultValue() != null || uproperty.isStereotypeApplied(this.sysmlutil.getPhSVariable())) break;
                log.warn("Skipping datatype property " + SysMLToSimulinkTranslator.print(rk));
                break;
            }
            case COMPONENT: {
                SPhysicalBlock sphysicalblock = SimscapeFactory.eINSTANCE.createSPhysicalBlock();
                SComponent scomponent = this.createComponent((Class)uproperty.getType());
                sphysicalblock.setComponent(scomponent);
                SimulinkUtil.setName(sphysicalblock, SysMLUtil.getName(uproperty));
                sblock = sphysicalblock;
                break;
            }
            case DOMAIN: {
                break;
            }
            case NONE: {
                log.warn("Skipping property " + SysMLToSimulinkTranslator.print(rk) + " because the type is not supported");
                break;
            }
        }
        if (sblock != null) {
            Object o;
            log.debug("Creating block " + SysMLToSimulinkTranslator.print(rk));
            String name = SysMLUtil.getName(uproperty);
            if (uproperty.isStereotypeApplied(this.sysmlutil.getSimulinkPort()) && (o = uproperty.getValue(this.sysmlutil.getSimulinkPort(), "name")) != null) {
                name = o.toString();
            }
            SimulinkUtil.setName(sblock, name);
            this.refs.put(rk, sblock);
        }
        return sblock;
    }

    private SFunction1 createSFunction1(Class ublock, Class ccontext, Property pcontext) {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(ublock, ccontext, pcontext);
        SElement selement = this.refs.get(rk);
        if (selement != null) {
            if (selement instanceof SFunction1) {
                return (SFunction1)selement;
            }
            throw new IllegalArgumentException("The element corresponding to " + SysMLToSimulinkTranslator.print(rk) + " is supposed to be a S-Function");
        }
        SFunction1 sfunction = SimulinkFactory.eINSTANCE.createSFunction1();
        log.debug("Creating sfunction " + SysMLToSimulinkTranslator.print(rk));
        this.refs.put(rk, sfunction);
        this.toProcess.push(rk);
        return sfunction;
    }

    private SFunction2 createSFunction2(Class ublock, Class ccontext, Property pcontext) {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(ublock, ccontext, pcontext);
        SElement selement = this.refs.get(rk);
        if (selement != null) {
            if (selement instanceof SFunction2) {
                return (SFunction2)selement;
            }
            throw new IllegalArgumentException("The element corresponding to " + SysMLToSimulinkTranslator.print(rk) + " is supposed to be a S-Function");
        }
        SFunction2 sfunction = SimulinkFactory.eINSTANCE.createSFunction2();
        log.debug("Creating sfunction " + SysMLToSimulinkTranslator.print(rk));
        this.refs.put(rk, sfunction);
        this.toProcess.push(rk);
        return sfunction;
    }

    private SFVariable createVariable(Class ublock, Property uproperty, Class ccontext, Property pcontext) throws UMLModelErrorException {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(ublock, uproperty, ccontext, pcontext);
        SElement selement = this.refs.get(rk);
        if (selement != null) {
            if (!(selement instanceof SFVariable)) {
                throw new IllegalArgumentException("Expecting a variable: " + selement.getClass());
            }
            return (SFVariable)selement;
        }
        SFVariable sv = null;
        for (Connector uconnector : SysMLUtil.getAllConnectors(ccontext)) {
            if (!uconnector.isStereotypeApplied(this.sysmlutil.getBindingConnector())) continue;
            ConnectorEnd uend1 = (ConnectorEnd)uconnector.getEnds().get(0);
            ConnectorEnd uend2 = (ConnectorEnd)uconnector.getEnds().get(1);
            List<Property> lprop1 = this.sysmlutil.getCorrectedPropertyPath(uend1, ccontext);
            List<Property> lprop2 = this.sysmlutil.getCorrectedPropertyPath(uend2, ccontext);
            List<Property> lblock = null;
            List<Property> lfunction = null;
            if (lprop1.size() == 2 && lprop1.get(0) == pcontext && lprop1.get(1) == uproperty) {
                lfunction = lprop1;
                lblock = lprop2;
            }
            if (lprop2.size() == 2 && lprop2.get(0) == pcontext && lprop2.get(1) == uproperty) {
                lfunction = lprop2;
                lblock = lprop1;
            }
            if (lblock == null || lfunction == null) continue;
            if (lblock.size() == 1) {
                Property ubound = lblock.get(0);
                if (ubound.isStereotypeApplied(this.sysmlutil.getPhSVariable())) {
                    if (((Boolean)ubound.getValue(this.sysmlutil.getPhSVariable(), "isContinuous")).booleanValue()) {
                        SFContinuousStateVariable scsv = SimulinkFactory.eINSTANCE.createSFContinuousStateVariable();
                        if (ubound.getDefaultValue() != null) {
                            scsv.getValue().add(this.getValue(ubound.getDefaultValue()));
                        } else {
                            log.warn("The property " + SysMLToSimulinkTranslator.print(ubound) + " should have a default value");
                        }
                        log.debug("Creating continuous variable " + SysMLToSimulinkTranslator.print(rk));
                        sv = scsv;
                    } else {
                        SFDiscreteStateVariable sdsv = SimulinkFactory.eINSTANCE.createSFDiscreteStateVariable();
                        if (ubound.getDefaultValue() != null) {
                            sdsv.getValue().add(this.getValue(ubound.getDefaultValue()));
                        } else {
                            log.warn("The property " + SysMLToSimulinkTranslator.print(ubound) + " should have a default value");
                        }
                        log.debug("Creating discrete variable " + SysMLToSimulinkTranslator.print(rk));
                        sv = sdsv;
                    }
                } else if (ubound.isStereotypeApplied(this.sysmlutil.getPhSConstant())) {
                    SFParameter sp = SimulinkFactory.eINSTANCE.createSFParameter();
                    if (ubound.getDefaultValue() == null) {
                        SDoubleValue sdv = SimulinkFactory.eINSTANCE.createSDoubleValue();
                        sdv.setValue(0.0);
                        sp.getValue().add(sdv);
                    } else {
                        sp.getValue().add(this.getValue(ubound.getDefaultValue()));
                    }
                    log.debug("Creating parameter " + SysMLToSimulinkTranslator.print(rk));
                    sv = sp;
                } else {
                    log.warn("Skipping property " + SysMLToSimulinkTranslator.print(uproperty) + " as it is not in, out, continuous, or discrete");
                }
            } else if (lblock.size() == 2) {
                SBlock so;
                SBlock sblock = this.createBlock(ccontext, lfunction.get(0));
                if (!(sblock instanceof SFunctionBlock)) {
                    log.warn("Skipping " + SysMLToSimulinkTranslator.print(uproperty) + " as an s-function can't be found");
                    continue;
                }
                SFunctionBlock sfb = (SFunctionBlock)sblock;
                sblock = this.createBlock(ccontext, lblock.get(0));
                if (sblock == null) {
                    log.warn("Skipping " + SysMLToSimulinkTranslator.print(uproperty) + " as an inport/outport can't be found");
                    continue;
                }
                if (sblock instanceof SInport) {
                    SFInputVariable siv = SimulinkFactory.eINSTANCE.createSFInputVariable();
                    log.debug("Creating input variable " + SysMLToSimulinkTranslator.print(rk));
                    sv = siv;
                    so = (SInport)sblock;
                    siv.setInport((SInport)so);
                    siv.setDirectFeedthrough(false);
                    sfb.getInports().add((SInport)so);
                } else if (sblock instanceof SOutport) {
                    SFOutputVariable sov = SimulinkFactory.eINSTANCE.createSFOutputVariable();
                    log.debug("Creating output variable " + SysMLToSimulinkTranslator.print(rk));
                    sv = sov;
                    so = (SOutport)sblock;
                    sov.setOutport((SOutport)so);
                    sfb.getOutports().add((SOutport)so);
                } else {
                    log.warn("Unexpected block type: " + sblock);
                }
            } else {
                log.warn("Can't support this number of nested properties");
            }
            if (sv == null) continue;
            SimulinkUtil.setName(sv, SysMLUtil.getName(uproperty));
            if (uproperty.isStereotypeApplied(this.sysmlutil.getMultidimensionalElement()) && uproperty.getValue(this.sysmlutil.getMultidimensionalElement(), "dimension") instanceof List) {
                List dims = (List)uproperty.getValue(this.sysmlutil.getMultidimensionalElement(), "dimension");
                if (dims.size() > 2) {
                    throw new UMLModelErrorException(this.r, "The property can't have more than 2 dimensions " + SysMLToSimulinkTranslator.print(uproperty));
                }
                for (int i = 0; i < dims.size(); ++i) {
                    if (!(dims.get(i) instanceof Integer)) continue;
                    sv.getDimensions().add((Integer)dims.get(i));
                }
            }
            this.refs.put(rk, sv);
            return sv;
        }
        SFDWorkVariable sdw = SimulinkFactory.eINSTANCE.createSFDWorkVariable();
        sv = sdw;
        SimulinkUtil.setName(sv, SysMLUtil.getName(uproperty));
        if (uproperty.isStereotypeApplied(this.sysmlutil.getMultidimensionalElement()) && uproperty.getValue(this.sysmlutil.getMultidimensionalElement(), "dimension") instanceof List) {
            List dims = (List)uproperty.getValue(this.sysmlutil.getMultidimensionalElement(), "dimension");
            if (dims.size() > 2) {
                throw new UMLModelErrorException(this.r, "The property can't have more than 2 dimensions " + SysMLToSimulinkTranslator.print(uproperty));
            }
            for (int i = 0; i < dims.size(); ++i) {
                if (!(dims.get(i) instanceof Integer)) continue;
                sv.getDimensions().add((Integer)dims.get(i));
            }
        }
        this.refs.put(rk, sv);
        return sv;
    }

    private SComponent createComponent(Class ublock) {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(ublock);
        SElement selement = this.refs.get(rk);
        if (selement != null) {
            if (selement instanceof SComponent) {
                return (SComponent)selement;
            }
            throw new IllegalStateException("The element correspinding to " + SysMLToSimulinkTranslator.print(ublock) + " is not a component: " + selement.getClass());
        }
        log.debug("Creating component " + SysMLToSimulinkTranslator.print(rk));
        SComponent scomponent = SimscapeFactory.eINSTANCE.createSComponent();
        this.refs.put(rk, scomponent);
        this.toProcess.push(rk);
        return scomponent;
    }

    private SDomain createDomain(Class ublock) {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(ublock);
        SElement selement = this.refs.get(rk);
        if (selement != null) {
            if (selement instanceof SDomain) {
                return (SDomain)selement;
            }
            throw new IllegalStateException("The element corresponding to " + SysMLToSimulinkTranslator.print(ublock) + " is not a domain: " + selement.getClass());
        }
        SDomain sdomain = null;
        if (this.domains == Domains.CREATE) {
            sdomain = SimscapeFactory.eINSTANCE.createSDomain();
            this.refs.put(rk, sdomain);
            this.toProcess.push(rk);
        } else {
            selement = this.refs.get(SysMLToSimulinkTranslator.getKey(this.sysmlutil.getAllPhSProperties(ublock).get(0).getType()));
            if (selement == null || !(selement instanceof SDomain)) {
                log.debug("Creating domain " + SysMLToSimulinkTranslator.print(rk));
                sdomain = SimscapeFactory.eINSTANCE.createSDomain();
                this.refs.put(rk, sdomain);
                this.toProcess.push(rk);
            } else {
                sdomain = (SDomain)selement;
                this.refs.put(rk, sdomain);
            }
        }
        return sdomain;
    }

    private SMember createMember(Property uproperty) throws UMLModelErrorException {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(uproperty);
        SElement selement = this.refs.get(rk);
        if (selement != null) {
            if (selement instanceof SMember) {
                return (SMember)selement;
            }
            throw new IllegalStateException("The element corresponding to " + SysMLToSimulinkTranslator.print(uproperty) + " is not a member: " + selement.getClass());
        }
        SMember smember = null;
        Type utype = uproperty.getType();
        if (utype.isStereotypeApplied(this.sysmlutil.getConstraintBlock())) {
            log.info("Skipping constraint block property" + SysMLToSimulinkTranslator.print(uproperty));
            return null;
        }
        boolean conjugated = uproperty instanceof Port && ((Port)uproperty).isConjugated();
        ValueSpecification vs = uproperty.getDefaultValue();
        String su = this.getUnitFromType(utype);
        TranslatedType tt = this.getTranslatedType(utype);
        switch (tt) {
            case SYSTEM: 
            case COMPONENT: {
                SComponentReference scomponentreference = SimscapeFactory.eINSTANCE.createSComponentReference();
                SComponent scomponent = this.createComponent((Class)utype);
                scomponentreference.setComponent(scomponent);
                scomponentreference.setHidden(true);
                smember = scomponentreference;
                break;
            }
            case DOMAIN: {
                SNode snode = SimscapeFactory.eINSTANCE.createSNode();
                SDomain sdomain = this.createDomain((Class)utype);
                snode.setDomain(sdomain);
                smember = snode;
                break;
            }
            case INPORT: {
                Property simprop = this.sysmlutil.getAllPhSProperties((Class)utype).get(0);
                su = this.getUnitFromType(simprop.getType());
                if (conjugated) {
                    SOutput soutput = SimscapeFactory.eINSTANCE.createSOutput();
                    if (vs != null) {
                        SDataValue sv = this.getValue(vs);
                        soutput.setValue(sv);
                    }
                    if (su != null) {
                        soutput.setUnit(su);
                    }
                    smember = soutput;
                    break;
                }
                SInput sinput = SimscapeFactory.eINSTANCE.createSInput();
                if (vs != null) {
                    SDataValue sv = this.getValue(vs);
                    sinput.setValue(sv);
                }
                if (su != null) {
                    sinput.setUnit(su);
                }
                smember = sinput;
                break;
            }
            case OUTPORT: {
                Property simprop = this.sysmlutil.getAllPhSProperties((Class)utype).get(0);
                su = this.getUnitFromType(simprop.getType());
                if (conjugated) {
                    SInput sinput = SimscapeFactory.eINSTANCE.createSInput();
                    if (vs != null) {
                        SDataValue sv = this.getValue(vs);
                        sinput.setValue(sv);
                    }
                    if (su != null) {
                        sinput.setUnit(su);
                    }
                    smember = sinput;
                    break;
                }
                SOutput soutput = SimscapeFactory.eINSTANCE.createSOutput();
                if (vs != null) {
                    SDataValue sv = this.getValue(vs);
                    soutput.setValue(sv);
                }
                if (su != null) {
                    soutput.setUnit(su);
                }
                smember = soutput;
                break;
            }
            case DATATYPE: {
                SDataValue sv;
                if (uproperty.isStereotypeApplied(this.sysmlutil.getPhSConstant())) {
                    SParameter sparameter = SimscapeFactory.eINSTANCE.createSParameter();
                    if (vs != null) {
                        SDataValue sv2 = this.getValue(vs);
                        sparameter.setValue(sv2);
                    }
                    if (su != null) {
                        sparameter.setUnit(su);
                    }
                    smember = sparameter;
                    break;
                }
                if (uproperty.isStereotypeApplied(this.sysmlutil.getPhSVariable())) {
                    if (!((Boolean)uproperty.getValue(this.sysmlutil.getPhSVariable(), "isContinuous")).booleanValue()) {
                        log.warn("Don't know how to handle discrete variables, skippig");
                        return null;
                    }
                    SVariable svariable = SimscapeFactory.eINSTANCE.createSVariable();
                    if (((Boolean)uproperty.getValue(this.sysmlutil.getPhSVariable(), "isConserved")).booleanValue() && this.sysmlutil.isSimBlock(uproperty.getClass_())) {
                        svariable.setBalancing(true);
                    }
                    if (vs != null) {
                        SDataValue sv3 = this.getValue(vs);
                        svariable.setValue(sv3);
                    }
                    if (su != null) {
                        svariable.setUnit(su);
                        log.info("SETTING UNIT " + su + " TO " + uproperty.getName());
                    }
                    smember = svariable;
                    break;
                }
                SVariable svariable = SimscapeFactory.eINSTANCE.createSVariable();
                if (vs != null && !((sv = this.getValue(vs)) instanceof SExpressionValue)) {
                    svariable.setValue(sv);
                }
                if (su != null) {
                    svariable.setUnit(su);
                    log.info("SETTING UNIT " + su + " TO " + svariable.getName());
                }
                smember = svariable;
                break;
            }
            default: {
                log.warn("Member " + SysMLToSimulinkTranslator.print(uproperty) + " skipped as " + SysMLToSimulinkTranslator.print(utype) + " can't be a component, domain, or datatype: " + tt.name());
            }
        }
        if (smember != null) {
            SimulinkUtil.setName(smember, SysMLUtil.getName(uproperty));
            if (uproperty.getVisibility() == VisibilityKind.PUBLIC_LITERAL) {
                smember.setAccess(SMemberAccess.PUBLIC);
            } else if (uproperty.getVisibility() == VisibilityKind.PROTECTED_LITERAL) {
                smember.setAccess(SMemberAccess.PROTECTED);
            }
            smember.setHidden(false);
            this.refs.put(rk, smember);
        } else {
            log.warn("Skipping property " + SysMLToSimulinkTranslator.print(uproperty));
        }
        return smember;
    }

    private SSystem processSystem(Class ublock) {
        Object o;
        log.debug("Processing system " + SysMLToSimulinkTranslator.print(ublock));
        SSystem ssystem = this.createSystem(ublock);
        String name = SysMLUtil.getName(ublock);
        if (ublock.isStereotypeApplied(this.sysmlutil.getSimulinkBlock()) && (o = ublock.getValue(this.sysmlutil.getSimulinkBlock(), "name")) != null) {
            name = o.toString();
        }
        SimulinkUtil.setName(ssystem, name);
        SSubsystem ssubsystem = ssystem.getOwningSubsystem();
        if (ssubsystem != null) {
            SimulinkUtil.setName(ssubsystem, name);
        }
        ArrayList<Property> uproperties = new ArrayList<Property>(SysMLUtil.getAllCorrectedAttributes(ublock));
        for (Property uproperty : uproperties) {
            SBlock sblock;
            Type utype = uproperty.getType();
            String upropertyname = SysMLUtil.getName(uproperty);
            if (utype != null && utype.isStereotypeApplied(this.sysmlutil.getInterfaceBlock()) && utype instanceof Class) {
                log.info("Processing InterfaceBlock" + SysMLToSimulinkTranslator.print(utype));
                for (Operation uoperation : ((Class)utype).getAllOperations()) {
                    SysMLToSimulationTranslator.ReferenceKey key;
                    if (!uoperation.isStereotypeApplied(this.sysmlutil.getDirectedFeature())) continue;
                    EnumerationLiteral direction = (EnumerationLiteral)uoperation.getValue(this.sysmlutil.getDirectedFeature(), "featureDirection");
                    String uoperationname = SysMLUtil.getName(uoperation);
                    if (direction.getName().equals("required")) {
                        key = SysMLToSimulinkTranslator.getKey(ublock, uproperty, uoperation);
                        SInport sinport = SimulinkFactory.eINSTANCE.createSInport();
                        sinport.setOwningSystem(ssystem);
                        SimulinkUtil.setName(sinport, upropertyname + "_" + uoperationname + "_required");
                        sinport.setSID();
                        this.refs.put(key, sinport);
                        continue;
                    }
                    if (direction.getName().equals("provided")) {
                        key = SysMLToSimulinkTranslator.getKey(ublock, uproperty, uoperation);
                        SOutport soutport = SimulinkFactory.eINSTANCE.createSOutport();
                        soutport.setOwningSystem(ssystem);
                        SimulinkUtil.setName(soutport, upropertyname + "_" + uoperationname + "_provided");
                        soutport.setSID();
                        this.refs.put(key, soutport);
                        continue;
                    }
                    log.warn("Provided+required features not implemented: " + SysMLToSimulinkTranslator.print(uproperty));
                }
            }
            if (ublock.isStereotypeApplied(this.sysmlutil.getSimulinkBlock())) {
                if (uproperty.isStereotypeApplied(this.sysmlutil.getSimulinkParameter())) {
                    SSystemParameter SFParameter2 = SimulinkFactory.eINSTANCE.createSSystemParameter();
                    Object o2 = uproperty.getValue(this.sysmlutil.getSimulinkParameter(), "name");
                    if (o2 == null) {
                        SimulinkUtil.setName(SFParameter2, upropertyname);
                    } else {
                        SimulinkUtil.setName(SFParameter2, o2.toString());
                    }
                    o2 = uproperty.getValue(this.sysmlutil.getSimulinkParameter(), "value");
                    if (o2 != null) {
                        Object of = null;
                        if (this.sysmlutil.getSimulinkParameter().getAttribute("format", null) != null) {
                            of = uproperty.getValue(this.sysmlutil.getSimulinkParameter(), "format");
                        }
                        String f = of == null ? "%s" : of.toString();
                        f = f.replaceAll("%s", o2.toString());
                        SExpressionValue sev = SimulinkFactory.eINSTANCE.createSExpressionValue();
                        sev.setValue(f);
                        SFParameter2.setValue(sev);
                    }
                    this.refs.put(SysMLToSimulinkTranslator.getKey(ublock, uproperty), SFParameter2);
                    ssystem.getSystemparameters().add(SFParameter2);
                    continue;
                }
                if (!uproperty.isStereotypeApplied(this.sysmlutil.getSimulinkPort())) {
                    log.info("Skipping non-SimulationPort " + SysMLToSimulinkTranslator.print(uproperty));
                    continue;
                }
            }
            if ((sblock = this.createBlock(ublock, uproperty)) != null) {
                log.info("Adding " + sblock.getName() + " to " + ssystem.getName());
                sblock.setOwningSystem(ssystem);
                sblock.setSID();
                continue;
            }
            if (uproperty.isStereotypeApplied(this.sysmlutil.getPhSConstant())) {
                log.info("Constant " + SysMLToSimulinkTranslator.print(SysMLToSimulinkTranslator.getKey(ublock, uproperty)) + " identified");
                continue;
            }
            log.warn("Block " + SysMLToSimulinkTranslator.print(SysMLToSimulinkTranslator.getKey(ublock, uproperty)) + " not added");
        }
        return ssystem;
    }

    private SChartSystem processChartSystem(Class ublock) throws UMLModelErrorException {
        log.debug("Processing chart system " + SysMLToSimulinkTranslator.print(ublock));
        SChartSystem schartsystem = this.createChartSystem(ublock);
        this.processSystem(ublock);
        SFunction1Block sf1block = SimulinkFactory.eINSTANCE.createSFunction1Block();
        sf1block.setName(" SFunction ");
        sf1block.setOwningSystem(schartsystem);
        sf1block.setSID();
        SFunction1 sf1 = SimulinkFactory.eINSTANCE.createSFunction1();
        sf1.setName("sf_sfun");
        sf1block.setSfunction(sf1);
        SChart chart = (SChart)this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, this.sysmlutil.getClassifierBehavior(ublock)));
        for (SBlock sb : schartsystem.getOwnedBlocks()) {
            SConnectionPoint pt;
            SLine line;
            if (sb instanceof SInport) {
                SInport inport = SimulinkFactory.eINSTANCE.createSInport();
                inport.setOwningSystem(sf1);
                line = schartsystem.getLine(sb, null);
                pt = SimulinkFactory.eINSTANCE.createSConnectionPoint();
                pt.setBlock(sf1block);
                pt.setPort(inport);
                line.getDestinations().add(pt);
                SData indata = StateflowFactory.eINSTANCE.createSData();
                indata.setOwningTreeNode(chart);
                SimulinkUtil.setName(indata, ((SInport)sb).getName());
                indata.setMachine(chart.getOwningMachine());
                indata.setID();
                indata.setScope(SDataScope.INPUT);
                continue;
            }
            if (!(sb instanceof SOutport)) continue;
            SOutport outport = SimulinkFactory.eINSTANCE.createSOutport();
            outport.setOwningSystem(sf1);
            line = schartsystem.getLine(sf1block, outport);
            pt = SimulinkFactory.eINSTANCE.createSConnectionPoint();
            pt.setBlock(sb);
            line.getDestinations().add(pt);
            SData outdata = StateflowFactory.eINSTANCE.createSData();
            outdata.setOwningTreeNode(chart);
            SimulinkUtil.setName(outdata, ((SOutport)sb).getName());
            outdata.setMachine(chart.getOwningMachine());
            outdata.setID();
            outdata.setScope(SDataScope.OUTPUT);
        }
        for (Property uproperty : SysMLUtil.getAllCorrectedAttributes(ublock)) {
            if (!uproperty.isStereotypeApplied(this.sysmlutil.getPhSConstant())) continue;
            String upropertyname = SysMLUtil.getName(uproperty);
            log.info("Constant " + upropertyname + " added to state machine");
            SData constant = StateflowFactory.eINSTANCE.createSData();
            constant.setOwningTreeNode(chart);
            SimulinkUtil.setName(constant, upropertyname);
            constant.setMachine(chart.getOwningMachine());
            constant.setID();
            constant.setScope(SDataScope.CONSTANT);
            if (uproperty.getDefaultValue() != null) {
                constant.setValue(this.getValue(uproperty.getDefaultValue()));
                continue;
            }
            SDoubleValue sdv = SimulinkFactory.eINSTANCE.createSDoubleValue();
            sdv.setValue(0.0);
            constant.setValue(sdv);
        }
        if (schartsystem.getInports().size() == 0) {
            SInport inground = SimulinkFactory.eINSTANCE.createSInport();
            inground.setOwningSystem(sf1);
            SInterface ground = SimulinkFactory.eINSTANCE.createSInterface();
            ground.setName(" Ground ");
            SSystem grounds = SimulinkFactory.eINSTANCE.createSSystem();
            grounds.setName("Ground");
            SimulinkFactory.eINSTANCE.createSInport().setOwningSystem(grounds);
            SimulinkFactory.eINSTANCE.createSOutport().setOwningSystem(grounds);
            ground.setSystem(grounds);
            ground.setOwningSystem(schartsystem);
            ground.setSID();
            SLine sline = schartsystem.getLine(ground, null);
            SConnectionPoint scp = SimulinkFactory.eINSTANCE.createSConnectionPoint();
            scp.setBlock(sf1block);
            scp.setPort(inground);
            sline.getDestinations().add(scp);
        }
        SOutport outterm = SimulinkFactory.eINSTANCE.createSOutport();
        outterm.setOwningSystem(sf1);
        SInterface demux = SimulinkFactory.eINSTANCE.createSInterface();
        demux.setName(" Demux ");
        SSystem demuxs = SimulinkFactory.eINSTANCE.createSSystem();
        demuxs.setName("Demux");
        SimulinkFactory.eINSTANCE.createSInport().setOwningSystem(demuxs);
        SimulinkFactory.eINSTANCE.createSOutport().setOwningSystem(demuxs);
        demux.setSystem(demuxs);
        SSystemParameter demuxoutput = SimulinkFactory.eINSTANCE.createSSystemParameter();
        demuxoutput.setName("Outputs");
        SExpressionValue demuxoutputv = SimulinkFactory.eINSTANCE.createSExpressionValue();
        demuxoutputv.setValue("1");
        demuxoutput.setValue(demuxoutputv);
        demuxs.getSystemparameters().add(demuxoutput);
        demux.setOwningSystem(schartsystem);
        demux.setSID();
        SLine line1 = schartsystem.getLine(sf1block, outterm);
        SConnectionPoint pt1 = SimulinkFactory.eINSTANCE.createSConnectionPoint();
        pt1.setBlock(demux);
        line1.getDestinations().add(pt1);
        SInterface terminator = SimulinkFactory.eINSTANCE.createSInterface();
        terminator.setName(" Terminator ");
        SSystem terminators = SimulinkFactory.eINSTANCE.createSSystem();
        terminators.setName("Terminator");
        SimulinkFactory.eINSTANCE.createSInport().setOwningSystem(terminators);
        terminator.setSystem(terminators);
        terminator.setOwningSystem(schartsystem);
        terminator.setSID();
        SLine line2 = schartsystem.getLine(demux, null);
        SConnectionPoint pt2 = SimulinkFactory.eINSTANCE.createSConnectionPoint();
        pt2.setBlock(terminator);
        line2.getDestinations().add(pt2);
        return schartsystem;
    }

    private SSystem processSystemForConnectors(Class ublock) throws UMLModelErrorException {
        log.debug("Processing system for connectors " + SysMLToSimulinkTranslator.print(ublock));
        SSystem ssystem = this.createSystem(ublock);
        for (Property uproperty : SysMLUtil.getAllCorrectedAttributes(ublock)) {
            SElement selement = this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, uproperty));
            ValueSpecification vs = uproperty.getDefaultValue();
            if (vs == null || !(vs instanceof InstanceValue) || ((InstanceValue)vs).getInstance() == null) continue;
            for (Slot uslot : ((InstanceValue)vs).getInstance().getSlots()) {
                SElement sassignment;
                StructuralFeature sf = uslot.getDefiningFeature();
                SElement o = this.refs.get(SysMLToSimulinkTranslator.getKey(uproperty.getType(), sf));
                if (o == null) {
                    log.warn("No reference for object defined by " + SysMLToSimulinkTranslator.print(uproperty.getType()) + " and " + SysMLToSimulinkTranslator.print(sf));
                }
                if (selement instanceof SInterface && o instanceof SSystemParameter) {
                    SSystemParameter SFParameter2 = (SSystemParameter)o;
                    sassignment = SimulinkFactory.eINSTANCE.createSSystemParameterAssignment();
                    ((SSystemParameterAssignment)sassignment).setParameter(SFParameter2);
                    SDataValue sdv = this.getValue(uslot);
                    if (sdv != null) {
                        ((SSystemParameterAssignment)sassignment).setValue(sdv);
                    }
                    ((SInterface)selement).getAssignments().add((SSystemParameterAssignment)sassignment);
                    continue;
                }
                o = this.refs.get(SysMLToSimulinkTranslator.getKey(sf));
                if (o == null) {
                    log.warn("The initial value of " + sf.getQualifiedName() + " in " + SysMLToSimulinkTranslator.print(ublock) + " was skipped, no reference for " + SysMLToSimulinkTranslator.print(sf));
                    continue;
                }
                if (selement instanceof SPhysicalBlock && o instanceof SMember) {
                    if (uslot.isStereotypeApplied(this.sysmlutil.getInitialValueReference()) && uslot.getValue(this.sysmlutil.getInitialValueReference(), "propertyPath") instanceof List) {
                        List references = (List)uslot.getValue(this.sysmlutil.getInitialValueReference(), "propertyPath");
                        if (references.size() != 1) continue;
                        SMember sm = (SMember)o;
                        SMemberAssignment sassignment2 = SimscapeFactory.eINSTANCE.createSMemberAssignment();
                        sassignment2.getMemberPath().add(sm);
                        SExpressionValue val = SimulinkFactory.eINSTANCE.createSExpressionValue();
                        val.setValue(SysMLUtil.getName((NamedElement)references.get(0)));
                        sassignment2.setAssignedValue(val);
                        ((SPhysicalBlock)selement).getAssignments().add(sassignment2);
                        continue;
                    }
                    if (uslot.getValues().size() == 1) {
                        SMember sm = (SMember)o;
                        sassignment = SimscapeFactory.eINSTANCE.createSMemberAssignment();
                        ((SMemberAssignment)sassignment).getMemberPath().add(sm);
                        ((SMemberAssignment)sassignment).setAssignedValue(this.getValue((ValueSpecification)uslot.getValues().get(0)));
                        ((SPhysicalBlock)selement).getAssignments().add((SMemberAssignment)sassignment);
                        continue;
                    }
                    log.warn("Can't assign an array to " + ((SPhysicalBlock)selement).getName() + "." + ((SMember)o).getName());
                    continue;
                }
                log.warn("The initial value of " + sf.getQualifiedName() + " in " + SysMLToSimulinkTranslator.print(ublock) + " was skipped, types:" + selement.getClass() + " and " + o.getClass());
            }
        }
        for (Connector uconnector : SysMLUtil.getAllConnectors(ublock)) {
            ConnectorEnd uend1 = (ConnectorEnd)uconnector.getEnds().get(0);
            ConnectorEnd uend2 = (ConnectorEnd)uconnector.getEnds().get(1);
            List<Property> lprop1 = this.sysmlutil.getCorrectedPropertyPath(uend1, ublock);
            List<Property> lprop2 = this.sysmlutil.getCorrectedPropertyPath(uend2, ublock);
            if (uconnector.isStereotypeApplied(this.sysmlutil.getBindingConnector())) {
                SElement se2;
                SElement se1;
                SSystemParameter ssp;
                SInterface si;
                SDataValue sdv;
                if (lprop1.size() == 2 && lprop1.get(0).getType().isStereotypeApplied(this.sysmlutil.getSimulinkBlock()) && lprop1.get(1).isStereotypeApplied(this.sysmlutil.getSimulinkParameter())) {
                    sdv = this.getValue(lprop2.get(0).getDefaultValue());
                    if (sdv != null) {
                        si = (SInterface)this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, lprop1.get(0)));
                        ssp = (SSystemParameter)this.refs.get(SysMLToSimulinkTranslator.getKey(lprop1.get(0).getType(), lprop1.get(1)));
                        SSystemParameterAssignment sspa = SimulinkFactory.eINSTANCE.createSSystemParameterAssignment();
                        sspa.setParameter(ssp);
                        sspa.setValue(sdv);
                        si.getAssignments().add(sspa);
                    } else {
                        log.warn("Couldn't assign parameter value");
                    }
                }
                if (lprop2.size() == 2 && lprop2.get(0).getType().isStereotypeApplied(this.sysmlutil.getSimulinkBlock()) && lprop2.get(1).isStereotypeApplied(this.sysmlutil.getSimulinkParameter())) {
                    sdv = this.getValue(lprop1.get(0).getDefaultValue());
                    if (sdv != null) {
                        si = (SInterface)this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, lprop2.get(0)));
                        ssp = (SSystemParameter)this.refs.get(SysMLToSimulinkTranslator.getKey(lprop2.get(0).getType(), lprop2.get(1)));
                        SSystemParameterAssignment sspa = SimulinkFactory.eINSTANCE.createSSystemParameterAssignment();
                        sspa.setParameter(ssp);
                        sspa.setValue(sdv);
                        si.getAssignments().add(sspa);
                    } else {
                        log.warn("Couldn't assign parameter value");
                    }
                }
                if (lprop1.size() == 1 && lprop1.get(0).isStereotypeApplied(this.sysmlutil.getPhSConstant()) && lprop2.size() == 2) {
                    sdv = this.getValue(lprop1.get(0).getDefaultValue());
                    se1 = this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, lprop2.get(0)));
                    se2 = this.refs.get(SysMLToSimulinkTranslator.getKey(lprop2.get(1)));
                    if (se1 instanceof SPhysicalBlock && se2 instanceof SParameter) {
                        SMemberAssignment sma = SimscapeFactory.eINSTANCE.createSMemberAssignment();
                        sma.getMemberPath().add((SMember)se2);
                        sma.setAssignedValue(sdv);
                        ((SPhysicalBlock)se1).getAssignments().add(sma);
                    }
                }
                if (lprop2.size() != 1 || !lprop2.get(0).isStereotypeApplied(this.sysmlutil.getPhSConstant()) || lprop1.size() != 2) continue;
                sdv = this.getValue(lprop2.get(0).getDefaultValue());
                se1 = this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, lprop1.get(0)));
                se2 = this.refs.get(SysMLToSimulinkTranslator.getKey(lprop1.get(1)));
                if (!(se1 instanceof SPhysicalBlock) || !(se2 instanceof SParameter)) continue;
                SMemberAssignment sma = SimscapeFactory.eINSTANCE.createSMemberAssignment();
                sma.getMemberPath().add((SMember)se2);
                sma.setAssignedValue(sdv);
                ((SPhysicalBlock)se1).getAssignments().add(sma);
                continue;
            }
            if (lprop1.size() > 2 || lprop2.size() > 2) {
                log.warn("Connector " + SysMLToSimulinkTranslator.print(uconnector) + " skipped as its ends must have 1 or 2 properties");
                continue;
            }
            if (lprop1.size() == 2 && lprop2.size() == 2) {
                Type type1 = lprop1.get(1).getType();
                Type type2 = lprop2.get(1).getType();
                if (type1.isStereotypeApplied(this.sysmlutil.getInterfaceBlock()) && type2.isStereotypeApplied(this.sysmlutil.getInterfaceBlock())) {
                    log.debug("Connection between two interfaces block found: " + SysMLToSimulinkTranslator.print(uconnector));
                    SBlock sb1 = (SBlock)this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, lprop1.get(0)));
                    SBlock sb2 = (SBlock)this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, lprop2.get(0)));
                    block3: for (Operation uop1 : ((Class)type1).getAllOperations()) {
                        for (Operation uop2 : ((Class)type2).getAllOperations()) {
                            SElement e2;
                            if (!uop1.getName().equals(uop2.getName()) || uop1.getType() != uop2.getType()) continue;
                            log.debug("Matching operations: " + uop1.getName());
                            SBlock srcblock = null;
                            SOutport srcport = null;
                            SBlock dstblock = null;
                            SInport dstport = null;
                            SElement e1 = this.refs.get(SysMLToSimulinkTranslator.getKey(lprop1.get(0).getType(), lprop1.get(1), uop1));
                            if (e1 instanceof SOutport) {
                                srcblock = sb1;
                                srcport = (SOutport)e1;
                            }
                            if (e1 instanceof SInport) {
                                dstblock = sb1;
                                dstport = (SInport)e1;
                            }
                            if ((e2 = this.refs.get(SysMLToSimulinkTranslator.getKey(lprop2.get(0).getType(), lprop2.get(1), uop2))) instanceof SOutport) {
                                srcblock = sb2;
                                srcport = (SOutport)e2;
                            }
                            if (e2 instanceof SInport) {
                                dstblock = sb2;
                                dstport = (SInport)e2;
                            }
                            if (srcport == null || dstport == null || dstblock == null || srcblock == null) continue;
                            log.debug("Adding line between " + srcblock.getName() + "/" + srcport.getName() + " and " + dstblock.getName() + "/" + dstport.getName());
                            SLine sline = ssystem.getLine(srcblock, srcport);
                            SConnectionPoint sdestination = SimulinkFactory.eINSTANCE.createSConnectionPoint();
                            sline.getDestinations().add(sdestination);
                            sdestination.setBlock(dstblock);
                            sdestination.setPort(dstport);
                            continue block3;
                        }
                    }
                }
            }
            ArrayList<Object> lspcp = new ArrayList<Object>();
            for (List lp : new List[]{lprop1, lprop2}) {
                SBlock sport;
                SElement sb = this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, (Element)lp.get(0)));
                if (sb instanceof SPhysicalBlock) {
                    SPhysicalConnectionPoint spcp;
                    SPhysicalBlock spb = (SPhysicalBlock)sb;
                    if (lp.size() > 1) {
                        SMember sm = (SMember)this.refs.get(SysMLToSimulinkTranslator.getKey((Element)lp.get(1)));
                        if (sm != null) {
                            spcp = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
                            spcp.setBlock(spb);
                            spcp.setPort(sm.getConnectionPortBlock());
                            lspcp.add(spcp);
                        } else {
                            log.warn("Can't find member corresponding to " + SysMLToSimulinkTranslator.print((Element)lp.get(1)));
                        }
                    } else {
                        SComponent sc = spb.getComponent();
                        if (sc != null && sc.getOwnedMembers().size() > 0) {
                            spcp = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
                            spcp.setBlock(spb);
                            spcp.setPort(((SMember)sc.getOwnedMembers().get(0)).getConnectionPortBlock());
                            lspcp.add(spcp);
                        } else {
                            log.warn("No component in physical block or no member in the component");
                        }
                    }
                }
                if (lp.size() <= 1 || !(sb instanceof SReference) || !((sport = this.createBlock((Class)((Property)lp.get(0)).getType(), (Property)lp.get(1))) instanceof SConnectionPortBlock)) continue;
                SPhysicalConnectionPoint spcp = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
                spcp.setBlock((SBlock)sb);
                spcp.setPort((SConnectionPortBlock)sport);
                lspcp.add(spcp);
            }
            if (lspcp.size() == 2) {
                SPhysicalConnectionPoint spc0 = (SPhysicalConnectionPoint)lspcp.get(0);
                SPhysicalConnectionPoint spc1 = (SPhysicalConnectionPoint)lspcp.get(1);
                log.debug("Adding physical line between " + spc0.getBlock().getName() + "/" + spc0.getPort().getName() + " and " + spc1.getBlock().getName() + "/" + spc1.getPort().getName());
                SysMLToSimulinkTranslator.addPhysicalLine(ssystem, spc0, spc1);
                continue;
            }
            SNamedElement srcblock = null;
            SNamedElement srcport = null;
            SBlock dstblock = null;
            SNamedElement dstport = null;
            SPhysicalLine splin = null;
            SPhysicalLine splout = null;
            for (List lp : new List[]{lprop1, lprop2}) {
                SBlock sblock = this.createBlock(ublock, (Property)lp.get(0));
                if (sblock instanceof SInport) {
                    srcblock = sblock;
                    continue;
                }
                if (sblock instanceof SOutport) {
                    dstblock = sblock;
                    continue;
                }
                if (((Property)lp.get(0)).isStereotypeApplied(this.sysmlutil.getPhSConstant()) && ((Property)lp.get(0)).getDefaultValue() != null) {
                    srcblock = sblock;
                    continue;
                }
                if (((Property)lp.get(0)).isStereotypeApplied(this.sysmlutil.getPhSVariable())) {
                    dstblock = sblock;
                    continue;
                }
                if (lp.size() == 2) {
                    if (sblock instanceof SReference || sblock instanceof SInterface || sblock instanceof SSubsystem) {
                        SBlock sport = this.createBlock((Class)((Property)lp.get(0)).getType(), (Property)lp.get(1));
                        if (sport instanceof SOutport) {
                            srcblock = sblock;
                            srcport = sport;
                            continue;
                        }
                        if (!(sport instanceof SInport)) continue;
                        dstblock = sblock;
                        dstport = sport;
                        continue;
                    }
                    if (sblock instanceof SPhysicalBlock) {
                        SPhysicalConnectionPoint scp2;
                        SPhysicalConnectionPoint scp1;
                        SPhysicalBlock spb;
                        SMember smember = this.createMember((Property)lp.get(1));
                        if (smember instanceof SInput) {
                            spb = SimscapeFactory.eINSTANCE.createSPhysicalBlock();
                            SimulinkUtil.setName(spb, spb.getSID());
                            spb.setComponent(SimscapeUtil.getSimulink2PS());
                            scp1 = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
                            scp1.setBlock(spb);
                            scp1.setPort(SimscapeUtil.getSimulink2PS().getRConnectionPorts().get(0));
                            scp2 = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
                            scp2.setBlock((SPhysicalBlock)sblock);
                            scp2.setPort(smember.getConnectionPortBlock());
                            splin = SimscapeFactory.eINSTANCE.createSPhysicalLine();
                            splin.getPoints().add(scp1);
                            splin.getPoints().add(scp2);
                            dstblock = spb;
                            dstport = spb.getComponent().getInports().get(0);
                            continue;
                        }
                        if (!(smember instanceof SOutput)) continue;
                        spb = SimscapeFactory.eINSTANCE.createSPhysicalBlock();
                        SimulinkUtil.setName(spb, spb.getSID());
                        spb.setComponent(SimscapeUtil.getPS2Simulink());
                        scp1 = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
                        scp1.setBlock(spb);
                        scp1.setPort(SimscapeUtil.getPS2Simulink().getLConnectionPorts().get(0));
                        scp2 = SimscapeFactory.eINSTANCE.createSPhysicalConnectionPoint();
                        scp2.setBlock((SPhysicalBlock)sblock);
                        scp2.setPort(smember.getConnectionPortBlock());
                        splout = SimscapeFactory.eINSTANCE.createSPhysicalLine();
                        splout.getPoints().add(scp1);
                        splout.getPoints().add(scp2);
                        srcblock = spb;
                        srcport = spb.getComponent().getOutports().get(0);
                        continue;
                    }
                    log.warn("Block type not supported: " + sblock.getClass());
                    continue;
                }
                log.warn("The connector " + SysMLToSimulinkTranslator.print(uconnector) + " is problematic");
            }
            if (srcblock == null || dstblock == null) {
                log.info("null==" + srcblock + "/" + srcport + "--" + dstblock + "/" + dstport);
            }
            if (srcblock != null && dstblock != null) {
                log.debug("Adding line between " + srcblock.getName() + "/" + (srcport == null ? "" : srcport.getName()) + " and " + dstblock.getName() + "/" + (dstport == null ? "" : dstport.getName()));
                SLine sline = ssystem.getLine((SBlock)srcblock, (SBlock)srcport);
                SConnectionPoint sdestination = SimulinkFactory.eINSTANCE.createSConnectionPoint();
                sline.getDestinations().add(sdestination);
                sdestination.setBlock(dstblock);
                sdestination.setPort((SBlock)dstport);
                if (srcblock instanceof SPhysicalBlock) {
                    ((SBlock)srcblock).setOwningSystem(ssystem);
                    ((SBlock)srcblock).setSID();
                }
                if (dstblock instanceof SPhysicalBlock) {
                    dstblock.setOwningSystem(ssystem);
                    dstblock.setSID();
                }
                if (splin != null) {
                    ssystem.getOwnedLines().add(splin);
                }
                if (splout != null) {
                    ssystem.getOwnedLines().add(splout);
                }
                if (ssystem.getOwnedLines().contains(sline)) continue;
                ssystem.getOwnedLines().add(sline);
                continue;
            }
            log.warn("Connector " + SysMLToSimulinkTranslator.print(uconnector) + " skipped because it does not connect compatible elements");
        }
        return ssystem;
    }

    private static void addPhysicalLine(SSystem ssystem, SPhysicalConnectionPoint spc0, SPhysicalConnectionPoint spc1) {
        int i = 0;
        SPhysicalLine spline = null;
        SPhysicalConnectionPoint scpconsolidate = null;
        while (i != ssystem.getOwnedLines().size()) {
            SLine sline = (SLine)ssystem.getOwnedLines().get(i);
            if (sline instanceof SPhysicalLine) {
                SPhysicalLine spline2 = (SPhysicalLine)sline;
                if (spline2.getPoints().contains(scpconsolidate)) {
                    for (SPhysicalConnectionPoint spcp : spline2.getPoints()) {
                        if (spcp.equals(scpconsolidate)) continue;
                        spline.getPoints().add(spcp);
                    }
                    ssystem.getOwnedLines().remove(i);
                    continue;
                }
                for (SPhysicalConnectionPoint spc : spline2.getPoints()) {
                    if (spc.equals(spc0)) {
                        spline = spline2;
                        spline.getPoints().add(spc1);
                        scpconsolidate = spc1;
                        break;
                    }
                    if (!spc.equals(spc1)) continue;
                    spline = spline2;
                    spline.getPoints().add(spc0);
                    scpconsolidate = spc0;
                    break;
                }
            }
            ++i;
        }
        if (spline == null) {
            spline = SimscapeFactory.eINSTANCE.createSPhysicalLine();
            spline.getPoints().add(spc0);
            spline.getPoints().add(spc1);
            ssystem.getOwnedLines().add(spline);
        }
    }

    private SFunction1 processSFunction1(Class ublock, Class ccontext, Property pcontext) throws UMLModelErrorException {
        SConnectionPoint scp;
        SLine sline;
        log.debug("Processing s-function " + SysMLToSimulinkTranslator.print(ublock));
        SFunction1 sfunction = this.createSFunction1(ublock, ccontext, pcontext);
        String name = SysMLUtil.getName(ccontext) + "_" + SysMLUtil.getName(pcontext) + "_" + SysMLUtil.getName(ublock);
        SimulinkUtil.setName(sfunction, name);
        for (Property uproperty : SysMLUtil.getAllCorrectedAttributes(ublock)) {
            SFVariable SFVariable2 = this.createVariable(ublock, uproperty, ccontext, pcontext);
            if (SFVariable2 != null) {
                log.debug("Adding variable " + SysMLToSimulinkTranslator.print(uproperty));
                sfunction.getVariables().add(SFVariable2);
                continue;
            }
            log.warn("Skipping variable " + SysMLToSimulinkTranslator.print(uproperty));
        }
        SFunction1Block sfb = (SFunction1Block)this.refs.get(SysMLToSimulinkTranslator.getKey(ccontext, pcontext));
        SSystem ssys = sfb.getOwningSystem();
        List<SFInputVariable> liv = sfunction.getInputs();
        List<SFOutputVariable> lov = sfunction.getOutputs();
        if (liv != null) {
            SInterface mux = null;
            if (liv.size() > 1) {
                mux = SimulinkFactory.eINSTANCE.createSInterface();
                mux.setOwningSystem(ssys);
                SimulinkUtil.setName(mux, sfunction.getName() + "Mux");
                SSystem smux = SimulinkFactory.eINSTANCE.createSSystem();
                SimulinkUtil.setName(smux, "Mux");
                mux.setSystem(smux);
                SSystemParameter sinputs = SimulinkFactory.eINSTANCE.createSSystemParameter();
                smux.getSystemparameters().add(sinputs);
                sinputs.setName("Inputs");
                SExpressionValue sinputsv = SimulinkFactory.eINSTANCE.createSExpressionValue();
                sinputsv.setValue(String.valueOf(liv.size()));
                sinputs.setValue(sinputsv);
                sline = ssys.getLine(mux, null);
                scp = SimulinkFactory.eINSTANCE.createSConnectionPoint();
                scp.setBlock(sfb);
                sline.getDestinations().add(scp);
            }
            for (int i = 0; i < liv.size(); ++i) {
                SFInputVariable SFInputVariable2 = liv.get(i);
                SInport sinport = SFInputVariable2.getInport();
                if (sinport == null) continue;
                sline = ssys.getLine(sinport, null);
                scp = SimulinkFactory.eINSTANCE.createSConnectionPoint();
                if (mux == null) {
                    scp.setBlock(sfb);
                } else {
                    scp.setBlock(mux);
                    SInport sin = SimulinkFactory.eINSTANCE.createSInport();
                    sin.setOwningSystem(mux.getSystem());
                    scp.setPort(sin);
                }
                sline.getDestinations().add(scp);
            }
        }
        if (lov != null) {
            SInterface demux = null;
            if (lov.size() > 1) {
                demux = SimulinkFactory.eINSTANCE.createSInterface();
                demux.setOwningSystem(ssys);
                SimulinkUtil.setName(demux, sfunction.getName() + "Demux");
                SSystem sdemux = SimulinkFactory.eINSTANCE.createSSystem();
                SimulinkUtil.setName(sdemux, "Demux");
                demux.setSystem(sdemux);
                SSystemParameter soutputs = SimulinkFactory.eINSTANCE.createSSystemParameter();
                SimulinkUtil.setName(soutputs, "Outputs");
                SExpressionValue soutputsv = SimulinkFactory.eINSTANCE.createSExpressionValue();
                soutputsv.setValue(String.valueOf(lov.size()));
                soutputs.setValue(soutputsv);
                sdemux.getSystemparameters().add(soutputs);
                sline = ssys.getLine(sfb, null);
                scp = SimulinkFactory.eINSTANCE.createSConnectionPoint();
                scp.setBlock(demux);
                sline.getDestinations().add(scp);
            }
            for (int i = 0; i < lov.size(); ++i) {
                SFOutputVariable SFOutputVariable2 = lov.get(i);
                SOutport soutport = SFOutputVariable2.getOutport();
                if (soutport == null) continue;
                if (demux == null) {
                    sline = ssys.getLine(sfb, null);
                    scp = SimulinkFactory.eINSTANCE.createSConnectionPoint();
                    scp.setBlock(soutport);
                    sline.getDestinations().add(scp);
                    continue;
                }
                SOutport sout = SimulinkFactory.eINSTANCE.createSOutport();
                sout.setOwningSystem(demux.getSystem());
                SLine sline2 = ssys.getLine(demux, sout);
                SConnectionPoint scp2 = SimulinkFactory.eINSTANCE.createSConnectionPoint();
                scp2.setBlock(soutport);
                sline2.getDestinations().add(scp2);
            }
        }
        return sfunction;
    }

    private SFunction1 processSFunction12(Class ublock, Class ccontext, Property pcontext) throws UMLModelErrorException {
        log.debug("Processing s-function " + SysMLToSimulinkTranslator.print(ublock) + " a second time");
        SFunction1 sfunction = this.createSFunction1(ublock, ccontext, pcontext);
        Hashtable<String, String> substitutionsLHS = new Hashtable<String, String>();
        Hashtable<String, String> substitutionsRHS = new Hashtable<String, String>();
        List<SFInputVariable> inputs = sfunction.getInputs();
        List<SFContinuousStateVariable> cvariables = sfunction.getContinuousStates();
        List<SFDiscreteStateVariable> dvariables = sfunction.getDiscreteStates();
        List<SFOutputVariable> outputs = sfunction.getOutputs();
        ArrayList<SFContinuousStateVariable> variables = new ArrayList<SFContinuousStateVariable>(cvariables);
        variables.addAll(dvariables);
        substitutionsRHS.put("time", "t");
        for (SFVariable svar : sfunction.getVariables()) {
            String add = "";
            if (svar instanceof SFInputVariable) {
                if (inputs.size() > 1) {
                    add = "(" + String.valueOf(inputs.indexOf(svar) + 1) + ")";
                }
                substitutionsRHS.put(svar.getName(), "u" + add);
                continue;
            }
            if (svar instanceof SFOutputVariable) {
                if (outputs.size() > 1) {
                    add = "(" + String.valueOf(outputs.indexOf(svar) + 1) + ")";
                }
                substitutionsLHS.put(svar.getName(), "sys" + add);
                continue;
            }
            if (svar instanceof SFDiscreteStateVariable) {
                if (dvariables.size() > 1) {
                    add = "(" + (dvariables.indexOf(svar) + 1) + ")";
                }
                substitutionsLHS.put("next(" + svar.getName() + ")", "sys" + add);
                if (variables.size() > 1) {
                    add = "(" + (variables.indexOf(svar) + 1) + ")";
                }
                substitutionsRHS.put(svar.getName(), "x" + add);
                continue;
            }
            if (svar instanceof SFContinuousStateVariable) {
                if (cvariables.size() > 1) {
                    add = "(" + (cvariables.indexOf(svar) + 1) + ")";
                }
                substitutionsLHS.put("der(" + svar.getName() + ")", "sys" + add);
                if (variables.size() > 1) {
                    add = "(" + (variables.indexOf(svar) + 1) + ")";
                }
                substitutionsRHS.put(svar.getName(), "x" + add);
                continue;
            }
            if (!(svar instanceof SFParameter)) continue;
            substitutionsRHS.put(svar.getName(), SysMLToSimulinkTranslator.getValue(svar));
        }
        for (Constraint uconstraint : SysMLUtil.getAllConstraints(ublock)) {
            this.el2m.prepareNextEquationParsing(sfunction, substitutionsLHS, substitutionsRHS, inputs);
            String expr = this.getEquation(uconstraint.getSpecification());
            SFVariableAssignment sassignment = this.el2m.getAssignment();
            if (sassignment == null) {
                log.warn("Assignment " + expr + " unrecognized and skipped");
                continue;
            }
            sfunction.getAssignments().add(sassignment);
            sassignment.setExpression(expr);
        }
        for (Dependency dep : ublock.getClientDependencies()) {
            if (!dep.isStereotypeApplied(this.sysmlutil.getInitialValuesSpecification())) continue;
            log.info("Found instance specification for " + SysMLToSimulinkTranslator.print(ublock));
            for (NamedElement supplier : dep.getSuppliers()) {
                if (!(supplier instanceof InstanceSpecification)) continue;
                InstanceSpecification target = (InstanceSpecification)supplier;
                for (Slot slot : target.getSlots()) {
                    StructuralFeature sf = slot.getDefiningFeature();
                    if (!(sf instanceof Property)) continue;
                    SFVariable sv = this.createVariable(ublock, (Property)sf, ccontext, pcontext);
                    for (ValueSpecification vs : slot.getValues()) {
                        sv.getValue().add(this.getValue(vs));
                    }
                    if (((Property)sf).getClass_() != ublock) continue;
                }
            }
        }
        return sfunction;
    }

    private SFunction2 processSFunction2(Class ublock, Class ccontext, Property pcontext) throws UMLModelErrorException {
        log.debug("Processing s-function " + SysMLToSimulinkTranslator.print(ublock));
        SFunction2 sfunction = this.createSFunction2(ublock, ccontext, pcontext);
        String name = SysMLUtil.getName(ccontext) + "_" + SysMLUtil.getName(pcontext) + "_" + SysMLUtil.getName(ublock);
        SimulinkUtil.setName(sfunction, name);
        for (Property uproperty : SysMLUtil.getAllCorrectedAttributes(ublock)) {
            SFVariable SFVariable2 = this.createVariable(ublock, uproperty, ccontext, pcontext);
            if (SFVariable2 != null) {
                log.debug("Adding variable " + SysMLToSimulinkTranslator.print(uproperty));
                sfunction.getVariables().add(SFVariable2);
                continue;
            }
            log.warn("Skipping variable " + SysMLToSimulinkTranslator.print(uproperty));
        }
        return sfunction;
    }

    private SFunction2 processSFunction22(Class ublock, Class ccontext, Property pcontext) throws UMLModelErrorException {
        String str;
        log.debug("Processing s-function " + SysMLToSimulinkTranslator.print(ublock) + " a second time");
        SFunction2 sfunction = this.createSFunction2(ublock, ccontext, pcontext);
        Hashtable<String, String> substitutionsLHS = new Hashtable<String, String>();
        Hashtable<String, String> substitutionsRHS = new Hashtable<String, String>();
        List<SFInputVariable> inputs = sfunction.getInputs();
        List<SFOutputVariable> outputs = sfunction.getOutputs();
        List<SFContinuousStateVariable> cvariables = sfunction.getContinuousStates();
        List<SFDiscreteStateVariable> dvariables = sfunction.getDiscreteStates();
        List<SFParameter> parameters = sfunction.getParameters();
        List<SFDWorkVariable> dworks = sfunction.getDWorkStates();
        ArrayList<SFDiscreteStateVariable> alldworks = new ArrayList<SFDiscreteStateVariable>(dvariables);
        alldworks.addAll(dworks);
        for (SFInputVariable siv : inputs) {
            substitutionsRHS.put(siv.getName(), "block.InputPort(" + (inputs.indexOf(siv) + 1) + ").Data");
        }
        for (SFOutputVariable sov : outputs) {
            substitutionsLHS.put(sov.getName(), "block.OutputPort(" + (outputs.indexOf(sov) + 1) + ").Data");
        }
        for (SFContinuousStateVariable scsv : cvariables) {
            substitutionsRHS.put(scsv.getName(), "block.ContStates.Data(" + (cvariables.indexOf(scsv) + 1) + ")");
            substitutionsLHS.put(scsv.getName(), "block.ContStates.Data(" + (cvariables.indexOf(scsv) + 1) + ")");
            substitutionsLHS.put("der(" + scsv.getName() + ")", "block.Derivatives.Data(" + (cvariables.indexOf(scsv) + 1) + ")");
        }
        for (SFParameter sp : parameters) {
            substitutionsRHS.put(sp.getName(), SysMLToSimulinkTranslator.getValue(sp));
        }
        for (SFDWorkVariable sdwv : dworks) {
            str = "block.Dwork(" + (alldworks.indexOf(sdwv) + 1) + ").Data";
            substitutionsLHS.put(sdwv.getName(), str);
            if (sdwv.getDimensions().size() == 2) {
                str = "reshape(" + str + "," + sdwv.getDimensions().get(1) + "," + sdwv.getDimensions().get(0) + ")";
            }
            substitutionsRHS.put(sdwv.getName(), str);
        }
        for (SFDiscreteStateVariable sdsv : dvariables) {
            str = "block.Dwork(" + (alldworks.indexOf(sdsv) + 1) + ").Data";
            substitutionsLHS.put(sdsv.getName(), str);
            if (sdsv.getDimensions().size() == 2) {
                str = "reshape(" + str + "," + sdsv.getDimensions().get(1) + "," + sdsv.getDimensions().get(0) + ")";
            }
            substitutionsRHS.put(sdsv.getName(), str);
        }
        for (Constraint uconstraint : SysMLUtil.getAllConstraints(ublock)) {
            this.el2m.prepareNextEquationParsing(sfunction, substitutionsLHS, substitutionsRHS, inputs);
            String expr = this.getEquation(uconstraint.getSpecification());
            SFVariableAssignment sassignment = this.el2m.getAssignment();
            if (sassignment == null) {
                log.warn("Assignment " + expr + " unrecognized and skipped");
                continue;
            }
            sfunction.getAssignments().add(sassignment);
            sassignment.setExpression(expr);
        }
        for (Dependency dep : ublock.getClientDependencies()) {
            if (!dep.isStereotypeApplied(this.sysmlutil.getInitialValuesSpecification())) continue;
            log.info("Found instance specification for " + SysMLToSimulinkTranslator.print(ublock));
            for (NamedElement supplier : dep.getSuppliers()) {
                if (!(supplier instanceof InstanceSpecification)) continue;
                InstanceSpecification target = (InstanceSpecification)supplier;
                for (Slot slot : target.getSlots()) {
                    StructuralFeature sf = slot.getDefiningFeature();
                    if (!(sf instanceof Property)) continue;
                    SFVariable sv = this.createVariable(ublock, (Property)sf, ccontext, pcontext);
                    for (ValueSpecification vs : slot.getValues()) {
                        sv.getValue().add(this.getValue(vs));
                    }
                    if (((Property)sf).getClass_() != ublock) continue;
                }
            }
        }
        return sfunction;
    }

    private SChart createChart(Class ublock, StateMachine ustatemachine) {
        log.debug("Creating state machine " + SysMLToSimulinkTranslator.print(ustatemachine) + "/" + SysMLToSimulinkTranslator.print(ustatemachine));
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(ublock, ustatemachine);
        SElement selement = this.refs.get(rk);
        if (selement != null) {
            if (selement instanceof SChart) {
                return (SChart)selement;
            }
            throw new IllegalStateException("The element correspinding to " + SysMLToSimulinkTranslator.print(ustatemachine) + "/" + SysMLToSimulinkTranslator.print(ustatemachine) + " is not a chart: " + selement.getClass());
        }
        SMachine smachine = this.sstateflow.getMachine();
        SChart schart = StateflowFactory.eINSTANCE.createSChart();
        this.refs.put(rk, schart);
        schart.setOwningMachine(smachine);
        schart.setID();
        String ustatemachinecontextname = SysMLUtil.getName(ublock);
        SimulinkUtil.setName(schart, ustatemachinecontextname);
        SInstance sinstance = StateflowFactory.eINSTANCE.createSInstance();
        sinstance.setChart(schart);
        sinstance.setOwningStateflow(this.sstateflow);
        sinstance.setID();
        sinstance.setMachine(smachine);
        SimulinkUtil.setName(sinstance, ustatemachinecontextname);
        SState scontainer = null;
        List<Region> regions = this.sysmlutil.getAllCorrectedRegions(ustatemachine);
        if (regions.size() > 1) {
            scontainer = StateflowFactory.eINSTANCE.createSState();
            scontainer.setType(SStateType.AND);
            scontainer.setOwningTreeNode(schart);
            scontainer.setID();
        } else if (regions.size() == 1) {
            this.refs.put(SysMLToSimulinkTranslator.getKey(ublock, regions.get(0)), schart);
        }
        for (Region uregion : regions) {
            if (scontainer != null) {
                SState slocalcontainer = StateflowFactory.eINSTANCE.createSState();
                slocalcontainer.setType(SStateType.OR);
                slocalcontainer.setOwningTreeNode(scontainer);
                slocalcontainer.setID();
                this.refs.put(SysMLToSimulinkTranslator.getKey(ublock, uregion), slocalcontainer);
            }
            this.processRegion1(ublock, uregion);
        }
        return schart;
    }

    private void processRegion1(Class ublock, Region uregion) {
        log.debug("Processing region " + SysMLToSimulinkTranslator.print(ublock) + "/" + SysMLToSimulinkTranslator.print(uregion) + " #1");
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToSimulinkTranslator.getKey(ublock, uregion);
        STreeNode snodecontainer = (STreeNode)this.refs.get(rk);
        block5: for (Vertex vertex : uregion.getSubvertices()) {
            switch (SysMLToSimulinkTranslator.getTranslatedVertex(vertex)) {
                case STATE: {
                    SState state = StateflowFactory.eINSTANCE.createSState();
                    log.debug("Creating state " + SysMLToSimulinkTranslator.print(vertex));
                    EList<Region> regions = ((State)vertex).getRegions();
                    SState scontainer = null;
                    if (regions.size() > 1) {
                        scontainer = StateflowFactory.eINSTANCE.createSState();
                        scontainer.setType(SStateType.AND);
                        scontainer.setOwningTreeNode(state);
                        scontainer.setID();
                    } else if (regions.size() == 1) {
                        this.refs.put(SysMLToSimulinkTranslator.getKey(ublock, (Element)regions.get(0)), state);
                    }
                    for (Region uregion2 : regions) {
                        if (scontainer != null) {
                            SState slocalcontainer = StateflowFactory.eINSTANCE.createSState();
                            slocalcontainer.setType(SStateType.OR);
                            slocalcontainer.setOwningTreeNode(scontainer);
                            slocalcontainer.setID();
                            this.refs.put(SysMLToSimulinkTranslator.getKey(ublock, uregion2), slocalcontainer);
                        }
                        this.processRegion1(ublock, uregion2);
                    }
                    this.refs.put(SysMLToSimulinkTranslator.getKey(ublock, vertex), state);
                    state.setOwningTreeNode(snodecontainer);
                    state.setID();
                    continue block5;
                }
                case INITIAL: {
                    continue block5;
                }
                case JUNCTION: {
                    SJunction junction = StateflowFactory.eINSTANCE.createSJunction();
                    junction.setOwningTreeNode(snodecontainer);
                    junction.setID();
                    log.debug("Creating junction " + SysMLToSimulinkTranslator.print(ublock) + "/" + SysMLToSimulinkTranslator.print(vertex));
                    this.refs.put(SysMLToSimulinkTranslator.getKey(ublock, vertex), junction);
                    continue block5;
                }
            }
            log.warn("Untranslated element: " + SysMLToSimulinkTranslator.print(ublock) + "/" + SysMLToSimulinkTranslator.print(vertex));
        }
        this.toProcess.push(rk);
    }

    private void processRegion2(Class ublock, Region uregion) throws UMLModelErrorException {
        log.debug("Processing region " + SysMLToSimulinkTranslator.print(ublock) + "/" + SysMLToSimulinkTranslator.print(uregion) + " #2");
        STreeNode snodecontainer = (STreeNode)this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, uregion));
        Hashtable<String, String> substitutions = new Hashtable<String, String>();
        Class context = ublock;
        for (Property uproperty : SysMLUtil.getAllCorrectedAttributes(context)) {
            List<Property> sps;
            if (!(uproperty.getType() instanceof Classifier) || (sps = this.sysmlutil.getAllPhSProperties((Classifier)uproperty.getType())).size() != 1) continue;
            substitutions.put(uproperty.getName() + "." + sps.get(0).getName(), uproperty.getName());
        }
        for (Vertex vertex : uregion.getSubvertices()) {
            Behavior during;
            SElement selement = this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, vertex));
            if (!(selement instanceof SState)) continue;
            SState state = (SState)selement;
            SimulinkUtil.setName(state, SysMLUtil.getName(vertex));
            StringBuilder sblabel = new StringBuilder();
            Behavior entry = ((State)vertex).getEntry();
            if (entry instanceof OpaqueBehavior) {
                this.el2m.setSubstitutions(substitutions);
                String expr = this.getAssignments((OpaqueBehavior)entry);
                this.el2m.setSubstitutions(null);
                if (sblabel.length() != 0) {
                    sblabel.append('\n');
                }
                sblabel.append("entry:" + expr + ";");
            }
            if ((during = ((State)vertex).getDoActivity()) instanceof Activity) {
                Activity activity = (Activity)during;
                if (activity.getOwnedNodes().size() == 1) {
                    ActivityNode node = (ActivityNode)activity.getOwnedNodes().get(0);
                    if (node instanceof CallOperationAction) {
                        CallOperationAction cao = (CallOperationAction)node;
                        for (Property prop : SysMLUtil.getAllCorrectedAttributes(context)) {
                            SElement se = this.refs.get(SysMLToSimulinkTranslator.getKey(context, prop, cao.getOperation()));
                            if (!(se instanceof SOutport)) continue;
                            if (sblabel.length() != 0) {
                                sblabel.append('\n');
                            }
                            sblabel.append("entry:" + ((SOutport)se).getName() + "=1;");
                            sblabel.append("\nexit:" + ((SOutport)se).getName() + "=0;");
                        }
                    } else {
                        log.warn("Can translate only activity with one call operation action");
                    }
                } else {
                    log.warn("Can translate only activity with one node: found " + activity.getOwnedNodes().size());
                }
            } else if (during != null) {
                log.warn("DoActivity not translated");
            }
            Behavior exit = ((State)vertex).getExit();
            if (exit != null) {
                log.warn("Exit unsupported");
            }
            if (exit instanceof OpaqueBehavior) {
                this.el2m.setSubstitutions(substitutions);
                String expr = this.getAssignments((OpaqueBehavior)exit);
                this.el2m.setSubstitutions(null);
                if (sblabel.length() != 0) {
                    sblabel.append('\n');
                }
                sblabel.append("exit:" + expr + ";");
            }
            state.setLabel(sblabel.toString());
        }
        for (Transition transition : uregion.getTransitions()) {
            Vertex target = transition.getTarget();
            if (target == null) {
                throw new UMLModelErrorException(this.r, "The transition has no target: " + SysMLToSimulinkTranslator.print(ublock) + "/" + SysMLToSimulinkTranslator.print(transition));
            }
            Vertex source = transition.getSource();
            if (source == null) {
                throw new UMLModelErrorException(this.r, "The transition has no source: " + SysMLToSimulinkTranslator.print(ublock) + "/" + SysMLToSimulinkTranslator.print(transition));
            }
            SElement starget = this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, target));
            if (starget != null) {
                SElement ssource = this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, source));
                if (ssource == null && SysMLToSimulinkTranslator.getTranslatedVertex(source) != TranslatedVertex.INITIAL) {
                    log.warn("Transition " + SysMLToSimulinkTranslator.print(ublock) + "/" + SysMLToSimulinkTranslator.print(transition) + " skipped as the source is not tanslated");
                    continue;
                }
                log.debug("Creating transition " + SysMLToSimulinkTranslator.print(ublock) + "/" + SysMLToSimulinkTranslator.print(transition));
                STransition stransition = StateflowFactory.eINSTANCE.createSTransition();
                if (ssource != null) {
                    stransition.setSrc((SConnectNode)((Object)ssource));
                }
                stransition.setDst((SConnectNode)((Object)starget));
                if (transition.getSource().isStereotypeApplied(this.sysmlutil.getSimulationVertex()) && transition.getSource().getValue(this.sysmlutil.getSimulationVertex(), "transitionPriority") instanceof List) {
                    List ltr = (List)transition.getSource().getValue(this.sysmlutil.getSimulationVertex(), "transitionPriority");
                    EList<STransition> outgoings = stransition.getSrc().getOutgoing();
                    for (int i = ltr.indexOf(transition) + 1; i < ltr.size(); ++i) {
                        int j = outgoings.indexOf(this.refs.get(SysMLToSimulinkTranslator.getKey(ublock, (Element)ltr.get(i))));
                        int k = ltr.indexOf(transition);
                        if (j == -1 || j >= k) continue;
                        outgoings.add(j, (STransition)outgoings.remove(k));
                    }
                }
                block5: for (Trigger trigger : transition.getTriggers()) {
                    String exp;
                    Event event = trigger.getEvent();
                    if (event instanceof ChangeEvent) {
                        this.el2m.setSubstitutions(substitutions);
                        exp = this.getExpression(((ChangeEvent)event).getChangeExpression());
                        this.el2m.setSubstitutions(null);
                        stransition.setLabel("[" + exp + "]");
                        continue;
                    }
                    if (event instanceof TimeEvent) {
                        this.el2m.setSubstitutions(substitutions);
                        exp = this.getExpression(((TimeEvent)event).getWhen());
                        this.el2m.setSubstitutions(null);
                        stransition.setLabel("after(" + exp + ", sec)");
                        continue;
                    }
                    if (!(event instanceof CallEvent)) continue;
                    Operation operation = ((CallEvent)event).getOperation();
                    for (Property prop : SysMLUtil.getAllCorrectedAttributes(context)) {
                        SElement se = this.refs.get(SysMLToSimulinkTranslator.getKey(context, prop, operation));
                        if (!(se instanceof SInport)) continue;
                        stransition.setLabel("[" + ((SInport)se).getName() + "==1]");
                        continue block5;
                    }
                }
                if (stransition.getLabel() == null && transition.getGuard() != null) {
                    this.el2m.setSubstitutions(substitutions);
                    String exp = this.getExpression(transition.getGuard().getSpecification());
                    this.el2m.setSubstitutions(null);
                    stransition.setLabel("[" + exp + "]");
                }
                stransition.setOwningTreeNode(snodecontainer);
                stransition.setID();
                continue;
            }
            log.warn("Transition " + SysMLToSimulinkTranslator.print(ublock) + "/" + SysMLToSimulinkTranslator.print(transition) + " skipped as the target is not tanslated");
        }
    }

    private SComponent processComponent(Class ublock) throws UMLModelErrorException {
        log.debug("Processing component " + SysMLToSimulinkTranslator.print(ublock));
        SComponent scomponent = this.createComponent(ublock);
        SimulinkUtil.setName(scomponent, SysMLUtil.getName(ublock));
        boolean inh = true;
        if (this.useInheritance(ublock)) {
            log.info("Using inheritence");
        } else {
            inh = false;
            log.info("Not using inheritence");
        }
        if (inh) {
            for (Classifier classifier : ublock.getGenerals()) {
                if (this.getTranslatedType(classifier) == TranslatedType.COMPONENT) {
                    SComponent sComponent = this.createComponent((Class)classifier);
                    scomponent.setBaseComponent(sComponent);
                    break;
                }
                log.warn("Unsupported generalization of " + SysMLToSimulinkTranslator.print(ublock) + ": " + SysMLToSimulinkTranslator.print(classifier));
            }
        }
        List<Property> uproperties = inh ? SysMLUtil.getOwnedAttributes(ublock) : SysMLUtil.getAllCorrectedAttributes(ublock);
        for (Property property : uproperties) {
            if (property.getVisibility() == VisibilityKind.PRIVATE_LITERAL) {
                log.warn("Skipping property " + SysMLToSimulinkTranslator.print(property) + " because it is private");
                continue;
            }
            if (property.getType() == null) {
                log.warn("Skipping property " + SysMLToSimulinkTranslator.print(property) + " because it has no type");
                continue;
            }
            if (this.getTranslatedType(property.getType()) == TranslatedType.NONE) {
                log.warn("Skipping property " + SysMLToSimulinkTranslator.print(property) + " because its type is not translated");
                continue;
            }
            SMember smember = this.createMember(property);
            if (smember == null) continue;
            if (property.getDefaultValue() != null) {
                SDataValue svalue;
                InstanceSpecification instancespec;
                if (property.getDefaultValue() instanceof InstanceValue && (instancespec = ((InstanceValue)property.getDefaultValue()).getInstance()) != null) {
                    LinkedList<SMember> ll = new LinkedList<SMember>();
                    ll.add(smember);
                    for (Slot slot : instancespec.getSlots()) {
                        this.addInitialValue(scomponent, ll, slot, (Property)slot.getDefiningFeature());
                    }
                }
                if ((svalue = this.getValue(property.getDefaultValue())) != null && svalue instanceof SExpressionValue) {
                    SEquation sequation = SimscapeFactory.eINSTANCE.createSEquation();
                    sequation.setExpression(smember.getName() + "==" + ((SExpressionValue)svalue).getValue());
                    scomponent.getOwnedEquations().add(sequation);
                }
            }
            log.debug("Adding " + SysMLToSimulinkTranslator.print(property) + " to " + SysMLToSimulinkTranslator.print(ublock));
            if (smember instanceof SNode) {
                if (scomponent.getNodes().size() % 2 == 0) {
                    ((SNode)smember).setLocation(SLocation.LEFT);
                    SysMLToSimulinkTranslator.createConnectionPortBlock(smember, SLocation.LEFT).setOwningSystem(scomponent);
                } else {
                    ((SNode)smember).setLocation(SLocation.RIGHT);
                    SysMLToSimulinkTranslator.createConnectionPortBlock(smember, SLocation.RIGHT).setOwningSystem(scomponent);
                }
            } else if (smember instanceof SInput) {
                ((SInput)smember).setLocation(SLocation.LEFT);
                SysMLToSimulinkTranslator.createConnectionPortBlock(smember, SLocation.LEFT).setOwningSystem(scomponent);
            } else if (smember instanceof SOutput) {
                ((SOutput)smember).setLocation(SLocation.RIGHT);
                SysMLToSimulinkTranslator.createConnectionPortBlock(smember, SLocation.RIGHT).setOwningSystem(scomponent);
            }
            scomponent.getOwnedMembers().add(smember);
        }
        scomponent.setHidden(true);
        for (Property property : SysMLUtil.getAllCorrectedAttributes(ublock)) {
            if (!(property instanceof Port)) continue;
            scomponent.setHidden(false);
            break;
        }
        List<Connector> list = inh ? ublock.getOwnedConnectors() : SysMLUtil.getAllConnectors(ublock);
        for (Connector uconnector : list) {
            List<Property> lp1;
            ConnectorEnd end0 = (ConnectorEnd)uconnector.getEnds().get(0);
            ConnectorEnd end1 = (ConnectorEnd)uconnector.getEnds().get(1);
            List<Property> lp0 = inh ? this.sysmlutil.getPropertyPath(end0) : this.sysmlutil.getCorrectedPropertyPath(end0, ublock);
            List<Property> list2 = lp1 = inh ? this.sysmlutil.getPropertyPath(end1) : this.sysmlutil.getCorrectedPropertyPath(end1, ublock);
            if (uconnector.isStereotypeApplied(this.sysmlutil.getBindingConnector())) continue;
            SConnection sconnection = SimscapeFactory.eINSTANCE.createSConnection();
            SMemberPath scp0 = SimscapeFactory.eINSTANCE.createSMemberPath();
            SMemberPath scp1 = SimscapeFactory.eINSTANCE.createSMemberPath();
            SMember sm0 = null;
            for (Property prop2 : lp0) {
                sm0 = this.createMember(prop2);
                if (sm0 != null) {
                    scp0.getPath().add(sm0);
                    continue;
                }
                log.error("Can't add " + SysMLToSimulinkTranslator.print(prop2) + " to the member path of " + SysMLToSimulinkTranslator.print(uconnector));
            }
            SMember sm1 = null;
            for (Property prop2 : lp1) {
                sm1 = this.createMember(prop2);
                if (sm1 != null) {
                    scp1.getPath().add(sm1);
                    continue;
                }
                log.error("Can't add " + SysMLToSimulinkTranslator.print(prop2) + " to the member path of " + SysMLToSimulinkTranslator.print(uconnector));
            }
            if (sm0 instanceof SNode && sm1 instanceof SNode) {
                sconnection.getPoints().add(scp0);
                sconnection.getPoints().add(scp1);
            } else if (sm0 instanceof SInput && sm1 instanceof SOutput) {
                sconnection.getPoints().add(scp1);
                sconnection.getPoints().add(scp0);
            } else if (sm1 instanceof SInput && sm0 instanceof SOutput) {
                sconnection.getPoints().add(scp0);
                sconnection.getPoints().add(scp1);
            } else {
                log.error("Incompatible types for connector " + SysMLToSimulinkTranslator.print(uconnector));
            }
            log.info("Adding connection");
            scomponent.getOwnedConnections().add(sconnection);
        }
        SysMLToSimulationTranslator.ReferenceKey referenceKey = SysMLToSimulinkTranslator.getKey(ublock);
        if (!this.toProcessForConnectors.contains(referenceKey)) {
            this.toProcessForConnectors.push(referenceKey);
        }
        return scomponent;
    }

    private static SConnectionPortBlock createConnectionPortBlock(SMember smember, SLocation location) {
        SConnectionPortBlock scpb = SimscapeFactory.eINSTANCE.createSConnectionPortBlock();
        scpb.setLocation(location);
        scpb.setMember(smember);
        return scpb;
    }

    private SDomain processDomain(Class ublock) throws UMLModelErrorException {
        log.debug("Processing domain " + SysMLToSimulinkTranslator.print(ublock));
        SDomain sdomain = this.createDomain(ublock);
        SimulinkUtil.setName(sdomain, SysMLUtil.getName(ublock));
        if (ublock.getGenerals().size() > 0) {
            log.warn("Generalization of domains is not supported by Simscape: " + SysMLToSimulinkTranslator.print(ublock));
        }
        for (Property simproperty : this.sysmlutil.getAllPhSProperties(ublock)) {
            if (simproperty.getType() instanceof Classifier) {
                for (Property uproperty : SysMLUtil.getAllCorrectedAttributes((Classifier)simproperty.getType())) {
                    if (uproperty.getVisibility() == VisibilityKind.PRIVATE_LITERAL) {
                        log.warn("Skipping non-public property " + SysMLToSimulinkTranslator.print(uproperty));
                        continue;
                    }
                    SMember smember = this.createMember(uproperty);
                    if (smember != null) {
                        if (smember instanceof SParameter) {
                            log.debug("Adding " + SysMLToSimulinkTranslator.print(uproperty) + " to " + SysMLToSimulinkTranslator.print(ublock));
                            sdomain.getParameters().add((SParameter)smember);
                            continue;
                        }
                        if (!(smember instanceof SVariable)) continue;
                        log.debug("Adding " + SysMLToSimulinkTranslator.print(uproperty) + " to " + SysMLToSimulinkTranslator.print(ublock));
                        sdomain.getVariables().add((SVariable)smember);
                        continue;
                    }
                    log.warn("Could not add " + SysMLToSimulinkTranslator.print(uproperty) + " to " + SysMLToSimulinkTranslator.print(ublock));
                }
                continue;
            }
            log.error("The sim property " + SysMLToSimulinkTranslator.print(simproperty) + " is not typed by a classifier");
        }
        return sdomain;
    }

    private SComponent processComponent2(Class ublock) throws UMLModelErrorException {
        log.debug("Processing component " + SysMLToSimulinkTranslator.print(ublock) + " a second time");
        SComponent scomponent = this.createComponent(ublock);
        boolean inh = this.useInheritance(ublock);
        block0: for (SMember sMember : new ArrayList<SMember>(scomponent.getOwnedMembers())) {
            if (!(sMember instanceof SNode)) continue;
            for (SConnection sc : scomponent.getOwnedConnections()) {
                for (SMemberPath smp : sc.getPoints()) {
                    if (smp.getPath().get(0) != sMember) continue;
                    continue block0;
                }
            }
            for (SVariable sv : ((SNode)sMember).getDomain().getVariables()) {
                if (!sv.isBalancing()) continue;
                SVariable sv2 = SimscapeFactory.eINSTANCE.createSVariable();
                scomponent.getOwnedMembers().add(sv2);
                SimulinkUtil.setName(sv2, sMember.getName() + sv.getName());
                sv2.setValue(sv.getValue());
                sv2.setUnit(sv.getUnit());
                SBranch sb = SimscapeFactory.eINSTANCE.createSBranch();
                sb.setVariable(sv2);
                SMemberPath smp = SimscapeFactory.eINSTANCE.createSMemberPath();
                smp.getPath().add(sMember);
                smp.getPath().add(sv);
                sb.setFrom(smp);
                scomponent.getBranches().add(sb);
            }
        }
        List<Connector> uconnectors = inh ? ublock.getOwnedConnectors() : SysMLUtil.getAllConnectors(ublock);
        for (Connector connector : uconnectors) {
            SMemberAssignment sma;
            SElement se3;
            SElement se2;
            SElement se1;
            if (!connector.isStereotypeApplied(this.sysmlutil.getBindingConnector())) continue;
            ConnectorEnd ce0 = (ConnectorEnd)connector.getEnds().get(0);
            ConnectorEnd ce1 = (ConnectorEnd)connector.getEnds().get(1);
            List<Property> lp0 = inh ? this.sysmlutil.getPropertyPath(ce0) : this.sysmlutil.getCorrectedPropertyPath(ce0, ublock);
            List<Property> lp1 = inh ? this.sysmlutil.getPropertyPath(ce1) : this.sysmlutil.getCorrectedPropertyPath(ce1, ublock);
            Object from = null;
            Object to = null;
            Property lp0p = lp0.get(lp0.size() - 1);
            Property lp1p = lp1.get(lp1.size() - 1);
            if (lp0.size() == 1 && lp1.size() == 2) {
                se1 = this.refs.get(SysMLToSimulinkTranslator.getKey(lp0.get(0)));
                se2 = this.refs.get(SysMLToSimulinkTranslator.getKey(lp1.get(0)));
                se3 = this.refs.get(SysMLToSimulinkTranslator.getKey(lp1.get(1)));
                if (se2 instanceof SComponentReference && se1 instanceof SParameter && se3 instanceof SParameter) {
                    sma = SimscapeFactory.eINSTANCE.createSMemberAssignment();
                    sma.getAssignedReference().add((SMember)se1);
                    sma.getMemberPath().add((SMember)se2);
                    sma.getMemberPath().add((SMember)se3);
                    scomponent.getOwnedAssignments().add(sma);
                }
            }
            if (lp1.size() == 1 && lp0.size() == 2) {
                se1 = this.refs.get(SysMLToSimulinkTranslator.getKey(lp1.get(0)));
                se2 = this.refs.get(SysMLToSimulinkTranslator.getKey(lp0.get(0)));
                se3 = this.refs.get(SysMLToSimulinkTranslator.getKey(lp0.get(1)));
                if (se2 instanceof SComponentReference && se1 instanceof SParameter && se3 instanceof SParameter) {
                    sma = SimscapeFactory.eINSTANCE.createSMemberAssignment();
                    sma.getAssignedReference().add((SMember)se1);
                    sma.getMemberPath().add((SMember)se2);
                    sma.getMemberPath().add((SMember)se3);
                    scomponent.getOwnedAssignments().add(sma);
                }
            }
            boolean lp0v = lp0p.isStereotypeApplied(this.sysmlutil.getPhSVariable());
            boolean lp1v = lp1p.isStereotypeApplied(this.sysmlutil.getPhSVariable());
            boolean lp0c = lp0p.isStereotypeApplied(this.sysmlutil.getPhSConstant());
            boolean lp1c = lp1p.isStereotypeApplied(this.sysmlutil.getPhSConstant());
            if ((!lp0v || !lp1v && !lp1c) && (!lp1v || !lp0v && !lp0c)) continue;
            SEquation seq = SimscapeFactory.eINSTANCE.createSEquation();
            seq.setExpression(this.sysmlutil.joinProperties(lp0, ".") + "==" + this.sysmlutil.joinProperties(lp1, "."));
            scomponent.getOwnedEquations().add(seq);
        }
        List<Constraint> list = inh ? ublock.getOwnedRules() : SysMLUtil.getAllConstraints(ublock);
        for (Constraint uconstraint : list) {
            this.el2m.prepareNextEquationParsing(scomponent, null);
            String value = this.getEquation(uconstraint.getSpecification());
            if (value == null) continue;
            SEquation sequation = SimscapeFactory.eINSTANCE.createSEquation();
            sequation.setExpression(value);
            scomponent.getOwnedEquations().add(sequation);
        }
        List<Property> list2 = inh ? SysMLUtil.getOwnedAttributes(ublock) : SysMLUtil.getAllCorrectedAttributes(ublock);
        for (Property uproperty : list2) {
            if (!uproperty.getType().isStereotypeApplied(this.sysmlutil.getConstraintBlock())) continue;
            Hashtable<String, String> subs = new Hashtable<String, String>();
            for (Connector uconnector : SysMLUtil.getAllConnectors(ublock)) {
                Property up;
                int i;
                StringBuilder to;
                String from;
                if (!uconnector.isStereotypeApplied(this.sysmlutil.getBindingConnector()) || uconnector.getEnds().size() != 2) continue;
                List<Property> lp0 = this.sysmlutil.getPropertyPath((ConnectorEnd)uconnector.getEnds().get(0));
                List<Property> lp1 = this.sysmlutil.getPropertyPath((ConnectorEnd)uconnector.getEnds().get(1));
                if (lp0.size() == 2 && lp0.get(0) == uproperty) {
                    from = lp0.get(1).getName();
                    to = new StringBuilder();
                    for (i = 0; i < lp1.size(); ++i) {
                        up = lp1.get(i);
                        if (this.sysmlutil.isPhSProperty(up)) continue;
                        if (!(i == 0 || up.isStereotypeApplied(this.sysmlutil.getPhSVariable()) && ((Boolean)up.getValue(this.sysmlutil.getPhSVariable(), "isConserved")).booleanValue())) {
                            to.append(".");
                        }
                        to.append(up.getName());
                    }
                    subs.put(from, to.toString());
                    continue;
                }
                if (lp1.size() != 2 || lp1.get(0) != uproperty) continue;
                from = lp1.get(1).getName();
                to = new StringBuilder();
                for (i = 0; i < lp0.size(); ++i) {
                    up = lp0.get(i);
                    if (this.sysmlutil.isPhSProperty(up)) continue;
                    if (!(i == 0 || up.isStereotypeApplied(this.sysmlutil.getPhSVariable()) && ((Boolean)up.getValue(this.sysmlutil.getPhSVariable(), "isConserved")).booleanValue())) {
                        to.append(".");
                    }
                    to.append(up.getName());
                }
                subs.put(from, to.toString());
            }
            for (Constraint uconstraint : SysMLUtil.getAllConstraints((Classifier)uproperty.getType())) {
                this.el2m.prepareNextEquationParsing(scomponent, subs);
                String value = this.getEquation(uconstraint.getSpecification());
                if (value == null) continue;
                SEquation sequation = SimscapeFactory.eINSTANCE.createSEquation();
                sequation.setExpression(value);
                scomponent.getOwnedEquations().add(sequation);
            }
        }
        return scomponent;
    }

    @Override
    protected String getOpaqueLanguage() {
        return "matlab";
    }

    private void addInitialValue(SComponent scomponent, LinkedList<SMember> ll, Slot slot, Property definingfeature) throws UMLModelErrorException {
        if (slot.getValues().size() == 0) {
            log.warn("Slot " + SysMLToSimulinkTranslator.print(slot) + " has no values");
        } else if (slot.getValues().size() > 1) {
            log.warn("Slot " + SysMLToSimulinkTranslator.print(slot) + " has several values");
        } else {
            Property sf = definingfeature;
            if (!(sf instanceof Property)) {
                log.warn("The feature of slot " + SysMLToSimulinkTranslator.print(slot) + " should be a property");
                return;
            }
            SMember lastmember = this.createMember(sf);
            if (slot.isStereotypeApplied(this.sysmlutil.getInitialValueReference()) && slot.getValue(this.sysmlutil.getInitialValueReference(), "propertyPath") instanceof List) {
                List references = (List)slot.getValue(this.sysmlutil.getInitialValueReference(), "propertyPath");
                LinkedList<SMember> members = new LinkedList<SMember>();
                for (Property prop : references) {
                    SMember member = this.createMember(prop);
                    if (member == null) continue;
                    members.add(member);
                }
                SMemberAssignment sassignment = SimscapeFactory.eINSTANCE.createSMemberAssignment();
                sassignment.getMemberPath().addAll(ll);
                sassignment.getMemberPath().add(lastmember);
                sassignment.getAssignedReference().addAll(members);
                scomponent.getOwnedAssignments().add(sassignment);
            } else {
                ValueSpecification vs = (ValueSpecification)slot.getValues().get(0);
                SDataValue sv = this.getValue(vs);
                if (sv != null) {
                    SMemberAssignment sassignment = SimscapeFactory.eINSTANCE.createSMemberAssignment();
                    sassignment.getMemberPath().addAll(ll);
                    sassignment.getMemberPath().add(lastmember);
                    sassignment.setAssignedValue(sv);
                    scomponent.getOwnedAssignments().add(sassignment);
                } else if (vs instanceof InstanceValue) {
                    for (Slot subslot : ((InstanceValue)vs).getInstance().getSlots()) {
                        LinkedList<SMember> newlist = new LinkedList<SMember>(ll);
                        if (this.sysmlutil.isPhSProperty((Property)subslot.getDefiningFeature())) {
                            this.addInitialValue(scomponent, newlist, subslot, sf);
                            continue;
                        }
                        newlist.add(lastmember);
                        this.addInitialValue(scomponent, newlist, subslot, (Property)subslot.getDefiningFeature());
                    }
                } else {
                    log.warn("Unable to process the value of " + SysMLToSimulinkTranslator.print(vs) + ". Use String, Boolean, Integer, Real or SysML initial values");
                }
            }
        }
    }

    private SDataValue getValue(ValueSpecification vs) throws UMLModelErrorException {
        String val;
        if (vs instanceof LiteralReal) {
            SDoubleValue sdouble = SimulinkFactory.eINSTANCE.createSDoubleValue();
            sdouble.setValue(((LiteralReal)vs).getValue());
            return sdouble;
        }
        if (vs instanceof OpaqueExpression && (val = this.getEquation(vs)) != null) {
            SExpressionValue sexpression = SimulinkFactory.eINSTANCE.createSExpressionValue();
            sexpression.setValue(val);
            return sexpression;
        }
        return null;
    }

    private SDataValue getValue(Slot slot) throws UMLModelErrorException {
        if (slot.getValues().size() == 1) {
            return this.getValue((ValueSpecification)slot.getValues().get(0));
        }
        if (slot.getValues().size() > 1) {
            int j;
            int cumul;
            int i;
            List dims;
            StringBuilder sb = new StringBuilder();
            LinkedList<Integer> dimensions = new LinkedList<Integer>();
            if (slot.isStereotypeApplied(this.sysmlutil.getMultidimensionalElement()) && slot.getValue(this.sysmlutil.getMultidimensionalElement(), "dimension") instanceof List) {
                dims = (List)slot.getValue(this.sysmlutil.getMultidimensionalElement(), "dimension");
                for (i = 0; i < dims.size(); ++i) {
                    cumul = (Integer)dims.get(i);
                    for (j = i + 1; j < dims.size(); ++j) {
                        cumul *= ((Integer)dims.get(j)).intValue();
                    }
                    dimensions.add(cumul);
                }
            } else if (slot.getDefiningFeature().isStereotypeApplied(this.sysmlutil.getMultidimensionalElement()) && slot.getDefiningFeature().getValue(this.sysmlutil.getMultidimensionalElement(), "dimension") instanceof List) {
                dims = (List)slot.getDefiningFeature().getValue(this.sysmlutil.getMultidimensionalElement(), "dimension");
                for (i = 0; i < dims.size(); ++i) {
                    cumul = (Integer)dims.get(i);
                    for (j = i + 1; j < dims.size(); ++j) {
                        cumul *= ((Integer)dims.get(j)).intValue();
                    }
                    dimensions.add(cumul);
                }
            } else {
                dimensions.add(slot.getValues().size());
            }
            if (dimensions.size() == 1) {
                sb.append("[");
                for (int i2 = 0; i2 < slot.getValues().size(); ++i2) {
                    if (i2 != 0) {
                        sb.append(" ");
                    }
                    sb.append(this.getValue((ValueSpecification)slot.getValues().get(i2)).getRawValue());
                }
                sb.append("]");
            } else if (dimensions.size() == 2) {
                int mod = (Integer)dimensions.get(1);
                sb.append("[");
                for (i = 0; i < slot.getValues().size(); ++i) {
                    if (i != 0) {
                        if (i % mod == 0) {
                            sb.append(";");
                        } else {
                            sb.append(" ");
                        }
                    }
                    sb.append(this.getValue((ValueSpecification)slot.getValues().get(i)).getRawValue());
                }
                sb.append("]");
            }
            SExpressionValue sexv = SimulinkFactory.eINSTANCE.createSExpressionValue();
            sexv.setValue(sb.toString());
            return sexv;
        }
        return null;
    }

    private static String getValue(SFVariable svar) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < svar.getValue().size(); ++i) {
            SDataValue sdv = (SDataValue)svar.getValue().get(i);
            if (i != 0) {
                sb.append(";");
            }
            if (sdv instanceof SExpressionValue) {
                sb.append(((SExpressionValue)sdv).getValue());
                continue;
            }
            if (!(sdv instanceof SDoubleValue)) continue;
            sb.append(((SDoubleValue)sdv).getValue());
        }
        return sb.toString();
    }

    private String getUnitFromType(Type utype) {
        if (!(utype instanceof Classifier)) {
            return null;
        }
        Classifier uclassifier = (Classifier)utype;
        ArrayList<Classifier> lclassifiers = new ArrayList<Classifier>();
        lclassifiers.add(uclassifier);
        lclassifiers.addAll(uclassifier.allParents());
        for (Classifier cl : lclassifiers) {
            InstanceSpecification unit;
            if (!cl.isStereotypeApplied(this.sysmlutil.getValueType()) || (unit = (InstanceSpecification)cl.getValue(this.sysmlutil.getValueType(), "unit")) == null) continue;
            for (Slot unitslot : unit.getSlots()) {
                Iterator iterator;
                if (unitslot.getDefiningFeature() == null || !unitslot.getDefiningFeature().getName().equals("symbol") || !(iterator = unitslot.getValues().iterator()).hasNext()) continue;
                ValueSpecification symbol = (ValueSpecification)iterator.next();
                String val = symbol.stringValue();
                if (Configuration.getSimulinkUnitMapping().get(val) != null) {
                    return Configuration.getSimulinkUnitMapping().get(val);
                }
                return val;
            }
        }
        return null;
    }

    private boolean useInheritance(Class uclass) {
        if (this.getTranslatedType(uclass) != TranslatedType.COMPONENT) {
            return false;
        }
        for (Property uproperty : SysMLUtil.getAllAttributes(uclass)) {
            if (uproperty.getRedefinedProperties().size() == 0) continue;
            return false;
        }
        ArrayList<Class> generals = new ArrayList<Class>(uclass.getGeneralizations().size());
        for (Generalization generalization : uclass.getGeneralizations()) {
            Classifier gen = generalization.getGeneral();
            Classifier spe = generalization.getSpecific();
            if (spe != uclass || this.getTranslatedType(gen) != TranslatedType.COMPONENT) continue;
            Class cl = (Class)gen;
            if (!this.useInheritance(cl)) {
                return false;
            }
            generals.add(cl);
        }
        return generals.size() <= 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        XML,
        TEXT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Domains {
        CREATE,
        REUSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SFunction {
        Simscape,
        Level2,
        Level1;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TranslatedVertex {
        STATE,
        INITIAL,
        JUNCTION,
        TRANSITION,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TranslatedType {
        NONE,
        SYSTEM,
        CHART,
        INPORT,
        OUTPORT,
        SFUNCTION,
        COMPONENT,
        DOMAIN,
        DATATYPE;

    }
}

