/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.translation.simulink;

import com.engisis.sysphs.deserialization.simulink.SimulinkDeserializer;
import com.engisis.sysphs.generation.simulink.MATLABLexer;
import com.engisis.sysphs.generation.simulink.MATLABParser;
import com.engisis.sysphs.language.simscape.SBranch;
import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SComponentReference;
import com.engisis.sysphs.language.simscape.SConnection;
import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SDomain;
import com.engisis.sysphs.language.simscape.SEquation;
import com.engisis.sysphs.language.simscape.SInput;
import com.engisis.sysphs.language.simscape.SMember;
import com.engisis.sysphs.language.simscape.SMemberAssignment;
import com.engisis.sysphs.language.simscape.SMemberPath;
import com.engisis.sysphs.language.simscape.SNode;
import com.engisis.sysphs.language.simscape.SOutput;
import com.engisis.sysphs.language.simscape.SParameter;
import com.engisis.sysphs.language.simscape.SPhysicalBlock;
import com.engisis.sysphs.language.simscape.SPhysicalConnectionPoint;
import com.engisis.sysphs.language.simscape.SPhysicalLine;
import com.engisis.sysphs.language.simscape.SVariable;
import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SConnectionPoint;
import com.engisis.sysphs.language.simulink.SDataValue;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.simulink.SFContinuousStateVariable;
import com.engisis.sysphs.language.simulink.SFDiscreteStateVariable;
import com.engisis.sysphs.language.simulink.SFInputVariable;
import com.engisis.sysphs.language.simulink.SFOutputVariable;
import com.engisis.sysphs.language.simulink.SFParameter;
import com.engisis.sysphs.language.simulink.SFVariable;
import com.engisis.sysphs.language.simulink.SFVariableAssignment;
import com.engisis.sysphs.language.simulink.SFunction2;
import com.engisis.sysphs.language.simulink.SFunction2Block;
import com.engisis.sysphs.language.simulink.SInport;
import com.engisis.sysphs.language.simulink.SInterface;
import com.engisis.sysphs.language.simulink.SLine;
import com.engisis.sysphs.language.simulink.SModel;
import com.engisis.sysphs.language.simulink.SNamedElement;
import com.engisis.sysphs.language.simulink.SOutport;
import com.engisis.sysphs.language.simulink.SReference;
import com.engisis.sysphs.language.simulink.SSubsystem;
import com.engisis.sysphs.language.simulink.SSystem;
import com.engisis.sysphs.language.simulink.SSystemParameterAssignment;
import com.engisis.sysphs.language.stateflow.SChart;
import com.engisis.sysphs.language.stateflow.SChartBlock;
import com.engisis.sysphs.language.stateflow.SChartSystem;
import com.engisis.sysphs.language.stateflow.SConnectNode;
import com.engisis.sysphs.language.stateflow.SData;
import com.engisis.sysphs.language.stateflow.SDataScope;
import com.engisis.sysphs.language.stateflow.SLinkNode;
import com.engisis.sysphs.language.stateflow.SState;
import com.engisis.sysphs.language.stateflow.SStateflow;
import com.engisis.sysphs.language.stateflow.STransition;
import com.engisis.sysphs.language.stateflow.STreeNode;
import com.engisis.sysphs.translation.simulink.MatlabExpressionExtractor;
import com.engisis.sysphs.translation.simulink.SimscapeExpressionExtractor;
import com.engisis.sysphs.util.ANTLRErrorListener;
import com.engisis.sysphs.util.EMFUtil;
import com.engisis.sysphs.util.SimulationToSysMLTranslator;
import com.engisis.sysphs.util.SysMLUtil;
import com.engisis.sysphs.util.UMLModelErrorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulinkToSysMLTranslator
extends SimulationToSysMLTranslator {
    private static final Logger log = Logger.getLogger(SimulinkToSysMLTranslator.class);
    private SModel smodel;
    private List<SStateflow> lstateflow;
    private SysMLUtil sysmlutil;
    private Package uroot;
    private Hashtable<String, DataType> units = new Hashtable();
    private Hashtable<DataType, Class> porttypes = new Hashtable();
    private Hashtable<ReferenceKey, NamedElement> refs = new Hashtable();
    private Hashtable<Class, Hashtable<String, String>> subs = new Hashtable();
    private Hashtable<SElement, ParseTree> expressions;
    private Stack<ReferenceKey> toProcess = new Stack();
    private Stack<ReferenceKey> toProcess2 = new Stack();
    private SimscapeExpressionExtractor see = new SimscapeExpressionExtractor();
    private Class usignalporttype;
    private Property usignalportproperty;

    private static ReferenceKey getKey(SNamedElement ... elements) {
        return new ReferenceKey(elements);
    }

    @Override
    public void execute(String model, ResourceSet rs, File outputdirectory, String target, String[] paths) throws IOException, UMLModelErrorException {
        SNamedElement snm0;
        ReferenceKey rk;
        String fn;
        if (model == null) {
            throw new IllegalArgumentException("The model can't be null");
        }
        if (rs == null) {
            throw new IllegalArgumentException("The ResourceSet can't be null");
        }
        File file = new File(model);
        if (!file.isFile() || !file.canRead()) {
            throw new IllegalArgumentException("The file must be readable");
        }
        SimulinkDeserializer sd = new SimulinkDeserializer();
        sd.deserialize(model);
        this.expressions = sd.getExpressions();
        this.smodel = sd.getModel();
        this.lstateflow = sd.getStateflow();
        String[] paths2 = null;
        if (paths == null) {
            paths2 = new String[1];
        } else {
            int len = paths.length;
            paths2 = new String[len + 1];
            for (int i = 0; i < len; ++i) {
                paths2[i] = paths[i];
            }
        }
        paths2[paths2.length - 1] = file.getParent();
        URI uri = null;
        if (outputdirectory == null) {
            uri = URI.createFileURI(model).trimFileExtension();
            fn = uri.lastSegment() + this.getFileNameSuffix();
            uri = uri.trimSegments(1).appendSegment(fn).appendFileExtension("xmi");
        } else {
            uri = URI.createFileURI(outputdirectory.getAbsolutePath());
            fn = URI.createFileURI(model).trimFileExtension().lastSegment() + this.getFileNameSuffix();
            uri = uri.appendSegment(fn).appendFileExtension("xmi");
        }
        Resource r = EMFUtil.createSysMLModel(rs, uri, paths2);
        EMFUtil.getSimulationLibrary(rs, URI.createFileURI(model), paths2);
        this.sysmlutil = new SysMLUtil(r.getResourceSet());
        for (EObject eo : r.getContents()) {
            if (!(eo instanceof Package)) continue;
            this.uroot = (Package)eo;
        }
        if (this.uroot == null) {
            log.info("Creating root model...");
            this.uroot = UMLFactory.eINSTANCE.createModel();
            SysMLUtil.setName(this.uroot, "Data");
            r.getContents().add(this.uroot);
        } else {
            log.info("Reusing root model " + this.uroot.getName());
        }
        if (this.smodel == null || this.smodel.getSystem() == null) {
            log.error("The model is null or has no system");
            return;
        }
        this.smodel.getSystem().setName(this.smodel.getName());
        Class uclass = this.createBlock(this.smodel.getSystem());
        while (this.toProcess.size() != 0) {
            rk = this.toProcess.pop();
            if (rk.getKey().length != 1) continue;
            snm0 = rk.getKey()[0];
            if (snm0 instanceof SBlock) {
                this.processProperty((SBlock)snm0);
                if (!(snm0 instanceof SPhysicalBlock)) continue;
                this.toProcess2.add(rk);
                continue;
            }
            if (snm0 instanceof SMember) {
                this.processProperty((SMember)snm0);
                continue;
            }
            if (snm0 instanceof SDomain) {
                this.processBlock((SDomain)snm0);
                continue;
            }
            if (snm0 instanceof SComponent) {
                Class res = this.processBlock((SComponent)snm0);
                if (uclass.getName() != null && res.getName().equals(uclass.getName())) {
                    SysMLUtil.setName(uclass, uclass.getName() + "Container");
                }
                this.toProcess2.add(rk);
                continue;
            }
            if (snm0 instanceof SFunction2) {
                this.processBlock((SFunction2)snm0);
                continue;
            }
            if (snm0 instanceof SChartSystem) {
                this.processBlock((SChartSystem)snm0);
                this.toProcess2.add(rk);
                continue;
            }
            if (snm0 instanceof SSystem) {
                this.processBlock((SSystem)snm0);
                this.toProcess2.add(rk);
                continue;
            }
            if (snm0 instanceof SState) {
                this.processState((SState)snm0);
                continue;
            }
            if (snm0 instanceof STransition) {
                this.processTransition((STransition)snm0);
                continue;
            }
            log.error("Element not processed: " + snm0);
        }
        while (this.toProcess2.size() != 0) {
            rk = this.toProcess2.pop();
            if (rk.getKey().length != 1) continue;
            snm0 = rk.getKey()[0];
            if (snm0 instanceof SComponent) {
                this.processBlock2((SComponent)snm0);
                continue;
            }
            if (snm0 instanceof SChartSystem) {
                this.processBlock2((SChartSystem)snm0);
                continue;
            }
            if (snm0 instanceof SSystem) {
                this.processBlock2((SSystem)snm0);
                continue;
            }
            if (snm0 instanceof SPhysicalBlock) {
                this.processProperty2((SPhysicalBlock)snm0);
                continue;
            }
            if (snm0 instanceof SInterface) {
                this.processProperty2((SInterface)snm0);
                continue;
            }
            log.error("Element not processed a second time: " + snm0);
        }
        log.info("Saving " + r.getURI());
        this.outputrootname = uclass.getQualifiedName();
        this.outputfilename = r.getURI().toFileString();
        EMFUtil.saveResource(r, target);
    }

    private Class createBlock(SSystem ssystem) {
        if (ssystem == null) {
            log.error("Null system found");
            return null;
        }
        ReferenceKey key = SimulinkToSysMLTranslator.getKey(ssystem);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Class) {
                return (Class)uelement;
            }
            throw new IllegalStateException("The element is not a class: " + ssystem.getName());
        }
        Class ublock = UMLFactory.eINSTANCE.createClass();
        this.uroot.getPackagedElements().add(ublock);
        ublock.applyStereotype(this.sysmlutil.getBlock());
        log.info("Creating class " + ssystem.getName());
        if (ssystem instanceof SChartSystem) {
            StateMachine ustatemachine = UMLFactory.eINSTANCE.createStateMachine();
            ublock.setClassifierBehavior(ustatemachine);
            log.info("Creating state machine " + ssystem.getName());
        }
        this.refs.put(key, ublock);
        this.toProcess.push(key);
        return ublock;
    }

    private Class createBlock(SFunction2 sfunction2) {
        if (sfunction2 == null) {
            log.error("Null SFunction found");
            return null;
        }
        ReferenceKey key = SimulinkToSysMLTranslator.getKey(sfunction2);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Class) {
                return (Class)uelement;
            }
            throw new IllegalStateException("The element is not a class: " + sfunction2.getName());
        }
        Class ublock = UMLFactory.eINSTANCE.createClass();
        this.uroot.getPackagedElements().add(ublock);
        ublock.applyStereotype(this.sysmlutil.getConstraintBlock());
        log.info("Creating constraint block " + sfunction2.getName());
        SysMLUtil.setName(ublock, sfunction2.getName());
        for (SFVariable sfvariable : sfunction2.getVariables()) {
            Property uproperty = UMLFactory.eINSTANCE.createProperty();
            ublock.getOwnedAttributes().add(uproperty);
            SysMLUtil.setName(uproperty, sfvariable.getName());
            this.refs.put(SimulinkToSysMLTranslator.getKey(sfvariable), uproperty);
            uproperty.setType(this.sysmlutil.getSysMLDouble());
        }
        for (SFVariableAssignment sfvariableassignment : sfunction2.getAssignments()) {
            Constraint uconstraint = UMLFactory.eINSTANCE.createConstraint();
            OpaqueExpression oe = UMLFactory.eINSTANCE.createOpaqueExpression();
            oe.getBodies().add(sfvariableassignment.getExpression());
            oe.getLanguages().add("sysphs");
            uconstraint.setSpecification(oe);
            ublock.getOwnedRules().add(uconstraint);
        }
        this.refs.put(key, ublock);
        this.toProcess.push(key);
        return ublock;
    }

    private Class createBlock(SDomain sdomain) {
        if (sdomain == null) {
            throw new IllegalArgumentException("The domain should not be null");
        }
        ReferenceKey key = SimulinkToSysMLTranslator.getKey(sdomain);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Class) {
                return (Class)uelement;
            }
            throw new IllegalStateException("The element is not a class: " + sdomain.getName());
        }
        Class ublock = UMLFactory.eINSTANCE.createClass();
        this.uroot.getPackagedElements().add(ublock);
        ublock.applyStereotype(this.sysmlutil.getBlock());
        log.info("Creating class " + sdomain.getName());
        this.refs.put(key, ublock);
        this.toProcess.push(key);
        return ublock;
    }

    private Class createBlock(SComponent scomponent) {
        if (scomponent == null) {
            throw new IllegalArgumentException("The component should not be null");
        }
        ReferenceKey key = SimulinkToSysMLTranslator.getKey(scomponent);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Class) {
                return (Class)uelement;
            }
            throw new IllegalStateException("The element is not a class: " + scomponent.getName());
        }
        Class ublock = UMLFactory.eINSTANCE.createClass();
        this.uroot.getPackagedElements().add(ublock);
        ublock.applyStereotype(this.sysmlutil.getBlock());
        log.info("Creating class " + scomponent.getName());
        this.refs.put(key, ublock);
        this.toProcess.push(key);
        return ublock;
    }

    private Property createProperty(SBlock sblock) {
        if (sblock == null) {
            throw new IllegalArgumentException("The block should not be null");
        }
        ReferenceKey key = SimulinkToSysMLTranslator.getKey(sblock);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Property) {
                return (Property)uelement;
            }
            throw new IllegalStateException("The element is not a port: " + sblock.getName());
        }
        Property uproperty = null;
        if (sblock instanceof SInport || sblock instanceof SOutport || sblock instanceof SConnectionPortBlock) {
            uproperty = UMLFactory.eINSTANCE.createPort();
            log.info("Creating port " + sblock.getName());
        } else {
            uproperty = UMLFactory.eINSTANCE.createProperty();
            log.info("Creating property " + sblock.getName());
        }
        this.refs.put(key, uproperty);
        this.toProcess.push(key);
        return uproperty;
    }

    private Property createProperty(SMember smember) {
        if (smember == null) {
            throw new IllegalArgumentException("The member should not be null");
        }
        ReferenceKey key = SimulinkToSysMLTranslator.getKey(smember);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Property) {
                return (Property)uelement;
            }
            throw new IllegalStateException("The element is not a property: " + smember.getName());
        }
        Property uproperty = null;
        if (smember instanceof SInput || smember instanceof SOutput || smember instanceof SNode) {
            uproperty = UMLFactory.eINSTANCE.createPort();
            log.info("Creating port " + smember.getName());
        } else {
            uproperty = UMLFactory.eINSTANCE.createProperty();
            log.info("Creating property " + smember.getName());
        }
        this.refs.put(key, uproperty);
        if (smember.getConnectionPortBlock() != null) {
            this.refs.put(SimulinkToSysMLTranslator.getKey(smember.getConnectionPortBlock()), uproperty);
        }
        this.toProcess.push(key);
        return uproperty;
    }

    private Class processBlock(SSystem ssystem) {
        Class ublock = this.createBlock(ssystem);
        if (ublock == null) {
            log.error("Can't retrieve block");
            return null;
        }
        log.info("Processing block " + ssystem.getName());
        SysMLUtil.setName(ublock, ssystem.getName());
        for (SBlock sblock : ssystem.getOwnedBlocks()) {
            if (sblock instanceof SInport || sblock instanceof SOutport || sblock instanceof SSubsystem || sblock instanceof SReference || sblock instanceof SPhysicalBlock || sblock instanceof SChartBlock || sblock instanceof SFunction2Block || sblock instanceof SInterface) {
                Property uproperty = this.createProperty(sblock);
                if (uproperty instanceof Port) {
                    ublock.getOwnedPorts().add((Port)uproperty);
                    continue;
                }
                ublock.getOwnedAttributes().add(uproperty);
                continue;
            }
            log.error("Unsupported block type: " + sblock.getClass());
        }
        return ublock;
    }

    private Class processBlock(SChartSystem schartsystem) {
        Class ublock = this.createBlock(schartsystem);
        if (ublock == null) {
            log.error("Can't retrieve block");
            return null;
        }
        log.info("Processing chart " + schartsystem.getName());
        SysMLUtil.setName(ublock, schartsystem.getName());
        for (SBlock sblock : schartsystem.getOwnedBlocks()) {
            if (sblock instanceof SInport || sblock instanceof SOutport) {
                Property uproperty = this.createProperty(sblock);
                if (uproperty instanceof Port) {
                    ublock.getOwnedPorts().add((Port)uproperty);
                    continue;
                }
                ublock.getOwnedAttributes().add(uproperty);
                continue;
            }
            log.error("Unsupported block type: " + sblock.getClass());
        }
        if (schartsystem.getOwningSubsystem() instanceof SChartBlock) {
            SChart schart = ((SChartBlock)schartsystem.getOwningSubsystem()).getChart();
            if (schart == null) {
                log.error("Chart not found for block " + schartsystem.getName());
                return ublock;
            }
            StateMachine ustatemachine = (StateMachine)ublock.getClassifierBehavior();
            SysMLUtil.setName(ustatemachine, ublock.getName() + "SB");
            Hashtable<String, String> sub = this.getClassSubstitutions(ublock);
            Region uregion = UMLFactory.eINSTANCE.createRegion();
            ustatemachine.getRegions().add(uregion);
            for (STreeNode stn : schart.getTreeNode()) {
                if (!(stn instanceof SState)) continue;
                State ustate = this.createState((SState)stn);
                uregion.getSubvertices().add(ustate);
            }
            for (SLinkNode sln : schart.getLinkNode()) {
                if (sln instanceof STransition) {
                    STransition stransition = (STransition)sln;
                    Transition utransition = this.createTransition(stransition);
                    uregion.getTransitions().add(utransition);
                    continue;
                }
                if (!(sln instanceof SData)) continue;
                SData sdata = (SData)sln;
                if (sdata.getScope() != SDataScope.INPUT && sdata.getScope() != SDataScope.OUTPUT && sdata.getScope() == SDataScope.CONSTANT) {
                    Property uproperty = UMLFactory.eINSTANCE.createProperty();
                    ublock.getOwnedAttributes().add(uproperty);
                    uproperty.applyStereotype(this.sysmlutil.getPhSConstant());
                    SysMLUtil.setName(uproperty, sdata.getName());
                    uproperty.setType(this.sysmlutil.getSysMLDouble());
                    log.info("Adding constant " + sdata.getName());
                    if (sdata.getValue() != null) {
                        uproperty.setDefaultValue(SimulinkToSysMLTranslator.getValueSpecification(sdata.getValue()));
                        log.info("Setting default value to " + uproperty.getDefaultValue());
                    }
                }
                sdata.getDataType();
            }
        }
        return ublock;
    }

    private State createState(SState sstate) {
        if (sstate == null) {
            throw new IllegalArgumentException("The state should not be null");
        }
        ReferenceKey key = SimulinkToSysMLTranslator.getKey(sstate);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof State) {
                return (State)uelement;
            }
            throw new IllegalStateException("The element is not a state: " + sstate.getName());
        }
        State ustate = UMLFactory.eINSTANCE.createState();
        log.info("Creating state " + sstate.getName());
        this.refs.put(key, ustate);
        this.toProcess.push(key);
        return ustate;
    }

    private State processState(SState sstate) {
        State ustate = this.createState(sstate);
        log.info("Processing state " + sstate.getName());
        SysMLUtil.setName(ustate, sstate.getName());
        Class ublock = (Class)ustate.getContainer().getStateMachine().getContext();
        Hashtable<String, String> sub = this.subs.get(ublock);
        String label = sstate.getLabel();
        if (label != null && !label.isEmpty()) {
            int i;
            StringBuilder sb;
            log.info("Parsing label " + label);
            MatlabExpressionExtractor mee = new MatlabExpressionExtractor();
            mee.prepareNextStateLabelParsing(sub);
            MATLABLexer ml = new MATLABLexer(new ANTLRInputStream(label));
            CommonTokenStream cts = new CommonTokenStream(ml);
            MATLABParser mp = new MATLABParser(cts);
            mp.addErrorListener(new ANTLRErrorListener(log));
            MATLABParser.State_labelContext prc = mp.state_label();
            new ParseTreeWalker().walk(mee, prc);
            if (mee.getEntry() != null) {
                sb = new StringBuilder();
                for (i = 0; i < mee.getEntry().size(); ++i) {
                    if (i != 0) {
                        sb.append('\n');
                    }
                    sb.append(mee.getEntry().get(i));
                }
                if (sb.length() != 0) {
                    OpaqueBehavior ob = UMLFactory.eINSTANCE.createOpaqueBehavior();
                    ob.getBodies().add(sb.toString());
                    ob.getLanguages().add("sysphs");
                    ustate.setEntry(ob);
                }
            }
            if (mee.getDo() != null) {
                sb = new StringBuilder();
                for (i = 0; i < mee.getDo().size(); ++i) {
                    if (i != 0) {
                        sb.append('\n');
                    }
                    sb.append(mee.getDo().get(i));
                }
                if (sb.length() != 0) {
                    OpaqueBehavior ob = UMLFactory.eINSTANCE.createOpaqueBehavior();
                    ob.getBodies().add(sb.toString());
                    ob.getLanguages().add("sysphs");
                    ustate.setEntry(ob);
                }
            }
            if (mee.getExit() != null) {
                sb = new StringBuilder();
                for (int i2 = 0; i2 < mee.getExit().size(); ++i2) {
                    if (i2 != 0) {
                        sb.append('\n');
                    }
                    sb.append(mee.getExit().get(i2));
                }
                if (sb.length() != 0) {
                    OpaqueBehavior ob = UMLFactory.eINSTANCE.createOpaqueBehavior();
                    ob.getBodies().add(sb.toString());
                    ob.getLanguages().add("sysphs");
                    ustate.setExit(ob);
                }
            }
        }
        return ustate;
    }

    private Transition createTransition(STransition stransition) {
        if (stransition == null) {
            throw new IllegalArgumentException("The transition should not be null");
        }
        ReferenceKey key = SimulinkToSysMLTranslator.getKey(stransition);
        Element uelement = this.refs.get(key);
        if (uelement != null) {
            if (uelement instanceof Transition) {
                return (Transition)uelement;
            }
            throw new IllegalStateException("The element is not a transition: " + stransition.getName());
        }
        Transition utransition = UMLFactory.eINSTANCE.createTransition();
        log.info("Creating transition " + stransition.getName());
        this.refs.put(key, utransition);
        this.toProcess.push(key);
        return utransition;
    }

    private Transition processTransition(STransition stransition) {
        Transition utransition = this.createTransition(stransition);
        log.info("Processing transition " + stransition.getName());
        SConnectNode src = stransition.getSrc();
        if (src == null) {
            Pseudostate upseudostate = UMLFactory.eINSTANCE.createPseudostate();
            upseudostate.setKind(PseudostateKind.INITIAL_LITERAL);
            utransition.getContainer().getSubvertices().add(upseudostate);
            utransition.setSource(upseudostate);
        } else if (src instanceof SState) {
            State ustate = this.createState((SState)src);
            utransition.setSource(ustate);
        } else {
            log.error("Unsupported transition source type: " + src.getClass());
        }
        SConnectNode dst = stransition.getDst();
        if (dst == null) {
            log.error("Null transition target for transition " + stransition);
        } else if (dst instanceof SState) {
            State ustate = this.createState((SState)dst);
            utransition.setTarget(ustate);
        } else {
            log.error("Unsupported transition target type: " + dst.getClass());
        }
        Class ublock = (Class)utransition.getContainer().getStateMachine().getContext();
        Hashtable<String, String> sub = this.subs.get(ublock);
        String label = stransition.getLabel();
        log.info("Parsing label " + label);
        if (label != null && !label.isEmpty()) {
            MatlabExpressionExtractor mee = new MatlabExpressionExtractor();
            mee.prepareNextStateLabelParsing(sub);
            MATLABLexer ml = new MATLABLexer(new ANTLRInputStream(label));
            CommonTokenStream cts = new CommonTokenStream(ml);
            MATLABParser mp = new MATLABParser(cts);
            mp.addErrorListener(new ANTLRErrorListener(log));
            MATLABParser.Transition_labelContext prc = mp.transition_label();
            new ParseTreeWalker().walk(mee, prc);
            if (mee.getTransitionCondition() != null) {
                Trigger t = UMLFactory.eINSTANCE.createTrigger();
                ChangeEvent ce = UMLFactory.eINSTANCE.createChangeEvent();
                ublock.getNearestPackage().getPackagedElements().add(ce);
                t.setEvent(ce);
                OpaqueExpression oe = UMLFactory.eINSTANCE.createOpaqueExpression();
                ce.setChangeExpression(oe);
                oe.getBodies().add(mee.getTransitionCondition());
                oe.getLanguages().add("sysphs");
                utransition.getTriggers().add(t);
            } else if (mee.getTransitionTime() != null) {
                Trigger t = UMLFactory.eINSTANCE.createTrigger();
                TimeEvent te = UMLFactory.eINSTANCE.createTimeEvent();
                ublock.getNearestPackage().getPackagedElements().add(te);
                t.setEvent(te);
                TimeExpression tex = UMLFactory.eINSTANCE.createTimeExpression();
                OpaqueExpression oe = UMLFactory.eINSTANCE.createOpaqueExpression();
                te.setIsRelative(true);
                te.setWhen(tex);
                tex.setExpr(oe);
                oe.getBodies().add(mee.getTransitionTime());
                oe.getLanguages().add("sysphs");
                utransition.getTriggers().add(t);
            } else {
                log.error("Unable to parse the transition label: " + label);
            }
        }
        return utransition;
    }

    private Class processBlock2(SSystem ssystem) {
        Class ublock = this.createBlock(ssystem);
        if (ublock == null) {
            log.error("Can't retrieve block");
            return null;
        }
        log.info("Processing block " + ssystem.getName() + " a second time");
        for (SLine sline : ssystem.getOwnedLines()) {
            if (sline instanceof SPhysicalLine) {
                EList<SPhysicalConnectionPoint> spcps = ((SPhysicalLine)sline).getPoints();
                if (spcps.size() < 2) {
                    log.error("The physical line doesn't have enough points");
                    continue;
                }
                SPhysicalConnectionPoint spcp0 = (SPhysicalConnectionPoint)spcps.get(0);
                Property p00 = (Property)this.refs.get(SimulinkToSysMLTranslator.getKey(spcp0.getBlock()));
                Property p01 = (Property)this.refs.get(SimulinkToSysMLTranslator.getKey(spcp0.getPort()));
                for (int i = 1; i < spcps.size(); ++i) {
                    SPhysicalConnectionPoint spcp1 = (SPhysicalConnectionPoint)spcps.get(i);
                    Property p10 = (Property)this.refs.get(SimulinkToSysMLTranslator.getKey(spcp1.getBlock()));
                    Property p11 = (Property)this.refs.get(SimulinkToSysMLTranslator.getKey(spcp1.getPort()));
                    this.createConnector(ublock, p00, p01, p10, p11);
                    log.info("Creating physical line between " + p00.getName() + "." + p01 + " and " + p10.getName() + "." + p11);
                }
                continue;
            }
            SConnectionPoint src = sline.getSource();
            Property pr0 = (Property)this.refs.get(SimulinkToSysMLTranslator.getKey(src.getBlock()));
            Port po0 = src.getPort() != null ? (Port)this.refs.get(SimulinkToSysMLTranslator.getKey(src.getPort())) : null;
            for (SConnectionPoint dst : sline.getDestinations()) {
                Port po1;
                Property pr1 = (Property)this.refs.get(SimulinkToSysMLTranslator.getKey(dst.getBlock()));
                Port port = po1 = dst.getPort() != null ? (Port)this.refs.get(SimulinkToSysMLTranslator.getKey(dst.getPort())) : null;
                if (pr0 == null || pr1 == null) continue;
                this.createConnector(ublock, pr0, po0, pr1, po1);
                log.info("Creating line between " + pr0.getName() + "." + po0 + " and " + pr1.getName() + "." + po1);
            }
        }
        for (SBlock sblock : ssystem.getOwnedBlocks()) {
            if (!(sblock instanceof SFunction2Block)) continue;
            this.processSFunction2(ssystem, sblock);
        }
        return ublock;
    }

    private Class processBlock(SFunction2 sfunction2) {
        return this.createBlock(sfunction2);
    }

    private Class processBlock(SDomain sdomain) {
        Class ublock = this.createBlock(sdomain);
        SysMLUtil.setName(ublock, sdomain.getName());
        log.info("Processing domain " + sdomain.getName());
        Property usp = UMLFactory.eINSTANCE.createProperty();
        ublock.getOwnedAttributes().add(usp);
        SysMLUtil.setName(usp, "phs" + sdomain.getName());
        usp.applyStereotype(this.sysmlutil.getFlowProperty());
        usp.setValue(this.sysmlutil.getFlowProperty(), "direction", this.sysmlutil.getFlowPropertyInout());
        usp.applyStereotype(this.sysmlutil.getPhSVariable());
        Class usb = UMLFactory.eINSTANCE.createClass();
        this.uroot.getPackagedElements().add(usb);
        Generalization ugeneralization = UMLFactory.eINSTANCE.createGeneralization();
        ugeneralization.setGeneral(this.sysmlutil.getConservedSubstance());
        ugeneralization.setSpecific(usb);
        usb.getGeneralizations().add(ugeneralization);
        SysMLUtil.setName(usb, "PhS" + sdomain.getName());
        usp.setType(usb);
        for (SMember sMember : sdomain.getVariables()) {
            Property uproperty = this.createProperty(sMember);
            usb.getOwnedAttributes().add(uproperty);
        }
        return ublock;
    }

    private Class processBlock(SComponent scomponent) {
        Class ublock = this.createBlock(scomponent);
        this.getComponentSubstitutions(scomponent);
        log.info("Processing component " + scomponent.getName());
        SysMLUtil.setName(ublock, scomponent.getName());
        Property uconstraintproperty = this.getOrCreateConstraintProperty(ublock);
        Class uconstraint = (Class)uconstraintproperty.getType();
        SysMLUtil.setName(uconstraint, ublock.getName() + "Constraint");
        SysMLUtil.setName(uconstraintproperty, "_" + uconstraint.getName());
        if (scomponent.getBaseComponent() != null) {
            Class ubase = this.createBlock(scomponent.getBaseComponent());
            Generalization ugen = UMLFactory.eINSTANCE.createGeneralization();
            ublock.getGeneralizations().add(ugen);
            ugen.setGeneral(ubase);
            ugen.setSpecific(ublock);
        }
        for (SMember smember : scomponent.getOwnedMembers()) {
            Property uproperty = this.createProperty(smember);
            if (uproperty instanceof Port) {
                ublock.getOwnedPorts().add((Port)uproperty);
                continue;
            }
            ublock.getOwnedAttributes().add(uproperty);
        }
        return ublock;
    }

    private Class processBlock2(SComponent scomponent) {
        Class ublock = this.createBlock(scomponent);
        log.info("Processing component " + scomponent.getName() + " a second time");
        Hashtable<String, String> substitutions = new Hashtable<String, String>();
        Property uconstraintproperty = this.getOrCreateConstraintProperty(ublock);
        Class uconstraint = (Class)uconstraintproperty.getType();
        for (SConnection sconn : scomponent.getOwnedConnections()) {
            Iterator iter = sconn.getPoints().iterator();
            if (!iter.hasNext()) continue;
            List<Property> src = this.convertList(((SMemberPath)iter.next()).getPath());
            while (iter.hasNext()) {
                List<Property> dst = this.convertList(((SMemberPath)iter.next()).getPath());
                this.createConnector(ublock, src, dst);
                log.info("Adding connection");
            }
        }
        block2: for (SMemberAssignment sma : scomponent.getOwnedAssignments()) {
            log.info("Translating assignment");
            if (sma == null) continue;
            InstanceSpecification is = null;
            for (SMember sm : sma.getMemberPath()) {
                Property prop = this.createProperty(sm);
                if (is == null) {
                    if (prop.getDefaultValue() instanceof InstanceValue) {
                        log.info("Retrieving existing instance specification for " + sm.getName());
                        InstanceValue instanceValue = (InstanceValue)prop.getDefaultValue();
                        is = instanceValue.getInstance();
                        if (is != null) continue;
                        continue block2;
                    }
                    is = UMLFactory.eINSTANCE.createInstanceSpecification();
                    this.uroot.getPackagedElements().add(is);
                    InstanceValue instanceValue = UMLFactory.eINSTANCE.createInstanceValue();
                    instanceValue.setInstance(is);
                    prop.setDefaultValue(instanceValue);
                    log.info("Creating instance specification for " + sm.getName());
                    continue;
                }
                if (sm instanceof SNode || sm instanceof SComponentReference) {
                    InstanceValue instanceValue = UMLFactory.eINSTANCE.createInstanceValue();
                    Slot s = UMLFactory.eINSTANCE.createSlot();
                    is.getSlots().add(s);
                    s.setDefiningFeature(prop);
                    s.getValues().add(instanceValue);
                    is = UMLFactory.eINSTANCE.createInstanceSpecification();
                    this.uroot.getPackagedElements().add(is);
                    instanceValue.setInstance(is);
                    log.info("Creating slot for " + sm.getName());
                    continue;
                }
                Slot slot = UMLFactory.eINSTANCE.createSlot();
                is.getSlots().add(slot);
                slot.setDefiningFeature(prop);
                if (sma.getAssignedValue() != null) {
                    ValueSpecification vs = SimulinkToSysMLTranslator.getValueSpecification(sma.getAssignedValue());
                    if (vs != null) {
                        slot.getValues().add(vs);
                        log.info("Creating slot for " + sm.getName() + " with value " + sma.getAssignedValue().getRawValue());
                        continue;
                    }
                    log.error("Unable to get value for " + sma.getAssignedValue().getRawValue());
                    continue;
                }
                if (sma.getAssignedReference() != null) {
                    log.error("Unsupported reference assignment to " + sma.getAssignedReference());
                    continue;
                }
                log.error("Member assignment without value nor reference");
            }
        }
        substitutions.putAll(this.getComponentSubstitutions(scomponent));
        for (SBranch sbranch : scomponent.getBranches()) {
            SVariable svar = sbranch.getVariable();
            SMemberPath sfrom = sbranch.getFrom();
            SMemberPath sto = sbranch.getTo();
            if (svar == null || sfrom == null && sto == null || sto == null || sfrom == null) continue;
            String from = SimulinkToSysMLTranslator.join(sfrom.getPath(), ".");
            String string = SimulinkToSysMLTranslator.join(sto.getPath(), ".");
            OpaqueExpression oe1 = UMLFactory.eINSTANCE.createOpaqueExpression();
            oe1.getBodies().add(svar.getName() + "=" + (String)from);
            oe1.getLanguages().add("sysphs");
            Constraint uc1 = UMLFactory.eINSTANCE.createConstraint();
            uc1.setSpecification(oe1);
            uconstraint.getOwnedRules().add(uc1);
            OpaqueExpression oe2 = UMLFactory.eINSTANCE.createOpaqueExpression();
            oe2.getBodies().add((String)from + "+" + string + "=0");
            oe2.getLanguages().add("sysphs");
            Constraint uc2 = UMLFactory.eINSTANCE.createConstraint();
            uc2.setSpecification(oe2);
            uconstraint.getOwnedRules().add(uc2);
        }
        EList<SEquation> equations = scomponent.getOwnedEquations();
        if (equations.size() > 0) {
            for (SMember smember : scomponent.getAllMembers()) {
                Property uproperty = this.createProperty(smember);
                Property uconstraintparameter = UMLFactory.eINSTANCE.createProperty();
                uconstraint.getOwnedAttributes().add(uconstraintparameter);
                SysMLUtil.setName(uconstraintparameter, uproperty.getName());
                uconstraintparameter.setType(this.sysmlutil.getSysMLDouble());
                if (smember instanceof SNode) {
                    for (SMember sMember : ((SNode)smember).getDomain().getVariables()) {
                        Property uproperty2 = this.createProperty(sMember);
                        Property uparam = UMLFactory.eINSTANCE.createProperty();
                        uconstraint.getOwnedAttributes().add(uparam);
                        SysMLUtil.setName(uparam, uproperty.getName() + "_" + uproperty2.getName());
                        uparam.setType(this.sysmlutil.getSysMLDouble());
                        Connector uconnector = this.createConnector(ublock, uproperty, uproperty2, uconstraintproperty, uparam);
                        uconnector.applyStereotype(this.sysmlutil.getBindingConnector());
                    }
                    continue;
                }
                if (!(smember instanceof SParameter) && !(smember instanceof SVariable) && !(smember instanceof SInput) && !(smember instanceof SOutput)) continue;
                Connector uconnector = this.createConnector(ublock, uproperty, null, uconstraintproperty, uconstraintparameter);
                uconnector.applyStereotype(this.sysmlutil.getBindingConnector());
            }
            for (SEquation sequation : equations) {
                ParseTree pt = this.expressions.get(sequation);
                if (pt != null) {
                    this.see.prepareNextEquationParsing(substitutions);
                    log.info("Parsing " + pt.getText());
                    ParseTreeWalker ptw = new ParseTreeWalker();
                    ptw.walk(this.see, pt);
                    log.info("Translating " + pt.getText() + " into " + this.see.getValue(pt));
                    OpaqueExpression oe = UMLFactory.eINSTANCE.createOpaqueExpression();
                    oe.getBodies().add(this.see.getValue(pt));
                    oe.getLanguages().add("sysphs");
                    Constraint constraint = UMLFactory.eINSTANCE.createConstraint();
                    constraint.setSpecification(oe);
                    uconstraint.getOwnedRules().add(constraint);
                    continue;
                }
                log.error("No tree for equation " + sequation.getExpression());
            }
        }
        return ublock;
    }

    private Hashtable<String, String> getComponentSubstitutions(SComponent scomponent) {
        Class uclass = (Class)this.refs.get(SimulinkToSysMLTranslator.getKey(scomponent));
        if (uclass == null) {
            return null;
        }
        Hashtable<String, String> ret = this.subs.get(uclass);
        if (ret != null) {
            return ret;
        }
        ret = new Hashtable();
        this.subs.put(uclass, ret);
        log.info("Analyzing branches for " + scomponent.getName());
        for (int i = 0; i < scomponent.getBranches().size(); ++i) {
            SBranch sbranch = (SBranch)scomponent.getBranches().get(i);
            SVariable svar = sbranch.getVariable();
            SMemberPath sMemberPath = sbranch.getFrom();
            SMemberPath sto = sbranch.getTo();
            if (svar == null || sMemberPath == null && sto == null) continue;
            if (sMemberPath == null) {
                log.info("Removing " + svar.getName() + " from " + scomponent.getName());
                ret.put(svar.getName(), "-" + SimulinkToSysMLTranslator.join(sto.getPath(), "_"));
                scomponent.getBranches().remove(i--);
                scomponent.getOwnedMembers().remove(svar);
            }
            if (sto != null) continue;
            log.info("Removing " + svar.getName() + " from " + scomponent.getName());
            ret.put(svar.getName(), SimulinkToSysMLTranslator.join(sMemberPath.getPath(), "_"));
            scomponent.getBranches().remove(i--);
            scomponent.getOwnedMembers().remove(svar);
        }
        for (SMember smember : scomponent.getOwnedMembers()) {
            if (!(smember instanceof SNode)) continue;
            for (SMember sMember : ((SNode)smember).getDomain().getVariables()) {
                String to = smember.getName() + "_" + sMember.getName();
                String from = smember.getName() + "." + sMember.getName();
                log.info("Replacing " + from + " by " + to);
                ret.put(from, to);
            }
        }
        SComponent base = scomponent.getBaseComponent();
        if (base != null) {
            Hashtable<String, String> basesub = this.getComponentSubstitutions(base);
            if (basesub == null) {
                log.error("Can't get substitutions for base component " + base.getName());
            } else {
                ret.putAll(basesub);
            }
        }
        return ret;
    }

    private Hashtable<String, String> getClassSubstitutions(Class uclass) {
        if (uclass == null) {
            return null;
        }
        Hashtable<String, String> ret = this.subs.get(uclass);
        if (ret != null) {
            return ret;
        }
        ret = new Hashtable();
        this.subs.put(uclass, ret);
        return ret;
    }

    private static String join(List<SMember> sms, String link) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sms.size(); ++i) {
            if (i != 0) {
                sb.append(link);
            }
            sb.append(sms.get(i).getName());
        }
        return sb.toString();
    }

    private void processSFunction2(SSystem ssystem, SBlock sblock) {
        SFunction2 sfunction = null;
        if (sblock instanceof SFunction2Block) {
            sfunction = ((SFunction2Block)sblock).getSfunction();
        }
        if (sfunction == null) {
            log.error("The object must be a SFunctionBlock with a SFunction: " + sblock);
            return;
        }
        Class ublock = this.createBlock(ssystem);
        for (SFVariable sv : sfunction.getVariables()) {
            Connector uconnector;
            Property uproperty;
            Connector uconnector2;
            Property uport;
            Property uparameter = (Property)this.refs.get(SimulinkToSysMLTranslator.getKey(sv));
            Property uconstraintproperty = (Property)this.refs.get(SimulinkToSysMLTranslator.getKey(sblock));
            if (sv instanceof SFInputVariable) {
                SInport sinport = ((SFInputVariable)sv).getInport();
                if (sinport == null) {
                    log.error("The output variable " + sv + " has no associated inport");
                    continue;
                }
                uport = this.createProperty(sinport);
                if (uport != null) {
                    uconnector2 = this.createConnector(ublock, uconstraintproperty, uparameter, uport, this.getSignalPortProperty());
                    uconnector2.applyStereotype(this.sysmlutil.getBindingConnector());
                    continue;
                }
                log.error("Couldn't bind input variable");
                continue;
            }
            if (sv instanceof SFOutputVariable) {
                SOutport soutport = ((SFOutputVariable)sv).getOutport();
                if (soutport == null) {
                    log.error("The output variable " + sv + " has no associated outport");
                    continue;
                }
                uport = this.createProperty(soutport);
                if (uport != null) {
                    uconnector2 = this.createConnector(ublock, uconstraintproperty, uparameter, uport, this.getSignalPortProperty());
                    uconnector2.applyStereotype(this.sysmlutil.getBindingConnector());
                    continue;
                }
                log.error("Couldn't bind input variable");
                continue;
            }
            if (sv instanceof SFParameter) {
                uproperty = UMLFactory.eINSTANCE.createProperty();
                ublock.getOwnedAttributes().add(uproperty);
                SysMLUtil.setName(uproperty, sblock.getName() + sv.getName());
                uproperty.applyStereotype(this.sysmlutil.getPhSConstant());
                uproperty.setType(this.sysmlutil.getSysMLDouble());
                uconnector = this.createConnector(ublock, uconstraintproperty, uparameter, uproperty, null);
                uconnector.applyStereotype(this.sysmlutil.getBindingConnector());
                continue;
            }
            if (sv instanceof SFDiscreteStateVariable) {
                uproperty = UMLFactory.eINSTANCE.createProperty();
                ublock.getOwnedAttributes().add(uproperty);
                SysMLUtil.setName(uproperty, sblock.getName() + sv.getName());
                uproperty.applyStereotype(this.sysmlutil.getPhSVariable());
                uproperty.setValue(this.sysmlutil.getPhSVariable(), "isContinuous", false);
                uproperty.setType(this.sysmlutil.getSysMLDouble());
                uconnector = this.createConnector(ublock, uconstraintproperty, uparameter, uproperty, null);
                uconnector.applyStereotype(this.sysmlutil.getBindingConnector());
                continue;
            }
            if (!(sv instanceof SFContinuousStateVariable)) continue;
            uproperty = UMLFactory.eINSTANCE.createProperty();
            ublock.getOwnedAttributes().add(uproperty);
            SysMLUtil.setName(uproperty, sblock.getName() + sv.getName());
            uproperty.applyStereotype(this.sysmlutil.getPhSVariable());
            uproperty.setValue(this.sysmlutil.getPhSVariable(), "isContinuous", true);
            uproperty.setType(this.sysmlutil.getSysMLDouble());
            uconnector = this.createConnector(ublock, uconstraintproperty, uparameter, uproperty, null);
            uconnector.applyStereotype(this.sysmlutil.getBindingConnector());
        }
    }

    /*
     * WARNING - void declaration
     */
    private Property processProperty(SBlock sblock) {
        Property uproperty = this.createProperty(sblock);
        if (uproperty == null) {
            log.error("Can't retrieve property");
            return null;
        }
        log.info("Processing property " + sblock.getName());
        SysMLUtil.setName(uproperty, sblock.getName());
        if (sblock instanceof SConnectionPortBlock) {
            SMember smember = ((SConnectionPortBlock)sblock).getClosestMember();
            if (smember instanceof SInput) {
                SInput sinput = (SInput)smember;
                uproperty.setType(this.getTypeForUnit(sinput.getUnit()));
            } else if (smember instanceof SOutput) {
                SOutput soutput = (SOutput)smember;
                ((Port)uproperty).setIsConjugated(true);
                uproperty.setType(this.getTypeForUnit(soutput.getUnit()));
            } else if (smember instanceof SNode) {
                uproperty.setType(this.createBlock(((SNode)smember).getDomain()));
            } else {
                log.error("Can't set type for block " + sblock.getName());
            }
        } else if (sblock instanceof SChartBlock) {
            uproperty.setType(this.createBlock(((SChartBlock)sblock).getSystem()));
        } else if (sblock instanceof SSubsystem) {
            uproperty.setType(this.createBlock(((SSubsystem)sblock).getSystem()));
        } else if (sblock instanceof SReference) {
            uproperty.setType(this.createBlock(((SReference)sblock).getSystem()));
        } else if (sblock instanceof SPhysicalBlock) {
            uproperty.setType(this.createBlock(((SPhysicalBlock)sblock).getComponent()));
        } else if (sblock instanceof SFunction2Block) {
            uproperty.setType(this.createBlock(((SFunction2Block)sblock).getSfunction()));
        } else if (sblock instanceof SInport) {
            uproperty.setType(this.getSignalPortType());
        } else if (sblock instanceof SOutport) {
            uproperty.setType(this.getSignalPortType());
            ((Port)uproperty).setIsConjugated(true);
        } else if (sblock instanceof SInterface) {
            String name = ((SInterface)sblock).getSystem().getName();
            block0: for (SysMLUtil.LibraryComponent lc : this.sysmlutil.getSimulinkComponents()) {
                void var10_21;
                if (!lc.getName().equals(name)) continue;
                ArrayList<SSystemParameterAssignment> todelete = new ArrayList<SSystemParameterAssignment>(((SInterface)sblock).getAssignments());
                log.debug("Potential type " + name);
                block1: for (SysMLUtil.LibraryParameter libraryParameter : lc.getParameters()) {
                    for (SSystemParameterAssignment sSystemParameterAssignment : ((SInterface)sblock).getAssignments()) {
                        if (!sSystemParameterAssignment.getParameter().getName().equals(libraryParameter.getName())) continue;
                        if (libraryParameter.getValue() == null) {
                            todelete.remove(sSystemParameterAssignment);
                            continue block1;
                        }
                        SDataValue val = sSystemParameterAssignment.getValue();
                        if (!val.getRawValue().equals(libraryParameter.getValue())) continue;
                        continue block1;
                    }
                    log.debug("Skipping potential type due to parameter " + libraryParameter.getName() + "/" + libraryParameter.getValue());
                    continue block0;
                }
                log.info("Assigning type " + lc.getClas().getQualifiedName() + " for block " + sblock.getName());
                uproperty.setType(lc.getClas());
                this.refs.put(SimulinkToSysMLTranslator.getKey(((SInterface)sblock).getSystem()), lc.getClas());
                ((SInterface)sblock).getAssignments().removeAll(todelete);
                InstanceSpecification is = UMLFactory.eINSTANCE.createInstanceSpecification();
                block3: for (SSystemParameterAssignment sspa : ((SInterface)sblock).getAssignments()) {
                    for (SysMLUtil.LibraryParameter lp : lc.getParameters()) {
                        if (!lp.getName().equals(sspa.getParameter().getName())) continue;
                        log.info("Linking parameter " + sspa.getParameter().getName() + ":" + sspa.getValue());
                        this.refs.put(SimulinkToSysMLTranslator.getKey(sspa.getParameter()), lp.getProperty());
                        Slot slot = UMLFactory.eINSTANCE.createSlot();
                        slot.setDefiningFeature(lp.getProperty());
                        slot.getValues().add(SimulinkToSysMLTranslator.getValueSpecification(sspa.getValue()));
                        is.getSlots().add(slot);
                        continue block3;
                    }
                }
                if (is.getSlots().size() > 0) {
                    uproperty.getNearestPackage().getPackagedElements().add(is);
                    InstanceValue instanceValue = UMLFactory.eINSTANCE.createInstanceValue();
                    instanceValue.setInstance(is);
                    uproperty.setDefaultValue(instanceValue);
                }
                List<SInport> list = ((SInterface)sblock).getSystem().getInports();
                List<SysMLUtil.LibraryPort> linputports = lc.getInputPorts();
                if (list.size() != linputports.size()) {
                    log.error("Mismatch in the number of inports " + list.size() + " vs " + linputports.size());
                }
                boolean bl = false;
                while (var10_21 < list.size()) {
                    SInport sinport = list.get((int)var10_21);
                    if (var10_21 < linputports.size()) {
                        this.refs.put(SimulinkToSysMLTranslator.getKey(sinport), linputports.get((int)var10_21).getPort());
                        log.info("Linking inport " + sinport.getName());
                    }
                    ++var10_21;
                }
                List<SOutport> list2 = ((SInterface)sblock).getSystem().getOutports();
                List<SysMLUtil.LibraryPort> loutputports = lc.getOutputPorts();
                if (list2.size() != loutputports.size()) {
                    log.error("Mismatch in the number of outports " + list2.size() + " vs " + loutputports.size());
                }
                for (int i = 0; i < list2.size(); ++i) {
                    SOutport soutport = list2.get(i);
                    if (i >= loutputports.size()) continue;
                    this.refs.put(SimulinkToSysMLTranslator.getKey(soutport), loutputports.get(i).getPort());
                    log.info("Linking outport " + soutport.getName());
                }
            }
            if (uproperty.getType() == null) {
                log.error("Unable to find a type for block " + sblock.getName());
            }
        } else {
            log.error("Unsupported block type: " + sblock.getClass());
        }
        return uproperty;
    }

    private Property processProperty(SMember smember) {
        Property uproperty = this.createProperty(smember);
        if (uproperty == null) {
            log.error("Can't retrieve property");
            return null;
        }
        log.info("Processing property " + smember.getName());
        SysMLUtil.setName(uproperty, smember.getName());
        if (smember instanceof SInput) {
            SInput sinput = (SInput)smember;
            uproperty.setType(this.getTypeForUnit(sinput.getUnit()));
        } else if (smember instanceof SOutput) {
            SOutput soutput = (SOutput)smember;
            ((Port)uproperty).setIsConjugated(true);
            uproperty.setType(this.getTypeForUnit(soutput.getUnit()));
        } else if (smember instanceof SParameter) {
            SParameter sparameter = (SParameter)smember;
            uproperty.setType(this.sysmlutil.getSysMLDouble());
            uproperty.applyStereotype(this.sysmlutil.getPhSConstant());
            String unit = sparameter.getUnit();
            if (unit == null || unit.isEmpty()) {
                uproperty.setType(this.sysmlutil.getSysMLDouble());
            } else {
                uproperty.setType(this.getValueType(unit));
            }
            uproperty.setDefaultValue(SimulinkToSysMLTranslator.getValueSpecification(sparameter.getValue()));
        } else if (smember instanceof SVariable) {
            String unit;
            SVariable svariable = (SVariable)smember;
            uproperty.applyStereotype(this.sysmlutil.getPhSVariable());
            if (svariable.isBalancing()) {
                uproperty.setValue(this.sysmlutil.getPhSVariable(), "isConserved", true);
            }
            if ((unit = svariable.getUnit()) == null || unit.isEmpty()) {
                uproperty.setType(this.sysmlutil.getSysMLDouble());
            } else {
                uproperty.setType(this.getValueType(unit));
            }
            uproperty.setDefaultValue(SimulinkToSysMLTranslator.getValueSpecification(svariable.getValue()));
        } else if (smember instanceof SNode) {
            uproperty.setType(this.createBlock(((SNode)smember).getDomain()));
        } else if (smember instanceof SComponentReference) {
            uproperty.setType(this.createBlock(((SComponentReference)smember).getComponent()));
        } else {
            log.error("Unsupported member type: " + smember.getClass());
        }
        return uproperty;
    }

    private Class getSignalPortType() {
        if (this.usignalporttype != null) {
            return this.usignalporttype;
        }
        Stereotype fp = this.sysmlutil.getFlowProperty();
        Enumeration en = null;
        for (Property p : fp.getOwnedAttributes()) {
            if (!p.getName().equals("direction")) continue;
            en = (Enumeration)p.getType();
        }
        if (en == null) {
            log.error("Can't get flow property direction");
            return null;
        }
        EnumerationLiteral el = en.getOwnedLiteral("in");
        this.usignalporttype = UMLFactory.eINSTANCE.createClass();
        this.uroot.getPackagedElements().add(this.usignalporttype);
        this.usignalporttype.setName("SignalPort");
        this.usignalporttype.applyStereotype(this.sysmlutil.getBlock());
        this.usignalportproperty = UMLFactory.eINSTANCE.createProperty();
        this.usignalporttype.getOwnedAttributes().add(this.usignalportproperty);
        this.usignalportproperty.setName("sfp");
        this.usignalportproperty.setType(this.sysmlutil.getSysMLDouble());
        this.usignalportproperty.applyStereotype(this.sysmlutil.getFlowProperty());
        this.usignalportproperty.setValue(this.sysmlutil.getFlowProperty(), "direction", el);
        this.usignalportproperty.applyStereotype(this.sysmlutil.getPhSVariable());
        return this.usignalporttype;
    }

    private Property processProperty2(SPhysicalBlock sphysicalblock) {
        log.info("Processing physical block " + sphysicalblock.getName() + " a second time");
        Property prop = this.createProperty(sphysicalblock);
        if (sphysicalblock.getAssignments().size() > 0) {
            log.info("Creating instance specification for " + prop.getName());
            InstanceSpecification is = UMLFactory.eINSTANCE.createInstanceSpecification();
            this.uroot.getPackagedElements().add(is);
            InstanceValue iv = UMLFactory.eINSTANCE.createInstanceValue();
            iv.setInstance(is);
            prop.setDefaultValue(iv);
            for (SMemberAssignment sma : sphysicalblock.getAssignments()) {
                if (sma == null) continue;
                if (sma.getMemberPath().size() != 1) {
                    log.error("Unexpected number of members");
                    continue;
                }
                SMember sm = (SMember)sma.getMemberPath().get(0);
                prop = this.createProperty(sm);
                Slot s = UMLFactory.eINSTANCE.createSlot();
                is.getSlots().add(s);
                s.setDefiningFeature(prop);
                s.getValues().add(SimulinkToSysMLTranslator.getValueSpecification(sma.getAssignedValue()));
                log.info("Added initial value for " + prop.getName());
            }
        }
        return prop;
    }

    private Property processProperty2(SInterface sinterface) {
        log.info("Processing interface block " + sinterface.getName() + " a second time");
        Property prop = this.createProperty(sinterface);
        if (sinterface.getAssignments().size() > 0) {
            InstanceSpecification is = UMLFactory.eINSTANCE.createInstanceSpecification();
            this.uroot.getPackagedElements().add(is);
            InstanceValue iv = UMLFactory.eINSTANCE.createInstanceValue();
            iv.setInstance(is);
            prop.setDefaultValue(iv);
            for (SSystemParameterAssignment sspa : sinterface.getAssignments()) {
                Property uparam = (Property)this.refs.get(SimulinkToSysMLTranslator.getKey(sspa.getParameter()));
                Slot uslot = UMLFactory.eINSTANCE.createSlot();
                uslot.setDefiningFeature(uparam);
                uslot.getValues().add(SimulinkToSysMLTranslator.getValueSpecification(sspa.getValue()));
                is.getSlots().add(uslot);
            }
        }
        return prop;
    }

    private Property getSignalPortProperty() {
        if (this.usignalportproperty == null) {
            this.getSignalPortType();
        }
        return this.usignalportproperty;
    }

    private Property getOrCreateConstraintProperty(Class ublock) {
        for (Property uproperty : ublock.getOwnedAttributes()) {
            if (!(uproperty.getType() instanceof Class) || !uproperty.getType().isStereotypeApplied(this.sysmlutil.getConstraintBlock())) continue;
            return uproperty;
        }
        Class uconstraintblock = UMLFactory.eINSTANCE.createClass();
        this.uroot.getPackagedElements().add(uconstraintblock);
        uconstraintblock.applyStereotype(this.sysmlutil.getConstraintBlock());
        Property uconstraintproperty = UMLFactory.eINSTANCE.createProperty();
        ublock.getOwnedAttributes().add(uconstraintproperty);
        uconstraintproperty.setType(uconstraintblock);
        return uconstraintproperty;
    }

    private static ValueSpecification getValueSpecification(SDataValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof SDoubleValue) {
            LiteralReal real = UMLFactory.eINSTANCE.createLiteralReal();
            real.setValue(((SDoubleValue)value).getValue());
            return real;
        }
        if (value instanceof SExpressionValue) {
            OpaqueExpression oe = UMLFactory.eINSTANCE.createOpaqueExpression();
            oe.getBodies().add(value.getRawValue());
            oe.getLanguages().add("sysphs");
            return oe;
        }
        return null;
    }

    private Class getTypeForUnit(String unit) {
        if (unit == null || unit.isEmpty()) {
            return this.getSignalPortType();
        }
        return this.getPortType(this.getValueType(unit));
    }

    private Class getPortType(DataType valueType) {
        Class ret = this.porttypes.get(valueType);
        if (ret != null) {
            return ret;
        }
        Class porttype = UMLFactory.eINSTANCE.createClass();
        this.uroot.getPackagedElements().add(porttype);
        porttype.applyStereotype(this.sysmlutil.getBlock());
        SysMLUtil.setName(porttype, "PhS" + valueType.getName());
        Property sp = UMLFactory.eINSTANCE.createProperty();
        porttype.getOwnedAttributes().add(sp);
        SysMLUtil.setName(sp, "phs" + valueType.getName());
        sp.applyStereotype(this.sysmlutil.getFlowProperty());
        sp.setValue(this.sysmlutil.getFlowProperty(), "direction", this.sysmlutil.getFlowPropertyIn());
        sp.applyStereotype(this.sysmlutil.getPhSVariable());
        sp.setType(valueType);
        return porttype;
    }

    private DataType getValueType(String unit) {
        DataType dt = this.units.get(unit);
        if (dt != null) {
            return dt;
        }
        dt = UMLFactory.eINSTANCE.createDataType();
        this.units.put(unit, dt);
        this.uroot.getPackagedElements().add(dt);
        Generalization ugen = UMLFactory.eINSTANCE.createGeneralization();
        dt.getGeneralizations().add(ugen);
        ugen.setGeneral(this.sysmlutil.getSysMLDouble());
        ugen.setSpecific(dt);
        dt.applyStereotype(this.sysmlutil.getValueType());
        StringBuilder sbunit = new StringBuilder();
        for (char c : unit.toCharArray()) {
            if (!Character.isLetterOrDigit(c)) continue;
            sbunit.append(c);
        }
        SysMLUtil.setName(dt, "VT" + sbunit.toString());
        InstanceSpecification isunit = UMLFactory.eINSTANCE.createInstanceSpecification();
        this.uroot.getPackagedElements().add(isunit);
        SysMLUtil.setName(isunit, "SU" + sbunit.toString());
        isunit.getClassifiers().add(this.sysmlutil.getUnit());
        Slot slot = UMLFactory.eINSTANCE.createSlot();
        isunit.getSlots().add(slot);
        slot.setDefiningFeature(this.sysmlutil.getUnit().getAttribute("symbol", null));
        LiteralString ls = UMLFactory.eINSTANCE.createLiteralString();
        slot.getValues().add(ls);
        ls.setValue(unit);
        dt.setValue(this.sysmlutil.getValueType(), "unit", isunit);
        return dt;
    }

    private List<Property> convertList(List<SMember> path) {
        ArrayList<Property> ret = new ArrayList<Property>(path.size());
        for (SMember smember : path) {
            ret.add(this.createProperty(smember));
        }
        return ret;
    }

    private Connector createConnector(Class ublock, List<Property> lp0, List<Property> lp1) {
        Connector uconnector = UMLFactory.eINSTANCE.createConnector();
        ublock.getOwnedConnectors().add(uconnector);
        ConnectorEnd uce0 = UMLFactory.eINSTANCE.createConnectorEnd();
        uconnector.getEnds().add(uce0);
        this.populateConnectorEnd(uce0, lp0);
        ConnectorEnd uce1 = UMLFactory.eINSTANCE.createConnectorEnd();
        uconnector.getEnds().add(uce1);
        this.populateConnectorEnd(uce1, lp1);
        return uconnector;
    }

    private Connector createConnector(Class ublock, Property uproperty00, Property uproperty01, Property uproperty10, Property uproperty11) {
        String sp00 = uproperty00 == null ? null : uproperty00.getName();
        String sp01 = uproperty01 == null ? null : uproperty01.getName();
        String sp10 = uproperty10 == null ? null : uproperty10.getName();
        String sp11 = uproperty11 == null ? null : uproperty11.getName();
        log.info("Creating connector from " + sp00 + "." + sp01 + " to " + sp10 + "." + sp11);
        Connector uconnector = UMLFactory.eINSTANCE.createConnector();
        ublock.getOwnedConnectors().add(uconnector);
        ConnectorEnd ce0 = UMLFactory.eINSTANCE.createConnectorEnd();
        uconnector.getEnds().add(ce0);
        this.populateConnectorEnd(ce0, uproperty00, uproperty01);
        ConnectorEnd ce1 = UMLFactory.eINSTANCE.createConnectorEnd();
        uconnector.getEnds().add(ce1);
        this.populateConnectorEnd(ce1, uproperty10, uproperty11);
        return uconnector;
    }

    private void populateConnectorEnd(ConnectorEnd uconnectorend, Property uproperty0, Property property1) {
        if (property1 != null) {
            uconnectorend.setPartWithPort(uproperty0);
            uconnectorend.setRole(property1);
            LinkedList<Property> np0 = new LinkedList<Property>();
            np0.add(uproperty0);
            uconnectorend.applyStereotype(this.sysmlutil.getNestedConnectorEnd());
            uconnectorend.setValue(this.sysmlutil.getNestedConnectorEnd(), "propertyPath", np0);
        } else {
            uconnectorend.setRole(uproperty0);
        }
    }

    private void populateConnectorEnd(ConnectorEnd uconnectorend, List<Property> lp) {
        LinkedList<Property> pp = new LinkedList<Property>(lp);
        int pps = pp.size();
        if (pps > 0) {
            uconnectorend.setRole((ConnectableElement)pp.get(pps - 1));
            pp.remove(pps - 1);
        }
        if (pps > 1) {
            uconnectorend.setPartWithPort((Property)pp.get(pps - 2));
        }
        if (pps > 1) {
            uconnectorend.applyStereotype(this.sysmlutil.getNestedConnectorEnd());
            uconnectorend.setValue(this.sysmlutil.getNestedConnectorEnd(), "propertyPath", pp);
        }
    }

    @Override
    public Set<java.lang.Class<?>> getOptions() {
        return null;
    }

    protected static class ReferenceKey {
        private SNamedElement[] key;

        public ReferenceKey(SNamedElement[] key) {
            this.key = (SNamedElement[])key.clone();
        }

        public SNamedElement[] getKey() {
            return (SNamedElement[])this.key.clone();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ReferenceKey) {
                ReferenceKey rk = (ReferenceKey)obj;
                if (rk.key.length != this.key.length) {
                    return false;
                }
                for (int i = 0; i < this.key.length; ++i) {
                    if (rk.key[i] == this.key[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (SNamedElement melem : this.key) {
                sb.append(melem.getName() + " ");
            }
            return sb.toString();
        }
    }
}

