/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.translation.simulink;

import com.engisis.sysphs.generation.simulink.MATLABBaseListener;
import com.engisis.sysphs.generation.simulink.MATLABParser;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatlabExpressionExtractor
extends MATLABBaseListener {
    private static final Logger log = Logger.getLogger(MatlabExpressionExtractor.class);
    private ParseTreeProperty<String> ptp = new ParseTreeProperty();
    private Hashtable<String, String> substitutions;
    private String scondition;
    private String stime;
    private List<String> lentry;
    private List<String> ldo;
    private List<String> lexit;

    public void prepareNextStateLabelParsing(Hashtable<String, String> substitutions) {
        this.substitutions = substitutions;
    }

    public void prepareNextTransitionLabelParsing(Hashtable<String, String> substitutions) {
        this.substitutions = substitutions;
    }

    public String getTransitionCondition() {
        return this.scondition;
    }

    public String getTransitionTime() {
        return this.stime;
    }

    public List<String> getEntry() {
        return this.lentry;
    }

    public List<String> getDo() {
        return this.ldo;
    }

    public List<String> getExit() {
        return this.lexit;
    }

    public String getValue(ParseTree pt) {
        String v = this.ptp.get(pt);
        if (v == null) {
            log.error("The value of " + pt.getClass() + " is null");
        }
        return v;
    }

    public void setValue(ParseTree pt, String str) {
        this.ptp.put(pt, str);
    }

    @Override
    public void exitEntry_action(MATLABParser.Entry_actionContext ctx) {
        if (this.lentry == null) {
            this.lentry = new LinkedList<String>();
        }
        for (MATLABParser.AssignmentContext ac : ctx.assignment()) {
            this.lentry.add(this.getValue(ac) + ";");
        }
    }

    @Override
    public void exitDuring_action(MATLABParser.During_actionContext ctx) {
        if (this.ldo == null) {
            this.ldo = new LinkedList<String>();
        }
        for (MATLABParser.AssignmentContext ac : ctx.assignment()) {
            this.ldo.add(this.getValue(ac) + ";");
        }
    }

    @Override
    public void exitExit_action(MATLABParser.Exit_actionContext ctx) {
        if (this.lexit == null) {
            this.lexit = new LinkedList<String>();
        }
        for (MATLABParser.AssignmentContext ac : ctx.assignment()) {
            this.lexit.add(this.getValue(ac) + ";");
        }
    }

    @Override
    public void exitCondition(MATLABParser.ConditionContext ctx) {
        this.scondition = this.getValue(ctx.expr());
    }

    @Override
    public void exitAssignment(MATLABParser.AssignmentContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitStmt_end(MATLABParser.Stmt_endContext ctx) {
        this.setValue(ctx, ";");
    }

    @Override
    public void exitExpr(MATLABParser.ExprContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr2(MATLABParser.Expr2Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr3(MATLABParser.Expr3Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr4(MATLABParser.Expr4Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr5(MATLABParser.Expr5Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitRelational_op(MATLABParser.Relational_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr6(MATLABParser.Expr6Context ctx) {
        if (ctx.expr7().size() > 1) {
            log.error("Colon operator not supported");
            this.setValue(ctx, "");
        } else {
            this.setValue(ctx, this.getValue(ctx.expr7(0)));
        }
    }

    @Override
    public void exitExpr7(MATLABParser.Expr7Context ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.expr8().size(); ++i) {
            String s = this.getValue(ctx.expr8(i));
            if (s.equals("0")) continue;
            if (sb.length() != 0 && i > 0) {
                sb.append(this.getValue(ctx.add_op(i - 1)));
            }
            sb.append(s);
        }
        if (sb.length() == 0) {
            sb.append("0");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitAdd_op(MATLABParser.Add_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr8(MATLABParser.Expr8Context ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.expr9().size(); ++i) {
            String s = this.getValue(ctx.expr9(i));
            if (s.equals("1")) continue;
            if (sb.length() != 0 && i > 0) {
                sb.append(this.getValue(ctx.mul_op(i - 1)));
            }
            sb.append(s);
        }
        if (sb.length() == 0) {
            sb.append("1");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitMul_op(MATLABParser.Mul_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr9(MATLABParser.Expr9Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitUnary(MATLABParser.UnaryContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr10(MATLABParser.Expr10Context ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitPow_op(MATLABParser.Pow_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpr11(MATLABParser.Expr11Context ctx) {
        if (ctx.AT() != null) {
            log.error("Operator @ not supported");
        } else {
            this.processStraight(ctx);
        }
    }

    @Override
    public void exitArray(MATLABParser.ArrayContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (MATLABParser.RowContext rc : ctx.row()) {
            sb.append(this.getValue(rc));
        }
        sb.append('}');
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitRow(MATLABParser.RowContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int i = 0; i < ctx.expr().size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.getValue(ctx.expr(i)));
        }
        sb.append('}');
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitReference(MATLABParser.ReferenceContext ctx) {
        String v;
        this.processStraight(ctx);
        if (this.substitutions != null && (v = this.substitutions.get(this.getValue(ctx))) != null) {
            this.setValue(ctx, v);
        }
    }

    @Override
    public void exitId_arg(MATLABParser.Id_argContext ctx) {
        if (ctx.ID().getText().equals("after")) {
            List<MATLABParser.ExprContext> exprs = ctx.argument_list().expr();
            if (exprs.size() != 2) {
                log.error("Unexpected number of arguments for function after");
                return;
            }
            if (!exprs.get(1).getText().equals("sec")) {
                log.error("Unsupported ");
            }
            this.stime = exprs.get(0).getText();
        } else {
            this.processStraight(ctx);
        }
    }

    @Override
    public void exitArgument_list(MATLABParser.Argument_listContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitObject(MATLABParser.ObjectContext ctx) {
        if (ctx.val().size() == 2) {
            String v0 = this.getValue(ctx.val(0).expr());
            String v1 = this.getValue(ctx.val(1).expr());
            if ("1".equals(v0) && v1.startsWith("'") && v1.endsWith("'")) {
                this.setValue(ctx, "1");
                return;
            }
        }
        log.error("Objects can't be translated");
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        int t = node.getSymbol().getType();
        if (t == 40) {
            this.setValue(node, ":=");
        } else if (t == 48) {
            this.setValue(node, " not ");
        } else if (t == 31) {
            this.setValue(node, " and ");
        } else if (t == 30) {
            this.setValue(node, " or ");
        } else if (t == 53) {
            log.error("Operator ' not supported");
        } else if (t == 39) {
            log.error("Operator .' not supported");
        } else if (t == 38) {
            log.error("Operator .^ not supported");
        } else if (t == 36) {
            log.error("Operator ./ not supported");
        } else if (t == 37) {
            log.error("Operator .\\ not supported");
        } else if (t == 35) {
            log.error("Operator .* not supported");
        } else {
            this.setValue(node, node.getText());
        }
    }

    protected void processStraight(ParseTree ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            String v = this.getValue(ctx.getChild(i));
            if (v == null) continue;
            sb.append(v);
        }
        this.setValue(ctx, sb.toString());
    }

    protected void processWithSpaces(ParseTree ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            String v;
            if (i != 0) {
                sb.append(" ");
            }
            if ((v = this.getValue(ctx.getChild(i))) == null) continue;
            sb.append(v);
        }
        this.setValue(ctx, sb.toString());
    }
}

