/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.simulink;

import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SLocation;
import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SConnectionPoint;
import com.engisis.sysphs.language.simulink.SDataValue;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.simulink.SFInputVariable;
import com.engisis.sysphs.language.simulink.SFOutputVariable;
import com.engisis.sysphs.language.simulink.SFVariable;
import com.engisis.sysphs.language.simulink.SFunction1Block;
import com.engisis.sysphs.language.simulink.SFunction2Block;
import com.engisis.sysphs.language.simulink.SInport;
import com.engisis.sysphs.language.simulink.SInterface;
import com.engisis.sysphs.language.simulink.SLibrary;
import com.engisis.sysphs.language.simulink.SLine;
import com.engisis.sysphs.language.simulink.SModel;
import com.engisis.sysphs.language.simulink.SOutport;
import com.engisis.sysphs.language.simulink.SReference;
import com.engisis.sysphs.language.simulink.SSubsystem;
import com.engisis.sysphs.language.simulink.SSystem;
import com.engisis.sysphs.language.simulink.SSystemParameter;
import com.engisis.sysphs.language.simulink.SSystemParameterAssignment;
import com.engisis.sysphs.util.XMLWriter;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SimulinkXMLWriter
extends XMLWriter {
    protected SimulinkXMLWriter(XMLStreamWriter xmlsw) {
        super(xmlsw);
    }

    public void introBlock() throws XMLStreamException {
        this.startElement("Block");
    }

    public void defaultBlock(SBlock sblock) throws XMLStreamException {
        if (sblock.getName() != null && !sblock.getName().isEmpty()) {
            this.attribute("Name", sblock.getName());
        }
        if (sblock.getSID() != null && !sblock.getSID().isEmpty()) {
            this.attribute("SID", sblock.getSID());
        }
    }

    public void positionBlock(SBlock sblock) throws XMLStreamException {
        if (sblock.getOwningSystem() != null) {
            int pos = sblock.getOwningSystem().getOwnedBlocks().indexOf(sblock);
            int w = 20;
            int h = 20;
            int m = 20;
            int x1 = m + m * pos + pos * w;
            int x2 = x1 + w;
            int y1 = m;
            int y2 = y1 + h;
            String position = "[" + x1 + "," + y1 + "," + x2 + "," + y2 + "]";
            this.property("Position", position);
        }
    }

    public void outroBlock() throws XMLStreamException {
        this.endElement();
    }

    public void visit(SExpressionValue object) throws XMLStreamException {
        this.characters(object.getValue());
    }

    public void visit(SFunction1Block object) throws XMLStreamException {
        this.introBlock();
        this.attribute("BlockType", "S-Function");
        this.defaultBlock(object);
        if (object.getSfunction() != null && object.getSfunction().getName() != null && !object.getSfunction().getName().isEmpty()) {
            this.property("FunctionName", object.getSfunction().getName());
        }
        if (object.getSfunction().getOwnedBlocks().size() == 0) {
            this.property("Ports", "[1,1]");
        } else {
            int i = 0;
            int o = 0;
            for (SBlock sbl : object.getSfunction().getOwnedBlocks()) {
                if (sbl instanceof SInport) {
                    ++i;
                    continue;
                }
                if (!(sbl instanceof SOutport)) continue;
                ++o;
            }
            this.property("Ports", "[" + i + "," + o + "]");
        }
        this.positionBlock(object);
        this.outroBlock();
    }

    public void visit(SFunction2Block object) throws XMLStreamException {
        this.introBlock();
        this.attribute("BlockType", "M-S-Function");
        this.defaultBlock(object);
        if (object.getSfunction() != null && object.getSfunction().getName() != null && !object.getSfunction().getName().isEmpty()) {
            this.property("FunctionName", object.getSfunction().getName());
        }
        this.property("Ports", "[" + object.getSfunction().getInputs().size() + "," + object.getSfunction().getOutputs().size() + "]");
        this.positionBlock(object);
        this.outroBlock();
    }

    public void visit(SInport object) throws XMLStreamException {
        this.introBlock();
        this.attribute("BlockType", "Inport");
        this.defaultBlock(object);
        int i = object.getOwningSystem().getInports().indexOf(object) + 1;
        if (i != 0) {
            this.property("Port", String.valueOf(i));
        }
        this.positionBlock(object);
        String unit = object.getUnit();
        if (unit != null) {
            this.property("Unit", unit);
        }
        this.outroBlock();
    }

    public void visit(SInterface object) throws XMLStreamException {
        this.introBlock();
        SSystem ssystem = object.getSystem();
        if (ssystem != null) {
            this.attribute("BlockType", ssystem.getName());
            this.defaultBlock(object);
            this.property("Ports", "[" + ssystem.getInports().size() + "," + ssystem.getOutports().size() + "]");
            this.positionBlock(object);
            for (SSystemParameter sparameter : object.getSystem().getSystemparameters()) {
                SDataValue val = sparameter.getValue();
                for (SSystemParameterAssignment sassignment : object.getAssignments()) {
                    if (sassignment.getParameter() != sparameter) continue;
                    val = sassignment.getValue();
                }
                if (val == null) continue;
                this.startElement("P");
                this.attribute("Name", sparameter.getName());
                val.accept(this.getDispatcher());
                this.endElement();
            }
        }
        this.outroBlock();
    }

    public void visit(SLibrary object) throws XMLStreamException {
        this.startElement("Library");
        this.property("SavedCharacterEncoding", "windows-1252");
        this.property("LibraryType", "BlockLibrary");
        this.property("SaveDefaultBlockParams", "on");
        this.property("ScopeRefreshTime", "0.035000");
        this.property("OverrideScopeRefreshTime", "on");
        this.property("DisableAllScopes", "off");
        this.property("FPTRunName", "Run 1");
        this.property("MaxMDLFileLineLength", "120");
        if (object.getSystem() != null) {
            object.getSystem().accept(this.getDispatcher());
        }
        this.endElement();
    }

    public void visit(SLine object) throws XMLStreamException {
        this.startElement("Line");
        SBlock sbsrcblock = object.getSource().getBlock();
        SBlock sbsrcport = object.getSource().getPort();
        String srcblock = sbsrcblock.getSID();
        String srcport = "out:0";
        if (sbsrcport == null) {
            srcport = "out:1";
        } else if (sbsrcblock instanceof SSubsystem) {
            if (sbsrcport instanceof SInport) {
                srcport = "out:" + (((SSubsystem)sbsrcblock).getSystem().getInports().indexOf(sbsrcport) + 1);
            } else if (sbsrcport instanceof SOutport) {
                srcport = "out:" + (((SSubsystem)sbsrcblock).getSystem().getOutports().indexOf(sbsrcport) + 1);
            }
        } else if (sbsrcblock instanceof SReference) {
            if (sbsrcport instanceof SInport) {
                srcport = "out:" + (((SReference)sbsrcblock).getSystem().getInports().indexOf(sbsrcport) + 1);
            } else if (sbsrcport instanceof SOutport) {
                srcport = "out:" + (((SReference)sbsrcblock).getSystem().getOutports().indexOf(sbsrcport) + 1);
            }
        } else if (sbsrcblock instanceof SInterface) {
            if (sbsrcport instanceof SInport) {
                srcport = "out:" + (((SInterface)sbsrcblock).getSystem().getInports().indexOf(sbsrcport) + 1);
            } else if (sbsrcport instanceof SOutport) {
                srcport = "out:" + (((SInterface)sbsrcblock).getSystem().getOutports().indexOf(sbsrcport) + 1);
            }
        } else if (sbsrcblock instanceof SFunction1Block) {
            if (sbsrcport instanceof SInport) {
                srcport = "out:" + (((SFunction1Block)sbsrcblock).getSfunction().getInports().indexOf(sbsrcport) + 1);
            } else if (sbsrcport instanceof SOutport) {
                srcport = "out:" + (((SFunction1Block)sbsrcblock).getSfunction().getOutports().indexOf(sbsrcport) + 1);
            }
        } else if (sbsrcblock instanceof SFunction2Block) {
            if (sbsrcport instanceof SInport) {
                srcport = "out:" + (((SFunction2Block)sbsrcblock).getSfunction().getInports().indexOf(sbsrcport) + 1);
            } else if (sbsrcport instanceof SOutport) {
                srcport = "out:" + (((SFunction2Block)sbsrcblock).getSfunction().getOutports().indexOf(sbsrcport) + 1);
            }
        } else if (sbsrcport instanceof SInport) {
            srcport = "out:" + (sbsrcport.getOwningSystem().getInports().indexOf(sbsrcport) + 1);
        } else if (sbsrcport instanceof SOutport) {
            srcport = "out:" + (sbsrcport.getOwningSystem().getOutports().indexOf(sbsrcport) + 1);
        }
        this.property("Src", srcblock + "#" + srcport);
        for (SConnectionPoint sdestination : object.getDestinations()) {
            SBlock sbdstblock = sdestination.getBlock();
            SBlock sbdstport = sdestination.getPort();
            String dstblock = sbdstblock.getSID();
            String dstport = "in:0";
            if (sbdstport == null) {
                dstport = "in:1";
            } else if (sbdstblock instanceof SSubsystem) {
                if (sbdstport instanceof SInport) {
                    dstport = "in:" + (((SSubsystem)sbdstblock).getSystem().getInports().indexOf(sbdstport) + 1);
                } else if (sbdstport instanceof SOutport) {
                    dstport = "in:" + (((SSubsystem)sbdstblock).getSystem().getOutports().indexOf(sbdstport) + 1);
                }
            } else if (sbdstblock instanceof SReference) {
                if (sbdstport instanceof SInport) {
                    dstport = "in:" + (((SReference)sbdstblock).getSystem().getInports().indexOf(sbdstport) + 1);
                } else if (sbdstport instanceof SOutport) {
                    dstport = "in:" + (((SReference)sbdstblock).getSystem().getOutports().indexOf(sbdstport) + 1);
                }
            } else if (sbdstblock instanceof SInterface) {
                if (sbdstport instanceof SInport) {
                    dstport = "in:" + (((SInterface)sbdstblock).getSystem().getInports().indexOf(sbdstport) + 1);
                } else if (sbdstport instanceof SOutport) {
                    dstport = "in:" + (((SInterface)sbdstblock).getSystem().getOutports().indexOf(sbdstport) + 1);
                }
            } else if (sbdstblock instanceof SFunction1Block) {
                if (sbdstport instanceof SInport) {
                    dstport = "in:" + (((SFunction1Block)sbdstblock).getSfunction().getInports().indexOf(sbdstport) + 1);
                } else if (sbdstport instanceof SOutport) {
                    dstport = "in:" + (((SFunction1Block)sbdstblock).getSfunction().getOutports().indexOf(sbdstport) + 1);
                }
            } else if (sbdstblock instanceof SFunction2Block) {
                if (sbdstport instanceof SInport) {
                    dstport = "in:" + (((SFunction2Block)sbdstblock).getSfunction().getInports().indexOf(sbdstport) + 1);
                } else if (sbdstport instanceof SOutport) {
                    dstport = "in:" + (((SFunction2Block)sbdstblock).getSfunction().getOutports().indexOf(sbdstport) + 1);
                }
            } else if (sbdstport instanceof SInport) {
                dstport = "in:" + (sbdstport.getOwningSystem().getInports().indexOf(sbdstport) + 1);
            } else if (sbdstport instanceof SOutport) {
                dstport = "in:" + (sbdstport.getOwningSystem().getOutports().indexOf(sbdstport) + 1);
            }
            if (object.getDestinations().size() > 1) {
                this.startElement("Branch");
                this.property("Dst", dstblock + "#" + dstport);
                this.endElement();
                continue;
            }
            this.property("Dst", dstblock + "#" + dstport);
        }
        this.endElement();
    }

    public void visit(SModel object) throws XMLStreamException {
        this.startElement("Model");
        this.startElement("Object");
        this.attribute("PropName", "BdWindowsInfo");
        this.attribute("ObjectID", "1");
        this.attribute("ClassName", "Simulink.BDWindowsInfo");
        this.startElement("Object");
        this.attribute("PropName", "WindowsInfo");
        this.attribute("ObjectID", "2");
        this.attribute("ClassName", "Simulink.WindowInfo");
        this.property("IsActive", "1");
        this.startElement("Object");
        this.attribute("PropName", "ModelBrowserInfo");
        this.attribute("ObjectID", "3");
        this.attribute("ClassName", "Simulink.ModelBrowserInfo");
        this.endElement();
        this.startElement("Object");
        this.attribute("PropName", "ExplorerBarInfo");
        this.attribute("ObjectID", "4");
        this.attribute("ClassName", "Simulink.ExplorerBarInfo");
        this.endElement();
        this.startElement("Object");
        this.attribute("PropName", "EditorsInfo");
        this.attribute("ObjectID", "5");
        this.attribute("ClassName", "Simulink.EditorInfo");
        this.endElement();
        this.endElement();
        this.endElement();
        if (object.getSystem() != null) {
            object.getSystem().accept(this.getDispatcher());
        }
        this.endElement();
    }

    public void visit(SOutport object) throws XMLStreamException {
        this.introBlock();
        this.attribute("BlockType", "Outport");
        this.defaultBlock(object);
        int i = object.getOwningSystem().getOutports().indexOf(object) + 1;
        if (i != 0) {
            this.property("Port", String.valueOf(i));
        }
        this.positionBlock(object);
        String unit = object.getUnit();
        if (unit != null) {
            this.property("Unit", unit);
        }
        this.outroBlock();
    }

    public void visit(SDoubleValue object) throws XMLStreamException {
        this.characters(String.valueOf(object.getValue()));
    }

    public void visit(SReference object) throws XMLStreamException {
        this.introBlock();
        this.attribute("BlockType", "Reference");
        this.defaultBlock(object);
        if (object.getSystem() != null) {
            this.property("Ports", "[" + SimulinkXMLWriter.getSystemPorts(object.getSystem()) + "]");
            this.positionBlock(object);
            this.property("SourceBlock", object.getSystem().getPath());
            this.property("SourceType", "SubSystem");
        }
        this.outroBlock();
    }

    public void visit(SSubsystem object) throws XMLStreamException {
        this.introBlock();
        this.attribute("BlockType", "SubSystem");
        this.defaultBlock(object);
        if (object.getSystem() != null) {
            this.property("Ports", "[" + SimulinkXMLWriter.getSystemPorts(object.getSystem()) + "]");
            object.getSystem().accept(this.getDispatcher());
        }
        this.positionBlock(object);
        this.outroBlock();
    }

    public void visit(SSystem object) throws XMLStreamException {
        this.startElement("System");
        if (object.getOwningModel() != null) {
            this.property("Open", "on");
        } else {
            this.property("Open", "off");
        }
        if (object.getSid() != 0) {
            this.property("SIDHighWatermark", String.valueOf(object.getSid()));
        }
        this.printSystem(object);
        this.endElement();
    }

    protected void printSystem(SSystem ssystem) throws XMLStreamException {
        for (SBlock sblock : ssystem.getOwnedBlocks()) {
            sblock.accept(this.getDispatcher());
        }
        for (SLine sline : ssystem.getOwnedLines()) {
            sline.accept(this.getDispatcher());
        }
        for (SBlock sblock : ssystem.getOwnedBlocks()) {
            this.printSystemCode(sblock);
        }
    }

    protected void printSystemCode(SBlock sblock) throws XMLStreamException {
        if (sblock instanceof SFunction2Block) {
            int i;
            SFunction2Block sf2block = (SFunction2Block)sblock;
            List<SFInputVariable> inputs = sf2block.getSfunction().getInputs();
            List<SFOutputVariable> outputs = sf2block.getSfunction().getOutputs();
            if (inputs != null) {
                for (i = 0; i < inputs.size(); ++i) {
                    SFInputVariable sinputvariable = inputs.get(i);
                    SInport sinport = sinputvariable.getInport();
                    if (sinport == null) continue;
                    this.startElement("Line");
                    this.property("Src", sinport.getSID() + "#out:1");
                    this.property("Dst", sf2block.getSID() + "#in:" + (i + 1));
                    this.endElement();
                }
            }
            if (outputs != null) {
                for (i = 0; i < outputs.size(); ++i) {
                    SFOutputVariable soutputvariable = outputs.get(i);
                    SOutport soutport = soutputvariable.getOutport();
                    if (soutport == null) continue;
                    this.startElement("Line");
                    this.property("Src", sf2block.getSID() + "#out:" + (i + 1));
                    this.property("Dst", soutport.getSID() + "#in:1");
                    this.endElement();
                }
            }
        }
    }

    private static String getSystemPorts(SSystem ssystem) {
        if (ssystem == null) {
            return "";
        }
        int ninport = 0;
        int noutport = 0;
        int nlport = 0;
        int nrport = 0;
        for (SBlock sblock : ssystem.getOwnedBlocks()) {
            if (sblock instanceof SInport) {
                ++ninport;
                continue;
            }
            if (sblock instanceof SOutport) {
                ++noutport;
                continue;
            }
            if (!(sblock instanceof SConnectionPortBlock)) continue;
            SLocation sl = ((SConnectionPortBlock)sblock).getLocation();
            if (sl == SLocation.RIGHT) {
                ++nrport;
                continue;
            }
            if (sl != SLocation.LEFT) continue;
            ++nlport;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ninport + "," + noutport);
        if (nlport != 0 || nrport != 0) {
            sb.append(",0,0,0," + nlport + "," + nrport);
        }
        return sb.toString();
    }

    protected void property(String name, String value) throws XMLStreamException {
        this.startElement("P");
        this.attribute("Name", name);
        this.characters(value);
        this.endElement();
    }

    public static String getValue(SFVariable svar) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < svar.getValue().size(); ++i) {
            SDataValue sdv = (SDataValue)svar.getValue().get(i);
            if (i != 0) {
                sb.append(";");
            }
            if (sdv instanceof SExpressionValue) {
                sb.append(((SExpressionValue)sdv).getValue());
                continue;
            }
            if (!(sdv instanceof SDoubleValue)) continue;
            sb.append(((SDoubleValue)sdv).getValue());
        }
        return sb.toString();
    }
}

