/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.simulink;

import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SMember;
import com.engisis.sysphs.language.simscape.SMemberAssignment;
import com.engisis.sysphs.language.simscape.SPhysicalBlock;
import com.engisis.sysphs.language.simscape.SPhysicalConnectionPoint;
import com.engisis.sysphs.language.simscape.SPhysicalLine;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.simulink.SSystem;
import com.engisis.sysphs.serialization.simulink.SimulinkMDLWriter;
import java.io.IOException;
import java.io.Writer;

public class SimulinkSimscapeMDLWriter
extends SimulinkMDLWriter {
    public SimulinkSimscapeMDLWriter(Writer w) {
        super(w);
    }

    public void visit(SDoubleValue object) throws IOException {
        this.append(Double.toString(object.getValue()));
    }

    public void visit(SExpressionValue object) throws IOException {
        this.append(object.getValue());
    }

    public void visit(SPhysicalBlock object) throws IOException {
        this.introBlock();
        this.append("BlockType Reference");
        SComponent scomponent = object.getComponent();
        if (scomponent != null) {
            this.append("Ports [" + scomponent.getInports().size() + "," + scomponent.getOutports().size() + ",0,0,0," + scomponent.getLConnectionPorts().size() + "," + scomponent.getRConnectionPorts().size() + "]", 3);
            this.append("SourceBlock \"" + scomponent.getBlockName() + "\"", 3);
            this.append("SourceType \"" + scomponent.getName() + "\"", 3);
            if (scomponent.getSubClass() != null) {
                this.append("SourceFile \"" + scomponent.getQualifiedName() + "\"", 3);
                this.append("ComponentPath \"" + scomponent.getQualifiedName() + "\"", 3);
                this.append("ClassName \"" + scomponent.getName() + "\"", 3);
            } else {
                this.append("PhysicalDomain \"" + scomponent.getPhysicalDomain() + "\"", 3);
                this.append("SubClassName \"" + scomponent.getSubClass() + "\"", 3);
            }
            for (SMemberAssignment sassignment : object.getAssignments()) {
                String svar = sassignment.getMemberPath().size() == 1 ? ((SMember)sassignment.getMemberPath().get(0)).getName() : null;
                if (svar == null) continue;
                this.append(svar + " \"", 1);
                sassignment.getAssignedValue().accept(this.getDispatcher());
                this.append("\"", 2);
            }
        }
        this.outroBlock();
    }

    public void visit(SPhysicalLine object) throws IOException {
        this.append("Line", 3);
        this.append("{", 3);
        this.append("LineType \"Connection\"", 3);
        if (object.getPoints().size() > 0) {
            SPhysicalConnectionPoint sconnector = (SPhysicalConnectionPoint)object.getPoints().get(0);
            String srcblock = sconnector.getBlock().getName();
            this.append("SrcBlock \"" + srcblock + "\"", 3);
            this.append("SrcPort " + SimulinkSimscapeMDLWriter.getPortString(sconnector.getPort()), 3);
        }
        if (object.getPoints().size() == 2) {
            SPhysicalConnectionPoint sdestination = (SPhysicalConnectionPoint)object.getPoints().get(1);
            String dstblock = sdestination.getBlock().getName();
            this.append("DstBlock \"" + dstblock + "\"", 3);
            this.append("DstPort " + SimulinkSimscapeMDLWriter.getPortString(sdestination.getPort()), 3);
        } else if (object.getPoints().size() > 2) {
            for (int i = 1; i < object.getPoints().size(); ++i) {
                SPhysicalConnectionPoint ssource = (SPhysicalConnectionPoint)object.getPoints().get(i);
                String srcblock = ssource.getBlock().getName();
                if (i > 1 && i < object.getPoints().size() - 1) {
                    this.append("Branch", 3);
                    this.append("{", 3);
                    this.append("ConnectType \"DEST_SRC\"", 3);
                }
                this.append("Branch", 3);
                this.append("{", 3);
                this.append("ConnectType \"DEST_DEST\"", 3);
                this.append("SrcBlock \"" + srcblock + "\"", 3);
                this.append("SrcPort " + SimulinkSimscapeMDLWriter.getPortString(ssource.getPort()), 3);
                this.append("}", 3);
            }
            for (int j = 2; j < object.getPoints().size() - 1; ++j) {
                this.append("}", 3);
            }
        }
        this.append("}", 3);
    }

    private static String getPortString(SConnectionPortBlock scpb) {
        SSystem ssystem = scpb.getOwningSystem();
        int i = ssystem.getLConnectionPorts().indexOf(scpb);
        if (i != -1) {
            return "LConn" + (i + 1);
        }
        i = ssystem.getRConnectionPorts().indexOf(scpb);
        if (i != -1) {
            return "RConn" + (i + 1);
        }
        return "";
    }
}

