/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.language.stateflow;

import com.engisis.sysphs.language.stateflow.SChart;
import com.engisis.sysphs.language.stateflow.SIdentifiedElement;
import com.engisis.sysphs.language.stateflow.SLinkNode;
import com.engisis.sysphs.language.stateflow.SState;
import com.engisis.sysphs.language.stateflow.SStateflow;
import com.engisis.sysphs.language.stateflow.StateflowPackage;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class STreeNode
extends SIdentifiedElement {
    protected EList<STreeNode> treeNode;
    protected EList<SLinkNode> linkNode;

    protected STreeNode() {
    }

    @Override
    protected EClass eStaticClass() {
        return StateflowPackage.Literals.STREE_NODE;
    }

    public EList<STreeNode> getTreeNode() {
        if (this.treeNode == null) {
            this.treeNode = new BasicInternalEList<STreeNode>(STreeNode.class);
        }
        return this.treeNode;
    }

    public EList<SLinkNode> getLinkNode() {
        if (this.linkNode == null) {
            this.linkNode = new BasicInternalEList<SLinkNode>(SLinkNode.class);
        }
        return this.linkNode;
    }

    public STreeNode getOwningTreeNode() {
        if (this.eContainerFeatureID() != 4) {
            return null;
        }
        return (STreeNode)this.eInternalContainer();
    }

    public NotificationChain basicSetOwningTreeNode(STreeNode newOwningTreeNode, NotificationChain msgs) {
        msgs = this.eBasicSetContainer(newOwningTreeNode, 4, msgs);
        return msgs;
    }

    public void setOwningTreeNode(STreeNode newOwningTreeNode) {
        if (newOwningTreeNode != this.eInternalContainer() || this.eContainerFeatureID() != 4 && newOwningTreeNode != null) {
            if (EcoreUtil.isAncestor(this, (EObject)newOwningTreeNode)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newOwningTreeNode != null) {
                msgs = newOwningTreeNode.eInverseAdd(this, 2, STreeNode.class, msgs);
            }
            if ((msgs = this.basicSetOwningTreeNode(newOwningTreeNode, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getTreeNode()).basicAdd(otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getLinkNode()).basicAdd(otherEnd, msgs);
            }
            case 4: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetOwningTreeNode((STreeNode)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getTreeNode()).basicRemove(otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getLinkNode()).basicRemove(otherEnd, msgs);
            }
            case 4: {
                return this.basicSetOwningTreeNode(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 4: {
                return this.eInternalContainer().eInverseRemove(this, 2, STreeNode.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getTreeNode();
            }
            case 3: {
                return this.getLinkNode();
            }
            case 4: {
                return this.getOwningTreeNode();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getTreeNode().clear();
                this.getTreeNode().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getLinkNode().clear();
                this.getLinkNode().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setOwningTreeNode((STreeNode)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getTreeNode().clear();
                return;
            }
            case 3: {
                this.getLinkNode().clear();
                return;
            }
            case 4: {
                this.setOwningTreeNode(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.treeNode != null && !this.treeNode.isEmpty();
            }
            case 3: {
                return this.linkNode != null && !this.linkNode.isEmpty();
            }
            case 4: {
                return this.getOwningTreeNode() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public SChart getChart() {
        STreeNode owner = this.getOwningTreeNode();
        if (owner == null) {
            return null;
        }
        if (owner instanceof SChart) {
            return (SChart)owner;
        }
        return ((SState)owner).getChart();
    }

    public String getTreeNodeString() {
        int owner = 0;
        int owned = 0;
        int pre = 0;
        int nex = 0;
        if (this.getOwningTreeNode() != null) {
            owner = this.getOwningTreeNode().getId();
            LinkedList<STreeNode> list = new LinkedList<STreeNode>();
            for (STreeNode streenode : this.getOwningTreeNode().getTreeNode()) {
                if (streenode.getClass() != this.getClass()) continue;
                list.add(streenode);
            }
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != this) continue;
                if (i - 1 >= 0) {
                    pre = ((STreeNode)list.get(i - 1)).getId();
                }
                if (i + 1 >= list.size()) break;
                nex = ((STreeNode)list.get(i + 1)).getId();
                break;
            }
        }
        if (this.getTreeNode().size() != 0) {
            owned = ((STreeNode)this.getTreeNode().get(0)).getId();
        }
        return "[" + owner + " " + owned + " " + pre + " " + nex + "]";
    }

    public void setID() {
        SStateflow stateflow = this.getStateflow();
        if (stateflow == null) {
            throw new RuntimeException("Wrong usage!!!");
        }
        this.setId(stateflow.generateID());
    }

    public SStateflow getStateflow() {
        if (this.getOwningTreeNode() != null) {
            return this.getOwningTreeNode().getStateflow();
        }
        return null;
    }
}

