/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.language.modelica;

import com.engisis.sysphs.language.modelica.MAlgorithm;
import com.engisis.sysphs.language.modelica.MComponent;
import com.engisis.sysphs.language.modelica.MElement;
import com.engisis.sysphs.language.modelica.MEquation;
import com.engisis.sysphs.language.modelica.MExtension;
import com.engisis.sysphs.language.modelica.MNamedElement;
import com.engisis.sysphs.language.modelica.ModelicaFactory;
import com.engisis.sysphs.language.modelica.ModelicaPackage;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MClass
extends MNamedElement {
    protected EList<MClass> ownedClasses;
    protected EList<MComponent> components;
    protected EList<MEquation> equations;
    protected EList<MExtension> extensions;
    protected EList<MAlgorithm> algorithms;

    protected MClass() {
    }

    @Override
    protected EClass eStaticClass() {
        return ModelicaPackage.Literals.MCLASS;
    }

    public EList<MClass> getOwnedClasses() {
        if (this.ownedClasses == null) {
            this.ownedClasses = new BasicInternalEList<MClass>(MClass.class);
        }
        return this.ownedClasses;
    }

    public EList<MComponent> getComponents() {
        if (this.components == null) {
            this.components = new BasicInternalEList<MComponent>(MComponent.class);
        }
        return this.components;
    }

    public EList<MEquation> getEquations() {
        if (this.equations == null) {
            this.equations = new BasicInternalEList<MEquation>(MEquation.class);
        }
        return this.equations;
    }

    public EList<MExtension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new BasicInternalEList<MExtension>(MExtension.class);
        }
        return this.extensions;
    }

    public MClass getOwningClass() {
        if (this.eContainerFeatureID() != 5) {
            return null;
        }
        return (MClass)this.eInternalContainer();
    }

    public NotificationChain basicSetOwningClass(MClass newOwningClass, NotificationChain msgs) {
        msgs = this.eBasicSetContainer(newOwningClass, 5, msgs);
        return msgs;
    }

    public void setOwningClass(MClass newOwningClass) {
        if (newOwningClass != this.eInternalContainer() || this.eContainerFeatureID() != 5 && newOwningClass != null) {
            if (EcoreUtil.isAncestor(this, (EObject)newOwningClass)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newOwningClass != null) {
                msgs = newOwningClass.eInverseAdd(this, 1, MClass.class, msgs);
            }
            if ((msgs = this.basicSetOwningClass(newOwningClass, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }

    public EList<MAlgorithm> getAlgorithms() {
        if (this.algorithms == null) {
            this.algorithms = new BasicInternalEList<MAlgorithm>(MAlgorithm.class);
        }
        return this.algorithms;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getOwnedClasses()).basicAdd(otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getComponents()).basicAdd(otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getEquations()).basicAdd(otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getExtensions()).basicAdd(otherEnd, msgs);
            }
            case 5: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetOwningClass((MClass)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getOwnedClasses()).basicRemove(otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getComponents()).basicRemove(otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getEquations()).basicRemove(otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getExtensions()).basicRemove(otherEnd, msgs);
            }
            case 5: {
                return this.basicSetOwningClass(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 5: {
                return this.eInternalContainer().eInverseRemove(this, 1, MClass.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getOwnedClasses();
            }
            case 2: {
                return this.getComponents();
            }
            case 3: {
                return this.getEquations();
            }
            case 4: {
                return this.getExtensions();
            }
            case 5: {
                return this.getOwningClass();
            }
            case 6: {
                return this.getAlgorithms();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getOwnedClasses().clear();
                this.getOwnedClasses().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getComponents().clear();
                this.getComponents().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getEquations().clear();
                this.getEquations().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getExtensions().clear();
                this.getExtensions().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setOwningClass((MClass)newValue);
                return;
            }
            case 6: {
                this.getAlgorithms().clear();
                this.getAlgorithms().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getOwnedClasses().clear();
                return;
            }
            case 2: {
                this.getComponents().clear();
                return;
            }
            case 3: {
                this.getEquations().clear();
                return;
            }
            case 4: {
                this.getExtensions().clear();
                return;
            }
            case 5: {
                this.setOwningClass(null);
                return;
            }
            case 6: {
                this.getAlgorithms().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.ownedClasses != null && !this.ownedClasses.isEmpty();
            }
            case 2: {
                return this.components != null && !this.components.isEmpty();
            }
            case 3: {
                return this.equations != null && !this.equations.isEmpty();
            }
            case 4: {
                return this.extensions != null && !this.extensions.isEmpty();
            }
            case 5: {
                return this.getOwningClass() != null;
            }
            case 6: {
                return this.algorithms != null && !this.algorithms.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    protected String getClassPrefix() {
        return "class";
    }

    public MComponent getComponentByName(String name) {
        for (MExtension mextension : this.getExtensions()) {
            MClass mclass = mextension.getExtendedClass();
            MComponent mcomponent = mclass.getComponentByName(name);
            if (mcomponent == null) continue;
            return mcomponent;
        }
        for (MComponent mcomponent : this.getComponents()) {
            if (!mcomponent.getName().equals(name)) continue;
            return mcomponent;
        }
        return null;
    }

    @Override
    public MElement createClone() {
        return ModelicaFactory.eINSTANCE.createMClass();
    }

    @Override
    public void copyElement(MElement melement) {
        super.copyElement(melement);
        if (melement instanceof MClass) {
            MClass mclass = (MClass)melement;
            this.setOwningClass(mclass.getOwningClass());
            for (MComponent mcomponent : mclass.getComponents()) {
                MComponent mcomponent2 = (MComponent)mcomponent.createClone();
                mcomponent2.copyElement(mcomponent);
                this.getComponents().add(mcomponent2);
            }
            for (MEquation mequation : mclass.getEquations()) {
                MEquation mequation2 = mequation.createClone();
                mequation2.copyElement(mequation);
                this.getEquations().add(mequation2);
            }
            for (MExtension mextension : mclass.getExtensions()) {
                MExtension mextension2 = (MExtension)mextension.createClone();
                mextension2.copyElement(mextension);
                this.getExtensions().add(mextension2);
            }
            for (MAlgorithm malgorithm : mclass.getAlgorithms()) {
                MAlgorithm malgorithm2 = (MAlgorithm)malgorithm.createClone();
                malgorithm2.copyElement(malgorithm);
                this.getAlgorithms().add(malgorithm2);
            }
        } else {
            throw new IllegalArgumentException("The argument should be a MClass");
        }
    }

    public List<MEquation> getAllEquations() {
        LinkedList<MEquation> ret = new LinkedList<MEquation>();
        Stack<MClass> st = new Stack<MClass>();
        st.add(this);
        while (!st.isEmpty()) {
            MClass mc = (MClass)st.pop();
            ret.addAll(mc.getEquations());
            for (MExtension me : mc.getExtensions()) {
                st.push(me.getExtendedClass());
            }
        }
        return ret;
    }

    public List<MComponent> getAllComponents() {
        LinkedList<MComponent> ret = new LinkedList<MComponent>();
        Stack<MClass> st = new Stack<MClass>();
        st.add(this);
        while (!st.isEmpty()) {
            MClass mc = (MClass)st.pop();
            ret.addAll(mc.getComponents());
            for (MExtension me : mc.getExtensions()) {
                st.push(me.getExtendedClass());
            }
        }
        return ret;
    }
}

