/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.deserialization.simulink.SimulinkReader;
import com.engisis.sysphs.deserialization.simulink.SimulinkReference;
import com.engisis.sysphs.deserialization.simulink.SimulinkXMLReaderPass1;
import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SimulinkFactory;
import com.engisis.sysphs.language.stateflow.SChart;
import com.engisis.sysphs.language.stateflow.SChartBlock;
import com.engisis.sysphs.language.stateflow.SData;
import com.engisis.sysphs.language.stateflow.SDataScope;
import com.engisis.sysphs.language.stateflow.SInstance;
import com.engisis.sysphs.language.stateflow.SMachine;
import com.engisis.sysphs.language.stateflow.SState;
import com.engisis.sysphs.language.stateflow.SStateflow;
import com.engisis.sysphs.language.stateflow.STarget;
import com.engisis.sysphs.language.stateflow.STransition;
import com.engisis.sysphs.language.stateflow.StateflowFactory;
import com.engisis.sysphs.translation.simulink.SimulinkUtil;
import com.engisis.sysphs.util.Util;
import com.engisis.sysphs.util.XMLReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateflowXMLReaderPass1
extends XMLReader
implements SimulinkReader {
    private static final Logger log = Logger.getLogger(StateflowXMLReaderPass1.class);
    private SimulinkXMLReaderPass1 definition;
    private SStateflow sstateflow;
    private Collection<SimulinkReference> references;
    private Hashtable<Integer, SElement> ids;
    private InputStream is;

    public StateflowXMLReaderPass1(SimulinkXMLReaderPass1 definition, InputStream inputStream) {
        this.definition = definition;
        this.references = new LinkedList<SimulinkReference>();
        this.ids = new Hashtable();
        this.is = inputStream;
    }

    public SStateflow getStateflow() {
        return this.sstateflow;
    }

    @Override
    public void process() {
        try {
            XmlPullParserFactory xmlppf = XmlPullParserFactory.newInstance();
            this.xmlpp = xmlppf.newPullParser();
            this.xmlpp.setInput(this.is, null);
            this.lookForElement("ModelInformation");
            this.processModelInformation();
        }
        catch (XmlPullParserException e) {
            log.error(e);
        }
        catch (IOException e) {
            log.error(e);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException e) {}
        }
    }

    private void processModelInformation() throws XmlPullParserException, IOException {
        log.info("Defining Model");
        int et = this.xmlpp.getEventType();
        int depth = this.xmlpp.getDepth();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String ln2 = this.xmlpp.getName();
            if (ln2.equals("Stateflow")) {
                this.sstateflow = this.processStateflow();
                continue;
            }
            this.skipToEnd();
        }
    }

    private SStateflow processStateflow() throws XmlPullParserException, IOException {
        log.info("Defining Stateflow");
        SStateflow sstateflow = StateflowFactory.eINSTANCE.createSStateflow();
        int et = this.xmlpp.getEventType();
        int depth = this.xmlpp.getDepth();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String name = this.xmlpp.getName();
            if (name.equals("machine")) {
                SMachine sma = this.processMachine();
                sstateflow.setMachine(sma);
                continue;
            }
            if (name.equals("instance")) {
                SInstance sinstance = this.processInstance();
                sstateflow.getInstance().add(sinstance);
                continue;
            }
            this.skipToEnd();
        }
        return sstateflow;
    }

    private SInstance processInstance() {
        log.info("Defining Instance");
        SInstance sinstance = StateflowFactory.eINSTANCE.createSInstance();
        this.associateID(sinstance);
        return sinstance;
    }

    private SMachine processMachine() throws XmlPullParserException, IOException {
        log.info("Defining Machine");
        SMachine smachine = StateflowFactory.eINSTANCE.createSMachine();
        String id = this.xmlpp.getAttributeValue(null, "id");
        smachine.setId(Util.toInt(id, 0));
        int et = this.xmlpp.getEventType();
        int depth = this.xmlpp.getDepth();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            String name;
            et = this.xmlpp.next();
            if (et != 2 || (name = this.xmlpp.getName()).equals("P")) continue;
            if (name.equals("Children")) {
                int depth2 = this.xmlpp.getDepth();
                while (et != 3 || depth2 != this.xmlpp.getDepth()) {
                    et = this.xmlpp.next();
                    if (et != 2) continue;
                    name = this.xmlpp.getName();
                    if (name.equals("target")) {
                        STarget starget = this.processTarget();
                        smachine.setTarget(starget);
                        continue;
                    }
                    if (name.equals("chart")) {
                        SChart schart = this.processChart();
                        smachine.getChart().add(schart);
                        continue;
                    }
                    this.skipToEnd();
                }
                continue;
            }
            this.skipToEnd();
        }
        return smachine;
    }

    private STarget processTarget() {
        log.info("Defining Target");
        STarget starget = StateflowFactory.eINSTANCE.createSTarget();
        this.associateID(starget);
        return starget;
    }

    private SChart processChart() throws XmlPullParserException, IOException {
        log.info("Defining Chart");
        SChart schart = StateflowFactory.eINSTANCE.createSChart();
        this.associateID(schart);
        int depth = this.xmlpp.getDepth();
        int et = this.xmlpp.getEventType();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String name = this.xmlpp.getName();
            if (name.equals("P")) {
                String attname = this.xmlpp.getAttributeValue(null, "Name");
                if (!"name".equals(attname)) continue;
                SimulinkUtil.setName(schart, this.xmlpp.nextText());
                if (this.definition != null && this.definition.getModel() != null) {
                    SBlock sb = this.definition.getModel().getSystem().getBlockByName(schart.getName().split("/"));
                    if (sb instanceof SChartBlock) {
                        log.info("Associating chart block with chart " + schart.getName());
                        ((SChartBlock)sb).setChart(schart);
                        continue;
                    }
                    log.error("Unable to locate the chart block " + schart.getName() + ", " + sb);
                    continue;
                }
                log.error("Unable to get simulink definition or its root model");
                continue;
            }
            if (name.equals("Children")) {
                int depth2 = this.xmlpp.getDepth();
                while (et != 3 || depth2 != this.xmlpp.getDepth()) {
                    et = this.xmlpp.next();
                    if (et != 2) continue;
                    String name2 = this.xmlpp.getName();
                    if (name2.equals("state")) {
                        SState sstate = this.processState();
                        schart.getTreeNode().add(sstate);
                        continue;
                    }
                    if (name2.equals("data")) {
                        SData sdata = this.processData();
                        schart.getLinkNode().add(sdata);
                        continue;
                    }
                    if (name2.equals("transition")) {
                        STransition stransition = this.processTransition();
                        schart.getLinkNode().add(stransition);
                        continue;
                    }
                    this.skipToEnd();
                }
                continue;
            }
            this.skipToEnd();
        }
        return schart;
    }

    private SState processState() throws XmlPullParserException, IOException {
        log.info("Defining State");
        SState sstate = StateflowFactory.eINSTANCE.createSState();
        this.associateSSID(sstate);
        int depth = this.xmlpp.getDepth();
        int et = this.xmlpp.getEventType();
        while (et != 3 || this.xmlpp.getDepth() != depth) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            if (this.xmlpp.getName().equals("P")) {
                String name = this.xmlpp.getAttributeValue(null, "Name");
                if (!"labelString".equals(name)) continue;
                String val = this.xmlpp.nextText().trim();
                String[] tab = val.split("\n");
                SimulinkUtil.setName(sstate, tab[0]);
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i < tab.length; ++i) {
                    if (i != 1) {
                        sb.append("\n");
                    }
                    sb.append(tab[i].trim());
                }
                sstate.setLabel(sb.toString());
                continue;
            }
            this.skipToEnd();
        }
        return sstate;
    }

    private SData processData() throws XmlPullParserException, IOException {
        log.info("Defining Data");
        SData sdata = StateflowFactory.eINSTANCE.createSData();
        this.associateSSID(sdata);
        SimulinkUtil.setName(sdata, this.xmlpp.getAttributeValue(null, "name"));
        int depth = this.xmlpp.getDepth();
        int et = this.xmlpp.getEventType();
        while (et != 3 || depth != this.xmlpp.getDepth()) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String name = this.xmlpp.getName();
            if (name.equals("P")) {
                name = this.xmlpp.getAttributeValue(null, "Name");
                if (!"scope".equals(name)) continue;
                String val = this.xmlpp.nextText().trim();
                if (val.equals("INPUT_DATA")) {
                    sdata.setScope(SDataScope.INPUT);
                    continue;
                }
                if (val.equals("OUTPUT_DATA")) {
                    sdata.setScope(SDataScope.OUTPUT);
                    continue;
                }
                if (!val.equals("CONSTANT_DATA")) continue;
                sdata.setScope(SDataScope.CONSTANT);
                continue;
            }
            if (name.equals("props")) {
                int depth2 = this.xmlpp.getDepth();
                while (et != 3 || depth2 != this.xmlpp.getDepth()) {
                    et = this.xmlpp.next();
                    if (!this.xmlpp.getName().equals("P")) continue;
                    name = this.xmlpp.getAttributeValue(null, "Name");
                    if ("initialValue".equals(name)) {
                        String val = this.xmlpp.nextText().trim();
                        Double d = null;
                        try {
                            log.info("Setting initial value");
                            d = Double.valueOf(val);
                            SDoubleValue sdv = SimulinkFactory.eINSTANCE.createSDoubleValue();
                            sdv.setValue(d);
                            sdata.setValue(sdv);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (!"dataType".equals("name")) continue;
                }
                continue;
            }
            this.skipToEnd();
        }
        return sdata;
    }

    private STransition processTransition() throws XmlPullParserException, IOException {
        log.info("Defining Transition");
        STransition stransition = StateflowFactory.eINSTANCE.createSTransition();
        this.associateSSID(stransition);
        int depth = this.xmlpp.getDepth();
        int et = this.xmlpp.getEventType();
        while (et != 3 || this.xmlpp.getDepth() != depth) {
            et = this.xmlpp.next();
            if (et != 2) continue;
            String name = this.xmlpp.getName();
            if (name.equals("P")) {
                name = this.xmlpp.getAttributeValue(null, "Name");
                String val = this.xmlpp.nextText();
                if (!"labelString".equals(name)) continue;
                stransition.setLabel(val);
                continue;
            }
            this.skipToEnd();
        }
        return stransition;
    }

    private void associateID(SElement selement) {
        String s = this.xmlpp.getAttributeValue(null, "id");
        if (s == null || s.length() == 0) {
            return;
        }
        try {
            this.ids.put(Integer.valueOf(s), selement);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void associateSSID(SElement selement) {
        String s = this.xmlpp.getAttributeValue(null, "SSID");
        if (s == null || s.length() == 0) {
            return;
        }
        this.ids.put(Util.toInteger(s, new Integer(0)), selement);
    }

    @Override
    public Collection<SimulinkReference> getReferences() {
        return this.references;
    }

    public Hashtable<Integer, SElement> getIDs() {
        return this.ids;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public SElement getRootElement() {
        return null;
    }
}

