/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs;

import com.engisis.sysphs.util.Configuration;
import com.engisis.sysphs.util.EMFUtil;
import com.engisis.sysphs.util.SysMLPreProcessor;
import com.engisis.sysphs.util.SysMLToSimulationTranslator;
import com.engisis.sysphs.util.SysMLUtil;
import com.engisis.sysphs.util.UMLModelErrorException;
import com.engisis.sysphs.util.XMIReferenceFinder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysMLToSimulationTranslationManager {
    private static final Logger log = Logger.getLogger(SysMLToSimulationTranslationManager.class);
    private Class rootclass;
    private String rootclassname;
    private Resource resource;
    private SysMLToSimulationTranslator translator;
    private File outputdirectory;
    private boolean preproc = false;
    private boolean preprocdone = false;

    public SysMLToSimulationTranslationManager(String model, String[] paths) throws IOException, FileNotFoundException, UMLModelErrorException, XMLStreamException {
        if (model == null) {
            throw new IllegalArgumentException("The model can't be null");
        }
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i].endsWith(File.separator)) continue;
                int n = i;
                paths[n] = paths[n] + File.separator;
            }
        }
        ResourceSet rs = EMFUtil.createResourceSet();
        Stack<URI> toprepare = new Stack<URI>();
        URI modeluri = URI.createFileURI(new File(model).getAbsolutePath());
        toprepare.push(modeluri);
        Hashtable<URI, HashSet<URI>> deps = new Hashtable<URI, HashSet<URI>>();
        while (toprepare.size() != 0) {
            URI input = (URI)toprepare.pop();
            try {
                InputStream is = rs.getURIConverter().createInputStream(input);
                XMIReferenceFinder xmir = new XMIReferenceFinder(rs, is, Configuration.getReaderIDMappings(), Configuration.getLocationMappings(), modeluri, paths);
                xmir.run();
                is.close();
                deps.put(input, xmir.getReferences());
                for (URI ref : xmir.getReferences()) {
                    log.debug("Dependency between " + input.lastSegment() + " and " + ref.lastSegment());
                    if (deps.containsKey(ref)) continue;
                    toprepare.push(ref);
                }
            }
            catch (IOException e) {
                log.error("Couldn't parse the XMI for dependencies", e);
                throw e;
            }
            catch (XMLStreamException e) {
                log.error("Couldn't parse the XMI for dependencies", e);
                throw e;
            }
            catch (FactoryConfigurationError e) {
                log.error("Couldn't parse the XMI for dependencies", e);
                throw e;
            }
        }
        ArrayList<URI> toload = new ArrayList<URI>();
        while (toload.size() != deps.keySet().size()) {
            boolean action = false;
            block8: for (URI uri : deps.keySet()) {
                if (toload.contains(uri)) continue;
                for (URI ref : (HashSet)deps.get(uri)) {
                    if (toload.contains(ref) || ref.equals(uri)) continue;
                    continue block8;
                }
                log.debug("Added " + uri.lastSegment() + " to load list");
                toload.add(uri);
                action = true;
            }
            if (action) continue;
            log.error("Dependency resolution problem");
            break;
        }
        for (int i = 0; i < toload.size(); ++i) {
            this.resource = EMFUtil.loadResource(rs, (URI)toload.get(i), paths);
        }
        EcoreUtil.resolveAll(rs);
        if (rs.getPackageRegistry().get(SysMLUtil.uriSysML.toString()) == null) {
            throw new UMLModelErrorException(this.resource, "The model doesn't import the SysML profile");
        }
        if (rs.getPackageRegistry().get(SysMLUtil.uriSysPhS.toString()) == null) {
            throw new UMLModelErrorException(this.resource, "The model doesn't import the SysPhS profile");
        }
    }

    public List<String> getClasses() {
        LinkedList<String> ret = new LinkedList<String>();
        TreeIterator<EObject> iter = this.resource.getAllContents();
        while (iter.hasNext()) {
            EObject eo = (EObject)iter.next();
            if (!(eo instanceof NamedElement)) {
                iter.prune();
                continue;
            }
            if (!(eo instanceof Class)) continue;
            ret.add(((Class)eo).getQualifiedName());
        }
        return ret;
    }

    public void setInputRootName(String rootclass) throws UMLModelErrorException {
        if (rootclass == null) {
            throw new IllegalArgumentException("The root element can't be null");
        }
        this.rootclassname = rootclass;
        String[] fqname = rootclass.split("::");
        Model umodel = null;
        for (EObject object : this.resource.getContents()) {
            if (!(object instanceof Model) || !fqname[0].equals(((Model)object).getName())) continue;
            umodel = (Model)object;
        }
        if (umodel == null) {
            throw new UMLModelErrorException(this.resource, "Could not find a root model in the XMI file named " + fqname[0]);
        }
        Namespace currentelement = umodel;
        NamedElement nerootblock = null;
        for (int i = 1; i < fqname.length; ++i) {
            String nextname = fqname[i];
            NamedElement nextelement = currentelement.getMember(nextname);
            if (nextelement == null) {
                log.error("Unknown element: " + currentelement.getQualifiedName() + "::" + fqname[i]);
                break;
            }
            if (rootclass.equals(nextelement.getQualifiedName())) {
                nerootblock = nextelement;
                continue;
            }
            if (nextelement instanceof Namespace) {
                currentelement = (Namespace)nextelement;
                continue;
            }
            log.error("Not a namespace: " + currentelement.getQualifiedName() + "::" + fqname[i]);
            break;
        }
        if (nerootblock == null) {
            throw new UMLModelErrorException(this.resource, "Could not find the root block in the model");
        }
        if (!(nerootblock instanceof Class)) {
            throw new UMLModelErrorException(this.resource, "The root block is not a Class");
        }
        this.rootclass = (Class)nerootblock;
    }

    public String getInputRootName() {
        return this.rootclassname;
    }

    public void setPreprocessing(boolean preproc) {
        this.preproc = preproc;
    }

    public void setOutputDirectory(File outputdirectory) {
        this.outputdirectory = outputdirectory;
    }

    public void setTranslator(SysMLToSimulationTranslator translator) {
        this.translator = translator;
    }

    public void execute() throws UMLModelErrorException, IOException {
        if (this.translator == null) {
            throw new IllegalStateException("A generator must be provided first");
        }
        if (this.rootclass == null) {
            throw new IllegalStateException("A root class must be provided first");
        }
        log.info("started");
        if (this.preproc && !this.preprocdone) {
            if (this.outputdirectory == null) {
                this.resource.setURI(this.resource.getURI().appendFileExtension("bak"));
            } else {
                this.resource.setURI(URI.createFileURI(this.outputdirectory.getAbsolutePath()).appendSegment(this.resource.getURI().lastSegment()).appendFileExtension("bak"));
            }
            SysMLPreProcessor sysmlt = new SysMLPreProcessor(this.resource);
            sysmlt.execute();
            this.resource.save(null);
            this.preprocdone = true;
        }
        this.translator.execute(this.rootclass, this.resource, this.outputdirectory);
    }
}

