/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.ClassOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationClassOperations
extends ClassOperations {
    protected AssociationClassOperations() {
    }

    public static boolean validateCannotBeDefined(AssociationClass associationClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (Type endType : associationClass.getEndTypes()) {
            if (endType != associationClass && (!(endType instanceof Classifier) || !((Classifier)endType).allParents().contains(associationClass))) continue;
            result = false;
            break;
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 438, UMLPlugin.INSTANCE.getString("_UI_AssociationClass_CannotBeDefined_diagnostic", AssociationClassOperations.getMessageSubstitutions(context, associationClass)), new Object[]{associationClass}));
        }
        return result;
    }

    public static boolean validateDisjointAttributesEnds(AssociationClass associationClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = Collections.disjoint(associationClass.getOwnedAttributes(), associationClass.getOwnedEnds());
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 439, UMLPlugin.INSTANCE.getString("_UI_AssociationClass_DisjointAttributesEnds_diagnostic", AssociationClassOperations.getMessageSubstitutions(context, associationClass)), new Object[]{associationClass}));
        }
        return result;
    }
}

