/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMIReferenceFinder
implements Runnable {
    static final Logger log = Logger.getLogger(XMIReferenceFinder.class);
    private HashSet<URI> references = new HashSet();
    private XMLStreamReader xmlr;
    private Map<String, String> objectmap;
    private Map<URI, URI> locationmap;
    private List<URI> baseuris;

    public XMIReferenceFinder(ResourceSet rs, InputStream inputstream, Map<String, String> objectmap, Map<URI, URI> locationmap, URI baseuri, String[] paths) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
        this.objectmap = objectmap;
        this.locationmap = locationmap;
        this.baseuris = new ArrayList<URI>(paths != null ? paths.length : 1);
        if (!baseuri.isHierarchical() || baseuri.isRelative()) {
            log.error("Relative/non hierarchical URI! " + baseuri);
        } else {
            this.baseuris.add(baseuri);
        }
        if (paths != null) {
            for (String path : paths) {
                URI uri = URI.createFileURI(path);
                if (!uri.isHierarchical() || uri.isRelative()) {
                    log.error("Relative/non hierarchical URI! " + uri);
                    continue;
                }
                this.baseuris.add(uri);
            }
        }
        XMLInputFactory xmlif = XMLInputFactory.newFactory();
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        this.xmlr = xmlif.createXMLStreamReader(inputstream);
    }

    @Override
    public void run() {
        try {
            block5: while (this.xmlr.hasNext()) {
                int eventType = this.xmlr.next();
                switch (eventType) {
                    case 1: {
                        block6: for (int i = 0; i < this.xmlr.getAttributeCount(); ++i) {
                            URI uri;
                            String name = this.xmlr.getAttributeLocalName(i);
                            String value = this.xmlr.getAttributeValue(i);
                            if (!"href".equals(name) || value == null) continue;
                            if (this.objectmap.containsKey(value)) {
                                value = this.objectmap.get(value);
                            }
                            if ((uri = URI.createURI(value).trimFragment().trimQuery()).lastSegment() == null) continue;
                            for (URI baseuri : this.baseuris) {
                                URI resuri = uri.resolve(baseuri);
                                boolean stop = false;
                                if (resuri.isFile() && new File(resuri.toFileString()).exists()) {
                                    String suri = resuri.toString();
                                    if (suri.indexOf("!") != -1) {
                                        suri = "jar:" + suri;
                                    }
                                    this.references.add(URI.createURI(suri));
                                    stop = true;
                                }
                                for (Map.Entry<URI, URI> localmapentry : this.locationmap.entrySet()) {
                                    if (!resuri.equals(localmapentry.getKey())) continue;
                                    this.references.add(localmapentry.getValue());
                                    stop = true;
                                    break;
                                }
                                if (!stop) continue;
                                continue block6;
                            }
                        }
                        continue block5;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.error("Error while parsing the file", e);
        }
    }

    public HashSet<URI> getReferences() {
        return this.references;
    }
}

