/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import com.engisis.sysphs.util.UMLModelErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysMLUtil {
    public static final String SYSPHS_LANGUAGE = "sysphs";
    private ResourceSet rs;
    private Stereotype sinitialvaluesspec;
    private Stereotype sblock;
    private Stereotype sconstraintblock;
    private Stereotype sbindingconnector;
    private Stereotype snestedconnectorend;
    private Stereotype svaluetype;
    private Class sunit;
    private Class squantitykind;
    private Stereotype spropertyspecifictype;
    private Stereotype sflowproperty;
    private Stereotype sinterfaceblock;
    private Stereotype sdirectedfeature;
    private Stereotype sconnectorproperty;
    private Stereotype sparticipantproperty;
    private Class sconservedsubstance;
    private Class srealsignalin;
    private Class srealsignalout;
    private Stereotype sphsvariable;
    private Stereotype sphsconstant;
    private Stereotype smultidimelement;
    private Stereotype sinitialvalueref;
    private Stereotype ssimulationvertex;
    private Stereotype smodelicablock;
    private Stereotype smodelicaport;
    private Stereotype smodelicaparameter;
    private Stereotype ssimulinkblock;
    private Stereotype ssimulinkport;
    private Stereotype ssimulinkparameter;
    private DataType ustring;
    private DataType uboolean;
    private DataType uinteger;
    private DataType udouble;
    private DataType sstring;
    private DataType sboolean;
    private DataType sinteger;
    private DataType sdouble;
    private List<LibraryComponent> lscomponents;
    private List<LibraryComponent> lmcomponents;
    private static final URI locationTypes = URI.createURI("http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#");
    public static final URI uriSysML = URI.createURI("http://www.omg.org/spec/SysML/20161101/SysML");
    public static final URI uriSysPhS = URI.createURI("http://www.omg.org/spec/SysPhS/20171215");
    private static final URI uriSysPhSExtended = URI.createURI("http://www.omg.org/spec/SysPhS/20171215/SysPhSExtended");
    private static final URI uriSysPhSPlatformProfile = URI.createURI("http://www.omg.org/spec/SysPhS/20171215/SysPhSPlatformProfile");

    public SysMLUtil(ResourceSet rs) throws UMLModelErrorException {
        if (rs == null) {
            throw new IllegalArgumentException("You must provide a ResourceSet");
        }
        this.rs = rs;
        this.loadSysML();
        this.loadSysPhS();
        this.loadSysPhSExtended();
        this.loadSysPhSPlatform();
    }

    public void loadSysML() throws UMLModelErrorException {
        this.sblock = SysMLUtil.loadStereotype(this.rs, uriSysML, "Block");
        this.sconstraintblock = SysMLUtil.loadStereotype(this.rs, uriSysML, "ConstraintBlock");
        this.sbindingconnector = SysMLUtil.loadStereotype(this.rs, uriSysML, "BindingConnector");
        this.snestedconnectorend = SysMLUtil.loadStereotype(this.rs, uriSysML, "NestedConnectorEnd");
        this.svaluetype = SysMLUtil.loadStereotype(this.rs, uriSysML, "ValueType");
        this.sunit = SysMLUtil.loadClass(this.rs, uriSysML, "Unit");
        this.squantitykind = SysMLUtil.loadClass(this.rs, uriSysML, "QuantityKind");
        this.spropertyspecifictype = SysMLUtil.loadStereotype(this.rs, uriSysML, "PropertySpecificType");
        this.sflowproperty = SysMLUtil.loadStereotype(this.rs, uriSysML, "FlowProperty");
        this.sinterfaceblock = SysMLUtil.loadStereotype(this.rs, uriSysML, "InterfaceBlock");
        this.sdirectedfeature = SysMLUtil.loadStereotype(this.rs, uriSysML, "DirectedFeature");
        this.sconnectorproperty = SysMLUtil.loadStereotype(this.rs, uriSysML, "ConnectorProperty");
        this.sparticipantproperty = SysMLUtil.loadStereotype(this.rs, uriSysML, "ParticipantProperty");
        this.ustring = SysMLUtil.loadType(this.rs, locationTypes, "String");
        this.uboolean = SysMLUtil.loadType(this.rs, locationTypes, "Boolean");
        this.uinteger = SysMLUtil.loadType(this.rs, locationTypes, "Integer");
        this.udouble = SysMLUtil.loadType(this.rs, locationTypes, "Real");
        this.sstring = SysMLUtil.loadType(this.rs, uriSysML, "SysML_dataType.String");
        this.sboolean = SysMLUtil.loadType(this.rs, uriSysML, "SysML_dataType.Boolean");
        this.sinteger = SysMLUtil.loadType(this.rs, uriSysML, "SysML_dataType.Integer");
        this.sdouble = SysMLUtil.loadType(this.rs, uriSysML, "SysML_dataType.Real");
    }

    public void loadSysPhS() throws UMLModelErrorException {
        this.sphsvariable = SysMLUtil.loadStereotype(this.rs, uriSysPhS, "PhSVariable");
        this.sphsconstant = SysMLUtil.loadStereotype(this.rs, uriSysPhS, "PhSConstant");
    }

    public void loadSysPhSExtended() throws UMLModelErrorException {
        if (this.rs.getResource(uriSysPhSExtended, false) != null) {
            this.sinitialvalueref = SysMLUtil.loadStereotype(this.rs, uriSysPhSExtended, "InitialValueReference");
            this.ssimulationvertex = SysMLUtil.loadStereotype(this.rs, uriSysPhSExtended, "SimulationVertex");
            this.sinitialvaluesspec = SysMLUtil.loadStereotype(this.rs, uriSysPhSExtended, "InitialValuesSpecification");
        }
    }

    public void loadSysPhSPlatform() throws UMLModelErrorException {
        Resource r = this.rs.getResource(uriSysPhSPlatformProfile, false);
        if (r != null) {
            this.smultidimelement = SysMLUtil.loadStereotype(this.rs, uriSysPhSPlatformProfile, "MultidimensionalElement");
            this.smodelicablock = SysMLUtil.loadStereotype(this.rs, uriSysPhSPlatformProfile, "ModelicaBlock");
            this.smodelicaparameter = SysMLUtil.loadStereotype(this.rs, uriSysPhSPlatformProfile, "ModelicaParameter");
            this.smodelicaport = SysMLUtil.loadStereotype(this.rs, uriSysPhSPlatformProfile, "ModelicaPort");
            this.ssimulinkblock = SysMLUtil.loadStereotype(this.rs, uriSysPhSPlatformProfile, "SimulinkBlock");
            this.ssimulinkparameter = SysMLUtil.loadStereotype(this.rs, uriSysPhSPlatformProfile, "SimulinkParameter");
            this.ssimulinkport = SysMLUtil.loadStereotype(this.rs, uriSysPhSPlatformProfile, "SimulinkPort");
            this.lscomponents = new LinkedList<LibraryComponent>();
            this.lmcomponents = new LinkedList<LibraryComponent>();
            TreeIterator<EObject> ti = r.getAllContents();
            while (ti.hasNext()) {
                EObject eo = (EObject)ti.next();
                if (!(eo instanceof Namespace)) {
                    ti.prune();
                    continue;
                }
                if (!(eo instanceof Class)) continue;
                Class uclass = (Class)eo;
                this.processLibraryComponent(this.lmcomponents, uclass, this.smodelicablock, this.smodelicaparameter, this.smodelicaport);
                this.processLibraryComponent(this.lscomponents, uclass, this.ssimulinkblock, this.ssimulinkparameter, this.ssimulinkport);
                if ("ConservedSubstance".equals(uclass.getName()) || "ConservedQuantityKind".equals(uclass.getName())) {
                    this.sconservedsubstance = uclass;
                    continue;
                }
                if ("RealSignalInElement".equals(uclass.getName())) {
                    this.srealsignalin = uclass;
                    continue;
                }
                if (!"RealSignalOutElement".equals(uclass.getName())) continue;
                this.srealsignalout = uclass;
            }
        }
    }

    private void processLibraryComponent(List<LibraryComponent> list, Class uclass, Stereotype stclass, Stereotype stparameter, Stereotype stport) {
        if (uclass.isStereotypeApplied(stclass)) {
            String name = (String)uclass.getValue(stclass, "name");
            if (name == null) {
                name = uclass.getName();
            }
            LibraryComponent lc = new LibraryComponent(uclass, name);
            for (Property uproperty : SysMLUtil.getAllAttributes(uclass)) {
                if (uproperty.isStereotypeApplied(stparameter)) {
                    name = (String)uproperty.getValue(stparameter, "name");
                    if (name == null) {
                        name = uproperty.getName();
                    }
                    String value = (String)uproperty.getValue(stparameter, "value");
                    LibraryParameter lp = new LibraryParameter(uproperty, name, value);
                    lc.parameters.add(lp);
                    continue;
                }
                if (!uproperty.isStereotypeApplied(stport)) continue;
                name = (String)uproperty.getValue(stport, "name");
                if (name == null) {
                    name = uproperty.getName();
                }
                LibraryPort lp = new LibraryPort((Port)uproperty, name);
                lc.ports.add(lp);
            }
            list.add(lc);
        }
    }

    public ResourceSet getResourceSet() {
        return this.rs;
    }

    private static Stereotype loadStereotype(ResourceSet rs, URI namespace, String name) throws UMLModelErrorException {
        NamedElement namedelement = SysMLUtil.loadFromNamespaceAndName(rs, namespace, name);
        if (!(namedelement instanceof Stereotype)) {
            throw new ClassCastException("The element named " + name + " in " + namespace + " is not a stereotype");
        }
        return (Stereotype)namedelement;
    }

    private static Class loadClass(ResourceSet rs, URI namespace, String name) throws UMLModelErrorException {
        NamedElement element = SysMLUtil.loadFromNamespaceAndName(rs, namespace, name);
        if (!(element instanceof Class)) {
            throw new ClassCastException("The element named " + name + " in " + namespace + " is not a class");
        }
        return (Class)element;
    }

    private static DataType loadType(ResourceSet rs, URI location, String id) {
        Element element = SysMLUtil.loadFromLocationAndID(rs, location, id);
        if (!(element instanceof DataType)) {
            throw new ClassCastException("The element identified by " + id + " at " + location + " is not a type");
        }
        return (DataType)element;
    }

    private static Element loadFromLocationAndID(ResourceSet rs, URI location, String id) {
        if (location == null) {
            throw new NullPointerException("You must provide a location");
        }
        if (id == null) {
            throw new NullPointerException("You must provide an id");
        }
        return (Element)rs.getEObject(location.appendFragment(id), true);
    }

    private static NamedElement loadFromNamespaceAndName(ResourceSet rs, URI namespace, String name) throws UMLModelErrorException {
        if (rs == null) {
            throw new IllegalArgumentException("You must provide a resource set");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("You must provide a namespace");
        }
        if (name == null) {
            throw new IllegalArgumentException("You must provide a name");
        }
        Resource resource = rs.getResource(namespace, true);
        TreeIterator<EObject> treeiterator = resource.getAllContents();
        while (treeiterator.hasNext()) {
            EObject currenteobject = (EObject)treeiterator.next();
            if (!(currenteobject instanceof Namespace)) {
                treeiterator.prune();
                continue;
            }
            Namespace namedelement = (Namespace)currenteobject;
            if (!name.equals(namedelement.getName())) continue;
            return namedelement;
        }
        throw new UMLModelErrorException(resource, "Can't retrieve an element named " + name + " in " + namespace);
    }

    public Stereotype getInitialValuesSpecification() {
        return this.sinitialvaluesspec;
    }

    public Stereotype getBlock() {
        return this.sblock;
    }

    public Stereotype getConstraintBlock() {
        return this.sconstraintblock;
    }

    public Stereotype getBindingConnector() {
        return this.sbindingconnector;
    }

    public Stereotype getNestedConnectorEnd() {
        return this.snestedconnectorend;
    }

    public Stereotype getValueType() {
        return this.svaluetype;
    }

    public Class getUnit() {
        return this.sunit;
    }

    public Class getQuantityKind() {
        return this.squantitykind;
    }

    public Stereotype getPropertySpecificType() {
        return this.spropertyspecifictype;
    }

    public Stereotype getFlowProperty() {
        return this.sflowproperty;
    }

    public EnumerationLiteral getFlowPropertyIn() {
        return ((Enumeration)this.getFlowProperty().getOwnedAttribute("direction", null).getType()).getOwnedLiteral("in");
    }

    public EnumerationLiteral getFlowPropertyOut() {
        return ((Enumeration)this.getFlowProperty().getOwnedAttribute("direction", null).getType()).getOwnedLiteral("out");
    }

    public EnumerationLiteral getFlowPropertyInout() {
        return ((Enumeration)this.getFlowProperty().getOwnedAttribute("direction", null).getType()).getOwnedLiteral("inout");
    }

    public Stereotype getInterfaceBlock() {
        return this.sinterfaceblock;
    }

    public Stereotype getDirectedFeature() {
        return this.sdirectedfeature;
    }

    public Stereotype getConnectorProperty() {
        return this.sconnectorproperty;
    }

    public Stereotype getParticipantProperty() {
        return this.sparticipantproperty;
    }

    public Stereotype getPhSVariable() {
        return this.sphsvariable;
    }

    public Stereotype getPhSConstant() {
        return this.sphsconstant;
    }

    public Stereotype getMultidimensionalElement() {
        return this.smultidimelement;
    }

    public Stereotype getInitialValueReference() {
        return this.sinitialvalueref;
    }

    public Stereotype getSimulationVertex() {
        return this.ssimulationvertex;
    }

    public DataType getUMLString() {
        return this.ustring;
    }

    public DataType getUMLBoolean() {
        return this.uboolean;
    }

    public DataType getUMLInteger() {
        return this.uinteger;
    }

    public DataType getUMLDouble() {
        return this.udouble;
    }

    public DataType getSysMLString() {
        return this.sstring;
    }

    public DataType getSysMLBoolean() {
        return this.sboolean;
    }

    public DataType getSysMLInteger() {
        return this.sinteger;
    }

    public DataType getSysMLDouble() {
        return this.sdouble;
    }

    public Class getConservedSubstance() {
        return this.sconservedsubstance;
    }

    public Class getRealSignalIn() {
        return this.srealsignalin;
    }

    public Class getRealSignalOut() {
        return this.srealsignalout;
    }

    public Stereotype getModelicaBlock() {
        return this.smodelicablock;
    }

    public Stereotype getModelicaParameter() {
        return this.smodelicaparameter;
    }

    public Stereotype getModelicaPort() {
        return this.smodelicaport;
    }

    public Stereotype getSimulinkBlock() {
        return this.ssimulinkblock;
    }

    public Stereotype getSimulinkParameter() {
        return this.ssimulinkparameter;
    }

    public Stereotype getSimulinkPort() {
        return this.ssimulinkport;
    }

    public List<LibraryComponent> getSimulinkComponents() {
        return Collections.unmodifiableList(this.lscomponents);
    }

    public List<LibraryComponent> getModelicaComponents() {
        return Collections.unmodifiableList(this.lmcomponents);
    }

    public List<Property> getPropertyPath(ConnectorEnd end) {
        ArrayList<Property> result = new ArrayList<Property>();
        if (end.isStereotypeApplied(this.snestedconnectorend)) {
            List properties = (List)end.getValue(this.snestedconnectorend, "propertyPath");
            for (Object property : properties) {
                result.add((Property)property);
            }
        } else if (end.getPartWithPort() != null) {
            result.add(end.getPartWithPort());
        }
        if (!(end.getRole() instanceof Property)) {
            throw new IllegalArgumentException("The connector role " + end.getRole() + " should be a property");
        }
        result.add((Property)end.getRole());
        return result;
    }

    public void updatePropertyPath(ConnectorEnd end, List<Property> lp) {
        if (lp.size() > 0) {
            end.setRole(lp.get(lp.size() - 1));
        }
        if (lp.size() > 1) {
            ArrayList<Property> pp;
            if (!end.isStereotypeApplied(this.getNestedConnectorEnd())) {
                end.applyStereotype(this.getNestedConnectorEnd());
            }
            if ((pp = (ArrayList<Property>)end.getValue(this.getNestedConnectorEnd(), "propertyPath")) == null) {
                pp = new ArrayList<Property>(lp.size() - 1);
                end.setValue(this.getNestedConnectorEnd(), "propertyPath", pp);
            }
            pp.clear();
            for (int i = 0; i < lp.size() - 1; ++i) {
                pp.add(lp.get(i));
            }
        }
    }

    public String joinProperties(List<Property> properties, String separator) {
        if (properties == null || separator == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < properties.size(); ++i) {
            List dims;
            Property p = properties.get(i);
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(SysMLUtil.getName(p));
            if (!p.isStereotypeApplied(this.smultidimelement) || !(p.getValue(this.smultidimelement, "dimensions") instanceof List) || (dims = (List)p.getValue(this.smultidimelement, "dimensions")).size() != 1 || !((Integer)dims.get(0)).equals(1)) continue;
            sb.append("[1]");
        }
        return sb.toString();
    }

    public List<Property> getOwnedPhSProperties(Classifier uclassifier) {
        List<Property> lp = SysMLUtil.getOwnedAttributes(uclassifier);
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property uproperty : lp) {
            if (!uproperty.isStereotypeApplied(this.sflowproperty) || !uproperty.isStereotypeApplied(this.sphsvariable) && !this.isSimBlock((Classifier)uproperty.getType())) continue;
            properties.add(uproperty);
        }
        return properties;
    }

    public boolean isPhSProperty(Property uproperty) {
        if (uproperty == null) {
            return false;
        }
        if (!uproperty.isStereotypeApplied(this.sflowproperty)) {
            return false;
        }
        if (uproperty.getType() instanceof DataType && uproperty.isStereotypeApplied(this.sphsvariable)) {
            return true;
        }
        return uproperty.getType() instanceof Classifier && this.isSimBlock((Classifier)uproperty.getType());
    }

    public boolean isSimBlock(Classifier uclassifier) {
        if (uclassifier == null) {
            return false;
        }
        for (Classifier ugeneral : uclassifier.getGenerals()) {
            if (ugeneral == this.sconservedsubstance) {
                return true;
            }
            if (!this.isSimBlock(ugeneral)) continue;
            return true;
        }
        return false;
    }

    public List<Property> getAllPhSProperties(Classifier uclassifier) {
        List<Property> lp = SysMLUtil.getAllCorrectedAttributes(uclassifier);
        ArrayList<Property> ret = new ArrayList<Property>();
        for (Property uproperty : lp) {
            if (!this.isPhSProperty(uproperty)) continue;
            ret.add(uproperty);
        }
        return ret;
    }

    public List<Property> getOwnedFlowProperties(Classifier uclassifier) {
        List<Property> lp = SysMLUtil.getOwnedAttributes(uclassifier);
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property uproperty : lp) {
            if (!uproperty.isStereotypeApplied(this.sflowproperty) || uproperty.getType() == null) continue;
            properties.add(uproperty);
        }
        return properties;
    }

    public List<Property> getAllFlowProperties(Classifier uclassifier) {
        List<Property> lp = SysMLUtil.getAllCorrectedAttributes(uclassifier);
        ArrayList<Property> ret = new ArrayList<Property>();
        for (Property uproperty : lp) {
            if (!uproperty.isStereotypeApplied(this.sflowproperty) || uproperty.getType() == null) continue;
            ret.add(uproperty);
        }
        return ret;
    }

    public List<Property> getSimVariables(Property uproperty) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (uproperty.getType() instanceof Class) {
            for (Property property : SysMLUtil.getAllAttributes((Class)uproperty.getType())) {
                if (!property.isStereotypeApplied(this.getPhSVariable())) continue;
                properties.add(property);
            }
        }
        return properties;
    }

    public static Property correctProperty(Property uproperty, Classifier context) {
        if (uproperty == null) {
            return null;
        }
        Property ret = uproperty;
        List<Property> uproperties = SysMLUtil.getAllAttributes(context);
        boolean cont = true;
        while (cont) {
            for (Property uprop : uproperties) {
                if (!uprop.getRedefinedProperties().contains(ret)) continue;
                ret = uprop;
            }
            cont = false;
        }
        return ret;
    }

    public static List<Constraint> getAllConstraints(Classifier uclassifier) {
        LinkedList<Constraint> ret = new LinkedList<Constraint>();
        ret.addAll(uclassifier.getOwnedRules());
        for (Classifier general : uclassifier.getGenerals()) {
            ret.addAll(SysMLUtil.getAllConstraints(general));
        }
        return ret;
    }

    public static List<Connector> getAllConnectors(Class uclass) {
        LinkedList<Connector> ret = new LinkedList<Connector>();
        ret.addAll(uclass.getOwnedConnectors());
        for (Generalization ugeneralization : uclass.getGeneralizations()) {
            if (ugeneralization.getSpecific() != uclass || !(ugeneralization.getGeneral() instanceof Class)) continue;
            ret.addAll(SysMLUtil.getAllConnectors((Class)ugeneralization.getGeneral()));
        }
        return ret;
    }

    public static List<Property> getOwnedAttributes(Classifier uclassifier) {
        if (uclassifier instanceof Class) {
            return ((Class)uclassifier).getOwnedAttributes();
        }
        if (uclassifier instanceof Interface) {
            return ((Interface)uclassifier).getOwnedAttributes();
        }
        if (uclassifier instanceof DataType) {
            return ((DataType)uclassifier).getOwnedAttributes();
        }
        return new ArrayList<Property>();
    }

    public static List<Property> getAllAttributes(Classifier uclassifier) {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (Classifier ugeneral : uclassifier.getGenerals()) {
            ret.addAll(SysMLUtil.getAllAttributes(ugeneral));
        }
        if (uclassifier instanceof Class) {
            ret.addAll(((Class)uclassifier).getOwnedAttributes());
        } else if (uclassifier instanceof Interface) {
            ret.addAll(((Interface)uclassifier).getOwnedAttributes());
        } else if (uclassifier instanceof DataType) {
            ret.addAll(((DataType)uclassifier).getOwnedAttributes());
        }
        return ret;
    }

    public static List<Classifier> getAllCompatibleTypes(Classifier uclassifier) {
        LinkedList<Classifier> ret = new LinkedList<Classifier>();
        if (uclassifier == null) {
            return ret;
        }
        ret.add(uclassifier);
        for (Classifier general : uclassifier.getGenerals()) {
            ret.addAll(SysMLUtil.getAllCompatibleTypes(general));
        }
        return ret;
    }

    public void removeSimProperty(List<Property> properties) {
        int i = 0;
        while (i != properties.size()) {
            if (properties.get(i).isStereotypeApplied(this.sflowproperty)) {
                properties.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static List<Property> getAllCorrectedAttributes(Classifier uclassifier) {
        ArrayList<Property> ret = new ArrayList<Property>(SysMLUtil.getAllAttributes(uclassifier));
        LinkedList<Property> rem = new LinkedList<Property>();
        for (Property p : ret) {
            rem.addAll(p.getRedefinedProperties());
        }
        ret.removeAll(rem);
        return ret;
    }

    public List<Property> getCorrectedPropertyPath(ConnectorEnd ce, Classifier context) throws UMLModelErrorException {
        if (ce == null) {
            throw new IllegalArgumentException("The connector end can't be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("The context end can't be null");
        }
        List<Property> lp = this.getPropertyPath(ce);
        ArrayList<Property> ret = new ArrayList<Property>(lp.size());
        Classifier c = context;
        for (Property p : lp) {
            Property p2 = SysMLUtil.correctProperty(p, c);
            ret.add(p2);
            if (ret.size() == lp.size()) continue;
            if (p2.getType() instanceof Classifier) {
                c = (Classifier)p2.getType();
                continue;
            }
            throw new UMLModelErrorException(p2.eResource(), "The property has no classifier type: " + p2.getQualifiedName());
        }
        return ret;
    }

    public static String getName(NamedElement ... nes) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < nes.length; ++i) {
            NamedElement ne;
            String n;
            if (i != 0) {
                ret.append("_");
            }
            if ((n = (ne = nes[i]).getName()) != null) {
                for (char c : n.toCharArray()) {
                    if (c != '_' && !Character.isLetter(c) && (!Character.isDigit(c) || ret.length() == 0)) continue;
                    ret.append(c);
                }
            }
            if (ret.length() != 0) continue;
            ret.append(SysMLUtil.getName((NamedElement)ne.getOwner()));
            ret.append("_");
            ret.append(ne.eClass().getName().toLowerCase());
            if (ne.getNamespace() == null) continue;
            ret.append(ne.getNamespace().getOwnedMembers().indexOf(ne));
        }
        return ret.toString();
    }

    public static void setName(NamedElement ne, String name) {
        String nname;
        if (name == null) {
            ne.setName(null);
            return;
        }
        String rname = name.length() == 0 ? "_" + ne.getClass().getName() : name;
        LinkedList<NamedElement> nes = new LinkedList<NamedElement>();
        Namespace ns = ne.getNamespace();
        if (ns != null) {
            nes.addAll(ns.getOwnedMembers());
        }
        if (!SysMLUtil.isPresent(rname, nes)) {
            ne.setName(rname);
            return;
        }
        int i = 0;
        while (SysMLUtil.isPresent(nname = rname + i++, nes)) {
        }
        ne.setName(nname);
    }

    private static boolean isPresent(String name, List<NamedElement> nes) {
        if (name != null) {
            for (NamedElement ne : nes) {
                if (!name.equals(ne.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<Region> getAllCorrectedRegions(StateMachine ustatemachine) {
        LinkedList<Region> ret = new LinkedList<Region>();
        for (Classifier c : ustatemachine.getGenerals()) {
            if (!(c instanceof StateMachine)) continue;
            ret.addAll(this.getAllCorrectedRegions((StateMachine)c));
        }
        for (Region r : ustatemachine.getRegions()) {
            ret.removeAll(r.getRedefinedElements());
        }
        ret.addAll(ustatemachine.getRegions());
        return ret;
    }

    public Behavior getClassifierBehavior(Class uclass) {
        Behavior b = uclass.getClassifierBehavior();
        if (b != null) {
            return b;
        }
        for (Classifier c : uclass.getGenerals()) {
            if (!(c instanceof Class) || (b = this.getClassifierBehavior((Class)c)) == null) continue;
            return b;
        }
        return null;
    }

    public class LibraryPort {
        private Port port;
        private String name;

        private LibraryPort(Port port, String name) {
            this.port = port;
            this.name = name;
        }

        public Port getPort() {
            return this.port;
        }

        public String getName() {
            return this.name;
        }
    }

    public class LibraryParameter {
        private Property property;
        private String name;
        private String value;

        private LibraryParameter(Property property, String name, String value) {
            this.property = property;
            this.name = name;
            this.value = value;
        }

        public Property getProperty() {
            return this.property;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LibraryComponent {
        private String name;
        private Class clas;
        private List<LibraryParameter> parameters = new LinkedList<LibraryParameter>();
        private List<LibraryPort> ports = new LinkedList<LibraryPort>();

        private LibraryComponent(Class clas, String name) {
            this.clas = clas;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Class getClas() {
            return this.clas;
        }

        public List<LibraryParameter> getParameters() {
            return Collections.unmodifiableList(this.parameters);
        }

        public List<LibraryPort> getPorts() {
            return Collections.unmodifiableList(this.ports);
        }

        public List<LibraryPort> getInputPorts() {
            LinkedList<LibraryPort> ret = new LinkedList<LibraryPort>();
            for (LibraryPort lp : this.ports) {
                EnumerationLiteral el;
                Object o;
                List<Property> lfp;
                if (!(lp.getPort().getType() instanceof Classifier) || (lfp = SysMLUtil.this.getAllFlowProperties((Classifier)lp.getPort().getType())).size() != 1 || !((o = lfp.get(0).getValue(SysMLUtil.this.sflowproperty, "direction")) instanceof EnumerationLiteral) || (!(el = (EnumerationLiteral)o).getName().equals("in") || lp.getPort().isConjugated()) && (!el.getName().equals("out") || !lp.getPort().isConjugated())) continue;
                ret.add(lp);
            }
            return Collections.unmodifiableList(ret);
        }

        public List<LibraryPort> getOutputPorts() {
            LinkedList<LibraryPort> ret = new LinkedList<LibraryPort>();
            for (LibraryPort lp : this.ports) {
                EnumerationLiteral el;
                Object o;
                List<Property> lfp;
                if (!(lp.getPort().getType() instanceof Classifier) || (lfp = SysMLUtil.this.getAllFlowProperties((Classifier)lp.getPort().getType())).size() != 1 || !((o = lfp.get(0).getValue(SysMLUtil.this.sflowproperty, "direction")) instanceof EnumerationLiteral) || (!(el = (EnumerationLiteral)o).getName().equals("out") || lp.getPort().isConjugated()) && (!el.getName().equals("in") || !lp.getPort().isConjugated())) continue;
                ret.add(lp);
            }
            return Collections.unmodifiableList(ret);
        }
    }
}

