/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import com.engisis.sysphs.SysMLToSimulationTranslationManager;
import com.engisis.sysphs.util.EMFUtil;
import com.engisis.sysphs.util.SysMLUtil;
import com.engisis.sysphs.util.UMLModelErrorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;

public class LibrarySummary {
    public static void main(String[] args) throws FileNotFoundException, UMLModelErrorException {
        File fp = new File(SysMLToSimulationTranslationManager.class.getResource("/SysML/SysPhSProfile.xmi").getPath());
        File fl = new File(SysMLToSimulationTranslationManager.class.getResource("/SysML/SysPhSLibrary.xmi").getPath());
        ResourceSet rs = EMFUtil.createBasicResourceSet();
        EMFUtil.loadResource(rs, URI.createURI("http://www.omg.org/spec/SysML/20161101/SysML.xmi"), null);
        EMFUtil.loadResource(rs, URI.createFileURI(fp.getAbsolutePath()), null);
        Resource rl = EMFUtil.loadResource(rs, URI.createFileURI(fl.getAbsolutePath()), null);
        SysMLUtil sysml = new SysMLUtil(rs);
        TreeIterator<EObject> ti = rl.getAllContents();
        while (ti.hasNext()) {
            Class uclass;
            EObject eo = (EObject)ti.next();
            if (!(eo instanceof Namespace)) {
                ti.prune();
                continue;
            }
            if (!(eo instanceof Class) || !(uclass = (Class)eo).isStereotypeApplied(sysml.getSimulinkBlock()) && !uclass.isStereotypeApplied(sysml.getModelicaBlock())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(uclass.getName());
            sb.append("--");
            if (uclass.isStereotypeApplied(sysml.getSimulinkBlock())) {
                sb.append(uclass.getValue(sysml.getSimulinkBlock(), "name"));
            }
            sb.append("--");
            if (uclass.isStereotypeApplied(sysml.getModelicaBlock())) {
                sb.append(uclass.getValue(sysml.getModelicaBlock(), "name"));
            }
            sb.append("\n");
            for (Property uproperty : uclass.getAllAttributes()) {
                sb.append("\t");
                sb.append(uproperty.getName());
                if (uproperty.isStereotypeApplied(sysml.getMultidimensionalElement())) {
                    sb.append("[");
                    List dims = (List)uproperty.getValue(sysml.getMultidimensionalElement(), "dimensions");
                    for (int i = 0; i < dims.size(); ++i) {
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append(dims.get(i));
                    }
                    sb.append("]");
                }
                sb.append("--");
                if (uproperty.isStereotypeApplied(sysml.getSimulinkPort())) {
                    sb.append(uproperty.getValue(sysml.getSimulinkPort(), "name"));
                } else if (uproperty.isStereotypeApplied(sysml.getSimulinkParameter())) {
                    sb.append(uproperty.getValue(sysml.getSimulinkParameter(), "name"));
                    sb.append("=");
                    sb.append(uproperty.getValue(sysml.getSimulinkParameter(), "value"));
                }
                sb.append("--");
                if (uproperty.isStereotypeApplied(sysml.getModelicaPort())) {
                    sb.append(uproperty.getValue(sysml.getModelicaPort(), "name"));
                } else if (uproperty.isStereotypeApplied(sysml.getModelicaParameter())) {
                    sb.append(uproperty.getValue(sysml.getModelicaParameter(), "name"));
                    sb.append("=");
                    sb.append(uproperty.getValue(sysml.getModelicaParameter(), "value"));
                }
                sb.append("\n");
            }
            System.out.print(sb.toString());
        }
    }
}

