/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import com.engisis.sysphs.util.EMFUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static final Logger log = Logger.getLogger(Configuration.class);
    public static final String PROPERTYFILE = "properties.config";
    public static final String RESOURCE_MAP = "resourcemap";
    public static final String NAMESPACE_MAP = "nsmap";
    public static final String ID_MAP = "idmap";
    public static final String SIMULINK_UNIT = "simulinkunitmapping";
    private static Hashtable<String, String> simulinkunits = null;
    private static Hashtable<URI, URI> locmaps = null;
    private static Hashtable<String, String> nsmaps_r = null;
    private static Hashtable<String, Hashtable<String, String>> nsmaps_w = null;
    private static Hashtable<String, String> idmaps_r = null;
    private static Hashtable<String, Hashtable<String, String>> idmaps_w = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadProperties() {
        if (locmaps != null && nsmaps_r != null && nsmaps_w != null && idmaps_r != null && idmaps_w != null) {
            return;
        }
        simulinkunits = new Hashtable();
        simulinkunits.put("\u2126", "Ohm");
        simulinkunits.put("\u03a9", "Ohm");
        simulinkunits.put("\u03c9", "Ohm");
        locmaps = new Hashtable();
        nsmaps_r = new Hashtable();
        nsmaps_w = new Hashtable();
        idmaps_r = new Hashtable();
        idmaps_w = new Hashtable();
        InputStream is = EMFUtil.class.getClassLoader().getResourceAsStream(PROPERTYFILE);
        if (is == null) {
            log.warn("properties.config not found");
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        String line = null;
        try {
            int skipped = 0;
            while ((line = br.readLine()) != null) {
                String[] spl = line.split("\\t+");
                if (spl.length > 1) {
                    Hashtable<String, String> ht;
                    String to;
                    String from;
                    String target;
                    Object to2;
                    Object from2;
                    if (spl[0].equals(SIMULINK_UNIT)) {
                        if (spl.length < 3) {
                            log.error("Line in the wrong format: " + line);
                            continue;
                        }
                        from2 = spl[1];
                        to2 = spl[2];
                        simulinkunits.put((String)from2, (String)to2);
                        log.info("add simulink unit mapping from " + (String)from2 + " to " + (String)to2);
                    }
                    if (spl[0].equals("nsmap_r")) {
                        if (spl.length < 3) {
                            log.error("Line in the wrong format: " + line);
                            continue;
                        }
                        from2 = spl[1];
                        to2 = spl[2];
                        nsmaps_r.put((String)from2, (String)to2);
                        log.info("add ns mapping from " + (String)from2 + " to " + (String)to2);
                        continue;
                    }
                    if (spl[0].equals("nsmap_w")) {
                        if (spl.length < 4) {
                            log.error("Line in the wrong format: " + line);
                            continue;
                        }
                        target = spl[1];
                        from = spl[2];
                        to = spl[3];
                        ht = nsmaps_w.get(target);
                        if (ht == null) {
                            ht = new Hashtable();
                            nsmaps_w.put(target, ht);
                        }
                        ht.put(from, to);
                        log.info("add ns mapping from " + from + " to " + to + " in target " + target);
                        continue;
                    }
                    if (spl[0].equals(ID_MAP) || spl[0].equals("idmap_r")) {
                        if (spl.length < 3) {
                            log.error("Line in the wrong format: " + line);
                            continue;
                        }
                        from2 = spl[1];
                        to2 = spl[2];
                        idmaps_r.put((String)from2, (String)to2);
                        log.info("add id mapping from " + (String)from2 + " to " + (String)to2);
                        continue;
                    }
                    if (spl[0].equals("idmap_w")) {
                        if (spl.length < 4) {
                            log.error("Line in the wrong format: " + line);
                            continue;
                        }
                        target = spl[1];
                        from = spl[2];
                        to = spl[3];
                        ht = idmaps_w.get(target);
                        if (ht == null) {
                            ht = new Hashtable();
                            idmaps_w.put(target, ht);
                        }
                        ht.put(from, to);
                        log.info("add id mapping from " + from + " to " + to + " in target " + target);
                        continue;
                    }
                    if (spl[0].equals(RESOURCE_MAP)) {
                        if (spl.length < 3) {
                            log.error("Line in the wrong format: " + line);
                            continue;
                        }
                        from2 = URI.createURI(spl[1]);
                        to2 = URI.createURI(Configuration.transformResource(EMFUtil.class.getResource(spl[2]).getPath()));
                        locmaps.put((URI)from2, (URI)to2);
                        log.info("add resource mapping from " + from2);
                        continue;
                    }
                }
                if (line.isEmpty()) continue;
                ++skipped;
            }
            if (skipped != 0) {
                log.warn(skipped + " non-empty lines skipped");
            }
        }
        catch (IOException e) {
            log.warn("Failed to read properties.config");
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String transformResource(String suri) {
        if (suri.indexOf("!") == -1) {
            return suri;
        }
        return "jar:" + suri;
    }

    public static Hashtable<String, String> getSimulinkUnitMapping() {
        if (simulinkunits == null) {
            Configuration.loadProperties();
        }
        return simulinkunits;
    }

    public static Hashtable<URI, URI> getLocationMappings() {
        if (locmaps == null) {
            Configuration.loadProperties();
        }
        return locmaps;
    }

    public static Hashtable<String, String> getReaderNSMappings() {
        if (nsmaps_r == null) {
            Configuration.loadProperties();
        }
        return nsmaps_r;
    }

    public static Hashtable<String, String> getWriterNSMappings(String target) {
        if (nsmaps_w == null) {
            Configuration.loadProperties();
        }
        return nsmaps_w.get(target);
    }

    public static Hashtable<String, String> getReaderIDMappings() {
        if (idmaps_r == null) {
            Configuration.loadProperties();
        }
        return idmaps_r;
    }

    public static Hashtable<String, String> getWriterIDMappings(String target) {
        if (idmaps_w == null) {
            Configuration.loadProperties();
        }
        return idmaps_w.get(target);
    }

    public static Collection<String> getTargets() {
        if (idmaps_w == null) {
            Configuration.loadProperties();
        }
        return Collections.unmodifiableCollection(idmaps_w.keySet());
    }
}

