/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.translation.modelica;

import com.engisis.sysphs.language.modelica.MAccessControl;
import com.engisis.sysphs.language.modelica.MAlgorithm;
import com.engisis.sysphs.language.modelica.MBlock;
import com.engisis.sysphs.language.modelica.MBooleanValue;
import com.engisis.sysphs.language.modelica.MClass;
import com.engisis.sysphs.language.modelica.MComponent;
import com.engisis.sysphs.language.modelica.MConnect;
import com.engisis.sysphs.language.modelica.MConnector;
import com.engisis.sysphs.language.modelica.MDataFlow;
import com.engisis.sysphs.language.modelica.MDataValue;
import com.engisis.sysphs.language.modelica.MDirection;
import com.engisis.sysphs.language.modelica.MElement;
import com.engisis.sysphs.language.modelica.MEquation;
import com.engisis.sysphs.language.modelica.MExpressionValue;
import com.engisis.sysphs.language.modelica.MExtension;
import com.engisis.sysphs.language.modelica.MHierarchy;
import com.engisis.sysphs.language.modelica.MIntegerValue;
import com.engisis.sysphs.language.modelica.MModel;
import com.engisis.sysphs.language.modelica.MModification;
import com.engisis.sysphs.language.modelica.MNamedElement;
import com.engisis.sysphs.language.modelica.MRealValue;
import com.engisis.sysphs.language.modelica.MStringValue;
import com.engisis.sysphs.language.modelica.MType;
import com.engisis.sysphs.language.modelica.MVariability;
import com.engisis.sysphs.language.modelica.ModelicaFactory;
import com.engisis.sysphs.serialization.modelica.ModelicaSerializer;
import com.engisis.sysphs.translation.modelica.ExpressionLanguageToModelicaTranslator;
import com.engisis.sysphs.translation.modelica.ModelicaUtil;
import com.engisis.sysphs.util.ExpressionLanguageToSimulation;
import com.engisis.sysphs.util.SysMLToSimulationTranslator;
import com.engisis.sysphs.util.SysMLUtil;
import com.engisis.sysphs.util.UMLModelErrorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.VisibilityKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysMLToModelicaTranslator
extends SysMLToSimulationTranslator {
    private static final Logger log = Logger.getLogger(SysMLToModelicaTranslator.class);
    private Hashtable<SysMLToSimulationTranslator.ReferenceKey, MElement> refs = new Hashtable();
    private Stack<SysMLToSimulationTranslator.ReferenceKey> toProcess = new Stack();
    private Stack<SysMLToSimulationTranslator.ReferenceKey> toProcess2 = new Stack();
    private MModel mmodel;
    private SysMLUtil sysmlutil;
    private String modelblock;
    private static final boolean USE_SM_LIBRARY = true;
    private ExpressionLanguageToModelicaTranslator el2m = new ExpressionLanguageToModelicaTranslator();

    public SysMLToModelicaTranslator() {
    }

    public SysMLToModelicaTranslator(Set<Object> options) {
        this.loadOptions(options);
    }

    @Override
    public void reset() {
        super.reset();
        this.refs.clear();
        this.mmodel = null;
    }

    @Override
    public void loadOptions(Set<Object> options) {
        super.loadOptions(options);
    }

    @Override
    public Set<java.lang.Class<?>> getOptions() {
        HashSet res = new HashSet();
        return res;
    }

    @Override
    protected ExpressionLanguageToSimulation getExpressionTranslator() {
        return this.el2m;
    }

    public String getModelBlock() {
        return this.modelblock;
    }

    public String getFileExtension() {
        return "mo";
    }

    @Override
    protected String getOpaqueLanguage() {
        return "modelica";
    }

    private void init() throws UMLModelErrorException {
        this.sysmlutil = new SysMLUtil(this.r.getResourceSet());
        this.setModelNameSuffix("Model");
        this.refs.put(SysMLToModelicaTranslator.getKey(this.sysmlutil.getUMLDouble()), ModelicaUtil.getReal());
        this.refs.put(SysMLToModelicaTranslator.getKey(this.sysmlutil.getSysMLDouble()), ModelicaUtil.getReal());
        this.refs.put(SysMLToModelicaTranslator.getKey(this.sysmlutil.getUMLInteger()), ModelicaUtil.getInteger());
        this.refs.put(SysMLToModelicaTranslator.getKey(this.sysmlutil.getSysMLInteger()), ModelicaUtil.getInteger());
        this.refs.put(SysMLToModelicaTranslator.getKey(this.sysmlutil.getUMLBoolean()), ModelicaUtil.getBoolean());
        this.refs.put(SysMLToModelicaTranslator.getKey(this.sysmlutil.getSysMLBoolean()), ModelicaUtil.getBoolean());
        this.refs.put(SysMLToModelicaTranslator.getKey(this.sysmlutil.getUMLString()), ModelicaUtil.getString());
        this.refs.put(SysMLToModelicaTranslator.getKey(this.sysmlutil.getSysMLString()), ModelicaUtil.getString());
    }

    private TranslatedType getTranslatedType(NamedElement unamedelement) {
        if (unamedelement == null) {
            throw new IllegalArgumentException("You must provide a UML named element");
        }
        if (unamedelement instanceof StateMachine) {
            return TranslatedType.STATEMACHINE;
        }
        if (unamedelement instanceof Vertex) {
            return TranslatedType.STATE;
        }
        if (unamedelement instanceof Class && unamedelement.isStereotypeApplied(this.sysmlutil.getModelicaBlock())) {
            return TranslatedType.INTERFACE;
        }
        if (unamedelement instanceof Class && ((unamedelement.isStereotypeApplied(this.sysmlutil.getBlock()) || unamedelement.isStereotypeApplied(this.sysmlutil.getInterfaceBlock())) && !this.sysmlutil.isSimBlock((Classifier)unamedelement) || unamedelement.isStereotypeApplied(this.sysmlutil.getConstraintBlock()))) {
            List<Property> lsp = this.sysmlutil.getAllPhSProperties((Class)unamedelement);
            for (Property uproperty : lsp) {
                Type utype = uproperty.getType();
                if (utype == null) continue;
                if (utype instanceof Classifier && this.sysmlutil.isSimBlock((Classifier)utype)) {
                    return TranslatedType.CONNECTOR;
                }
                if (!(utype instanceof DataType)) continue;
                return TranslatedType.TYPE;
            }
            return TranslatedType.MODEL;
        }
        if (unamedelement instanceof Class && unamedelement.isStereotypeApplied(this.sysmlutil.getInterfaceBlock())) {
            return TranslatedType.CONNECTOR;
        }
        if (unamedelement instanceof DataType && !Collections.disjoint(SysMLUtil.getAllCompatibleTypes((DataType)unamedelement), Arrays.asList(this.sysmlutil.getUMLBoolean(), this.sysmlutil.getUMLInteger(), this.sysmlutil.getUMLDouble(), this.sysmlutil.getSysMLBoolean(), this.sysmlutil.getSysMLInteger(), this.sysmlutil.getSysMLDouble()))) {
            return TranslatedType.TYPE;
        }
        if (unamedelement instanceof Property) {
            return TranslatedType.COMPONENT;
        }
        return TranslatedType.NONE;
    }

    @Override
    public void execute(Class urootblock, Resource r, File outputdirectory) throws UMLModelErrorException, IOException {
        Element uelem;
        SysMLToSimulationTranslator.ReferenceKey rk;
        if (urootblock == null) {
            throw new IllegalArgumentException("You must provide a root block");
        }
        if (r == null) {
            throw new IllegalArgumentException("You must provide a resouce");
        }
        this.r = r;
        log.debug("Starting translation");
        this.init();
        log.debug("Creating the root Modelica model");
        this.mmodel = ModelicaFactory.eINSTANCE.createMModel();
        String urootblockname = SysMLUtil.getName(urootblock);
        this.modelblock = urootblockname + this.getModelNameSuffix();
        ModelicaUtil.setName(this.mmodel, this.modelblock);
        MClass mrootblock = this.createClass(urootblock);
        MComponent mrootcomponent = ModelicaFactory.eINSTANCE.createMComponent();
        this.mmodel.getComponents().add(mrootcomponent);
        ModelicaUtil.setName(mrootcomponent, "_" + urootblockname);
        mrootcomponent.setType(mrootblock);
        while (this.toProcess.size() != 0) {
            rk = this.toProcess.pop();
            uelem = rk.getKey()[0];
            if (!(uelem instanceof NamedElement)) {
                throw new IllegalStateException("The element to process " + rk + " is expected to be a named element: " + uelem.getClass());
            }
            MClass mclass = null;
            switch (this.getTranslatedType((NamedElement)uelem)) {
                case MODEL: {
                    mclass = this.processModel((Class)uelem);
                    break;
                }
                case CONNECTOR: {
                    mclass = this.processConnector((Class)uelem);
                    break;
                }
                case TYPE: {
                    if (!(uelem instanceof DataType)) break;
                    mclass = this.processType((DataType)uelem);
                    break;
                }
                case COMPONENT: {
                    this.processProperty((Property)uelem);
                    break;
                }
                case STATEMACHINE: {
                    this.processStateMachineLibrary((StateMachine)uelem);
                    break;
                }
                case INTERFACE: {
                    this.processInterface((Class)uelem);
                    break;
                }
                case STATE: {
                    break;
                }
                default: {
                    log.warn("The element " + SysMLToModelicaTranslator.print(uelem) + " must be a named element to be processed");
                }
            }
            if (mclass == null || mclass.getOwningClass() != null || uelem.isStereotypeApplied(this.sysmlutil.getConstraintBlock())) continue;
            this.mmodel.getOwnedClasses().add(mclass);
        }
        block17: while (this.toProcess2.size() != 0) {
            rk = this.toProcess2.pop();
            uelem = rk.getKey()[0];
            if (!(uelem instanceof NamedElement)) {
                throw new IllegalStateException("The element to process " + rk + " is expected to be a named element: " + uelem.getClass());
            }
            switch (this.getTranslatedType((NamedElement)uelem)) {
                case CONNECTOR: {
                    this.processConnector2((Class)uelem);
                    continue block17;
                }
                case MODEL: {
                    this.processModel2((Class)uelem);
                    continue block17;
                }
                case STATE: {
                    this.processStateLibrary2((Vertex)uelem);
                    continue block17;
                }
            }
            log.warn("The element " + SysMLToModelicaTranslator.print(uelem) + " can't be processed a second time");
        }
        ModelicaSerializer ms = new ModelicaSerializer();
        if (outputdirectory != null) {
            this.outputfilename = ms.serialize(outputdirectory.getAbsolutePath(), this.mmodel, this.getFileNameSuffix());
        } else {
            URI target = r.getURI().trimSegments(1);
            try {
                if (target.isFile()) {
                    this.outputfilename = ms.serialize(target.toFileString(), this.mmodel, this.getFileNameSuffix());
                } else {
                    log.error("The target is not a file");
                }
            }
            catch (IOException e) {
                log.error("Can't save the model at the location " + target, e);
                throw e;
            }
        }
    }

    private MClass createClass(Type utype) throws UMLModelErrorException {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToModelicaTranslator.getKey(utype);
        if (utype == null) {
            throw new IllegalArgumentException("You must provide a UML type");
        }
        if (utype.getVisibility() == VisibilityKind.PRIVATE_LITERAL) {
            throw new UMLModelErrorException(this.r, "The type " + SysMLToModelicaTranslator.print(utype) + " is private and can't be translated");
        }
        MElement melement = null;
        melement = this.refs.get(rk);
        if (melement != null) {
            if (!(melement instanceof MClass)) {
                throw new ClassCastException("The element " + SysMLToModelicaTranslator.print(utype) + " is expected to be a class, but it is not");
            }
            return (MClass)melement;
        }
        MClass mclass = null;
        switch (this.getTranslatedType(utype)) {
            case MODEL: {
                log.debug("Creating block " + SysMLToModelicaTranslator.print(utype));
                mclass = ModelicaFactory.eINSTANCE.createMModel();
                break;
            }
            case CONNECTOR: {
                log.debug("Creating simulation block " + SysMLToModelicaTranslator.print(utype));
                mclass = ModelicaFactory.eINSTANCE.createMConnector();
                break;
            }
            case TYPE: {
                if (utype instanceof DataType) {
                    log.debug("Creating datatype " + SysMLToModelicaTranslator.print(utype));
                    mclass = ModelicaFactory.eINSTANCE.createMType();
                    break;
                }
                Property sp = this.sysmlutil.getAllPhSProperties((Class)utype).get(0);
                mclass = this.createClass(sp.getType());
                break;
            }
            case STATEMACHINE: {
                log.debug("Creating StateMachine " + SysMLToModelicaTranslator.print(utype));
                mclass = ModelicaFactory.eINSTANCE.createMBlock();
                break;
            }
            case INTERFACE: {
                log.debug("Creating Interface " + SysMLToModelicaTranslator.print(utype));
                mclass = ModelicaFactory.eINSTANCE.createMModel();
                break;
            }
            default: {
                log.error("Unexpected type:" + SysMLToModelicaTranslator.print(utype));
                log.error("Stereotypes: " + utype.getStereotypeApplications().size());
                for (EObject eobj : utype.getStereotypeApplications()) {
                    log.error(eobj);
                }
            }
        }
        if (mclass == null) {
            throw new IllegalArgumentException("The element " + SysMLToModelicaTranslator.print(utype) + " can't be translated as block or type");
        }
        this.refs.put(rk, mclass);
        this.toProcess.push(rk);
        return mclass;
    }

    private MComponent createProperty(Property uproperty) {
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToModelicaTranslator.getKey(uproperty);
        if (uproperty == null) {
            throw new IllegalArgumentException("You must provide a UML property");
        }
        if (uproperty.getVisibility() == VisibilityKind.PRIVATE_LITERAL) {
            log.warn("Property " + SysMLToModelicaTranslator.print(uproperty) + " skipped because it is private");
            return null;
        }
        if (uproperty.getType() == null) {
            log.warn("Property " + SysMLToModelicaTranslator.print(uproperty) + " skipped because it has no type");
            return null;
        }
        if (this.getTranslatedType(uproperty.getType()) == TranslatedType.NONE) {
            log.warn("Property " + SysMLToModelicaTranslator.print(uproperty) + " skipped because its type has no translation");
            return null;
        }
        MElement melement = this.refs.get(rk);
        MComponent mcomponent = null;
        if (melement != null) {
            if (melement instanceof MComponent) {
                mcomponent = (MComponent)melement;
            } else {
                throw new ClassCastException("The element " + SysMLToModelicaTranslator.print(uproperty) + " is expected to be a property, but it is not");
            }
        }
        if (mcomponent == null) {
            mcomponent = ModelicaFactory.eINSTANCE.createMComponent();
            this.refs.put(rk, mcomponent);
            this.toProcess.push(rk);
        }
        return mcomponent;
    }

    private MModel processModel(Class ublock) throws UMLModelErrorException {
        return (MModel)this.processClass(ublock);
    }

    private MConnector processConnector(Class ublock) throws UMLModelErrorException {
        return (MConnector)this.processClass(ublock);
    }

    private MClass processClass(Class ublock) throws UMLModelErrorException {
        if (ublock == null) {
            throw new IllegalArgumentException("You must provide a UML class");
        }
        log.debug("Processing block " + SysMLToModelicaTranslator.print(ublock));
        MClass mclass = this.createClass(ublock);
        ModelicaUtil.setName(mclass, SysMLUtil.getName(ublock));
        for (Constraint constraint : ublock.getOwnedRules()) {
            MEquation mequation = ModelicaFactory.eINSTANCE.createMEquation();
            mequation.setExpression(this.getEquation(constraint.getSpecification()));
            mclass.getEquations().add(mequation);
        }
        for (Classifier classifier : ublock.getGenerals()) {
            TranslatedType tself = this.getTranslatedType(ublock);
            TranslatedType tgen = this.getTranslatedType(classifier);
            if (tself == TranslatedType.MODEL && tgen == TranslatedType.MODEL || tself == TranslatedType.CONNECTOR && tgen == TranslatedType.CONNECTOR) {
                MExtension mExtension = ModelicaFactory.eINSTANCE.createMExtension();
                MClass mgeneral = this.createClass(classifier);
                mExtension.setExtendedClass(mgeneral);
                mExtension.setOwningClass(mclass);
            } else {
                log.debug("Skipping non-block general classifier " + SysMLToModelicaTranslator.print(classifier));
            }
            if (tself != TranslatedType.MODEL || tgen != TranslatedType.CONNECTOR) continue;
            for (Operation uoperation : classifier.getAllOperations()) {
                if (!uoperation.isStereotypeApplied(this.sysmlutil.getDirectedFeature())) continue;
                LinkedList<Property> lp = new LinkedList<Property>();
                for (Property uproperty : SysMLUtil.getAllAttributes(ublock)) {
                    if (this.getTranslatedType(uproperty.getType()) != TranslatedType.CONNECTOR || !((Class)uproperty.getType()).getAllOperations().contains(uoperation)) continue;
                    lp.add(uproperty);
                }
                if (lp.size() == 0) continue;
                MComponent moperation = ModelicaFactory.eINSTANCE.createMComponent();
                mclass.getComponents().add(moperation);
                ModelicaUtil.setName(moperation, SysMLUtil.getName(uoperation));
                moperation.setType((MClass)this.refs.get(SysMLToModelicaTranslator.getKey(this.sysmlutil.getSysMLBoolean())));
                String dir = ((EnumerationLiteral)uoperation.getValue(this.sysmlutil.getDirectedFeature(), "featureDirection")).getName();
                if (dir.equals("provided")) {
                    for (Property uproperty : lp) {
                        MEquation meq = ModelicaFactory.eINSTANCE.createMEquation();
                        meq.setExpression(moperation.getName() + "=" + SysMLUtil.getName(uproperty) + "." + moperation.getName());
                        mclass.getEquations().add(meq);
                    }
                    continue;
                }
                if (!dir.equals("required")) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < lp.size(); ++i) {
                    if (i != 0) {
                        sb.append(" or ");
                    }
                    sb.append(SysMLUtil.getName((NamedElement)lp.get(i)) + "." + moperation.getName());
                }
                MEquation meq = ModelicaFactory.eINSTANCE.createMEquation();
                meq.setExpression(moperation.getName() + "=" + sb.toString());
                mclass.getEquations().add(meq);
            }
        }
        ArrayList<Property> uproperties = new ArrayList<Property>(ublock.getOwnedAttributes());
        for (Property uproperty : uproperties) {
            if (uproperty.getType() == null) {
                throw new UMLModelErrorException(this.r, "The property " + SysMLToModelicaTranslator.print(uproperty) + " must have a type");
            }
            if (this.sysmlutil.isPhSProperty(uproperty)) {
                for (Property property : SysMLUtil.getAllAttributes((Classifier)uproperty.getType())) {
                    MComponent mcomponent = this.createProperty(property);
                    if (mcomponent == null) continue;
                    log.info("Adding " + SysMLToModelicaTranslator.print(property) + " to " + SysMLToModelicaTranslator.print(ublock));
                    mclass.getComponents().add(mcomponent);
                }
                continue;
            }
            if (uproperty.getType().isStereotypeApplied(this.sysmlutil.getConstraintBlock())) continue;
            MComponent mcomponent = this.createProperty(uproperty);
            if (mcomponent != null) {
                log.info("Adding " + SysMLToModelicaTranslator.print(uproperty) + " to " + SysMLToModelicaTranslator.print(ublock));
                mclass.getComponents().add(mcomponent);
                continue;
            }
            log.debug("Skipping property " + SysMLToModelicaTranslator.print(uproperty));
        }
        for (Connector uconnector : ublock.getOwnedConnectors()) {
            ConnectableElement uproperty1 = ((ConnectorEnd)uconnector.getEnds().get(0)).getRole();
            ConnectableElement connectableElement = ((ConnectorEnd)uconnector.getEnds().get(1)).getRole();
            if (uproperty1 == null || connectableElement == null) {
                log.warn("Skipped connector " + SysMLToModelicaTranslator.print(uconnector) + " because of missing role");
                continue;
            }
            Type uproperty1type = uproperty1.getType();
            Type uproperty2type = connectableElement.getType();
            List<Property> lp0 = this.sysmlutil.getPropertyPath((ConnectorEnd)uconnector.getEnds().get(0));
            List<Property> lp1 = this.sysmlutil.getPropertyPath((ConnectorEnd)uconnector.getEnds().get(1));
            if (uproperty1type instanceof Class && uproperty2type instanceof Class) {
                List<Property> simproperties1 = this.sysmlutil.getAllPhSProperties((Class)uproperty1type);
                List<Property> simproperties2 = this.sysmlutil.getAllPhSProperties((Class)uproperty2type);
                if (simproperties1.size() > 0 && simproperties2.size() > 0) {
                    MConnect mconnect = ModelicaFactory.eINSTANCE.createMConnect();
                    for (Property uprop : lp0) {
                        mconnect.getRef1().add(this.createProperty(uprop));
                    }
                    for (Property uprop : lp1) {
                        mconnect.getRef2().add(this.createProperty(uprop));
                    }
                    mclass.getEquations().add(mconnect);
                    continue;
                }
                if (lp0.get(lp0.size() - 1).getType().isStereotypeApplied(this.sysmlutil.getInterfaceBlock()) && lp1.get(lp1.size() - 1).getType().isStereotypeApplied(this.sysmlutil.getInterfaceBlock())) {
                    MEquation mequation = ModelicaFactory.eINSTANCE.createMEquation();
                    mequation.setExpression(this.sysmlutil.joinProperties(lp0, ".") + "=" + this.sysmlutil.joinProperties(lp1, "."));
                    mclass.getEquations().add(mequation);
                }
            }
            if (uconnector.isStereotypeApplied(this.sysmlutil.getBindingConnector())) {
                MModification mmod;
                MComponent mc3;
                MModification mmodification;
                MComponent mc2;
                MComponent mc1;
                if (lp0.size() == 2 && lp0.get(0).getType().isStereotypeApplied(this.sysmlutil.getModelicaBlock()) && lp0.get(1).isStereotypeApplied(this.sysmlutil.getModelicaParameter())) {
                    mc1 = this.createProperty(lp0.get(0));
                    mc2 = this.createProperty(lp0.get(1));
                    mmodification = ModelicaFactory.eINSTANCE.createMModification();
                    if (mc2 != null) {
                        mmodification.getComponentPath().add(mc2);
                    } else {
                        log.error("Can't add component " + lp0.get(1).getQualifiedName() + " to the modification in " + ublock.getQualifiedName());
                    }
                    for (Property property : lp1) {
                        MComponent mc32 = this.createProperty(property);
                        if (mc32 != null) {
                            mmodification.getAssignedReference().add(mc32);
                            continue;
                        }
                        log.error("Can't add reference " + property.getQualifiedName() + " to the modification in " + ublock.getQualifiedName());
                    }
                    mc1.getModifications().add(mmodification);
                }
                if (lp1.size() == 2 && lp1.get(0).getType().isStereotypeApplied(this.sysmlutil.getModelicaBlock()) && lp1.get(1).isStereotypeApplied(this.sysmlutil.getModelicaParameter())) {
                    mc1 = this.createProperty(lp1.get(0));
                    mc2 = this.createProperty(lp1.get(1));
                    mmodification = ModelicaFactory.eINSTANCE.createMModification();
                    if (mc2 != null) {
                        mmodification.getComponentPath().add(mc2);
                    } else {
                        log.error("Can't add component " + lp1.get(1).getQualifiedName() + " to the modification in " + ublock.getQualifiedName());
                    }
                    for (Property property : lp0) {
                        MComponent mc32 = this.createProperty(property);
                        if (mc32 != null) {
                            mmodification.getAssignedReference().add(mc32);
                            continue;
                        }
                        log.error("Can't add reference " + property.getQualifiedName() + " to the modification in " + ublock.getQualifiedName());
                    }
                    mc1.getModifications().add(mmodification);
                }
                if (lp0.size() == 2 && lp1.size() == 1 && lp0.get(0).getType().isStereotypeApplied(this.sysmlutil.getBlock()) && lp0.get(1).isStereotypeApplied(this.sysmlutil.getPhSConstant()) && lp1.get(0).isStereotypeApplied(this.sysmlutil.getPhSConstant())) {
                    mc1 = this.createProperty(lp0.get(0));
                    mc2 = this.createProperty(lp0.get(1));
                    mc3 = this.createProperty(lp1.get(0));
                    mmod = ModelicaFactory.eINSTANCE.createMModification();
                    if (mc2 != null) {
                        mmod.getComponentPath().add(mc2);
                    } else {
                        log.error("Can't add component " + lp0.get(1).getQualifiedName() + " to the modification in " + ublock.getQualifiedName());
                    }
                    if (mc3 != null) {
                        mmod.getAssignedReference().add(mc3);
                    } else {
                        log.error("Can't add reference " + lp1.get(0).getQualifiedName() + " to the modification in " + ublock.getQualifiedName());
                    }
                    mc1.getModifications().add(mmod);
                }
                if (lp1.size() != 2 || lp0.size() != 1 || !lp1.get(0).getType().isStereotypeApplied(this.sysmlutil.getBlock()) || !lp1.get(1).isStereotypeApplied(this.sysmlutil.getPhSConstant()) || !lp0.get(0).isStereotypeApplied(this.sysmlutil.getPhSConstant())) continue;
                mc1 = this.createProperty(lp1.get(0));
                mc2 = this.createProperty(lp1.get(1));
                mc3 = this.createProperty(lp0.get(0));
                mmod = ModelicaFactory.eINSTANCE.createMModification();
                if (mc2 != null) {
                    mmod.getComponentPath().add(mc2);
                } else {
                    log.error("Can't add component " + lp1.get(1).getQualifiedName() + " to the modification in " + ublock.getQualifiedName());
                }
                if (mc3 != null) {
                    mmod.getAssignedReference().add(mc3);
                } else {
                    log.error("Can't add reference " + lp0.get(0).getQualifiedName() + " to the modification in " + ublock.getQualifiedName());
                }
                mc1.getModifications().add(mmod);
                continue;
            }
            log.warn("Connector " + SysMLToModelicaTranslator.print(uconnector) + " doesn't connect two simblocks and is not a binding connector");
        }
        if (ublock.getClassifierBehavior() != null && ublock.getClassifierBehavior() instanceof StateMachine) {
            StateMachine stateMachine = (StateMachine)ublock.getClassifierBehavior();
            MBlock mstatemachine = this.createStateMachine(stateMachine);
            mstatemachine.setOwningClass(mclass);
        }
        for (Operation uoperation : ublock.getOperations()) {
            if (!uoperation.isStereotypeApplied(this.sysmlutil.getDirectedFeature())) continue;
            String dir = ((EnumerationLiteral)uoperation.getValue(this.sysmlutil.getDirectedFeature(), "featureDirection")).getName();
            MComponent mComponent = ModelicaFactory.eINSTANCE.createMComponent();
            mclass.getComponents().add(mComponent);
            ModelicaUtil.setName(mComponent, SysMLUtil.getName(uoperation));
            if (dir.equals("provided")) {
                mComponent.setDirection(MDirection.OUTPUT);
            } else if (dir.equals("required")) {
                mComponent.setDirection(MDirection.INPUT);
            }
            mComponent.setType((MClass)this.refs.get(SysMLToModelicaTranslator.getKey(this.sysmlutil.getSysMLBoolean())));
            this.refs.put(SysMLToModelicaTranslator.getKey(uoperation), mComponent);
        }
        this.toProcess2.push(SysMLToModelicaTranslator.getKey(ublock));
        return mclass;
    }

    private MClass processInterface(Class ublock) throws UMLModelErrorException {
        if (ublock == null) {
            throw new IllegalArgumentException("You must provide a UML class");
        }
        log.debug("Processing " + SysMLToModelicaTranslator.print(ublock));
        MClass mclass = this.createClass(ublock);
        mclass.setName((String)ublock.getValue(this.sysmlutil.getModelicaBlock(), "name"));
        for (Property uproperty : SysMLUtil.getAllAttributes(ublock)) {
            if (!uproperty.isStereotypeApplied(this.sysmlutil.getModelicaParameter()) && !uproperty.isStereotypeApplied(this.sysmlutil.getModelicaPort())) continue;
            MComponent mcomponent = this.createProperty(uproperty);
            if (mcomponent != null) {
                log.info("Adding " + SysMLToModelicaTranslator.print(uproperty) + " to " + SysMLToModelicaTranslator.print(ublock));
                mclass.getComponents().add(mcomponent);
                continue;
            }
            log.debug("Skipping property " + SysMLToModelicaTranslator.print(uproperty));
        }
        return mclass;
    }

    private MBlock createStateMachine(StateMachine ustatemachine) {
        if (ustatemachine == null) {
            throw new IllegalArgumentException("You must provide a UML state machine");
        }
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToModelicaTranslator.getKey(ustatemachine);
        MBlock mblock = null;
        MElement melement = this.refs.get(rk);
        if (melement != null) {
            if (melement instanceof MBlock) {
                mblock = (MBlock)melement;
            } else {
                throw new ClassCastException("The element " + SysMLToModelicaTranslator.print(ustatemachine) + " is expected to be a block, but it is not");
            }
        }
        if (mblock == null) {
            mblock = ModelicaFactory.eINSTANCE.createMBlock();
            this.refs.put(rk, mblock);
            this.toProcess.push(rk);
        }
        return mblock;
    }

    private MBlock createStateLanguage(State uvertex) {
        if (uvertex == null) {
            throw new IllegalArgumentException("You must provide a UML state");
        }
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToModelicaTranslator.getKey(uvertex);
        MBlock mblock = null;
        MElement melement = this.refs.get(rk);
        if (melement != null) {
            if (melement instanceof MBlock) {
                mblock = (MBlock)melement;
            } else {
                throw new ClassCastException("The element " + SysMLToModelicaTranslator.print(uvertex) + " is expected to be a block, but it is not");
            }
        }
        if (mblock == null) {
            mblock = ModelicaFactory.eINSTANCE.createMBlock();
            this.refs.put(rk, mblock);
            this.toProcess2.push(rk);
        }
        return mblock;
    }

    private MComponent createStateLibrary(Vertex uvertex) {
        if (uvertex == null) {
            throw new IllegalArgumentException("You must provide a UML state");
        }
        SysMLToSimulationTranslator.ReferenceKey rk = SysMLToModelicaTranslator.getKey(uvertex);
        MComponent mcomponent = null;
        MElement melement = this.refs.get(rk);
        if (melement != null) {
            if (melement instanceof MComponent) {
                mcomponent = (MComponent)melement;
            } else {
                throw new ClassCastException("The element " + SysMLToModelicaTranslator.print(uvertex) + " is expected to be a component, but it is not");
            }
        }
        if (mcomponent == null) {
            mcomponent = ModelicaFactory.eINSTANCE.createMComponent();
            ModelicaUtil.setName(mcomponent, SysMLUtil.getName(uvertex));
            this.refs.put(rk, mcomponent);
            this.toProcess2.push(rk);
        }
        return mcomponent;
    }

    private MBlock processStateMachineLanguage(StateMachine ustatemachine) throws UMLModelErrorException {
        if (ustatemachine == null) {
            throw new IllegalArgumentException("You must provide a UML state machine");
        }
        log.debug("Processing " + SysMLToModelicaTranslator.print(ustatemachine));
        MBlock mblock = (MBlock)this.processClass(ustatemachine);
        MElement mcontext = this.refs.get(SysMLToModelicaTranslator.getKey(ustatemachine.getContext()));
        if (mcontext instanceof MClass) {
            for (MComponent mcomponent : ((MClass)mcontext).getComponents()) {
                mcomponent.setHierarchy(MHierarchy.INNER);
            }
        }
        for (Region uregion : ustatemachine.getRegions()) {
            this.processRegionLanguage(uregion, mblock);
        }
        return mblock;
    }

    private MBlock processStateMachineLibrary(StateMachine ustatemachine) throws UMLModelErrorException {
        if (ustatemachine == null) {
            throw new IllegalArgumentException("You must provide a UML state machine");
        }
        log.debug("Processing " + SysMLToModelicaTranslator.print(ustatemachine));
        MBlock mblock = (MBlock)this.processClass(ustatemachine);
        for (Region uregion : ustatemachine.getRegions()) {
            this.processRegionLibrary(uregion, mblock);
        }
        return mblock;
    }

    private void processRegionLanguage(Region uregion, MBlock mblock) throws UMLModelErrorException {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        BehavioredClassifier context = uregion.getStateMachine().getContext();
        for (Property uproperty : SysMLUtil.getAllAttributes(context)) {
            List<Property> sps;
            if (!(uproperty.getType() instanceof Classifier) || (sps = this.sysmlutil.getAllPhSProperties((Classifier)uproperty.getType())).size() != 1) continue;
            substitutions.put(uproperty.getName() + "." + sps.get(0).getName(), uproperty.getName());
        }
        for (Vertex uvertex : uregion.getSubvertices()) {
            Behavior uexit;
            Object udo;
            if (!(uvertex instanceof State)) continue;
            State ustate = (State)uvertex;
            MBlock mstatetype = this.createStateLanguage(ustate);
            mstatetype.setOwningClass(mblock);
            MComponent mstate = ModelicaFactory.eINSTANCE.createMComponent();
            mblock.getComponents().add(mstate);
            ModelicaUtil.setName(mstate, "_" + SysMLUtil.getName(ustate));
            mstate.setType(mstatetype);
            Behavior uentry = ustate.getEntry();
            if (uentry != null) {
                if (uentry instanceof OpaqueBehavior) {
                    MAlgorithm mal = ModelicaFactory.eINSTANCE.createMAlgorithm();
                    String exp = SysMLToModelicaTranslator.replace(this.getAssignments((OpaqueBehavior)uentry), "\\w+(\\.\\w+)*", substitutions);
                    mal.setExpression(exp);
                    mstatetype.getAlgorithms().add(mal);
                } else {
                    log.warn("Entry behavior unsupported " + uentry);
                }
            }
            if ((udo = ustate.getDoActivity()) != null) {
                log.warn("DoActivity not translated");
            }
            if ((uexit = ustate.getExit()) != null) {
                log.warn("Exit not translated");
            }
            log.debug("Adding state " + SysMLToModelicaTranslator.print(ustate));
            for (Region uregion2 : ustate.getRegions()) {
                this.processRegionLanguage(uregion2, mstatetype);
            }
        }
        for (Transition utransition : uregion.getTransitions()) {
            Vertex source = utransition.getSource();
            if (source == null) {
                throw new UMLModelErrorException(this.r, "The transition has no source: " + SysMLToModelicaTranslator.print(utransition));
            }
            Vertex target = utransition.getTarget();
            if (target == null) {
                throw new UMLModelErrorException(this.r, "The transition has no target: " + SysMLToModelicaTranslator.print(utransition));
            }
            if (source instanceof Pseudostate && ((Pseudostate)source).getKind() == PseudostateKind.INITIAL_LITERAL) {
                if (target instanceof State) {
                    MEquation meq = ModelicaFactory.eINSTANCE.createMEquation();
                    meq.setExpression("initialState(_" + SysMLUtil.getName(target) + ")");
                    mblock.getEquations().add(meq);
                    continue;
                }
                log.warn("Can't set the initial state: target not a state" + SysMLToModelicaTranslator.print(target));
                continue;
            }
            if (source instanceof State && target instanceof State) {
                String condition = "true";
                String timer = "";
                for (Trigger trigger : utransition.getTriggers()) {
                    Event event = trigger.getEvent();
                    if (event == null) continue;
                    if (event instanceof ChangeEvent) {
                        condition = SysMLToModelicaTranslator.replace(this.getExpression(((ChangeEvent)event).getChangeExpression()), "\\w+(\\.\\w+)*", substitutions);
                        continue;
                    }
                    if (event instanceof TimeEvent) {
                        TimeEvent te = (TimeEvent)event;
                        if (te.isRelative()) {
                            timer = ",enableTimer=true,waitTime=" + this.getExpression(((TimeEvent)event).getWhen());
                            continue;
                        }
                        condition = "time>" + this.getExpression(((TimeEvent)event).getWhen());
                        continue;
                    }
                    if (event instanceof CallEvent) {
                        condition = SysMLUtil.getName(((CallEvent)event).getOperation());
                        continue;
                    }
                    log.warn("Trigger " + trigger + " with event " + event + " couldn't be translated");
                }
                String priority = "";
                if (source.isStereotypeApplied(this.sysmlutil.getSimulationVertex()) && source.getValue(this.sysmlutil.getSimulationVertex(), "transitionPriority") instanceof List) {
                    List ltr = (List)source.getValue(this.sysmlutil.getSimulationVertex(), "transitionPriority");
                    priority = ",priority=" + (ltr.indexOf(utransition) + 1);
                }
                MEquation meq = ModelicaFactory.eINSTANCE.createMEquation();
                meq.setExpression("transition(_" + SysMLUtil.getName(source) + ", _" + SysMLUtil.getName(target) + ", " + condition + timer + priority + ")");
                mblock.getEquations().add(meq);
                continue;
            }
            log.warn("Unsupported transition " + SysMLToModelicaTranslator.print(utransition));
        }
    }

    private void processRegionLibrary(Region uregion, MBlock mblock) throws UMLModelErrorException {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        BehavioredClassifier context = uregion.getStateMachine().getContext();
        for (Property uproperty : SysMLUtil.getAllAttributes(context)) {
            List<Property> sps;
            if (!(uproperty.getType() instanceof Classifier) || (sps = this.sysmlutil.getAllPhSProperties((Classifier)uproperty.getType())).size() != 1) continue;
            substitutions.put(uproperty.getName() + "." + sps.get(0).getName(), uproperty.getName());
        }
        for (Vertex uvertex : uregion.getSubvertices()) {
            if (uvertex instanceof State) {
                Behavior uexit;
                Behavior udo;
                State ustate = (State)uvertex;
                String ustatename = SysMLUtil.getName(ustate);
                MComponent mc = this.createStateLibrary(ustate);
                mblock.getComponents().add(mc);
                Behavior uentry = ustate.getEntry();
                if (uentry != null) {
                    if (uentry instanceof OpaqueBehavior) {
                        String exp = "if " + ustatename + ".active then " + this.getAssignments((OpaqueBehavior)uentry) + " end if;";
                        MAlgorithm mal = ModelicaFactory.eINSTANCE.createMAlgorithm();
                        mal.setExpression(SysMLToModelicaTranslator.replace(exp, "\\w+(\\.\\w+)*", substitutions));
                        mblock.getAlgorithms().add(mal);
                    } else {
                        log.warn("Entry unsupported " + uentry);
                    }
                }
                if ((udo = ustate.getDoActivity()) != null) {
                    log.warn("DoActivity not translated");
                    if (udo instanceof Activity) {
                        Activity activity = (Activity)udo;
                        if (activity.getOwnedNodes().size() == 1) {
                            ActivityNode node = (ActivityNode)activity.getOwnedNodes().get(0);
                            if (node instanceof CallOperationAction) {
                                CallOperationAction cao = (CallOperationAction)node;
                                MAlgorithm mal = ModelicaFactory.eINSTANCE.createMAlgorithm();
                                String uoperationname = SysMLUtil.getName(cao.getOperation());
                                mal.setExpression("if " + ustatename + ".active and not(pre(" + ustatename + ".active)) then " + uoperationname + ":=true; endif;");
                                mblock.getAlgorithms().add(mal);
                                mal = ModelicaFactory.eINSTANCE.createMAlgorithm();
                                mal.setExpression("if not(" + ustatename + ".active) and pre(" + ustatename + ".active) then " + uoperationname + ":=false; end if;");
                                mblock.getAlgorithms().add(mal);
                            } else {
                                log.warn("Can translate only activity with one call operation action");
                            }
                        } else {
                            log.warn("Can translate only activity with one node: found " + activity.getOwnedNodes().size());
                        }
                    } else {
                        log.warn("Do behavior unsupported " + udo);
                    }
                }
                if ((uexit = ustate.getEntry()) != null) {
                    log.warn("Exit not translated");
                }
                log.debug("Adding state " + SysMLToModelicaTranslator.print(ustate));
                for (Region uregion2 : ustate.getRegions()) {
                    this.processRegionLibrary(uregion2, mblock);
                }
                continue;
            }
            if (uvertex instanceof Pseudostate && ((Pseudostate)uvertex).getKind() == PseudostateKind.INITIAL_LITERAL) {
                Pseudostate upseudostate = (Pseudostate)uvertex;
                MComponent mc = this.createStateLibrary(upseudostate);
                mblock.getComponents().add(mc);
                continue;
            }
            log.warn("Untreated vertex: " + SysMLToModelicaTranslator.print(uvertex));
        }
        for (Transition utransition : uregion.getTransitions()) {
            if (utransition.getSource() == null || utransition.getTarget() == null) {
                log.error("The transition has a no source or target");
                continue;
            }
            MComponent source = this.createStateLibrary(utransition.getSource());
            MComponent target = this.createStateLibrary(utransition.getTarget());
            MComponent transition = ModelicaFactory.eINSTANCE.createMComponent();
            mblock.getComponents().add(transition);
            ModelicaUtil.setName(transition, SysMLUtil.getName(utransition));
            log.info("Creating transition " + transition.getName());
            transition.setType(ModelicaUtil.getTransition());
            MEquation meq1 = ModelicaFactory.eINSTANCE.createMEquation();
            meq1.setExpression("connect(" + source.getName() + ".outPort[" + (utransition.getSource().getOutgoings().indexOf(utransition) + 1) + "], " + transition.getName() + ".inPort)");
            mblock.getEquations().add(meq1);
            MEquation meq2 = ModelicaFactory.eINSTANCE.createMEquation();
            meq2.setExpression("connect(" + transition.getName() + ".outPort, " + target.getName() + ".inPort[" + (utransition.getTarget().getIncomings().indexOf(utransition) + 1) + "])");
            mblock.getEquations().add(meq2);
            String condition = "true";
            for (Trigger trigger : utransition.getTriggers()) {
                Event event = trigger.getEvent();
                if (event == null) continue;
                if (event instanceof ChangeEvent) {
                    condition = this.getExpression(((ChangeEvent)event).getChangeExpression());
                    continue;
                }
                if (event instanceof TimeEvent) {
                    TimeEvent te = (TimeEvent)event;
                    if (te.isRelative()) {
                        MModification mtimer = ModelicaFactory.eINSTANCE.createMModification();
                        MExpressionValue mtimerex = ModelicaFactory.eINSTANCE.createMExpressionValue();
                        mtimerex.setValue("true");
                        mtimer.getComponentPath().add(ModelicaUtil.getTransition().getComponentByName("enableTimer"));
                        mtimer.setAssignedValue(mtimerex);
                        transition.getModifications().add(mtimer);
                        MModification mwait = ModelicaFactory.eINSTANCE.createMModification();
                        MExpressionValue mwaitex = ModelicaFactory.eINSTANCE.createMExpressionValue();
                        mwaitex.setValue(this.getExpression(((TimeEvent)event).getWhen()));
                        mwait.getComponentPath().add(ModelicaUtil.getTransition().getComponentByName("waitTime"));
                        mwait.setAssignedValue(mwaitex);
                        transition.getModifications().add(mwait);
                        continue;
                    }
                    condition = "time>" + this.getExpression(((TimeEvent)event).getWhen());
                    continue;
                }
                if (event instanceof CallEvent) {
                    condition = SysMLUtil.getName(((CallEvent)event).getOperation());
                    continue;
                }
                log.warn("Trigger " + SysMLToModelicaTranslator.print(trigger) + " couldn't be translated");
            }
            MModification mcondition = ModelicaFactory.eINSTANCE.createMModification();
            MExpressionValue mex = ModelicaFactory.eINSTANCE.createMExpressionValue();
            mex.setValue(SysMLToModelicaTranslator.replace(condition, "\\w+(\\.\\w+)*", substitutions));
            mcondition.getComponentPath().add(ModelicaUtil.getTransition().getComponentByName("condition"));
            mcondition.setAssignedValue(mex);
            transition.getModifications().add(mcondition);
        }
    }

    private MBlock processStateLanguage2(State ustate) {
        if (ustate == null) {
            throw new IllegalArgumentException("You must provide a UML state");
        }
        log.debug("Processing " + SysMLToModelicaTranslator.print(ustate));
        MBlock mblock = this.createStateLanguage(ustate);
        ModelicaUtil.setName(mblock, SysMLUtil.getName(ustate));
        LinkedList<String> lhss = new LinkedList<String>();
        for (MAlgorithm mal : mblock.getAlgorithms()) {
            for (String assign : mal.getExpression().split(";")) {
                for (String lhs : assign.split(":=")) {
                    lhss.add(lhs.trim());
                }
            }
        }
        MElement mcontext = this.refs.get(SysMLToModelicaTranslator.getKey(ustate.containingStateMachine().getContext()));
        if (mcontext instanceof MClass) {
            for (MComponent mcomponent : ((MClass)mcontext).getComponents()) {
                if (mcomponent.getHierarchy() != MHierarchy.INNER) continue;
                MComponent mcomponent2 = ModelicaFactory.eINSTANCE.createMComponent();
                mblock.getComponents().add(mcomponent2);
                ModelicaUtil.setName(mcomponent2, mcomponent.getName());
                mcomponent2.setType(mcomponent.getType());
                mcomponent2.setHierarchy(MHierarchy.OUTER);
                if (!lhss.contains(mcomponent2.getName())) continue;
                mcomponent2.setDirection(MDirection.OUTPUT);
            }
        }
        return mblock;
    }

    private MComponent processStateLibrary2(Vertex uvertex) {
        if (uvertex == null) {
            throw new IllegalArgumentException("You must provide a UML state");
        }
        log.debug("Processing state " + SysMLUtil.getName(uvertex));
        MComponent mcomponent = this.createStateLibrary(uvertex);
        if (uvertex instanceof Pseudostate && ((Pseudostate)uvertex).getKind() == PseudostateKind.INITIAL_LITERAL) {
            mcomponent.setType(ModelicaUtil.getInitialStep());
        } else {
            mcomponent.setType(ModelicaUtil.getStep());
        }
        MModification mmodification1 = ModelicaFactory.eINSTANCE.createMModification();
        mmodification1.getComponentPath().add(ModelicaUtil.getStep().getComponentByName("nIn"));
        MIntegerValue miv1 = ModelicaFactory.eINSTANCE.createMIntegerValue();
        miv1.setValue(uvertex.getIncomings().size());
        mmodification1.setAssignedValue(miv1);
        mcomponent.getModifications().add(mmodification1);
        MModification mmodification2 = ModelicaFactory.eINSTANCE.createMModification();
        mmodification2.getComponentPath().add(ModelicaUtil.getStep().getComponentByName("nOut"));
        MIntegerValue miv2 = ModelicaFactory.eINSTANCE.createMIntegerValue();
        miv2.setValue(uvertex.getOutgoings().size());
        mmodification2.setAssignedValue(miv2);
        mcomponent.getModifications().add(mmodification2);
        return mcomponent;
    }

    private MModel processModel2(Class ublock) throws UMLModelErrorException {
        return (MModel)this.processClass2(ublock);
    }

    private MConnector processConnector2(Class ublock) throws UMLModelErrorException {
        return (MConnector)this.processClass2(ublock);
    }

    private MClass processClass2(Class ublock) throws UMLModelErrorException {
        if (ublock == null) {
            throw new IllegalArgumentException("You must provide a UML class");
        }
        log.debug("Processing " + SysMLToModelicaTranslator.print(ublock) + " a second time");
        MClass mclass = this.createClass(ublock);
        if (ublock.getClassifierBehavior() != null && ublock.getClassifierBehavior() instanceof StateMachine) {
            StateMachine sm = (StateMachine)ublock.getClassifierBehavior();
            MBlock mstatemachine = this.createStateMachine(sm);
            MComponent mstatemachinecomponent = ModelicaFactory.eINSTANCE.createMComponent();
            mclass.getComponents().add(mstatemachinecomponent);
            ModelicaUtil.setName(mstatemachinecomponent, "_" + SysMLUtil.getName(sm));
            mstatemachinecomponent.setType(mstatemachine);
            for (Property uproperty : SysMLUtil.getAllAttributes(ublock)) {
                if (!(this.refs.get(SysMLToModelicaTranslator.getKey(uproperty)) instanceof MComponent)) continue;
                MComponent copied = (MComponent)this.refs.get(SysMLToModelicaTranslator.getKey(uproperty));
                String string = SysMLUtil.getName(uproperty);
                MComponent mc1 = ModelicaFactory.eINSTANCE.createMComponent();
                mstatemachine.getComponents().add(mc1);
                ModelicaUtil.setName(mc1, string);
                mc1.setType(copied.getType());
                MEquation mequation = ModelicaFactory.eINSTANCE.createMEquation();
                mequation.setExpression(string + "=" + mstatemachinecomponent.getName() + "." + string);
                mclass.getEquations().add(mequation);
            }
            for (Classifier uclassifier : ublock.getGenerals()) {
                TranslatedType tself = this.getTranslatedType(ublock);
                TranslatedType translatedType = this.getTranslatedType(uclassifier);
                if (tself != TranslatedType.MODEL || translatedType != TranslatedType.CONNECTOR) continue;
                for (Operation uoperation : uclassifier.getAllOperations()) {
                    if (!uoperation.isStereotypeApplied(this.sysmlutil.getDirectedFeature())) continue;
                    MComponent mc1 = ModelicaFactory.eINSTANCE.createMComponent();
                    mstatemachine.getComponents().add(mc1);
                    ModelicaUtil.setName(mc1, SysMLUtil.getName(uoperation));
                    mc1.setType(ModelicaUtil.getBoolean());
                    MEquation mequation = ModelicaFactory.eINSTANCE.createMEquation();
                    mequation.setExpression(mc1.getName() + "=" + mstatemachinecomponent.getName() + "." + mc1.getName());
                    mclass.getEquations().add(mequation);
                }
            }
        }
        EList<Connector> connectors = ublock.getOwnedConnectors();
        for (Connector conn : connectors) {
            if (!conn.isStereotypeApplied(this.sysmlutil.getBindingConnector())) continue;
            List<Property> lp0 = this.sysmlutil.getPropertyPath((ConnectorEnd)conn.getEnds().get(0));
            List<Property> lp1 = this.sysmlutil.getPropertyPath((ConnectorEnd)conn.getEnds().get(1));
            boolean join = true;
            block4: for (List lp : new List[]{lp0, lp1}) {
                for (int i = 0; i < lp.size(); ++i) {
                    if (((Property)lp.get(i)).getType() == null || !((Property)lp.get(i)).getType().isStereotypeApplied(this.sysmlutil.getConstraintBlock())) continue;
                    join = false;
                    break block4;
                }
            }
            if (!lp0.get(lp0.size() - 1).isStereotypeApplied(this.sysmlutil.getPhSVariable()) && !lp1.get(lp1.size() - 1).isStereotypeApplied(this.sysmlutil.getPhSVariable())) {
                join = false;
            }
            String string = this.sysmlutil.joinProperties(lp0, ".") + "=" + this.sysmlutil.joinProperties(lp1, ".");
            if (!join) continue;
            MEquation meq = ModelicaFactory.eINSTANCE.createMEquation();
            meq.setExpression(string);
            mclass.getEquations().add(meq);
        }
        for (Property uproperty : ublock.getOwnedAttributes()) {
            if (!uproperty.getType().isStereotypeApplied(this.sysmlutil.getConstraintBlock())) continue;
            Class uconstraintblock = (Class)uproperty.getType();
            Hashtable<String, String> substitutions = new Hashtable<String, String>();
            for (Connector connector : connectors) {
                if (!connector.isStereotypeApplied(this.sysmlutil.getBindingConnector())) continue;
                List<Property> lp0 = this.sysmlutil.getPropertyPath((ConnectorEnd)connector.getEnds().get(0));
                List<Property> lp1 = this.sysmlutil.getPropertyPath((ConnectorEnd)connector.getEnds().get(1));
                String from = null;
                String to = null;
                if (lp0.size() > 1 && lp0.get(0) == uproperty) {
                    from = SysMLUtil.getName(lp0.get(1));
                    this.sysmlutil.removeSimProperty(lp1);
                    to = this.sysmlutil.joinProperties(lp1, ".");
                    if (lp0.get(1).isStereotypeApplied(this.sysmlutil.getMultidimensionalElement())) {
                        to = "{" + to + "}";
                    }
                }
                if (lp1.size() > 1 && lp1.get(0) == uproperty) {
                    from = SysMLUtil.getName(lp1.get(1));
                    this.sysmlutil.removeSimProperty(lp0);
                    to = this.sysmlutil.joinProperties(lp0, ".");
                    if (lp1.get(1).isStereotypeApplied(this.sysmlutil.getMultidimensionalElement()) && !lp0.get(lp0.size() - 1).isStereotypeApplied(this.sysmlutil.getMultidimensionalElement())) {
                        to = "{" + to + "}";
                    }
                }
                if (from == null || to == null) continue;
                substitutions.put(from, to);
            }
            List<Constraint> uconstraints = SysMLUtil.getAllConstraints(uconstraintblock);
            for (Constraint uconstraint : uconstraints) {
                MEquation meq = ModelicaFactory.eINSTANCE.createMEquation();
                this.getExpressionTranslator().setSubstitutions(substitutions);
                meq.setExpression(this.getEquation(uconstraint.getSpecification()));
                this.getExpressionTranslator().setSubstitutions(null);
                mclass.getEquations().add(meq);
            }
        }
        for (Property uproperty : ublock.getOwnedAttributes()) {
            MNamedElement mc;
            Object vs;
            MElement melement = this.refs.get(SysMLToModelicaTranslator.getKey(uproperty));
            if (melement != null && (vs = uproperty.getDefaultValue()) != null) {
                if (vs instanceof InstanceValue) {
                    InstanceSpecification instancespec = ((InstanceValue)vs).getInstance();
                    if (instancespec != null) {
                        for (Slot slot : instancespec.getSlots()) {
                            for (MModification mmodification : this.getModificationsFromSlot(slot, (Property)slot.getDefiningFeature())) {
                                mc = this.createProperty((Property)slot.getDefiningFeature());
                                if (mc != null) {
                                    mmodification.getComponentPath().add(0, (MComponent)mc);
                                } else {
                                    log.error("Can't add component " + slot.getDefiningFeature().getQualifiedName() + " to the modification in " + ublock.getQualifiedName());
                                }
                                ((MComponent)melement).getModifications().add(mmodification);
                            }
                        }
                    }
                } else {
                    MDataValue mdv = this.getValue((ValueSpecification)vs);
                    if (mdv != null) {
                        Classifier classifier = (Classifier)uproperty.getType();
                        MClass mc2 = this.createClass(classifier);
                        MComponent start = mc2.getComponentByName("start");
                        MComponent fixed = mc2.getComponentByName("fixed");
                        if (start != null && fixed != null) {
                            MModification mmod = ModelicaFactory.eINSTANCE.createMModification();
                            mmod.getComponentPath().add(start);
                            mmod.setAssignedValue(mdv);
                            ((MComponent)melement).getModifications().add(mmod);
                            MBooleanValue mbv = ModelicaFactory.eINSTANCE.createMBooleanValue();
                            mbv.setValue(true);
                            MModification mmod2 = ModelicaFactory.eINSTANCE.createMModification();
                            mmod2.getComponentPath().add(fixed);
                            mmod2.setAssignedValue(mbv);
                            ((MComponent)melement).getModifications().add(mmod2);
                        } else {
                            log.warn("The start component of " + SysMLToModelicaTranslator.print(uproperty) + " couldn't be found");
                        }
                    } else {
                        log.warn("Could not retrieve the default value of " + SysMLToModelicaTranslator.print(uproperty));
                    }
                }
            }
            if (!this.sysmlutil.isPhSProperty(uproperty)) continue;
            vs = SysMLUtil.getAllAttributes((Classifier)uproperty.getType()).iterator();
            while (vs.hasNext()) {
                Property uproperty2 = (Property)vs.next();
                MComponent mComponent = this.createProperty(uproperty2);
                ValueSpecification vs2 = uproperty2.getDefaultValue();
                if (mComponent == null || vs2 == null) continue;
                MDataValue mdv = this.getValue(vs2);
                if (mdv != null) {
                    Classifier uclassifier = (Classifier)uproperty2.getType();
                    mc = this.createClass(uclassifier);
                    MComponent start = ((MClass)mc).getComponentByName("start");
                    MComponent fixed = ((MClass)mc).getComponentByName("fixed");
                    if (start != null && fixed != null) {
                        MModification mmod = ModelicaFactory.eINSTANCE.createMModification();
                        mmod.getComponentPath().add(start);
                        mmod.setAssignedValue(mdv);
                        mComponent.getModifications().add(mmod);
                        MBooleanValue mbv = ModelicaFactory.eINSTANCE.createMBooleanValue();
                        mbv.setValue(true);
                        MModification mmod2 = ModelicaFactory.eINSTANCE.createMModification();
                        mmod2.getComponentPath().add(fixed);
                        mmod2.setAssignedValue(mbv);
                        mComponent.getModifications().add(mmod2);
                        continue;
                    }
                    log.warn("The start component of " + SysMLToModelicaTranslator.print(ublock) + " couldn't be found");
                    continue;
                }
                log.warn("Could not retrieve the default value of " + SysMLToModelicaTranslator.print(uproperty));
            }
        }
        for (Dependency dep : ublock.getClientDependencies()) {
            if (!dep.isStereotypeApplied(this.sysmlutil.getInitialValuesSpecification())) continue;
            log.info("Found instance specification for " + SysMLToModelicaTranslator.print(ublock));
            for (NamedElement supplier : dep.getSuppliers()) {
                if (!(supplier instanceof InstanceSpecification)) continue;
                InstanceSpecification target = (InstanceSpecification)supplier;
                for (Slot slot : target.getSlots()) {
                    List<MModification> mmodifications = this.getModificationsFromSlot(slot, (Property)slot.getDefiningFeature());
                    StructuralFeature sf = slot.getDefiningFeature();
                    MComponent mcomponent = this.createProperty((Property)sf);
                    mcomponent.getModifications().addAll(mmodifications);
                }
            }
        }
        return mclass;
    }

    private MType processType(DataType udatatype) throws UMLModelErrorException {
        if (udatatype == null) {
            throw new IllegalArgumentException("You must provide a UML datatype");
        }
        log.debug("Processing " + SysMLToModelicaTranslator.print(udatatype));
        MType mtype = (MType)this.createClass(udatatype);
        ModelicaUtil.setName(mtype, SysMLUtil.getName(udatatype));
        for (Classifier uclassifier : udatatype.getGenerals()) {
            MExtension mextansion = ModelicaFactory.eINSTANCE.createMExtension();
            MType mgeneral = (MType)this.createClass(uclassifier);
            mextansion.setExtendedClass(mgeneral);
            log.info("Adding generalization to " + mgeneral.getName());
            mextansion.getModifications().addAll(this.getModificationsFromValueType(udatatype));
            mextansion.setOwningClass(mtype);
        }
        for (Property uproperty : udatatype.getOwnedAttributes()) {
            log.debug("Skipping datatype property " + SysMLToModelicaTranslator.print(uproperty));
        }
        return mtype;
    }

    private MComponent processProperty(Property uproperty) throws UMLModelErrorException {
        EnumerationLiteral el;
        String name;
        if (uproperty == null) {
            throw new NullPointerException("You must provide a UML property");
        }
        log.debug("Processing property " + SysMLToModelicaTranslator.print(uproperty));
        MComponent mcomponent = this.createProperty(uproperty);
        ModelicaUtil.setName(mcomponent, SysMLUtil.getName(uproperty));
        if (uproperty.isStereotypeApplied(this.sysmlutil.getModelicaParameter())) {
            name = (String)uproperty.getValue(this.sysmlutil.getModelicaParameter(), "name");
            if (name != null) {
                ModelicaUtil.setName(mcomponent, name);
            }
        } else if (uproperty.isStereotypeApplied(this.sysmlutil.getModelicaPort()) && (name = (String)uproperty.getValue(this.sysmlutil.getModelicaPort(), "name")) != null) {
            ModelicaUtil.setName(mcomponent, name);
        }
        if (uproperty.getVisibility() == VisibilityKind.PUBLIC_LITERAL) {
            mcomponent.setAccessControl(MAccessControl.PUBLIC);
        } else {
            mcomponent.setAccessControl(MAccessControl.PROTECTED);
        }
        Type utype = uproperty.getType();
        if (utype == null) {
            throw new UMLModelErrorException(this.r, "The property " + SysMLToModelicaTranslator.print(uproperty) + " must have a type");
        }
        List<Property> sps = null;
        if (utype instanceof Class) {
            sps = this.sysmlutil.getAllPhSProperties((Class)utype);
        }
        if (sps != null && sps.size() > 0) {
            Property sp = sps.get(0);
            EnumerationLiteral enumerationLiteral = (EnumerationLiteral)sp.getValue(this.sysmlutil.getFlowProperty(), "direction");
            if (enumerationLiteral != null) {
                boolean conj = uproperty instanceof Port && ((Port)uproperty).isConjugated();
                String sdirection = enumerationLiteral.getName();
                if ("in".equals(sdirection) && !conj || "out".equals(sdirection) && conj) {
                    mcomponent.setDirection(MDirection.INPUT);
                    mcomponent.setType(this.createClass(sp.getType()));
                } else if ("out".equals(sdirection) && !conj || "in".equals(sdirection) && conj) {
                    mcomponent.setDirection(MDirection.OUTPUT);
                    mcomponent.setType(this.createClass(sp.getType()));
                } else {
                    mcomponent.setType(this.createClass(utype));
                }
            }
        } else if (utype.isStereotypeApplied(this.sysmlutil.getPropertySpecificType())) {
            Classifier uclassifier = (Classifier)utype;
            if (!uclassifier.isStereotypeApplied(this.sysmlutil.getValueType())) {
                log.warn("Can only process PropertySpecificType that are ValueTypes");
            } else if (uclassifier.getGenerals().size() != 1) {
                log.warn("The PropertySpecificType must have 1 general classifier to be processed");
            } else if (((Classifier)uclassifier.getGenerals().get(0)).isStereotypeApplied(this.sysmlutil.getPropertySpecificType())) {
                log.warn("The general classifier of PropertySpecificType must not me a PropertySpecificType");
            } else {
                Classifier classifier = (Classifier)uclassifier.getGenerals().get(0);
                mcomponent.setType(this.createClass(classifier));
                mcomponent.getModifications().addAll(this.getModificationsFromValueType((DataType)classifier));
            }
        } else {
            MClass mtype = this.createClass(utype);
            mcomponent.setType(mtype);
        }
        for (Property property : uproperty.getRedefinedProperties()) {
            if (property.getName().equals(uproperty.getName())) {
                MComponent mcomponent2 = this.createProperty(property);
                mcomponent.setRedefinedComponent(mcomponent2);
                log.info("Assigning redefined property " + SysMLToModelicaTranslator.print(property));
                break;
            }
            log.warn("Redefined property has different name: " + SysMLToModelicaTranslator.print(property));
        }
        if (uproperty.isReadOnly()) {
            mcomponent.setVariability(MVariability.CONSTANT);
        } else if (uproperty.isStereotypeApplied(this.sysmlutil.getPhSConstant())) {
            mcomponent.setVariability(MVariability.PARAMETER);
        } else if (uproperty.isStereotypeApplied(this.sysmlutil.getPhSVariable())) {
            Object o = uproperty.getValue(this.sysmlutil.getPhSVariable(), "isContinuous");
            if (o != null && o instanceof Boolean && !((Boolean)o).booleanValue()) {
                mcomponent.setVariability(MVariability.DISCRETE);
            }
            if ((o = uproperty.getValue(this.sysmlutil.getPhSVariable(), "isConserved")) != null && o instanceof Boolean && ((Boolean)o).booleanValue()) {
                log.info("Setting component as flow");
                mcomponent.setDataFlow(MDataFlow.FLOW);
            }
        }
        if (this.sysmlutil.isPhSProperty(uproperty) && (el = (EnumerationLiteral)uproperty.getValue(this.sysmlutil.getFlowProperty(), "direction")) != null) {
            if (el.getName().equals("in")) {
                mcomponent.setDirection(MDirection.INPUT);
            } else if (el.getName().equals("out")) {
                mcomponent.setDirection(MDirection.OUTPUT);
            }
        }
        if (uproperty.isStereotypeApplied(this.sysmlutil.getMultidimensionalElement()) && uproperty.getValue(this.sysmlutil.getMultidimensionalElement(), "dimension") instanceof List) {
            List dimensions = (List)uproperty.getValue(this.sysmlutil.getMultidimensionalElement(), "dimension");
            for (Object o : dimensions) {
                if (!(o instanceof Integer)) continue;
                Integer dim = (Integer)o;
                mcomponent.getDimensions().add(dim);
            }
        }
        if (this.getTranslatedType(utype) == TranslatedType.INTERFACE) {
            for (Property property : SysMLUtil.getAllAttributes((Class)utype)) {
                Object oformat;
                Object val;
                if (!property.isStereotypeApplied(this.sysmlutil.getModelicaParameter()) || (val = property.getValue(this.sysmlutil.getModelicaParameter(), "value")) == null) continue;
                if (this.sysmlutil.getModelicaParameter().getAttribute("format", null) != null && (oformat = property.getValue(this.sysmlutil.getModelicaParameter(), "format")) instanceof String) {
                    val = ((String)oformat).replaceAll("%s", val.toString());
                }
                MModification mmod = ModelicaFactory.eINSTANCE.createMModification();
                MComponent mc = this.createProperty(property);
                if (mc != null) {
                    mmod.getComponentPath().add(mc);
                } else {
                    log.error("Can't add component " + property.getQualifiedName() + " to the modification in " + utype.getQualifiedName());
                }
                MExpressionValue mexp = ModelicaFactory.eINSTANCE.createMExpressionValue();
                mexp.setValue(val.toString());
                mmod.setAssignedValue(mexp);
                mcomponent.getModifications().add(mmod);
            }
        }
        return mcomponent;
    }

    private void addInitialValue(MComponent mcomponent, LinkedList<MComponent> linkedList, Slot slot) throws UMLModelErrorException {
        if (slot.getValues().size() == 0) {
            log.warn("Slot " + SysMLToModelicaTranslator.print(slot) + " has no values");
        } else {
            StructuralFeature sf = slot.getDefiningFeature();
            if (!(sf instanceof Property)) {
                log.warn("The feature of slot " + SysMLToModelicaTranslator.print(slot) + " should be a property");
                return;
            }
            MComponent lastcomp = this.createProperty((Property)sf);
            if (lastcomp == null) {
                log.error("Can't get component for property " + sf.getQualifiedName() + " in modification");
                return;
            }
            if (slot.isStereotypeApplied(this.sysmlutil.getInitialValueReference()) && slot.getValue(this.sysmlutil.getInitialValueReference(), "propertyPath") instanceof List) {
                List references = (List)slot.getValue(this.sysmlutil.getInitialValueReference(), "propertyPath");
                LinkedList<MComponent> components = new LinkedList<MComponent>();
                for (Property prop : references) {
                    MComponent comp = this.createProperty(prop);
                    if (comp != null) {
                        components.add(comp);
                        continue;
                    }
                    log.error("Can't get component for property " + prop.getQualifiedName() + " in modification");
                }
                MModification mmodification = ModelicaFactory.eINSTANCE.createMModification();
                mmodification.getComponentPath().addAll(linkedList);
                mmodification.getComponentPath().add(lastcomp);
                mmodification.getComponentPath().add(lastcomp.getComponentByName("start"));
                mmodification.getAssignedReference().addAll(components);
                mcomponent.getModifications().add(mmodification);
                MBooleanValue mbv = ModelicaFactory.eINSTANCE.createMBooleanValue();
                mbv.setValue(true);
                MModification mmod2 = ModelicaFactory.eINSTANCE.createMModification();
                mmod2.getComponentPath().addAll(linkedList);
                mmod2.getComponentPath().add(lastcomp);
                mmod2.getComponentPath().add(lastcomp.getComponentByName("fixed"));
                mmod2.setAssignedValue(mbv);
                mcomponent.getModifications().add(mmod2);
            } else {
                ValueSpecification vs = (ValueSpecification)slot.getValues().get(0);
                MDataValue mdv = this.getValue(vs);
                if (mdv != null) {
                    MModification mmodification = ModelicaFactory.eINSTANCE.createMModification();
                    mmodification.getComponentPath().addAll(linkedList);
                    mmodification.getComponentPath().add(lastcomp);
                    if (!sf.isStereotypeApplied(this.sysmlutil.getModelicaParameter())) {
                        mmodification.getComponentPath().add(lastcomp.getComponentByName("start"));
                    }
                    mmodification.setAssignedValue(mdv);
                    mcomponent.getModifications().add(mmodification);
                    MBooleanValue mbv = ModelicaFactory.eINSTANCE.createMBooleanValue();
                    mbv.setValue(true);
                    MModification mmod2 = ModelicaFactory.eINSTANCE.createMModification();
                    mmod2.getComponentPath().addAll(linkedList);
                    mmod2.getComponentPath().add(lastcomp);
                    mmod2.getComponentPath().add(lastcomp.getComponentByName("fixed"));
                    mmod2.setAssignedValue(mbv);
                    mcomponent.getModifications().add(mmod2);
                } else if (vs instanceof InstanceValue) {
                    LinkedList<MComponent> newlist = new LinkedList<MComponent>(linkedList);
                    newlist.add(lastcomp);
                    for (Slot subslot : ((InstanceValue)vs).getInstance().getSlots()) {
                        this.addInitialValue(mcomponent, newlist, subslot);
                    }
                } else {
                    log.warn("Unable to process the value of " + SysMLToModelicaTranslator.print(vs) + ". Use String, Boolean, Integer, Real or SysML initial values");
                }
            }
        }
    }

    private List<MModification> getModificationsFromSlot(Slot uslot, Property definingfeature) throws UMLModelErrorException {
        ArrayList<MModification> ret = new ArrayList<MModification>();
        MComponent mcomponent = this.createProperty(definingfeature);
        if (mcomponent == null) {
            log.error("Can't get component for property " + definingfeature.getQualifiedName() + " for modification");
            return ret;
        }
        if (uslot.isStereotypeApplied(this.sysmlutil.getInitialValueReference()) && uslot.getValue(this.sysmlutil.getInitialValueReference(), "propertyPath") instanceof List) {
            List propertyPath = (List)uslot.getValue(this.sysmlutil.getInitialValueReference(), "propertyPath");
            LinkedList<MComponent> referencedcomponents = new LinkedList<MComponent>();
            for (Property prop : propertyPath) {
                if (this.sysmlutil.isPhSProperty(prop)) continue;
                MComponent comp = this.createProperty(prop);
                if (comp != null) {
                    referencedcomponents.add(comp);
                    continue;
                }
                log.error("Can't get component for property " + prop.getQualifiedName() + " in modification");
            }
            MModification mmod1 = ModelicaFactory.eINSTANCE.createMModification();
            mmod1.getComponentPath().add(mcomponent.getComponentByName("start"));
            mmod1.getAssignedReference().addAll(referencedcomponents);
            ret.add(mmod1);
            MBooleanValue mbv = ModelicaFactory.eINSTANCE.createMBooleanValue();
            mbv.setValue(true);
            MModification mmod2 = ModelicaFactory.eINSTANCE.createMModification();
            mmod2.getComponentPath().add(mcomponent.getComponentByName("fixed"));
            mmod2.setAssignedValue(mbv);
            ret.add(mmod2);
        } else if (uslot.getValues().size() == 1) {
            ValueSpecification vs = (ValueSpecification)uslot.getValues().get(0);
            MDataValue mdv = this.getValue(vs);
            if (mdv != null) {
                MModification mmod1 = ModelicaFactory.eINSTANCE.createMModification();
                if (!uslot.getDefiningFeature().isStereotypeApplied(this.sysmlutil.getModelicaParameter())) {
                    mmod1.getComponentPath().add(mcomponent.getComponentByName("start"));
                }
                mmod1.setAssignedValue(mdv);
                ret.add(mmod1);
                MBooleanValue mbv = ModelicaFactory.eINSTANCE.createMBooleanValue();
                mbv.setValue(true);
                MModification mmod2 = ModelicaFactory.eINSTANCE.createMModification();
                mmod2.getComponentPath().add(mcomponent.getComponentByName("fixed"));
                mmod2.setAssignedValue(mbv);
                ret.add(mmod2);
            } else if (vs instanceof InstanceValue) {
                for (Slot subslot : ((InstanceValue)vs).getInstance().getSlots()) {
                    if (this.sysmlutil.isPhSProperty((Property)subslot.getDefiningFeature())) {
                        List<MModification> mmodifications = this.getModificationsFromSlot(subslot, definingfeature);
                        for (MModification mModification : mmodifications) {
                            ret.add(mModification);
                        }
                        continue;
                    }
                    MComponent mcomponent2 = this.createProperty((Property)subslot.getDefiningFeature());
                    if (mcomponent2 == null) {
                        log.error("Can't get component for property " + subslot.getDefiningFeature().getQualifiedName() + " in modification");
                        continue;
                    }
                    List<MModification> mmodifications = this.getModificationsFromSlot(subslot, (Property)subslot.getDefiningFeature());
                    for (MModification mmodification3 : mmodifications) {
                        mmodification3.getComponentPath().add(0, mcomponent2);
                        ret.add(mmodification3);
                    }
                }
            } else {
                log.warn("Unable to process the value of " + SysMLToModelicaTranslator.print(vs) + ". Use String, Boolean, Integer, Real or SysML initial values");
            }
        } else if (uslot.getValues().size() > 1) {
            int j;
            int i;
            List dims;
            StringBuilder sb = new StringBuilder();
            LinkedList<Integer> dimensions = new LinkedList<Integer>();
            if (uslot.isStereotypeApplied(this.sysmlutil.getMultidimensionalElement()) && uslot.getValue(this.sysmlutil.getMultidimensionalElement(), "dimension") instanceof List) {
                dims = (List)uslot.getValue(this.sysmlutil.getMultidimensionalElement(), "dimension");
                for (i = 0; i < dims.size(); ++i) {
                    int cumul = (Integer)dims.get(i);
                    for (j = i + 1; j < dims.size(); ++j) {
                        cumul *= ((Integer)dims.get(j)).intValue();
                    }
                    dimensions.add(cumul);
                }
            } else if (uslot.getDefiningFeature().isStereotypeApplied(this.sysmlutil.getMultidimensionalElement()) && uslot.getDefiningFeature().getValue(this.sysmlutil.getMultidimensionalElement(), "dimension") instanceof List) {
                dims = (List)uslot.getDefiningFeature().getValue(this.sysmlutil.getMultidimensionalElement(), "dimension");
                for (i = 0; i < dims.size(); ++i) {
                    int cumul2 = (Integer)dims.get(i);
                    for (j = i + 1; j < dims.size(); ++j) {
                        cumul2 *= ((Integer)dims.get(j)).intValue();
                    }
                    dimensions.add(cumul2);
                }
            } else {
                dimensions.add(uslot.getValues().size());
            }
            for (i = 0; i < uslot.getValues().size(); ++i) {
                int dim;
                boolean bcom = true;
                Iterator cumul2 = dimensions.iterator();
                while (cumul2.hasNext()) {
                    dim = (Integer)cumul2.next();
                    if (i % dim != 0) continue;
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append("{");
                    bcom = false;
                }
                if (bcom) {
                    sb.append(",");
                }
                sb.append(this.getValue((ValueSpecification)uslot.getValues().get(i)).serialize());
                cumul2 = dimensions.iterator();
                while (cumul2.hasNext()) {
                    dim = (Integer)cumul2.next();
                    if ((i + 1) % dim != 0) continue;
                    sb.append("}");
                }
            }
            MExpressionValue mexv = ModelicaFactory.eINSTANCE.createMExpressionValue();
            mexv.setValue(sb.toString());
            MModification mmod1 = ModelicaFactory.eINSTANCE.createMModification();
            if (!uslot.getDefiningFeature().isStereotypeApplied(this.sysmlutil.getModelicaParameter())) {
                mmod1.getComponentPath().add(mcomponent.getComponentByName("start"));
            }
            mmod1.setAssignedValue(mexv);
            ret.add(mmod1);
            MBooleanValue mbv = ModelicaFactory.eINSTANCE.createMBooleanValue();
            mbv.setValue(true);
            MModification mModification = ModelicaFactory.eINSTANCE.createMModification();
            mModification.getComponentPath().add(mcomponent.getComponentByName("fixed"));
            mModification.setAssignedValue(mbv);
            ret.add(mModification);
        }
        return ret;
    }

    private List<MModification> getModificationsFromValueType(DataType udatatype) {
        LinkedList<MModification> modifs = new LinkedList<MModification>();
        if (udatatype.isStereotypeApplied(this.sysmlutil.getValueType())) {
            MType primitive = null;
            for (Classifier parent : udatatype.allParents()) {
                if (parent != this.sysmlutil.getUMLString() && parent != this.sysmlutil.getUMLBoolean() && parent != this.sysmlutil.getUMLDouble() && parent != this.sysmlutil.getUMLInteger() && parent != this.sysmlutil.getSysMLString() && parent != this.sysmlutil.getSysMLBoolean() && parent != this.sysmlutil.getSysMLInteger() && parent != this.sysmlutil.getSysMLDouble()) continue;
                primitive = (MType)this.refs.get(SysMLToModelicaTranslator.getKey(parent));
            }
            if (primitive != null) {
                MModification modif;
                InstanceSpecification unit = (InstanceSpecification)udatatype.getValue(this.sysmlutil.getValueType(), "unit");
                String usymbol = null;
                String uname = null;
                if (unit != null) {
                    for (Slot unitslot : unit.getSlots()) {
                        if (unitslot.getDefiningFeature() == null) continue;
                        if (unitslot.getDefiningFeature().getName().equals("symbol")) {
                            for (ValueSpecification symbol : unitslot.getValues()) {
                                usymbol = symbol.stringValue();
                            }
                        }
                        if (!unitslot.getDefiningFeature().getName().equals("quantityKind")) continue;
                        for (ValueSpecification quantitykind : unitslot.getValues()) {
                            if (!(quantitykind instanceof InstanceValue)) continue;
                            for (Slot quantitykindslot : ((InstanceValue)quantitykind).getInstance().getSlots()) {
                                if (!quantitykindslot.getDefiningFeature().getName().equals("name")) continue;
                                for (ValueSpecification name : quantitykindslot.getValues()) {
                                    uname = name.stringValue();
                                }
                            }
                        }
                    }
                } else {
                    log.error("The value type " + SysMLToModelicaTranslator.print(udatatype) + " must have a unit: ");
                }
                if (usymbol != null) {
                    modif = ModelicaFactory.eINSTANCE.createMModification();
                    modif.getComponentPath().add(primitive.getComponentByName("unit"));
                    MStringValue svunit = ModelicaFactory.eINSTANCE.createMStringValue();
                    svunit.setValue(usymbol);
                    modif.setAssignedValue(svunit);
                    modifs.add(modif);
                }
                if (uname != null) {
                    modif = ModelicaFactory.eINSTANCE.createMModification();
                    modif.getComponentPath().add(primitive.getComponentByName("quantity"));
                    MStringValue svquantity = ModelicaFactory.eINSTANCE.createMStringValue();
                    svquantity.setValue(uname);
                    modif.setAssignedValue(svquantity);
                    modifs.add(modif);
                }
            } else {
                log.warn("The type " + SysMLToModelicaTranslator.print(udatatype) + " has a ValueType stereotype, but can't retrieve a primitive (type) ancestor");
            }
        }
        return modifs;
    }

    private MDataValue getValue(ValueSpecification vs) throws UMLModelErrorException {
        String val;
        if (vs instanceof LiteralString) {
            MStringValue mstringvalue = ModelicaFactory.eINSTANCE.createMStringValue();
            mstringvalue.setValue(vs.stringValue());
            return mstringvalue;
        }
        if (vs instanceof LiteralBoolean) {
            MBooleanValue mbooleanvalue = ModelicaFactory.eINSTANCE.createMBooleanValue();
            mbooleanvalue.setValue(vs.booleanValue());
            return mbooleanvalue;
        }
        if (vs instanceof LiteralInteger) {
            MIntegerValue mintegervalue = ModelicaFactory.eINSTANCE.createMIntegerValue();
            mintegervalue.setValue(vs.integerValue());
            return mintegervalue;
        }
        if (vs instanceof LiteralReal) {
            MRealValue mrealvalue = ModelicaFactory.eINSTANCE.createMRealValue();
            mrealvalue.setValue(vs.realValue());
            return mrealvalue;
        }
        if (vs instanceof OpaqueExpression && (val = this.getEquation(vs)) != null) {
            MExpressionValue mexpressionvalue = ModelicaFactory.eINSTANCE.createMExpressionValue();
            mexpressionvalue.setValue(val);
            return mexpressionvalue;
        }
        return null;
    }

    public static String replace(String original, String pattern, HashMap<String, String> replacements) {
        if (original == null || replacements == null) {
            return original;
        }
        Pattern pat = Pattern.compile(pattern);
        Matcher mat = pat.matcher(original);
        StringBuffer sb = new StringBuffer(original.length());
        while (mat.find()) {
            mat.appendReplacement(sb, "");
            String rep = replacements.get(mat.group());
            sb.append(rep == null ? mat.group() : rep);
        }
        mat.appendTail(sb);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TranslatedType {
        NONE,
        MODEL,
        CONNECTOR,
        TYPE,
        STATEMACHINE,
        STATE,
        COMPONENT,
        INTERFACE;

    }
}

