/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.translation.modelica;

import com.engisis.sysphs.generation.modelica.ModelicaBaseListener;
import com.engisis.sysphs.generation.modelica.ModelicaParser;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelicaExpressionExtractor
extends ModelicaBaseListener {
    private static final Logger log = Logger.getLogger(ModelicaExpressionExtractor.class);
    private ParseTreeProperty<String> ptp = new ParseTreeProperty();
    private Hashtable<List<String>, String> parameters;
    private ParseTreeProperty<Object> values = new ParseTreeProperty();
    private List<String> lbind;
    private List<String> rbind;
    private Hashtable<String, String> substitutions;
    private Hashtable<String, String> stateactions;

    public List<String> getLBinding() {
        return this.lbind;
    }

    public List<String> getRBinding() {
        return this.rbind;
    }

    public Hashtable<List<String>, String> getParameters() {
        return this.parameters;
    }

    public void setStateActions(Hashtable<String, String> stateactions) {
        this.stateactions = stateactions;
    }

    public void setSubstitutions(Hashtable<String, String> substitutions) {
        this.substitutions = substitutions;
    }

    public String getValue(ParseTree pt) {
        String v = this.ptp.get(pt);
        if (v == null) {
            log.error("The value of " + pt.getClass() + " is null");
        }
        return v;
    }

    public void setValue(ParseTree pt, String str) {
        this.ptp.put(pt, str);
    }

    public void prepareForConstraint() {
        this.parameters = new Hashtable();
    }

    @Override
    public void enterEquation(ModelicaParser.EquationContext ctx) {
        super.enterEquation(ctx);
    }

    @Override
    public void exitEquation(ModelicaParser.EquationContext ctx) {
        this.processStraight(ctx);
        this.lbind = null;
        this.rbind = null;
        if (ctx.simple_expression() == null || ctx.expression() == null) {
            return;
        }
        Object lb = this.values.get(ctx.simple_expression());
        Object rb = this.values.get(ctx.expression());
        if (lb instanceof List && rb instanceof List) {
            this.lbind = (List)lb;
            this.rbind = (List)rb;
        }
    }

    @Override
    public void exitStatement(ModelicaParser.StatementContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitIf_equation(ModelicaParser.If_equationContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree pt = ctx.getChild(i);
            if (pt instanceof TerminalNode) {
                int t = ((TerminalNode)pt).getSymbol().getType();
                if (t == 31) {
                    sb.append("if");
                    continue;
                }
                if (t == 58) {
                    sb.append("then\n");
                    continue;
                }
                if (t == 17) {
                    sb.append("elseif");
                    continue;
                }
                if (t == 16) {
                    sb.append("else\n");
                    continue;
                }
                if (t != 19) continue;
                sb.append("end ");
                continue;
            }
            if (pt instanceof ModelicaParser.ExpressionContext) {
                sb.append(" " + this.getValue(pt) + " ");
                continue;
            }
            if (!(pt instanceof ModelicaParser.EquationContext)) continue;
            sb.append(this.getValue(pt) + ";\n");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitIf_statement(ModelicaParser.If_statementContext ctx) {
        StringBuilder sb = new StringBuilder();
        String currentstate = null;
        StringBuilder sb2 = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree pt = ctx.getChild(i);
            if (pt instanceof TerminalNode) {
                int t = ((TerminalNode)pt).getSymbol().getType();
                if (t == 31) {
                    sb.append("if");
                    continue;
                }
                if (t == 58) {
                    sb.append("then\n");
                    continue;
                }
                if (t == 17) {
                    if (currentstate != null) {
                        this.stateactions.put(currentstate, sb2.toString());
                        sb2.setLength(0);
                    }
                    currentstate = null;
                    sb.append("elseif");
                    continue;
                }
                if (t == 16) {
                    if (currentstate != null) {
                        this.stateactions.put(currentstate, sb2.toString());
                        sb2.setLength(0);
                    }
                    currentstate = null;
                    sb.append("else\n");
                    continue;
                }
                if (t != 19) continue;
                if (currentstate != null) {
                    this.stateactions.put(currentstate, sb2.toString());
                    sb2.setLength(0);
                }
                currentstate = null;
                sb.append("end ");
                continue;
            }
            if (pt instanceof ModelicaParser.ExpressionContext) {
                String act;
                String v = this.getValue(pt);
                if (v.endsWith(act = ".active")) {
                    currentstate = v.substring(0, v.length() - act.length());
                }
                sb.append(" " + v + " ");
                continue;
            }
            if (!(pt instanceof ModelicaParser.StatementContext)) continue;
            if (currentstate != null) {
                sb2.append(this.getValue(pt) + ";");
            }
            sb.append(this.getValue(pt) + ";\n");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitFor_statement(ModelicaParser.For_statementContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append("for " + this.getValue(ctx.for_indices()) + " loop\n");
        for (ModelicaParser.StatementContext sc : ctx.statement()) {
            sb.append(this.getValue(sc) + ";\n");
        }
        sb.append("end for");
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitFor_indices(ModelicaParser.For_indicesContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitFor_index(ModelicaParser.For_indexContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitWhile_statement(ModelicaParser.While_statementContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append("while " + this.getValue(ctx.expression()) + " loop");
        for (ModelicaParser.StatementContext sc : ctx.statement()) {
            sb.append(this.getValue(sc) + ";\n");
        }
        sb.append("end while");
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitExpression(ModelicaParser.ExpressionContext ctx) {
        this.processWithSpaces(ctx);
        if (ctx.simple_expression() != null) {
            this.values.put(ctx, this.values.get(ctx.simple_expression()));
        }
    }

    @Override
    public void exitSimple_expression(ModelicaParser.Simple_expressionContext ctx) {
        this.processStraight(ctx);
        if (ctx.logical_expression().size() == 1) {
            this.values.put(ctx, this.values.get(ctx.logical_expression(0)));
        }
    }

    @Override
    public void exitLogical_expression(ModelicaParser.Logical_expressionContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (ModelicaParser.Logical_termContext ltc : ctx.logical_term()) {
            if (ltc != ctx.logical_term(0)) {
                sb.append(" " + this.getValue(ctx.OR(0)) + " ");
            }
            sb.append(this.getValue(ltc));
        }
        this.setValue(ctx, sb.toString());
        if (ctx.logical_term().size() == 1) {
            this.values.put(ctx, this.values.get(ctx.logical_term(0)));
        }
    }

    @Override
    public void exitLogical_term(ModelicaParser.Logical_termContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (ModelicaParser.Logical_factorContext lfc : ctx.logical_factor()) {
            if (lfc != ctx.logical_factor(0)) {
                sb.append(" " + this.getValue(ctx.AND(0)) + " ");
            }
            sb.append(this.getValue(lfc));
        }
        this.setValue(ctx, sb.toString());
        if (ctx.logical_factor().size() == 1) {
            this.values.put(ctx, this.values.get(ctx.logical_factor(0)));
        }
    }

    @Override
    public void exitLogical_factor(ModelicaParser.Logical_factorContext ctx) {
        StringBuilder sb = new StringBuilder();
        if (ctx.NOT() != null) {
            sb.append(this.getValue(ctx.NOT()) + " ");
        }
        sb.append(this.getValue(ctx.relation()));
        this.setValue(ctx, sb.toString());
        this.values.put(ctx, this.values.get(ctx.relation()));
    }

    @Override
    public void exitRelation(ModelicaParser.RelationContext ctx) {
        this.processStraight(ctx);
        if (ctx.arithmetic_expression().size() == 1) {
            this.values.put(ctx, this.values.get(ctx.arithmetic_expression(0)));
        }
    }

    @Override
    public void exitRel_op(ModelicaParser.Rel_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitArithmetic_expression(ModelicaParser.Arithmetic_expressionContext ctx) {
        this.processStraight(ctx);
        if (ctx.term().size() == 1 && ctx.add_op().size() == 0) {
            this.values.put(ctx, this.values.get(ctx.term(0)));
        }
    }

    @Override
    public void exitAdd_op(ModelicaParser.Add_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitTerm(ModelicaParser.TermContext ctx) {
        this.processStraight(ctx);
        if (ctx.factor().size() == 1) {
            this.values.put(ctx, this.values.get(ctx.factor(0)));
        }
    }

    @Override
    public void exitMul_op(ModelicaParser.Mul_opContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitFactor(ModelicaParser.FactorContext ctx) {
        this.processStraight(ctx);
        this.values.put(ctx, this.values.get(ctx.primary(0)));
    }

    @Override
    public void exitPrimary(ModelicaParser.PrimaryContext ctx) {
        StringBuilder sb = new StringBuilder();
        if (ctx.UNSIGNED_NUMBER() != null) {
            sb.append(ctx.getText());
        } else if (ctx.STRING() != null) {
            sb.append(ctx.STRING());
        } else if (ctx.TRUE() != null) {
            sb.append("true");
        } else if (ctx.FALSE() != null) {
            sb.append("false");
        } else if (ctx.function_call_args() != null) {
            if (ctx.name_path() != null) {
                sb.append(this.getValue(ctx.name_path()));
            } else if (ctx.DER() != null) {
                sb.append("der");
            }
            sb.append(this.getValue(ctx.function_call_args()));
        } else if (ctx.component_reference() != null) {
            sb.append(this.getValue(ctx.component_reference()));
            this.values.put(ctx, this.values.get(ctx.component_reference()));
        } else if (ctx.output_expression_list() != null) {
            sb.append("(" + this.getValue(ctx.output_expression_list()) + ")");
        } else if (ctx.expression_list().size() != 0) {
            sb.append("[");
            for (ModelicaParser.Expression_listContext elc : ctx.expression_list()) {
                if (elc != ctx.expression_list(0)) {
                    sb.append(";");
                }
                sb.append(this.getValue(elc));
            }
            sb.append("]");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitFunction_call_args(ModelicaParser.Function_call_argsContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitName_path(ModelicaParser.Name_pathContext ctx) {
        this.processStraight(ctx);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exitComponent_reference(ModelicaParser.Component_referenceContext ctx) {
        String sub;
        String text = ctx.getText();
        if (text.equals("time")) {
            this.setValue(ctx, "time");
            return;
        }
        if (this.substitutions != null && (sub = this.substitutions.get(text)) != null) {
            this.setValue(ctx, sub);
            return;
        }
        ArrayList<String> ls = new ArrayList<String>(ctx.IDENT().size());
        for (int i = 0; i < ctx.IDENT().size(); ++i) {
            String v = this.getValue(ctx.IDENT(i));
            ls.add(v);
        }
        this.values.put(ctx, ls);
        if (this.parameters == null) {
            this.processStraight(ctx);
        } else {
            List k = null;
            block1: for (List list : this.parameters.keySet()) {
                if (list.size() != ls.size()) continue;
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equals(ls.get(i))) continue block1;
                }
                k = list;
                break;
            }
            if (k != null) {
                this.setValue(ctx, this.parameters.get(k));
            } else {
                void var6_9;
                StringBuilder sb = new StringBuilder();
                boolean bl = false;
                while (var6_9 < ls.size()) {
                    if (var6_9 != false) {
                        sb.append("__");
                    }
                    sb.append((String)ls.get((int)var6_9));
                    ++var6_9;
                }
                String string = sb.toString();
                this.parameters.put(ls, string);
                this.setValue(ctx, string);
            }
        }
    }

    @Override
    public void exitFunction_arguments(ModelicaParser.Function_argumentsContext ctx) {
        StringBuilder sb = new StringBuilder();
        if (ctx.named_arguments() != null) {
            sb.append(this.getValue(ctx.named_arguments()));
        } else {
            sb.append(this.getValue(ctx.function_argument()));
            if (ctx.function_arguments() != null) {
                sb.append("," + this.getValue(ctx.function_arguments()));
            }
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitNamed_arguments(ModelicaParser.Named_argumentsContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitNamed_argument(ModelicaParser.Named_argumentContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitFunction_argument(ModelicaParser.Function_argumentContext ctx) {
        StringBuilder sb = new StringBuilder();
        if (ctx.expression() != null) {
            sb.append(this.getValue(ctx.expression()));
        } else {
            sb.append("function " + this.getValue(ctx.IDENT()) + "(");
            sb.append(this.getValue(ctx.named_arguments()));
            sb.append(")");
        }
        this.setValue(ctx, sb.toString());
    }

    @Override
    public void exitOutput_expression_list(ModelicaParser.Output_expression_listContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitExpression_list(ModelicaParser.Expression_listContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitArray_subscripts(ModelicaParser.Array_subscriptsContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void exitSubscript(ModelicaParser.SubscriptContext ctx) {
        this.processStraight(ctx);
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        this.setValue(node, node.getText());
    }

    protected void processStraight(ParseTree ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            String v = this.getValue(ctx.getChild(i));
            if (v == null) continue;
            sb.append(v);
        }
        String ret = sb.toString();
        this.setValue(ctx, ret);
    }

    protected void processWithSpaces(ParseTree ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            String v;
            if (i != 0) {
                sb.append(" ");
            }
            if ((v = this.getValue(ctx.getChild(i))) == null) continue;
            sb.append(v);
        }
        String ret = sb.toString();
        this.setValue(ctx, ret);
    }
}

