/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.simulink;

import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SConnectionPoint;
import com.engisis.sysphs.language.simulink.SDataValue;
import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.simulink.SFInputVariable;
import com.engisis.sysphs.language.simulink.SFOutputVariable;
import com.engisis.sysphs.language.simulink.SFunction1Block;
import com.engisis.sysphs.language.simulink.SFunction2Block;
import com.engisis.sysphs.language.simulink.SInport;
import com.engisis.sysphs.language.simulink.SInterface;
import com.engisis.sysphs.language.simulink.SLibrary;
import com.engisis.sysphs.language.simulink.SLine;
import com.engisis.sysphs.language.simulink.SModel;
import com.engisis.sysphs.language.simulink.SOutport;
import com.engisis.sysphs.language.simulink.SReference;
import com.engisis.sysphs.language.simulink.SSubsystem;
import com.engisis.sysphs.language.simulink.SSystem;
import com.engisis.sysphs.language.simulink.SSystemParameter;
import com.engisis.sysphs.language.simulink.SSystemParameterAssignment;
import com.engisis.sysphs.util.TextWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class SimulinkMDLWriter
extends TextWriter {
    protected SimulinkMDLWriter(Writer w) {
        super(w);
    }

    public void positionBlock(SBlock sblock) throws IOException {
        if (sblock.getOwningSystem() != null) {
            int pos = sblock.getOwningSystem().getOwnedBlocks().indexOf(sblock);
            int w = 20;
            int h = 20;
            int m = 20;
            int x1 = m + m * pos + pos * w;
            int x2 = x1 + w;
            int y1 = m;
            int y2 = y1 + h;
            String position = "[" + x1 + "," + y1 + "," + x2 + "," + y2 + "]";
            this.append("Position " + position, 3);
        }
    }

    public void introBlock() throws IOException {
        this.append("Block", 3);
        this.append("{", 3);
        this.indent();
    }

    public void defaultBlock(SBlock sblock) throws IOException {
        if (sblock.getName() != null && !sblock.getName().isEmpty()) {
            this.append("Name \"" + sblock.getName() + "\"", 3);
        }
        if (sblock.getSID() != null && !sblock.getSID().isEmpty()) {
            this.append("SID \"" + sblock.getSID() + "\"", 3);
        }
    }

    public void outroBlock() throws IOException {
        this.unindent();
        this.append("}", 3);
    }

    public void visit(SExpressionValue object) throws IOException {
        this.append(object.getValue());
    }

    public void visit(SFunction1Block object) throws IOException {
        this.introBlock();
        this.append("BlockType S-Function", 3);
        this.defaultBlock(object);
        if (object.getSfunction() != null && object.getSfunction().getName() != null && !object.getSfunction().getName().isEmpty()) {
            this.append("FunctionName \"" + object.getSfunction().getName() + "\"", 3);
        }
        if (object.getSfunction().getOwnedBlocks().size() == 0) {
            this.append("Ports [1,1]", 3);
        } else {
            int i = 0;
            int o = 0;
            for (SBlock sbl : object.getSfunction().getOwnedBlocks()) {
                if (sbl instanceof SInport) {
                    ++i;
                    continue;
                }
                if (!(sbl instanceof SOutport)) continue;
                ++o;
            }
            this.append("Ports [" + i + "," + o + "]", 3);
        }
        this.positionBlock(object);
        this.outroBlock();
    }

    public void visit(SFunction2Block object) throws IOException {
        this.introBlock();
        this.append("BlockType M-S-Function", 3);
        this.defaultBlock(object);
        if (object.getSfunction() != null && object.getSfunction().getName() != null && !object.getSfunction().getName().isEmpty()) {
            this.append("FunctionName \"" + object.getSfunction().getName() + "\"", 3);
        }
        this.append("Ports [" + object.getSfunction().getInputs().size() + "," + object.getSfunction().getOutputs().size() + "]", 3);
        this.positionBlock(object);
        this.outroBlock();
    }

    public void visit(SInport object) throws IOException {
        this.introBlock();
        this.append("BlockType Inport", 3);
        this.defaultBlock(object);
        this.positionBlock(object);
        String unit = object.getUnit();
        if (unit != null) {
            this.append("Unit \"" + unit + "\"");
        }
        this.outroBlock();
    }

    public void visit(SInterface object) throws IOException {
        this.introBlock();
        SSystem ssystem = object.getSystem();
        if (ssystem != null) {
            this.append("BlockType " + ssystem.getName(), 3);
            this.defaultBlock(object);
            this.append("Ports [" + ssystem.getInports().size() + "," + ssystem.getOutports().size() + "]", 3);
            this.positionBlock(object);
            for (SSystemParameter sparameter : object.getSystem().getSystemparameters()) {
                SDataValue val = sparameter.getValue();
                for (SSystemParameterAssignment sassignment : object.getAssignments()) {
                    if (sassignment.getParameter() != sparameter) continue;
                    val = sassignment.getValue();
                }
                if (val == null) continue;
                this.append(sparameter.getName() + " \"", 1);
                val.accept(this.getDispatcher());
                this.append("\"", 2);
            }
        }
        this.outroBlock();
    }

    public void visit(SLibrary object) throws IOException {
        this.append("Library", 3);
        this.append("{", 3);
        this.indent();
        if (object.getName() != null && !object.getName().isEmpty()) {
            this.append("Name \"" + object.getName() + "\"", 3);
        }
        this.append("Version 8.2", 3);
        this.append("MdlSubVersion 0", 3);
        if (object.getSystem() != null) {
            object.getSystem().accept(this.getDispatcher());
        }
        this.unindent();
        this.append("}", 3);
    }

    public void visit(SLine object) throws IOException {
        this.append("Line", 3);
        this.append("{", 3);
        this.indent();
        SBlock sbsrcblock = object.getSource().getBlock();
        SBlock sbsrcport = object.getSource().getPort();
        this.append("SrcBlock \"" + sbsrcblock.getName() + "\"", 3);
        int srcport = 0;
        if (sbsrcport == null) {
            srcport = 1;
        } else if (sbsrcport instanceof SInport) {
            srcport = sbsrcport.getOwningSystem().getInports().indexOf(sbsrcport) + 1;
        } else if (sbsrcport instanceof SOutport) {
            srcport = sbsrcport.getOwningSystem().getOutports().indexOf(sbsrcport) + 1;
        }
        this.append("SrcPort " + srcport, 3);
        for (SConnectionPoint sdestination : object.getDestinations()) {
            SBlock sbdstblock = sdestination.getBlock();
            SBlock sbdstport = sdestination.getPort();
            String dstblock = sbdstblock.getName();
            int dstport = 0;
            if (sbdstport == null) {
                dstport = 1;
            } else if (sbdstport instanceof SInport) {
                dstport = sbdstport.getOwningSystem().getInports().indexOf(sbdstport) + 1;
            } else if (sbdstport instanceof SOutport) {
                dstport = sbdstport.getOwningSystem().getOutports().indexOf(sbdstport) + 1;
            }
            if (object.getDestinations().size() > 1) {
                this.append("Branch", 3);
                this.append("{", 3);
                this.indent();
                this.append("DstBlock \"" + dstblock + "\"", 3);
                this.append("DstPort " + dstport, 3);
                this.unindent();
                this.append("}", 3);
                continue;
            }
            this.append("DstBlock \"" + dstblock + "\"", 3);
            this.append("DstPort " + dstport, 3);
        }
        this.unindent();
        this.append("}", 3);
    }

    public void visit(SModel object) throws IOException {
        this.append("Model", 3);
        this.append("{", 3);
        this.indent();
        if (object.getName() != null && !object.getName().isEmpty()) {
            this.append("Name \"" + object.getName() + "\"", 3);
        }
        this.append("Version 8.2", 3);
        this.append("MdlSubVersion 0", 3);
        if (object.getSystem() != null) {
            object.getSystem().accept(this.getDispatcher());
        }
        this.append("}", 3);
    }

    public void visit(SOutport object) throws IOException {
        this.introBlock();
        this.append("BlockType Outport", 3);
        this.defaultBlock(object);
        this.positionBlock(object);
        String unit = object.getUnit();
        if (unit != null) {
            this.append("Unit \"" + unit + "\"");
        }
        this.outroBlock();
    }

    public void visit(SDoubleValue object) throws IOException {
        this.append(String.valueOf(object.getValue()));
    }

    public void visit(SReference object) throws IOException {
        this.introBlock();
        this.append("BlockType Reference", 3);
        this.defaultBlock(object);
        if (object.getSystem() != null) {
            this.append("Ports [" + object.getSystem().getInports().size() + "," + object.getSystem().getOutports().size() + "]", 3);
            this.append("SourceBlock \"" + object.getSystem().getPath() + "\"", 3);
            this.append("SourceType \"SubSystem\"", 3);
        }
        this.positionBlock(object);
        this.outroBlock();
    }

    public void visit(SSubsystem object) throws IOException {
        this.introBlock();
        this.append("BlockType SubSystem", 3);
        this.defaultBlock(object);
        if (object.getSystem() != null) {
            this.append("Ports [" + object.getSystem().getInports().size() + "," + object.getSystem().getOutports().size() + "]", 3);
            object.getSystem().accept(this.getDispatcher());
        }
        this.positionBlock(object);
        this.outroBlock();
    }

    public void visit(SSystem object) throws IOException {
        this.append("System", 3);
        this.append("{", 3);
        this.indent();
        this.printSystem(object);
        this.unindent();
        this.append("}", 3);
    }

    protected void printSystem(SSystem ssystem) throws IOException {
        if (ssystem.getName() != null && !ssystem.getName().isEmpty()) {
            this.append("Name \"" + ssystem.getName() + "\"", 3);
        }
        for (SBlock sblock : ssystem.getOwnedBlocks()) {
            sblock.accept(this.getDispatcher());
        }
        for (SLine sline : ssystem.getOwnedLines()) {
            sline.accept(this.getDispatcher());
        }
        for (SBlock sblock : ssystem.getOwnedBlocks()) {
            this.printSystemCode(sblock);
        }
    }

    protected void printSystemCode(SBlock sblock) throws IOException {
        if (sblock instanceof SFunction2Block) {
            int i;
            SFunction2Block sf2block = (SFunction2Block)sblock;
            List<SFInputVariable> inputs = sf2block.getSfunction().getInputs();
            List<SFOutputVariable> outputs = sf2block.getSfunction().getOutputs();
            if (inputs != null) {
                for (i = 0; i < inputs.size(); ++i) {
                    SFInputVariable sinputvariable = inputs.get(i);
                    SInport sinport = sinputvariable.getInport();
                    if (sinport == null) continue;
                    this.append("Line", 3);
                    this.append("{", 3);
                    this.append("SrcBlock \"" + sinport.getName() + "\"", 3);
                    this.append("SrcPort 1", 3);
                    this.append("DstBlock \"" + sf2block.getName() + "\"", 3);
                    this.append("DstPort " + (i + 1), 3);
                    this.append("}", 3);
                }
            }
            if (outputs != null) {
                for (i = 0; i < outputs.size(); ++i) {
                    SFOutputVariable soutputvariable = outputs.get(i);
                    SOutport soutport = soutputvariable.getOutport();
                    if (soutport == null) continue;
                    this.append("Line", 3);
                    this.append("{", 3);
                    this.append("SrcBlock \"" + sf2block.getName() + "\"", 3);
                    this.append("SrcPort " + (i + 1), 3);
                    this.append("DstBlock \"" + soutport.getName() + "\"", 3);
                    this.append("DstPort 1", 3);
                    this.append("}", 3);
                }
            }
        }
    }
}

