/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.deserialization.simulink.SimulinkFile;
import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SComponentReference;
import com.engisis.sysphs.language.simscape.SDomain;
import com.engisis.sysphs.language.simscape.SNode;
import com.engisis.sysphs.language.simscape.SPhysicalBlock;
import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SFunction1;
import com.engisis.sysphs.language.simulink.SFunction1Block;
import com.engisis.sysphs.language.simulink.SFunction2;
import com.engisis.sysphs.language.simulink.SFunction2Block;
import com.engisis.sysphs.language.simulink.SModel;
import com.engisis.sysphs.language.simulink.SReference;
import com.engisis.sysphs.language.simulink.SSubsystem;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulinkReference {
    private static final Logger log = Logger.getLogger(SimulinkReference.class);
    private String ref;
    private ReferenceType type;
    private SElement selement;

    public SimulinkReference(SElement selement, String ref, ReferenceType type) {
        this.selement = selement;
        this.ref = ref;
        this.type = type;
    }

    public String getLocation() {
        switch (this.type) {
            case BLOCK: {
                return this.ref.split("/")[0];
            }
            case SF1: {
                return this.ref;
            }
            case SF2: {
                return this.ref;
            }
            case COMPONENT: {
                return "+" + this.ref;
            }
            case DOMAIN: {
                return "+" + this.ref;
            }
        }
        return null;
    }

    public ReferenceType getReferenceType() {
        return this.type;
    }

    public void resolve(Map<String, SimulinkFile> mapFiles) {
        SimulinkFile sf = mapFiles.get(this.getLocation());
        if (sf == null) {
            log.error("No file for location " + this.getLocation());
            return;
        }
        SElement root = sf.getRootElement();
        if (root instanceof SModel) {
            SBlock ref = ((SModel)root).getBlockByName(this.ref.split("/"));
            if (ref instanceof SSubsystem) {
                if (this.selement instanceof SReference) {
                    ((SReference)this.selement).setSystem(((SSubsystem)ref).getSystem());
                    log.info("Resolved reference " + this.selement + " to " + ((SSubsystem)ref).getSystem());
                } else {
                    log.error("Only a Reference block can refer to another block: " + this.selement);
                }
            } else {
                log.error("Block " + ref + " is expected to be a subsystem");
            }
        } else if (root instanceof SFunction1) {
            if (this.selement instanceof SFunction1Block) {
                ((SFunction1Block)this.selement).setSfunction((SFunction1)root);
                log.info("Resolved sfunction1 " + this.selement + " to " + root);
            } else {
                log.error("Only a SFunction block can refer to an SFunction: " + this.selement);
            }
        } else if (root instanceof SFunction2) {
            if (this.selement instanceof SFunction2Block) {
                ((SFunction2Block)this.selement).setSfunction((SFunction2)root);
                log.info("Resolved sfunction2 " + this.selement + " to " + root);
            } else {
                log.error("Only a SFunction block can refer to an SFunction: " + this.selement);
            }
        } else if (root instanceof SDomain) {
            if (this.selement instanceof SNode) {
                ((SNode)this.selement).setDomain((SDomain)root);
                log.info("Resolved component " + this.selement + " to " + root);
            } else {
                log.error("Only a Node can refer to a domain: " + this.selement);
            }
        } else if (root instanceof SComponent) {
            if (this.selement instanceof SComponent) {
                ((SComponent)this.selement).setBaseComponent((SComponent)root);
                log.info("Resolved component " + this.selement + " to " + root);
            } else if (this.selement instanceof SComponentReference) {
                ((SComponentReference)this.selement).setComponent((SComponent)root);
                log.info("Resolved component " + this.selement + " to " + root);
            } else if (this.selement instanceof SPhysicalBlock) {
                ((SPhysicalBlock)this.selement).setComponent((SComponent)root);
                log.info("Resolved component " + this.selement + " to " + root);
            } else {
                log.error("Only a Component, a component reference, or a physical block can refer to a Component: " + this.selement);
            }
        } else {
            log.error("Root not recognized: " + root);
        }
    }

    public SElement getElement() {
        return this.selement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReferenceType {
        BLOCK,
        SF1,
        SF2,
        COMPONENT,
        DOMAIN;

    }
}

