/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.simulink;

import com.engisis.sysphs.deserialization.simulink.Format;
import com.engisis.sysphs.deserialization.simulink.SimscapeReaderPass1;
import com.engisis.sysphs.deserialization.simulink.SimscapeReaderPass2;
import com.engisis.sysphs.deserialization.simulink.SimulinkFile;
import com.engisis.sysphs.deserialization.simulink.SimulinkMDLReader;
import com.engisis.sysphs.deserialization.simulink.SimulinkReader;
import com.engisis.sysphs.deserialization.simulink.SimulinkReference;
import com.engisis.sysphs.deserialization.simulink.SimulinkSF1Reader;
import com.engisis.sysphs.deserialization.simulink.SimulinkSF2Reader;
import com.engisis.sysphs.deserialization.simulink.SimulinkXMLReaderPass1;
import com.engisis.sysphs.deserialization.simulink.SimulinkXMLReaderPass2;
import com.engisis.sysphs.deserialization.simulink.StateflowMDLReader;
import com.engisis.sysphs.deserialization.simulink.StateflowXMLReaderPass1;
import com.engisis.sysphs.deserialization.simulink.StateflowXMLReaderPass2;
import com.engisis.sysphs.generation.simulink.MATLABLexer;
import com.engisis.sysphs.generation.simulink.MATLABParser;
import com.engisis.sysphs.generation.simulink.MDLLexer;
import com.engisis.sysphs.generation.simulink.MDLParser;
import com.engisis.sysphs.generation.simulink.SimscapeLexer;
import com.engisis.sysphs.generation.simulink.SimscapeParser;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SModel;
import com.engisis.sysphs.language.simulink.SNamedElement;
import com.engisis.sysphs.language.stateflow.SStateflow;
import com.engisis.sysphs.translation.simulink.SimulinkUtil;
import com.engisis.sysphs.util.ANTLRErrorListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulinkDeserializer {
    private static final Logger log = Logger.getLogger(SimulinkDeserializer.class);
    private Hashtable<String, SimulinkFile> mapFiles;
    private Queue<SimulinkReader> p1queue;
    private Queue<SimulinkReader> p2queue;
    private Set<SimulinkReader> processed;
    private SModel rootmodel;
    private List<SStateflow> lstateflow;
    private Stack<Closeable> toclose;
    private Hashtable<SElement, ParseTree> expressions;
    private File wd;

    public Hashtable<SElement, ParseTree> getExpressions() {
        return this.expressions;
    }

    public void deserialize(String filename) throws IOException {
        this.toclose = new Stack();
        this.rootmodel = null;
        this.lstateflow = new LinkedList<SStateflow>();
        this.mapFiles = new Hashtable();
        this.p1queue = new PriorityQueue<SimulinkReader>(new SimulinkReaderComparator());
        this.p2queue = new PriorityQueue<SimulinkReader>(new SimulinkReaderComparator());
        this.processed = new HashSet<SimulinkReader>();
        this.expressions = new Hashtable();
        File f = new File(filename);
        this.wd = f.getParentFile();
        SimulinkFile sf = new SimulinkFile(filename, Format.SIM);
        String shortname = f.getName().split("\\.")[0];
        this.mapFiles.put(shortname, sf);
        this.populateReaders(sf);
        SimulinkReader sr = null;
        while (!this.p1queue.isEmpty()) {
            sr = this.p1queue.poll();
            this.processed.add(sr);
            log.debug("Popped " + sr);
            if (sr.getReferences() != null) {
                for (SimulinkReference ref : sr.getReferences()) {
                    ref.resolve(this.mapFiles);
                }
            }
            sr.process();
            if (sr instanceof SimulinkXMLReaderPass1) {
                Iterator<SimulinkReference> smodel = ((SimulinkXMLReaderPass1)sr).getModel();
                SimulinkUtil.setName((SNamedElement)((Object)smodel), shortname);
                if (this.rootmodel == null) {
                    this.rootmodel = smodel;
                }
            } else if (sr instanceof StateflowXMLReaderPass1) {
                this.lstateflow.add(((StateflowXMLReaderPass1)sr).getStateflow());
            }
            if (sr.getReferences() == null) continue;
            block4: for (SimulinkReference ref : sr.getReferences()) {
                Object sf2;
                String fn;
                SimulinkReference.ReferenceType rt = ref.getReferenceType();
                if (rt == SimulinkReference.ReferenceType.BLOCK) {
                    SimulinkFile sf22;
                    String fn1 = this.wd.getAbsolutePath() + File.separator + ref.getLocation() + ".mdl";
                    String fn2 = this.wd.getAbsolutePath() + File.separator + ref.getLocation() + ".slx";
                    for (SimulinkFile sf23 : this.mapFiles.values()) {
                        if (!sf23.getFilename().equals(fn1) && !sf23.getFilename().equals(fn2)) continue;
                        continue block4;
                    }
                    File f1 = new File(fn1);
                    File f2 = new File(fn2);
                    if (f1.isFile() && f1.canRead()) {
                        log.info("Adding reference " + fn1);
                        sf22 = new SimulinkFile(fn1, Format.SIM);
                        this.mapFiles.put(ref.getLocation(), sf22);
                        this.populateReaders(sf22);
                        continue;
                    }
                    if (!f2.isFile() || !f2.canRead()) continue;
                    log.info("Adding reference " + (String)fn2);
                    sf22 = new SimulinkFile(fn2, Format.SIM);
                    this.mapFiles.put(ref.getLocation(), sf22);
                    this.populateReaders(sf22);
                    continue;
                }
                if (rt == SimulinkReference.ReferenceType.SF1 || rt == SimulinkReference.ReferenceType.SF2) {
                    fn = this.wd.getAbsolutePath() + File.separator + ref.getLocation() + ".m";
                    for (SimulinkFile sf24 : this.mapFiles.values()) {
                        if (!sf24.getFilename().equals(fn)) continue;
                        continue block4;
                    }
                    f = new File(fn);
                    if (!f.isFile() || !f.canRead()) continue;
                    log.info("Adding reference " + fn);
                    if (ref.getReferenceType() == SimulinkReference.ReferenceType.SF1) {
                        sf2 = new SimulinkFile(fn, Format.SF1);
                        this.mapFiles.put(ref.getLocation(), (SimulinkFile)sf2);
                        this.populateReaders((SimulinkFile)sf2);
                        continue;
                    }
                    sf2 = new SimulinkFile(fn, Format.SF2);
                    this.mapFiles.put(ref.getLocation(), (SimulinkFile)sf2);
                    this.populateReaders((SimulinkFile)sf2);
                    continue;
                }
                if (rt == SimulinkReference.ReferenceType.COMPONENT || rt == SimulinkReference.ReferenceType.DOMAIN) {
                    fn = this.wd.getAbsolutePath() + File.separator + ref.getLocation().replace('.', File.separatorChar) + ".ssc";
                    for (SimulinkFile sf24 : this.mapFiles.values()) {
                        if (!sf24.getFilename().equals(fn)) continue;
                        continue block4;
                    }
                    f = new File(fn);
                    if (f.isFile() && f.canRead()) {
                        log.info("Adding reference " + fn);
                        sf2 = new SimulinkFile(fn, Format.SSC);
                        this.mapFiles.put(ref.getLocation(), (SimulinkFile)sf2);
                        this.populateReaders((SimulinkFile)sf2);
                        continue;
                    }
                    log.error("Can't find " + f);
                    continue;
                }
                log.error("Untreated reference: " + f);
            }
        }
        for (SimulinkReader reader : this.processed) {
            if (reader.getReferences() == null) continue;
            for (SimulinkReference ref : reader.getReferences()) {
                ref.resolve(this.mapFiles);
            }
        }
        while (!this.p2queue.isEmpty()) {
            sr = this.p2queue.poll();
            sr.process();
        }
        while (this.toclose.size() != 0) {
            Closeable c = this.toclose.pop();
            try {
                c.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void populateReaders(SimulinkFile sf) throws IOException {
        String filename = sf.getFilename();
        Format format = sf.getFormat();
        if (format == Format.SIM) {
            log.info("Determining format of " + filename);
            File f = new File(filename);
            if (!f.canRead()) {
                throw new IOException("Can't read the file " + filename);
            }
            boolean slx = false;
            FileInputStream fis = new FileInputStream(f);
            byte[] zipbytes = new byte[4];
            fis.read(zipbytes);
            if (zipbytes[0] == 80 && zipbytes[1] == 75 && zipbytes[2] == 3 && zipbytes[3] == 4) {
                slx = true;
            }
            fis.close();
            if (slx) {
                log.info("XML format detected");
                ZipFile zf = new ZipFile(filename);
                ZipEntry ze = zf.getEntry("simulink/blockdiagram.xml");
                if (ze == null) {
                    zf.close();
                    throw new IOException("The given model does not contain simulink/blockdiagram.xml");
                }
                log.debug("Adding XML Simulink Definition reader to " + filename);
                SimulinkXMLReaderPass1 sxmlr = new SimulinkXMLReaderPass1(zf.getInputStream(ze));
                sf.getReaders().add(sxmlr);
                this.p1queue.add(sxmlr);
                log.debug("Adding XML Stateflow Definition reader to " + filename);
                StateflowXMLReaderPass1 sxmlr2 = new StateflowXMLReaderPass1(sxmlr, zf.getInputStream(ze));
                sf.getReaders().add(sxmlr2);
                this.p1queue.add(sxmlr2);
                log.debug("Adding XML Simulink Resolution reader to " + filename);
                SimulinkXMLReaderPass2 sxmlr3 = new SimulinkXMLReaderPass2(sxmlr, zf.getInputStream(ze));
                sf.getReaders().add(sxmlr3);
                this.p2queue.add(sxmlr3);
                log.debug("Adding XML Stateflow Resolution reader to " + filename);
                StateflowXMLReaderPass2 sxmlr4 = new StateflowXMLReaderPass2(sxmlr2, zf.getInputStream(ze));
                sf.getReaders().add(sxmlr4);
                this.p2queue.add(sxmlr4);
                this.toclose.push(zf);
            } else {
                log.info("Text format detected");
                MDLLexer ml = new MDLLexer(new ANTLRFileStream(filename));
                CommonTokenStream cts = new CommonTokenStream(ml);
                MDLParser mp = new MDLParser(cts);
                mp.addErrorListener(new ANTLRErrorListener(log));
                MDLParser.FileContext prc = mp.file();
                log.debug("Adding MDL Simulink Definition reader to " + filename);
                SimulinkMDLReader smdlr = new SimulinkMDLReader(prc);
                sf.getReaders().add(smdlr);
                this.p1queue.add(smdlr);
                log.debug("Adding MDL Stateflow Definition reader to " + filename);
                StateflowMDLReader smdlr2 = new StateflowMDLReader(prc);
                sf.getReaders().add(smdlr2);
                this.p1queue.add(smdlr2);
            }
        } else if (format == Format.SF1) {
            MATLABLexer ml = new MATLABLexer(new ANTLRFileStream(filename));
            CommonTokenStream cts = new CommonTokenStream(ml);
            MATLABParser mp = new MATLABParser(cts);
            mp.addErrorListener(new ANTLRErrorListener(log));
            MATLABParser.FileContext prc = mp.file();
            log.debug("Adding SF1 reader to " + filename);
            SimulinkSF1Reader sr = new SimulinkSF1Reader(prc);
            sf.getReaders().add(sr);
            this.p1queue.add(sr);
        } else if (format == Format.SF2) {
            MATLABLexer ml = new MATLABLexer(new ANTLRFileStream(filename));
            CommonTokenStream cts = new CommonTokenStream(ml);
            MATLABParser mp = new MATLABParser(cts);
            mp.addErrorListener(new ANTLRErrorListener(log));
            MATLABParser.FileContext prc = mp.file();
            log.debug("Adding SF2 reader to " + filename);
            SimulinkSF2Reader sr = new SimulinkSF2Reader(prc);
            sf.getReaders().add(sr);
            this.p1queue.add(sr);
        } else if (format == Format.SSC) {
            SimscapeLexer sl = new SimscapeLexer(new ANTLRFileStream(filename));
            CommonTokenStream cts = new CommonTokenStream(sl);
            SimscapeParser sp = new SimscapeParser(cts);
            sp.addErrorListener(new ANTLRErrorListener(log));
            SimscapeParser.FileContext prc = sp.file();
            log.debug("Adding Simscape Definition reader to " + filename);
            SimscapeReaderPass1 srd = new SimscapeReaderPass1(cts, prc);
            srd.setExpressions(this.expressions);
            sf.getReaders().add(srd);
            this.p1queue.add(srd);
            log.debug("Adding Simscape Resolution reader to " + filename);
            SimscapeReaderPass2 srr = new SimscapeReaderPass2(srd, prc);
            sf.getReaders().add(srr);
            this.p2queue.add(srr);
        } else {
            log.error("Can't find format of " + filename);
        }
    }

    public SModel getModel() {
        return this.rootmodel;
    }

    public List<SStateflow> getStateflow() {
        return Collections.unmodifiableList(this.lstateflow);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimulinkReaderComparator
    implements Comparator<SimulinkReader> {
        private SimulinkReaderComparator() {
        }

        @Override
        public int compare(SimulinkReader o1, SimulinkReader o2) {
            return o1.getPriority() - o2.getPriority();
        }
    }
}

