/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.deserialization.modelica;

import com.engisis.sysphs.deserialization.modelica.ModelicaReaderPass1;
import com.engisis.sysphs.deserialization.modelica.ModelicaScope;
import com.engisis.sysphs.generation.modelica.ModelicaBaseListener;
import com.engisis.sysphs.generation.modelica.ModelicaParser;
import com.engisis.sysphs.language.modelica.MClass;
import com.engisis.sysphs.language.modelica.MComponent;
import com.engisis.sysphs.language.modelica.MConnect;
import com.engisis.sysphs.language.modelica.MDataValue;
import com.engisis.sysphs.language.modelica.MExpressionValue;
import com.engisis.sysphs.language.modelica.MExtension;
import com.engisis.sysphs.language.modelica.MIntegerValue;
import com.engisis.sysphs.language.modelica.MModification;
import com.engisis.sysphs.language.modelica.MRealValue;
import com.engisis.sysphs.language.modelica.MStringValue;
import com.engisis.sysphs.language.modelica.ModelicaFactory;
import com.engisis.sysphs.translation.modelica.ModelicaUtil;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelicaReaderPass2
extends ModelicaBaseListener {
    private static final Logger log = Logger.getLogger(ModelicaReaderPass2.class);
    private ModelicaReaderPass1 mpd;
    private ParseTreeProperty<ModelicaScope> scopelist;
    private ModelicaScope scope;
    private ParseTreeProperty<Object> values;

    public ModelicaReaderPass2(ModelicaReaderPass1 mpd) {
        this.mpd = mpd;
        this.scopelist = mpd.getScopeList();
        this.values = new ParseTreeProperty();
    }

    @Override
    public void enterStored_definition(ModelicaParser.Stored_definitionContext ctx) {
        super.enterStored_definition(ctx);
        this.scope = this.scopelist.get(ctx);
    }

    @Override
    public void exitStored_definition(ModelicaParser.Stored_definitionContext ctx) {
        super.exitStored_definition(ctx);
        this.scope = this.scope.getParent();
    }

    @Override
    public void enterClass_definition(ModelicaParser.Class_definitionContext ctx) {
        super.enterClass_definition(ctx);
        this.scope = this.scopelist.get(ctx);
    }

    @Override
    public void exitClass_definition(ModelicaParser.Class_definitionContext ctx) {
        super.exitClass_definition(ctx);
        this.scope = this.scope.getParent();
    }

    @Override
    public void exitClass_specifier(ModelicaParser.Class_specifierContext ctx) {
        super.exitClass_specifier(ctx);
        ModelicaScope ms = this.scopelist.get(ctx);
        if (ms == null || !(ms.getMNamedElement() instanceof MClass)) {
            return;
        }
        MClass mclass = (MClass)ms.getMNamedElement();
        if (ctx.name_path() == null) {
            return;
        }
        MClass mclass2 = (MClass)ms.lookForClass(ctx.name_path().IDENT()).getMNamedElement();
        if (ctx.class_modification() == null || ctx.class_modification().argument_list() == null) {
            return;
        }
        for (ModelicaParser.ArgumentContext ac : ctx.class_modification().argument_list().argument()) {
            ModelicaParser.Simple_expressionContext sec;
            log.info("Extension modification for class " + this.scope.getMNamedElement().getName());
            MModification modif = ModelicaFactory.eINSTANCE.createMModification();
            ModelicaParser.Element_modificationContext emc = ac.element_modification_or_replaceable().element_modification();
            for (TerminalNode tn : emc.component_reference().IDENT()) {
                MComponent mc = mclass.getComponentByName(tn.getText());
                if (mc == null) {
                    modif.getComponentPath().clear();
                    break;
                }
                mclass = mc.getType();
                modif.getComponentPath().add(mc);
            }
            if (emc.modification() != null && emc.modification().class_modification() == null && (sec = emc.modification().expression().simple_expression()) != null) {
                Object o = this.values.get(sec);
                if (o instanceof List) {
                    modif.getAssignedReference().addAll((List)o);
                    log.info("Assigning reference " + modif.getComponentPath() + " = " + o);
                } else {
                    modif.setAssignedValue(this.getValueFromExpression(sec));
                    log.info("Assigning value " + modif.getComponentPath() + " = " + modif.getAssignedValue());
                }
            }
            if (modif.getComponentPath().size() > 0 && (modif.getAssignedValue() != null || modif.getAssignedReference().size() > 0)) {
                for (MExtension me : ((MClass)this.scope.getMNamedElement()).getExtensions()) {
                    if (me.getExtendedClass() != mclass2) continue;
                    me.getModifications().add(modif);
                }
                continue;
            }
            log.error("No modification was added");
        }
    }

    @Override
    public void enterComponent_declaration(ModelicaParser.Component_declarationContext ctx) {
        super.enterComponent_declaration(ctx);
        this.scope = this.scopelist.get(ctx);
    }

    @Override
    public void exitComponent_declaration(ModelicaParser.Component_declarationContext ctx) {
        super.exitComponent_declaration(ctx);
        this.scope = this.scope.getParent();
    }

    @Override
    public void exitDeclaration(ModelicaParser.DeclarationContext ctx) {
        super.exitDeclaration(ctx);
        ModelicaParser.ModificationContext modification = ctx.modification();
        if (modification != null && this.scope.getMNamedElement() instanceof MComponent) {
            MComponent mcomponent = (MComponent)this.scope.getMNamedElement();
            if (modification.expression() != null && modification.expression().simple_expression() != null) {
                mcomponent.setValue(this.getValueFromExpression(modification.expression().simple_expression()));
            } else if (modification.class_modification() != null && modification.class_modification().argument_list() != null) {
                block0: for (ModelicaParser.ArgumentContext ac : modification.class_modification().argument_list().argument()) {
                    ModelicaParser.Simple_expressionContext sec;
                    log.info("Component modification for component " + mcomponent.getName());
                    MComponent mc = mcomponent;
                    if (ac.element_modification_or_replaceable() == null || ac.element_modification_or_replaceable().element_modification() == null) continue;
                    MModification modif = ModelicaFactory.eINSTANCE.createMModification();
                    ModelicaParser.Element_modificationContext emc = ac.element_modification_or_replaceable().element_modification();
                    for (TerminalNode tn : emc.component_reference().IDENT()) {
                        MClass type = mc.getType();
                        if (type == null) {
                            log.error("The type of component " + mc.getName() + " in null");
                            continue block0;
                        }
                        mc = type.getComponentByName(tn.getText());
                        if (mc == null) {
                            log.error("Couldn't find component " + tn.getText() + " in class " + type.getName() + ", creating it");
                            mc = ModelicaFactory.eINSTANCE.createMComponent();
                            mc.setOwningClass(type);
                            ModelicaUtil.setName(mc, tn.getText());
                            continue block0;
                        }
                        modif.getComponentPath().add(mc);
                    }
                    if (emc.modification() != null && emc.modification().class_modification() == null && (sec = emc.modification().expression().simple_expression()) != null) {
                        Object o = this.values.get(sec);
                        if (o instanceof List) {
                            modif.getAssignedReference().addAll((List)o);
                            log.info("Assigning reference " + modif.getComponentPath() + " = " + o);
                        } else {
                            this.mpd.getExpressions().put(modif, sec);
                            modif.setAssignedValue(this.getValueFromExpression(sec));
                            log.info("Assigning value " + modif.getComponentPath() + " = " + modif.getAssignedValue());
                        }
                    }
                    if (modif.getAssignedValue() != null || modif.getAssignedReference().size() > 0) {
                        ((MComponent)this.scope.getMNamedElement()).getModifications().add(modif);
                        continue;
                    }
                    log.error("Coundn't get the modification of " + this.scope);
                }
            }
        }
    }

    @Override
    public void enterComponent_clause1(ModelicaParser.Component_clause1Context ctx) {
        super.enterComponent_clause1(ctx);
        this.scope = this.scopelist.get(ctx.component_declaration1());
        if (this.scope.getMNamedElement() instanceof MComponent) {
            MComponent mc = (MComponent)this.scope.getMNamedElement();
            MClass owner = mc.getOwningClass();
            for (MExtension mextension : owner.getExtensions()) {
                MClass mextended = mextension.getExtendedClass();
                MComponent mc2 = mextended.getComponentByName(mc.getName());
                if (mc2 == null) continue;
                mc.setRedefinedComponent(mc2);
                log.info("Setting redefined property for " + mc.getName());
                return;
            }
        }
        log.error("Unable to set redefined component");
    }

    @Override
    public void exitComponent_clause1(ModelicaParser.Component_clause1Context ctx) {
        super.exitComponent_clause1(ctx);
        this.scope = this.scope.getParent();
    }

    @Override
    public void enterConnect_clause(ModelicaParser.Connect_clauseContext ctx) {
        super.enterConnect_clause(ctx);
        if (!(this.scope.getMNamedElement() instanceof MClass)) {
            log.debug("Connect clause skipped, " + this.scope.getMNamedElement() + " not a class");
            return;
        }
        MConnect mconnect = ModelicaFactory.eINSTANCE.createMConnect();
        List<TerminalNode> idents1 = ctx.connector_ref(0).IDENT();
        this.addComponentToList(mconnect.getRef1(), idents1);
        if (mconnect.getRef1().size() == idents1.size()) {
            List<TerminalNode> idents2 = ctx.connector_ref(1).IDENT();
            this.addComponentToList(mconnect.getRef2(), idents2);
            if (mconnect.getRef2().size() == idents2.size()) {
                ((MClass)this.scope.getMNamedElement()).getEquations().add(mconnect);
                log.info("Connect equation added to " + this.scope);
            } else {
                log.warn("Connect equation failed: found " + mconnect.getRef2().size() + "/" + idents2.size() + " in " + idents2);
            }
        } else {
            log.warn("Connect equation failed: found " + mconnect.getRef1().size() + "/" + idents1.size() + " in " + idents1);
        }
    }

    @Override
    public void exitArgument(ModelicaParser.ArgumentContext ctx) {
        super.enterArgument(ctx);
    }

    private void addComponentToList(List<MComponent> list, List<TerminalNode> idents) {
        ModelicaScope ms = this.scope.lookForElementInScope(idents.get(0));
        if (ms.getMNamedElement() instanceof MComponent) {
            MComponent mc = (MComponent)ms.getMNamedElement();
            list.add(mc);
            for (int i = 1; i < idents.size(); ++i) {
                MClass type = mc.getType();
                if (type == null) {
                    log.warn("Type of component " + mc.getName() + " is null");
                    break;
                }
                String sclass = type.getName();
                String scomponent = idents.get(i).getText();
                mc = type.getComponentByName(scomponent);
                if (mc == null) {
                    log.warn("Component " + scomponent + " not found in class " + sclass + ", creating it");
                    mc = ModelicaFactory.eINSTANCE.createMComponent();
                    mc.setOwningClass(type);
                    ModelicaUtil.setName(mc, scomponent);
                }
                list.add(mc);
            }
        }
    }

    @Override
    public void exitPrimary(ModelicaParser.PrimaryContext ctx) {
        super.exitPrimary(ctx);
        if (ctx.STRING() != null) {
            String v = ctx.STRING().getText();
            this.values.put(ctx, v.substring(1, v.length() - 1));
        } else if (ctx.FALSE() != null) {
            this.values.put(ctx, false);
        } else if (ctx.TRUE() != null) {
            this.values.put(ctx, true);
        } else if (ctx.UNSIGNED_NUMBER() != null) {
            this.values.put(ctx, Double.valueOf(ctx.UNSIGNED_NUMBER().getText()));
        } else if (ctx.component_reference() != null && this.scope.getMNamedElement() instanceof MComponent) {
            LinkedList<MComponent> lmc = new LinkedList<MComponent>();
            MClass mc = (MClass)this.scope.getParent().getMNamedElement();
            for (TerminalNode tn : ctx.component_reference().IDENT()) {
                MComponent mcomp = mc.getComponentByName(tn.getText());
                if (mcomp != null) {
                    lmc.add(mcomp);
                    mc = mcomp.getType();
                    continue;
                }
                log.error("Can't find component " + tn.getText() + " in " + mc.getName());
                break;
            }
            this.values.put(ctx, lmc);
        }
    }

    @Override
    public void exitFactor(ModelicaParser.FactorContext ctx) {
        super.exitFactor(ctx);
        List<ModelicaParser.PrimaryContext> primary = ctx.primary();
        if (primary.size() == 1 && this.values.get(primary.get(0)) != null) {
            this.values.put(ctx, this.values.get(primary.get(0)));
        }
    }

    @Override
    public void exitTerm(ModelicaParser.TermContext ctx) {
        super.exitTerm(ctx);
        List<ModelicaParser.FactorContext> factor = ctx.factor();
        if (factor.size() == 1 && this.values.get(factor.get(0)) != null) {
            this.values.put(ctx, this.values.get(factor.get(0)));
        }
    }

    @Override
    public void exitArithmetic_expression(ModelicaParser.Arithmetic_expressionContext ctx) {
        super.exitArithmetic_expression(ctx);
        List<ModelicaParser.TermContext> term = ctx.term();
        if (term.size() == 1 && this.values.get(term.get(0)) != null) {
            if (this.values.get(term.get(0)) instanceof Double) {
                if (ctx.add_op().size() == 0 || ctx.add_op(0).PLUS() != null) {
                    this.values.put(ctx, this.values.get(term.get(0)));
                } else if (ctx.add_op().size() == 1 && ctx.add_op(0).MINUS() != null) {
                    this.values.put(ctx, -((Double)this.values.get(term.get(0))).doubleValue());
                }
            } else if (ctx.add_op().size() == 0 || ctx.add_op(0).PLUS() != null) {
                this.values.put(ctx, this.values.get(term.get(0)));
            }
        }
    }

    @Override
    public void exitRelation(ModelicaParser.RelationContext ctx) {
        super.exitRelation(ctx);
        List<ModelicaParser.Arithmetic_expressionContext> exp = ctx.arithmetic_expression();
        if (exp.size() == 1 && this.values.get(exp.get(0)) != null) {
            this.values.put(ctx, this.values.get(exp.get(0)));
        }
    }

    @Override
    public void exitLogical_factor(ModelicaParser.Logical_factorContext ctx) {
        super.exitLogical_factor(ctx);
        if (this.values.get(ctx.relation()) != null) {
            this.values.put(ctx, this.values.get(ctx.relation()));
        }
    }

    @Override
    public void exitLogical_term(ModelicaParser.Logical_termContext ctx) {
        super.exitLogical_term(ctx);
        List<ModelicaParser.Logical_factorContext> term = ctx.logical_factor();
        if (term.size() == 1 && this.values.get(term.get(0)) != null) {
            this.values.put(ctx, this.values.get(term.get(0)));
        }
    }

    @Override
    public void exitLogical_expression(ModelicaParser.Logical_expressionContext ctx) {
        super.exitLogical_expression(ctx);
        List<ModelicaParser.Logical_termContext> term = ctx.logical_term();
        if (term.size() == 1 && this.values.get(term.get(0)) != null) {
            this.values.put(ctx, this.values.get(term.get(0)));
        }
    }

    @Override
    public void exitSimple_expression(ModelicaParser.Simple_expressionContext ctx) {
        super.exitSimple_expression(ctx);
        List<ModelicaParser.Logical_expressionContext> exp = ctx.logical_expression();
        if (exp.size() == 1 && this.values.get(exp.get(0)) != null) {
            this.values.put(ctx, this.values.get(exp.get(0)));
        }
    }

    public MDataValue getValueFromExpression(ModelicaParser.Simple_expressionContext exp) {
        if (this.values.get(exp) != null) {
            Object o = this.values.get(exp);
            if (o instanceof Integer) {
                MIntegerValue mdv = ModelicaFactory.eINSTANCE.createMIntegerValue();
                mdv.setValue((Integer)o);
                return mdv;
            }
            if (o instanceof String) {
                MStringValue mdv = ModelicaFactory.eINSTANCE.createMStringValue();
                mdv.setValue(o.toString());
                return mdv;
            }
            if (o instanceof Double) {
                MRealValue mdv = ModelicaFactory.eINSTANCE.createMRealValue();
                mdv.setValue((Double)o);
                return mdv;
            }
        }
        MExpressionValue mdv = ModelicaFactory.eINSTANCE.createMExpressionValue();
        mdv.setValue(exp.getText());
        return mdv;
    }
}

