/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs;

import com.engisis.sysphs.SimulationToSysMLTranslationManager;
import com.engisis.sysphs.SysMLToSimulationTranslationManager;
import com.engisis.sysphs.client.gui.SimulationToSysMLFrame;
import com.engisis.sysphs.client.gui.SysMLToSimulationFrame;
import com.engisis.sysphs.translation.modelica.ModelicaToSysMLTranslator;
import com.engisis.sysphs.translation.modelica.SysMLToModelicaTranslator;
import com.engisis.sysphs.translation.simulink.SimulinkToSysMLTranslator;
import com.engisis.sysphs.translation.simulink.SysMLToSimulinkTranslator;
import com.engisis.sysphs.util.SimulationToSysMLTranslator;
import com.engisis.sysphs.util.SysMLToSimulationTranslator;
import com.engisis.sysphs.util.UMLModelErrorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class TranslationManager {
    private static final Logger log = Logger.getLogger(TranslationManager.class);
    private static final String PATH = "path";
    private static final String REVERSE = "reverse";
    private static final String TARGET = "target";
    private static final String TARGET_SIMULINK = "simulink";
    private static final String TARGET_MODELICA = "modelica";
    private static final String SFUNCTION = "sfunction";
    private static final String SFUNCTION_LEVEL1 = "level1";
    private static final String SFUNCTION_LEVEL2 = "level2";
    private static final String SFUNCTION_SIMSCAPE = "simscape";
    private static final String FORMAT = "format";
    private static final String FORMAT_TEXT = "text";
    private static final String FORMAT_XML = "xml";
    private static final String DOMAINS = "domains";
    private static final String DOMAINS_CREATE = "create";
    private static final String DOMAINS_REUSE = "reuse";
    private static final String PREPROC = "preproc";

    public static void main(String[] args) {
        JFrame simulationframe;
        JFileChooser jfc;
        Object translator;
        log.debug("Program started");
        boolean reverse = false;
        Target target = null;
        SysMLToSimulinkTranslator.SFunction sfunction = null;
        SysMLToSimulinkTranslator.Format format = null;
        SysMLToSimulinkTranslator.Domains domains = null;
        String rootblock = null;
        String model = null;
        String[] paths = null;
        boolean preproc = false;
        HelpFormatter formatter = new HelpFormatter();
        Options options = new Options();
        options.addOption(PATH, true, "Paths separated by " + File.pathSeparator);
        options.addOption(REVERSE, false, "Reverse translation (disabled by default)");
        options.addOption(TARGET, true, "Target platform ('modelica' or 'simulink')");
        options.addOption(SFUNCTION, true, "Type of SFunction ('level1', 'level2', 'simscape')");
        options.addOption(FORMAT, true, "Simulink format ('text' or 'xml')");
        options.addOption(DOMAINS, true, "Simscape domains ('create', 'reuse')");
        options.addOption(PREPROC, false, "Enables preprocessing transformations (disabled by default)");
        BasicParser clp = new BasicParser();
        try {
            List arglist;
            String s;
            CommandLine cl = clp.parse(options, args);
            if (cl.hasOption(REVERSE)) {
                reverse = true;
            }
            if (cl.hasOption(TARGET)) {
                s = cl.getOptionValue(TARGET);
                if (TARGET_MODELICA.equals(s)) {
                    target = Target.MODELICA;
                } else if (TARGET_SIMULINK.equals(s)) {
                    target = Target.SIMULINK;
                } else {
                    log.warn("Unrecognized target " + s);
                    formatter.printHelp("", options);
                }
            }
            if (cl.hasOption(SFUNCTION)) {
                s = cl.getOptionValue(SFUNCTION);
                if (SFUNCTION_LEVEL1.equals(s)) {
                    sfunction = SysMLToSimulinkTranslator.SFunction.Level1;
                } else if (SFUNCTION_LEVEL2.equals(s)) {
                    sfunction = SysMLToSimulinkTranslator.SFunction.Level2;
                } else if (SFUNCTION_SIMSCAPE.equals(s)) {
                    sfunction = SysMLToSimulinkTranslator.SFunction.Simscape;
                } else {
                    log.warn("Unrecognized sfunction " + s);
                    formatter.printHelp("", options);
                }
            }
            if (cl.hasOption(FORMAT)) {
                s = cl.getOptionValue(FORMAT);
                if (FORMAT_TEXT.equals(s)) {
                    format = SysMLToSimulinkTranslator.Format.TEXT;
                } else if (FORMAT_XML.equals(s)) {
                    format = SysMLToSimulinkTranslator.Format.XML;
                } else {
                    log.warn("Unrecognized format " + s);
                    formatter.printHelp("", options);
                }
            }
            if (cl.hasOption(DOMAINS)) {
                s = cl.getOptionValue(DOMAINS);
                if (DOMAINS_CREATE.equals(s)) {
                    domains = SysMLToSimulinkTranslator.Domains.CREATE;
                } else if (DOMAINS_REUSE.equals(s)) {
                    domains = SysMLToSimulinkTranslator.Domains.REUSE;
                } else {
                    log.warn("Unrecognized domains " + s);
                    formatter.printHelp("", options);
                }
            }
            if (cl.hasOption(PREPROC)) {
                preproc = true;
            }
            if (cl.hasOption(PATH)) {
                paths = cl.getOptionValue(PATH).split(File.pathSeparator);
            }
            if ((arglist = cl.getArgList()).size() > 0) {
                model = (String)arglist.get(0);
            }
            if (arglist.size() > 1) {
                rootblock = (String)arglist.get(1);
            }
        }
        catch (ParseException e) {
            log.error("Could not parse the command line", e);
            formatter.printHelp("", options);
            System.exit(1);
        }
        if (!reverse) {
            log.info("Straight translation");
            if (model != null && rootblock != null && target != null) {
                log.info("No GUI necessary");
                try {
                    SysMLToSimulationTranslationManager sysml2simulation = new SysMLToSimulationTranslationManager(model, paths);
                    if (preproc) {
                        sysml2simulation.setPreprocessing(true);
                    }
                    sysml2simulation.setInputRootName(rootblock);
                    translator = null;
                    if (target == Target.MODELICA) {
                        translator = new SysMLToModelicaTranslator();
                    } else {
                        translator = new SysMLToSimulinkTranslator();
                        HashSet<Object> os = new HashSet<Object>();
                        if (domains != null) {
                            os.add((Object)domains);
                        }
                        if (format != null) {
                            os.add((Object)format);
                        }
                        if (sfunction != null) {
                            os.add((Object)sfunction);
                        }
                        ((SysMLToSimulationTranslator)translator).loadOptions(os);
                    }
                    sysml2simulation.setTranslator((SysMLToSimulationTranslator)translator);
                    sysml2simulation.execute();
                }
                catch (FileNotFoundException e) {
                    log.error("File not found during the initialization", e);
                    System.exit(2);
                }
                catch (UMLModelErrorException e) {
                    log.error("Bad model error during the initialization", e);
                    System.exit(2);
                }
                catch (XMLStreamException e) {
                    log.error("XML error during the initialization", e);
                    System.exit(2);
                }
                catch (IOException e) {
                    log.error("IO error during the translation", e);
                    System.exit(2);
                }
            } else {
                log.info("GUI necessary");
                if (model == null) {
                    jfc = new JFileChooser(".");
                    if (jfc.showDialog(null, "Select") != 0) {
                        System.exit(1);
                    }
                    model = jfc.getSelectedFile().getAbsolutePath();
                }
                simulationframe = new SysMLToSimulationFrame(model, rootblock, paths);
                simulationframe.pack();
                simulationframe.setVisible(true);
            }
        } else {
            log.info("Reverse translation");
            if (model != null && target != null) {
                log.info("No GUI necessary");
                try {
                    SimulationToSysMLTranslationManager simulation2sysml = new SimulationToSysMLTranslationManager(model, paths);
                    translator = null;
                    translator = target == Target.MODELICA ? new ModelicaToSysMLTranslator(null) : new SimulinkToSysMLTranslator();
                    simulation2sysml.setTranslator((SimulationToSysMLTranslator)translator);
                    simulation2sysml.execute();
                }
                catch (FileNotFoundException e) {
                    log.error("File not found during the initialization", e);
                    System.exit(2);
                }
                catch (IOException e) {
                    log.error("IO error during the translation", e);
                    System.exit(2);
                }
                catch (UMLModelErrorException e) {
                    log.error("Bad model error during the initialization", e);
                    System.exit(2);
                }
            } else {
                log.info("GUI necessary");
                if (model == null) {
                    jfc = new JFileChooser(".");
                    if (jfc.showDialog(null, "Select") != 0) {
                        System.exit(1);
                    }
                    model = jfc.getSelectedFile().getAbsolutePath();
                }
                simulationframe = new SimulationToSysMLFrame(model, rootblock, paths);
                simulationframe.pack();
                simulationframe.setVisible(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Target {
        MODELICA,
        SIMULINK;

    }
}

