package com.engisis.sysphs.test;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import javax.xml.stream.XMLStreamException;

import com.engisis.sysphs.SimulationToSysMLTranslationManager;
import com.engisis.sysphs.SysMLToSimulationTranslationManager;
import com.engisis.sysphs.translation.modelica.ModelicaToSysMLTranslator;
import com.engisis.sysphs.translation.modelica.SysMLToModelicaTranslator;
import com.engisis.sysphs.translation.simulink.SimulinkToSysMLTranslator;
import com.engisis.sysphs.translation.simulink.SysMLToSimulinkTranslator;
import com.engisis.sysphs.translation.simulink.SysMLToSimulinkTranslator.Domains;
import com.engisis.sysphs.translation.simulink.SysMLToSimulinkTranslator.SFunction;
import com.engisis.xmiutil.UMLModelErrorException;

public class BaseTest
{
    private String target;
    private String path;
    private File ftarget;
    
    private Set<Object> optMo = new HashSet<Object>();
    private Set<Object> optSimu2 = new HashSet<Object>();
    private Set<Object> optSims1 = new HashSet<Object>();
    private Set<Object> optSims2 = new HashSet<Object>();
    
    public BaseTest(String target)
    {
        this.target = target;
        optSimu2.add(SFunction.Level2);
        
        optSims1.add(SFunction.Simscape);
        optSims1.add(Domains.CREATE);
        
        optSims2.add(SFunction.Simscape);
        optSims2.add(Domains.REUSE);
        
        ftarget = new File(SysMLToSimulationTranslationManager.class.getResource("/SysML/").getPath());
        path = ftarget.getAbsolutePath();
    }
    
    protected Set<Object> getModelicaOptions()
    {
        return optMo;
    }
    
    protected Set<Object> getSimulinkOptions()
    {
        return optSimu2;
    }
    
    protected Set<Object> getSimscapeCreateOptions()
    {
        return optSims1;
    }
    
    protected Set<Object> getSimscapeReuseOptions()
    {
        return optSims2;
    }
    
    /*
     * F for forward, R for reverse
     */
    
    protected void translateModelicaF(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException
    {
        File fd = new File(ftarget, suffix);
        fd.mkdir();
        
        SysMLToModelicaTranslator mg = new SysMLToModelicaTranslator(options);
        
        simulation.setOutputDirectory(fd);
        simulation.setTranslator(mg);
        simulation.execute();
        
    }
    
    protected void translateSimulinkF(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException
    {
        File fd = new File(ftarget, suffix);
        fd.mkdir();
        
        SysMLToSimulinkTranslator sg = new SysMLToSimulinkTranslator(options);
        simulation.setOutputDirectory(fd);
        simulation.setTranslator(sg);
        simulation.execute();
        
    }
    
    protected void translateModelicaFR(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException
    {
        File fd1 = new File(ftarget, suffix + "1");
        fd1.mkdir();
        
        SysMLToModelicaTranslator mg = new SysMLToModelicaTranslator(options);
        
        simulation.setOutputDirectory(fd1);
        simulation.setTranslator(mg);
        simulation.execute();
        
        File fd2 = new File(ftarget, suffix + "2");
        fd2.mkdir();
        
        ModelicaToSysMLTranslator sg = new ModelicaToSysMLTranslator(options);
        
        SimulationToSysMLTranslationManager sysml = new SimulationToSysMLTranslationManager(mg.getOutputFileName(),
                new String[] { ftarget.getAbsolutePath(), path });
        sysml.setOutputDirectory(fd2);
        sysml.setTranslator(sg);
        sysml.setTarget(target);
        sysml.execute();
        
    }
    
    protected void translateSimulinkFR(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException
    {
        File fd1 = new File(ftarget, suffix + "1");
        fd1.mkdir();
        
        SysMLToSimulinkTranslator sg = new SysMLToSimulinkTranslator(options);
        simulation.setOutputDirectory(fd1);
        simulation.setTranslator(sg);
        simulation.execute();
        
        File fd2 = new File(ftarget, suffix + "2");
        fd2.mkdir();
        
        SimulinkToSysMLTranslator sg2 = new SimulinkToSysMLTranslator();
        
        SimulationToSysMLTranslationManager sysml = new SimulationToSysMLTranslationManager(sg.getOutputFileName(),
                new String[] { ftarget.getAbsolutePath(), path });
        sysml.setOutputDirectory(fd2);
        sysml.setTranslator(sg2);
        sysml.setTarget(target);
        sysml.execute();
        
    }
    
    protected void translateModelicaFRF(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException, XMLStreamException
    {
        translateModelicaFRF(simulation, options, suffix, false);
    }
    
    protected void translateModelicaFRF(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix, boolean preprocessing) throws UMLModelErrorException, IOException, XMLStreamException
    {
        File fd1 = new File(ftarget, suffix + "1");
        fd1.mkdir();
        
        SysMLToModelicaTranslator mg = new SysMLToModelicaTranslator(options);
        simulation.setOutputDirectory(fd1);
        simulation.setPreprocessing(preprocessing);
        simulation.setTranslator(mg);
        simulation.execute();
        
        File fd2 = new File(ftarget, suffix + "2");
        fd2.mkdir();
        
        ModelicaToSysMLTranslator sg = new ModelicaToSysMLTranslator(options);
        
        SimulationToSysMLTranslationManager sysml = new SimulationToSysMLTranslationManager(mg.getOutputFileName(),
                new String[] { ftarget.getAbsolutePath(), path });
        sysml.setOutputDirectory(fd2);
        sysml.setTranslator(sg);
        sysml.setTarget(target);
        sysml.execute();
        
        File fd3 = new File(ftarget, suffix + "3");
        fd3.mkdir();
        
        SysMLToModelicaTranslator mg2 = new SysMLToModelicaTranslator(options);
        
        SysMLToSimulationTranslationManager simulation2 = new SysMLToSimulationTranslationManager(
                sg.getOutputFileName(), new String[] { ftarget.getAbsolutePath(), path });
        simulation2.setOutputDirectory(fd3);
        simulation2.setInputRootName(sg.getOutputRootName());
        simulation2.setTranslator(mg2);
        simulation2.execute();
    }
    
    protected void translateSimulinkFRF(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix) throws UMLModelErrorException, IOException, XMLStreamException
    {
        translateSimulinkFRF(simulation, options, suffix, false);
    }
    
    protected void translateSimulinkFRF(SysMLToSimulationTranslationManager simulation, Set<Object> options,
            String suffix, boolean preprocessing) throws UMLModelErrorException, IOException, XMLStreamException
    {
        File fd1 = new File(ftarget, suffix + "1");
        fd1.mkdir();
        
        SysMLToSimulinkTranslator sg = new SysMLToSimulinkTranslator(options);
        simulation.setOutputDirectory(fd1);
        simulation.setPreprocessing(preprocessing);
        simulation.setTranslator(sg);
        simulation.execute();
        
        File fd2 = new File(ftarget, suffix + "2");
        fd2.mkdir();
        
        SimulinkToSysMLTranslator sg2 = new SimulinkToSysMLTranslator();
        SimulationToSysMLTranslationManager sysml = new SimulationToSysMLTranslationManager(sg.getOutputFileName(),
                new String[] { ftarget.getAbsolutePath(), path });
        sysml.setOutputDirectory(fd2);
        sysml.setTranslator(sg2);
        
        sysml.setTarget(target);
        sysml.execute();
        
        File fd3 = new File(ftarget, suffix + "3");
        fd3.mkdir();
        
        SysMLToSimulinkTranslator sg3 = new SysMLToSimulinkTranslator(options);
        
        SysMLToSimulationTranslationManager simulation2 = new SysMLToSimulationTranslationManager(
                sg2.getOutputFileName(), new String[] { ftarget.getAbsolutePath(), path });
        simulation2.setOutputDirectory(fd3);
        simulation2.setInputRootName(sg2.getOutputRootName());
        simulation2.setTranslator(sg3);
        simulation2.execute();
    }
    
}
