package com.engisis.sysphs.util;

import java.io.IOException;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class XMLReader
{
    protected XmlPullParser xmlpp;
    
    protected boolean lookForElement(String... elements) throws XmlPullParserException, IOException
    {
        int et = xmlpp.getEventType();
        while (et != XmlPullParser.END_DOCUMENT)
        {
            et = xmlpp.next();
            if (et == XmlPullParser.START_TAG)
            {
                String name = xmlpp.getName();
                for (int i = 0; i < elements.length; i++)
                {
                    if (name.equals(elements[i]))
                        return true;
                }
            }
        }
        return false;
    }
    
    protected XMLLocation getLocation()
    {
        return new XMLLocation(xmlpp.getLineNumber(), xmlpp.getColumnNumber());
    }
    
    protected void skipToEnd() throws XmlPullParserException, IOException
    {
        if (xmlpp.getEventType() != XmlPullParser.START_TAG)
            throw new IllegalStateException("Wrong call of this method");
        int d = xmlpp.getDepth();
        while (xmlpp.next() != XmlPullParser.END_TAG || xmlpp.getDepth() != d)
            ;
    }
}
