package com.engisis.sysphs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map.Entry;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

import com.engisis.xmiutil.EMFUtil;

public class OMGFileGenerator
{
    public static void main(String[] args) throws FileNotFoundException
    {
        String[] files = new String[] { "SysPhSProfile.xmi", "SysPhSLibrary.xmi", "SysPhSAnnexA-CruiseController.xmi",
                "SysPhSAnnexA-ElectricCircuit.xmi", "SysPhSAnnexA-Humidifier.xmi", "SysPhSAnnexA-Hydraulics.xmi",
                "SysPhSAnnexA-SignalProcessor.xmi" };
        
        HashMap<String, Resource> hm = new HashMap<>();
        ResourceSet rs = EMFUtil.createResourceSet();
        for (String file : files)
        {
            String path = OMGFileGenerator.class.getResource("/SysML/" + file).getPath();
            
            hm.put(file, EMFUtil.loadResourceWithDependencies(rs, URI.createFileURI(new File(path).getAbsolutePath()),
                    Collections.emptyList()));
        }
        
        File output = new File("OMG");
        output.mkdirs();
        
        for (Entry<String, Resource> e : hm.entrySet())
        {
            try
            {
                EMFUtil.saveResource(e.getValue(), "OMG", new File(output, e.getKey()).toString());
            }
            catch (IOException e1)
            {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
        }
        
    }
}
