package com.engisis.sysphs.serialization.simulink;

import java.io.IOException;
import java.io.Writer;

import com.engisis.sysphs.language.stateflow.SChartBlock;

/**
 * Writes the Stateflow part of Simulink model in MDL
 * 
 * @author barbau
 *
 */
public class SimulinkStateflowMDLWriter extends SimulinkMDLWriter
{
    
    public SimulinkStateflowMDLWriter(Writer w)
    {
        super(w);
    }
    
    public void visit(SChartBlock object) throws IOException
    {
        introBlock();
        append("BlockType SubSystem", TL);
        defaultBlock(object);
        append("SFBlockType \"Chart\"", TL);
        if (object.getSystem() != null)
        {
            append("Ports [" + object.getSystem().getInports().size() + "," + object.getSystem().getOutports().size()
                    + "]", TL);
            object.getSystem().accept(getDispatcher());
        }
        outroBlock();
    }
}
