/**
 */
package com.engisis.sysphs.language.simulink.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;

import com.engisis.sysphs.language.simulink.*;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * @see com.engisis.sysphs.language.simulink.SimulinkPackage
 * @generated
 */
public class SimulinkSwitch<T> extends Switch<T>
{
    /**
     * The cached model package
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    protected static SimulinkPackage modelPackage;
    
    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    public SimulinkSwitch()
    {
        if (modelPackage == null)
        {
            modelPackage = SimulinkPackage.eINSTANCE;
        }
    }
    
    /**
     * Checks whether this is a switch for the given package. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @parameter ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
    @Override
    protected boolean isSwitchFor(EPackage ePackage)
    {
        return ePackage == modelPackage;
    }
    
    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    @Override
    protected T doSwitch(int classifierID, EObject theEObject)
    {
        switch (classifierID)
        {
            case SimulinkPackage.SELEMENT:
            {
                SElement sElement = (SElement)theEObject;
                T result = caseSElement(sElement);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SNAMED_ELEMENT:
            {
                SNamedElement sNamedElement = (SNamedElement)theEObject;
                T result = caseSNamedElement(sNamedElement);
                if (result == null) result = caseSElement(sNamedElement);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SSYSTEM:
            {
                SSystem sSystem = (SSystem)theEObject;
                T result = caseSSystem(sSystem);
                if (result == null) result = caseSNamedElement(sSystem);
                if (result == null) result = caseSElement(sSystem);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SBLOCK:
            {
                SBlock sBlock = (SBlock)theEObject;
                T result = caseSBlock(sBlock);
                if (result == null) result = caseSNamedElement(sBlock);
                if (result == null) result = caseSElement(sBlock);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SLINE:
            {
                SLine sLine = (SLine)theEObject;
                T result = caseSLine(sLine);
                if (result == null) result = caseSElement(sLine);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SMODEL:
            {
                SModel sModel = (SModel)theEObject;
                T result = caseSModel(sModel);
                if (result == null) result = caseSNamedElement(sModel);
                if (result == null) result = caseSElement(sModel);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SINPORT:
            {
                SInport sInport = (SInport)theEObject;
                T result = caseSInport(sInport);
                if (result == null) result = caseSBlock(sInport);
                if (result == null) result = caseSNamedElement(sInport);
                if (result == null) result = caseSElement(sInport);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SOUTPORT:
            {
                SOutport sOutport = (SOutport)theEObject;
                T result = caseSOutport(sOutport);
                if (result == null) result = caseSBlock(sOutport);
                if (result == null) result = caseSNamedElement(sOutport);
                if (result == null) result = caseSElement(sOutport);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SSUBSYSTEM:
            {
                SSubsystem sSubsystem = (SSubsystem)theEObject;
                T result = caseSSubsystem(sSubsystem);
                if (result == null) result = caseSBlock(sSubsystem);
                if (result == null) result = caseSNamedElement(sSubsystem);
                if (result == null) result = caseSElement(sSubsystem);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SCONNECTION_POINT:
            {
                SConnectionPoint sConnectionPoint = (SConnectionPoint)theEObject;
                T result = caseSConnectionPoint(sConnectionPoint);
                if (result == null) result = caseSElement(sConnectionPoint);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SLIBRARY:
            {
                SLibrary sLibrary = (SLibrary)theEObject;
                T result = caseSLibrary(sLibrary);
                if (result == null) result = caseSModel(sLibrary);
                if (result == null) result = caseSNamedElement(sLibrary);
                if (result == null) result = caseSElement(sLibrary);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SREFERENCE:
            {
                SReference sReference = (SReference)theEObject;
                T result = caseSReference(sReference);
                if (result == null) result = caseSBlock(sReference);
                if (result == null) result = caseSNamedElement(sReference);
                if (result == null) result = caseSElement(sReference);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SDATA_VALUE:
            {
                SDataValue sDataValue = (SDataValue)theEObject;
                T result = caseSDataValue(sDataValue);
                if (result == null) result = caseSElement(sDataValue);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SEXPRESSION_VALUE:
            {
                SExpressionValue sExpressionValue = (SExpressionValue)theEObject;
                T result = caseSExpressionValue(sExpressionValue);
                if (result == null) result = caseSDataValue(sExpressionValue);
                if (result == null) result = caseSElement(sExpressionValue);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SDOUBLE_VALUE:
            {
                SDoubleValue sDoubleValue = (SDoubleValue)theEObject;
                T result = caseSDoubleValue(sDoubleValue);
                if (result == null) result = caseSDataValue(sDoubleValue);
                if (result == null) result = caseSElement(sDoubleValue);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SINTERFACE:
            {
                SInterface sInterface = (SInterface)theEObject;
                T result = caseSInterface(sInterface);
                if (result == null) result = caseSBlock(sInterface);
                if (result == null) result = caseSNamedElement(sInterface);
                if (result == null) result = caseSElement(sInterface);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SSYSTEM_PARAMETER:
            {
                SSystemParameter sSystemParameter = (SSystemParameter)theEObject;
                T result = caseSSystemParameter(sSystemParameter);
                if (result == null) result = caseSNamedElement(sSystemParameter);
                if (result == null) result = caseSElement(sSystemParameter);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.STRIGGER:
            {
                STrigger sTrigger = (STrigger)theEObject;
                T result = caseSTrigger(sTrigger);
                if (result == null) result = caseSBlock(sTrigger);
                if (result == null) result = caseSNamedElement(sTrigger);
                if (result == null) result = caseSElement(sTrigger);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SSYSTEM_PARAMETER_ASSIGNMENT:
            {
                SSystemParameterAssignment sSystemParameterAssignment = (SSystemParameterAssignment)theEObject;
                T result = caseSSystemParameterAssignment(sSystemParameterAssignment);
                if (result == null) result = caseSElement(sSystemParameterAssignment);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SFUNCTION1:
            {
                SFunction1 sFunction1 = (SFunction1)theEObject;
                T result = caseSFunction1(sFunction1);
                if (result == null) result = caseSFunction(sFunction1);
                if (result == null) result = caseSSystem(sFunction1);
                if (result == null) result = caseSNamedElement(sFunction1);
                if (result == null) result = caseSElement(sFunction1);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_VARIABLE:
            {
                SFVariable sfVariable = (SFVariable)theEObject;
                T result = caseSFVariable(sfVariable);
                if (result == null) result = caseSNamedElement(sfVariable);
                if (result == null) result = caseSElement(sfVariable);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_INPUT_VARIABLE:
            {
                SFInputVariable sfInputVariable = (SFInputVariable)theEObject;
                T result = caseSFInputVariable(sfInputVariable);
                if (result == null) result = caseSFVariable(sfInputVariable);
                if (result == null) result = caseSNamedElement(sfInputVariable);
                if (result == null) result = caseSElement(sfInputVariable);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_OUTPUT_VARIABLE:
            {
                SFOutputVariable sfOutputVariable = (SFOutputVariable)theEObject;
                T result = caseSFOutputVariable(sfOutputVariable);
                if (result == null) result = caseSFVariable(sfOutputVariable);
                if (result == null) result = caseSNamedElement(sfOutputVariable);
                if (result == null) result = caseSElement(sfOutputVariable);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_DISCRETE_STATE_VARIABLE:
            {
                SFDiscreteStateVariable sfDiscreteStateVariable = (SFDiscreteStateVariable)theEObject;
                T result = caseSFDiscreteStateVariable(sfDiscreteStateVariable);
                if (result == null) result = caseSFVariable(sfDiscreteStateVariable);
                if (result == null) result = caseSNamedElement(sfDiscreteStateVariable);
                if (result == null) result = caseSElement(sfDiscreteStateVariable);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_VARIABLE_ASSIGNMENT:
            {
                SFVariableAssignment sfVariableAssignment = (SFVariableAssignment)theEObject;
                T result = caseSFVariableAssignment(sfVariableAssignment);
                if (result == null) result = caseSElement(sfVariableAssignment);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_DERIVATIVE_ASSIGNMENT:
            {
                SFDerivativeAssignment sfDerivativeAssignment = (SFDerivativeAssignment)theEObject;
                T result = caseSFDerivativeAssignment(sfDerivativeAssignment);
                if (result == null) result = caseSFVariableAssignment(sfDerivativeAssignment);
                if (result == null) result = caseSElement(sfDerivativeAssignment);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_OUTPUT_ASSIGNMENT:
            {
                SFOutputAssignment sfOutputAssignment = (SFOutputAssignment)theEObject;
                T result = caseSFOutputAssignment(sfOutputAssignment);
                if (result == null) result = caseSFVariableAssignment(sfOutputAssignment);
                if (result == null) result = caseSElement(sfOutputAssignment);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_CONTINUOUS_STATE_VARIABLE:
            {
                SFContinuousStateVariable sfContinuousStateVariable = (SFContinuousStateVariable)theEObject;
                T result = caseSFContinuousStateVariable(sfContinuousStateVariable);
                if (result == null) result = caseSFVariable(sfContinuousStateVariable);
                if (result == null) result = caseSNamedElement(sfContinuousStateVariable);
                if (result == null) result = caseSElement(sfContinuousStateVariable);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_UPDATE_ASSIGNMENT:
            {
                SFUpdateAssignment sfUpdateAssignment = (SFUpdateAssignment)theEObject;
                T result = caseSFUpdateAssignment(sfUpdateAssignment);
                if (result == null) result = caseSFVariableAssignment(sfUpdateAssignment);
                if (result == null) result = caseSElement(sfUpdateAssignment);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SFUNCTION1_BLOCK:
            {
                SFunction1Block sFunction1Block = (SFunction1Block)theEObject;
                T result = caseSFunction1Block(sFunction1Block);
                if (result == null) result = caseSFunctionBlock(sFunction1Block);
                if (result == null) result = caseSBlock(sFunction1Block);
                if (result == null) result = caseSNamedElement(sFunction1Block);
                if (result == null) result = caseSElement(sFunction1Block);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_PARAMETER:
            {
                SFParameter sfParameter = (SFParameter)theEObject;
                T result = caseSFParameter(sfParameter);
                if (result == null) result = caseSFVariable(sfParameter);
                if (result == null) result = caseSNamedElement(sfParameter);
                if (result == null) result = caseSElement(sfParameter);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SFUNCTION2_BLOCK:
            {
                SFunction2Block sFunction2Block = (SFunction2Block)theEObject;
                T result = caseSFunction2Block(sFunction2Block);
                if (result == null) result = caseSFunctionBlock(sFunction2Block);
                if (result == null) result = caseSBlock(sFunction2Block);
                if (result == null) result = caseSNamedElement(sFunction2Block);
                if (result == null) result = caseSElement(sFunction2Block);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SFUNCTION2:
            {
                SFunction2 sFunction2 = (SFunction2)theEObject;
                T result = caseSFunction2(sFunction2);
                if (result == null) result = caseSFunction(sFunction2);
                if (result == null) result = caseSSystem(sFunction2);
                if (result == null) result = caseSNamedElement(sFunction2);
                if (result == null) result = caseSElement(sFunction2);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SFD_WORK_VARIABLE:
            {
                SFDWorkVariable sfdWorkVariable = (SFDWorkVariable)theEObject;
                T result = caseSFDWorkVariable(sfdWorkVariable);
                if (result == null) result = caseSFVariable(sfdWorkVariable);
                if (result == null) result = caseSNamedElement(sfdWorkVariable);
                if (result == null) result = caseSElement(sfdWorkVariable);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SFD_WORK_ASSIGNMENT:
            {
                SFDWorkAssignment sfdWorkAssignment = (SFDWorkAssignment)theEObject;
                T result = caseSFDWorkAssignment(sfdWorkAssignment);
                if (result == null) result = caseSFVariableAssignment(sfdWorkAssignment);
                if (result == null) result = caseSElement(sfdWorkAssignment);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SFUNCTION:
            {
                SFunction sFunction = (SFunction)theEObject;
                T result = caseSFunction(sFunction);
                if (result == null) result = caseSSystem(sFunction);
                if (result == null) result = caseSNamedElement(sFunction);
                if (result == null) result = caseSElement(sFunction);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SFUNCTION_BLOCK:
            {
                SFunctionBlock sFunctionBlock = (SFunctionBlock)theEObject;
                T result = caseSFunctionBlock(sFunctionBlock);
                if (result == null) result = caseSBlock(sFunctionBlock);
                if (result == null) result = caseSNamedElement(sFunctionBlock);
                if (result == null) result = caseSElement(sFunctionBlock);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimulinkPackage.SF_PARAMETER_ASSIGNMENT:
            {
                SFParameterAssignment sfParameterAssignment = (SFParameterAssignment)theEObject;
                T result = caseSFParameterAssignment(sfParameterAssignment);
                if (result == null) result = caseSFVariableAssignment(sfParameterAssignment);
                if (result == null) result = caseSElement(sfParameterAssignment);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SElement</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SElement</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSElement(SElement object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SNamed Element</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SNamed Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSNamedElement(SNamedElement object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SSystem</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SSystem</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSSystem(SSystem object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SBlock</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SBlock</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSBlock(SBlock object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SLine</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SLine</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSLine(SLine object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SModel</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SModel</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSModel(SModel object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SInport</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SInport</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSInport(SInport object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SOutport</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SOutport</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSOutport(SOutport object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SSubsystem</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SSubsystem</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSSubsystem(SSubsystem object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SConnection Point</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SConnection Point</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSConnectionPoint(SConnectionPoint object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SLibrary</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SLibrary</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSLibrary(SLibrary object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SReference</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SReference</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSReference(SReference object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SData Value</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SData Value</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSDataValue(SDataValue object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SExpression Value</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SExpression Value</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSExpressionValue(SExpressionValue object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SDouble Value</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SDouble Value</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSDoubleValue(SDoubleValue object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SInterface</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SInterface</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSInterface(SInterface object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SSystem Parameter</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SSystem Parameter</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSSystemParameter(SSystemParameter object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>STrigger</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>STrigger</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSTrigger(STrigger object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SSystem Parameter Assignment</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SSystem Parameter Assignment</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSSystemParameterAssignment(SSystemParameterAssignment object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SFunction1</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SFunction1</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFunction1(SFunction1 object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SF Variable</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Variable</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFVariable(SFVariable object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SF Input Variable</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Input Variable</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFInputVariable(SFInputVariable object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SF Output Variable</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Output Variable</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFOutputVariable(SFOutputVariable object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SF Discrete State Variable</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Discrete State Variable</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFDiscreteStateVariable(SFDiscreteStateVariable object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SF Variable Assignment</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Variable Assignment</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFVariableAssignment(SFVariableAssignment object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SF Derivative Assignment</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Derivative Assignment</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFDerivativeAssignment(SFDerivativeAssignment object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SF Output Assignment</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Output Assignment</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFOutputAssignment(SFOutputAssignment object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SF Continuous State Variable</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Continuous State Variable</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFContinuousStateVariable(SFContinuousStateVariable object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SF Update Assignment</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Update Assignment</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFUpdateAssignment(SFUpdateAssignment object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SFunction1 Block</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SFunction1 Block</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFunction1Block(SFunction1Block object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SF Parameter</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Parameter</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFParameter(SFParameter object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SFunction2 Block</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SFunction2 Block</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFunction2Block(SFunction2Block object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SFunction2</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SFunction2</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFunction2(SFunction2 object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SFD Work Variable</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SFD Work Variable</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFDWorkVariable(SFDWorkVariable object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SFD Work Assignment</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SFD Work Assignment</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFDWorkAssignment(SFDWorkAssignment object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SFunction</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SFunction</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFunction(SFunction object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SFunction Block</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SFunction Block</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSFunctionBlock(SFunctionBlock object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>SF Parameter Assignment</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SF Parameter Assignment</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSFParameterAssignment(SFParameterAssignment object) {
        return null;
    }

																/**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch, but this is
     * the last case anyway. <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    @Override
    public T defaultCase(EObject object)
    {
        return null;
    }
    
} // SimulinkSwitch
