/**
 */
package com.engisis.sysphs.language.simscape.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;

import com.engisis.sysphs.language.simscape.*;
import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SLine;
import com.engisis.sysphs.language.simulink.SNamedElement;
import com.engisis.sysphs.language.simulink.SSystem;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * @see com.engisis.sysphs.language.simscape.SimscapePackage
 * @generated
 */
public class SimscapeSwitch<T> extends Switch<T>
{
    /**
     * The cached model package
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    protected static SimscapePackage modelPackage;
    
    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    public SimscapeSwitch()
    {
        if (modelPackage == null)
        {
            modelPackage = SimscapePackage.eINSTANCE;
        }
    }
    
    /**
     * Checks whether this is a switch for the given package. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @parameter ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
    @Override
    protected boolean isSwitchFor(EPackage ePackage)
    {
        return ePackage == modelPackage;
    }
    
    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    @Override
    protected T doSwitch(int classifierID, EObject theEObject)
    {
        switch (classifierID)
        {
            case SimscapePackage.SCOMPONENT:
            {
                SComponent sComponent = (SComponent)theEObject;
                T result = caseSComponent(sComponent);
                if (result == null) result = caseSSystem(sComponent);
                if (result == null) result = caseSNamedElement(sComponent);
                if (result == null) result = caseSElement(sComponent);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SNODE:
            {
                SNode sNode = (SNode)theEObject;
                T result = caseSNode(sNode);
                if (result == null) result = caseSMember(sNode);
                if (result == null) result = caseSNamedElement(sNode);
                if (result == null) result = caseSElement(sNode);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SVARIABLE:
            {
                SVariable sVariable = (SVariable)theEObject;
                T result = caseSVariable(sVariable);
                if (result == null) result = caseSMember(sVariable);
                if (result == null) result = caseSNamedElement(sVariable);
                if (result == null) result = caseSElement(sVariable);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SEQUATION:
            {
                SEquation sEquation = (SEquation)theEObject;
                T result = caseSEquation(sEquation);
                if (result == null) result = caseSElement(sEquation);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SDOMAIN:
            {
                SDomain sDomain = (SDomain)theEObject;
                T result = caseSDomain(sDomain);
                if (result == null) result = caseSNamedElement(sDomain);
                if (result == null) result = caseSElement(sDomain);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SMEMBER:
            {
                SMember sMember = (SMember)theEObject;
                T result = caseSMember(sMember);
                if (result == null) result = caseSNamedElement(sMember);
                if (result == null) result = caseSElement(sMember);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SINPUT:
            {
                SInput sInput = (SInput)theEObject;
                T result = caseSInput(sInput);
                if (result == null) result = caseSMember(sInput);
                if (result == null) result = caseSNamedElement(sInput);
                if (result == null) result = caseSElement(sInput);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SOUTPUT:
            {
                SOutput sOutput = (SOutput)theEObject;
                T result = caseSOutput(sOutput);
                if (result == null) result = caseSMember(sOutput);
                if (result == null) result = caseSNamedElement(sOutput);
                if (result == null) result = caseSElement(sOutput);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SPARAMETER:
            {
                SParameter sParameter = (SParameter)theEObject;
                T result = caseSParameter(sParameter);
                if (result == null) result = caseSMember(sParameter);
                if (result == null) result = caseSNamedElement(sParameter);
                if (result == null) result = caseSElement(sParameter);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SCOMPONENT_REFERENCE:
            {
                SComponentReference sComponentReference = (SComponentReference)theEObject;
                T result = caseSComponentReference(sComponentReference);
                if (result == null) result = caseSMember(sComponentReference);
                if (result == null) result = caseSNamedElement(sComponentReference);
                if (result == null) result = caseSElement(sComponentReference);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SMEMBER_ASSIGNMENT:
            {
                SMemberAssignment sMemberAssignment = (SMemberAssignment)theEObject;
                T result = caseSMemberAssignment(sMemberAssignment);
                if (result == null) result = caseSElement(sMemberAssignment);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SCONNECTION:
            {
                SConnection sConnection = (SConnection)theEObject;
                T result = caseSConnection(sConnection);
                if (result == null) result = caseSElement(sConnection);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SMEMBER_PATH:
            {
                SMemberPath sMemberPath = (SMemberPath)theEObject;
                T result = caseSMemberPath(sMemberPath);
                if (result == null) result = caseSElement(sMemberPath);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SPACKAGE:
            {
                SPackage sPackage = (SPackage)theEObject;
                T result = caseSPackage(sPackage);
                if (result == null) result = caseSNamedElement(sPackage);
                if (result == null) result = caseSElement(sPackage);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SBRANCH:
            {
                SBranch sBranch = (SBranch)theEObject;
                T result = caseSBranch(sBranch);
                if (result == null) result = caseSElement(sBranch);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SPHYSICAL_BLOCK:
            {
                SPhysicalBlock sPhysicalBlock = (SPhysicalBlock)theEObject;
                T result = caseSPhysicalBlock(sPhysicalBlock);
                if (result == null) result = caseSBlock(sPhysicalBlock);
                if (result == null) result = caseSNamedElement(sPhysicalBlock);
                if (result == null) result = caseSElement(sPhysicalBlock);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SPHYSICAL_LINE:
            {
                SPhysicalLine sPhysicalLine = (SPhysicalLine)theEObject;
                T result = caseSPhysicalLine(sPhysicalLine);
                if (result == null) result = caseSLine(sPhysicalLine);
                if (result == null) result = caseSElement(sPhysicalLine);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SPHYSICAL_CONNECTION_POINT:
            {
                SPhysicalConnectionPoint sPhysicalConnectionPoint = (SPhysicalConnectionPoint)theEObject;
                T result = caseSPhysicalConnectionPoint(sPhysicalConnectionPoint);
                if (result == null) result = caseSElement(sPhysicalConnectionPoint);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case SimscapePackage.SCONNECTION_PORT_BLOCK:
            {
                SConnectionPortBlock sConnectionPortBlock = (SConnectionPortBlock)theEObject;
                T result = caseSConnectionPortBlock(sConnectionPortBlock);
                if (result == null) result = caseSPhysicalBlock(sConnectionPortBlock);
                if (result == null) result = caseSBlock(sConnectionPortBlock);
                if (result == null) result = caseSNamedElement(sConnectionPortBlock);
                if (result == null) result = caseSElement(sConnectionPortBlock);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SComponent</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SComponent</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSComponent(SComponent object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SNode</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SNode</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSNode(SNode object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SVariable</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SVariable</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSVariable(SVariable object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SEquation</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SEquation</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSEquation(SEquation object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SDomain</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SDomain</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSDomain(SDomain object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SMember</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SMember</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSMember(SMember object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SInput</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SInput</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSInput(SInput object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SOutput</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SOutput</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSOutput(SOutput object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SParameter</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SParameter</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSParameter(SParameter object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SComponent Reference</em>'.
     * <!-- begin-user-doc --> This
     * implementation returns null; returning a non-null result will terminate
     * the switch. <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SComponent Reference</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSComponentReference(SComponentReference object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SMember Assignment</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SMember Assignment</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSMemberAssignment(SMemberAssignment object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SConnection</em>'.
     * <!-- begin-user-doc --> This implementation
     * returns null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SConnection</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSConnection(SConnection object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SMember Path</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SMember Path</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSMemberPath(SMemberPath object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SPackage</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch. <!--
     * end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SPackage</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSPackage(SPackage object)
    {
        return null;
    }
    
    /**
     * Returns the result of interpreting the object as an instance of '<em>SBranch</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SBranch</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSBranch(SBranch object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SPhysical Block</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SPhysical Block</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSPhysicalBlock(SPhysicalBlock object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>SPhysical Line</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SPhysical Line</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSPhysicalLine(SPhysicalLine object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>SPhysical Connection Point</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SPhysical Connection Point</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSPhysicalConnectionPoint(SPhysicalConnectionPoint object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SConnection Port Block</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SConnection Port Block</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSConnectionPortBlock(SConnectionPortBlock object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>SElement</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SElement</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSElement(SElement object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>SNamed Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SNamed Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSNamedElement(SNamedElement object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>SSystem</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SSystem</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSSystem(SSystem object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>SBlock</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SBlock</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSBlock(SBlock object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>SLine</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SLine</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSLine(SLine object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc --> This implementation returns
     * null; returning a non-null result will terminate the switch, but this is
     * the last case anyway. <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    @Override
    public T defaultCase(EObject object)
    {
        return null;
    }
    
} // SimscapeSwitch
