package com.engisis.sysphs.test;

import java.io.IOException;

import javax.xml.stream.XMLStreamException;

import org.junit.Test;

import com.engisis.sysphs.SysMLToSimulationTranslationManager;
import com.engisis.xmiutil.UMLModelErrorException;

public class OMGTest extends BaseTest
{
    
    private String circuitblockomg = "TestCaseCircuit::Circuit";
    private String cruisecontrollerblockomg = "Model::CruiseControlTotalSystem";
    private String humidifierblockomg = "TestCaseHumidifier::HumidifierSystemScenario1";
    private String hydraulicsblockomg = "Data::ConnectedTanks";
    private String signalprocessorblockomg = "TestCaseSignalProcessor::TestBedScenario1";
    
    public OMGTest()
    {
        super("OMG");
    }
    
    @Test
    public void testCircuitOMGSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SysPhSAnnexA-ElectricCircuit.xmi")
                        .getPath(),
                null);
        circuitSysML.setInputRootName(circuitblockomg);
        
        translateModelicaFRF(circuitSysML, getModelicaOptions(), "OMGCircuitM");
        translateSimulinkFRF(circuitSysML, getSimscapeCreateOptions(), "OMGCircuitS");
    }
    
    @Test
    public void testCruiseControllerOMGSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager cruisecontrollerSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SysPhSAnnexA-CruiseController.xmi")
                        .getPath(),
                null);
        cruisecontrollerSysML.setInputRootName(cruisecontrollerblockomg);
        
        translateModelicaFRF(cruisecontrollerSysML, getModelicaOptions(), "OMGCruiseControllerM", true);
        translateSimulinkFRF(cruisecontrollerSysML, getSimscapeCreateOptions(), "OMGCruiseControllerS", true);
    }
    
    @Test
    public void testHumidifierOMGSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SysPhSAnnexA-Humidifier.xmi").getPath(),
                null);
        humidifierSysML.setInputRootName(humidifierblockomg);
        
        translateModelicaFRF(humidifierSysML, getModelicaOptions(), "OMGHumidifierM");
        translateSimulinkFRF(humidifierSysML, getSimulinkOptions(), "OMGHumidifierS");
    }
    
    @Test
    public void testHydraulicsOMGSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager hydraulicsSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SysPhSAnnexA-Hydraulics.xmi").getPath(),
                null);
        hydraulicsSysML.setInputRootName(hydraulicsblockomg);
        
        translateModelicaFRF(hydraulicsSysML, getModelicaOptions(), "OMGHydraulicsM");
        translateSimulinkFRF(hydraulicsSysML, getSimscapeCreateOptions(), "OMGHydraulicsS");
    }
    
    @Test
    public void testSignalProcessorOMGSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalprocessorSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SysPhSAnnexA-SignalProcessor.xmi")
                        .getPath(),
                null);
        signalprocessorSysML.setInputRootName(signalprocessorblockomg);
        
        translateModelicaFRF(signalprocessorSysML, getModelicaOptions(), "OMGSignalProcessorM");
        translateSimulinkFRF(signalprocessorSysML, getSimulinkOptions(), "OMGSignalProcessorS");
    }
}
