package com.engisis.sysphs.util;

import java.util.Hashtable;

import org.apache.log4j.Logger;

import com.engisis.xmiutil.EMFConfiguration;

public class SysPhSConfiguration extends EMFConfiguration
{
    private static final Logger log = Logger.getLogger(SysPhSConfiguration.class);
    
    public static final String SIMULINK_UNIT = "simulinkunitmapping";
    
    /**
     * a map of standard units to simulink units
     */
    private static Hashtable<String, String> simulinkunits = null;
    
    public synchronized static void loadProperties()
    {
        EMFConfiguration.loadProperties();
        
        simulinkunits = new Hashtable<String, String>();
        simulinkunits.put("\u2126", "Ohm");
        simulinkunits.put("\u03A9", "Ohm");
        simulinkunits.put("\u03C9", "Ohm");
        
        for (String[] spl : getValues())
        {
            if (spl[0].equals(SIMULINK_UNIT))
            {
                if (spl.length < 3)
                {
                    log.error("Line in the wrong format: " + String.join(" ", spl));
                    continue;
                }
                String from = spl[1];
                String to = spl[2];
                simulinkunits.put(from, to);
                log.info("add simulink unit mapping from " + from + " to " + to);
            }
        }
    }
    
    public static Hashtable<String, String> getSimulinkUnitMapping()
    {
        if (simulinkunits == null)
            loadProperties();
        return simulinkunits;
    }
}
