package com.engisis.sysphs.translation.simulink;

import java.util.ArrayList;
import java.util.List;

import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SDomain;
import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SNamedElement;

public class SimulinkUtil
{
    public static void setName(SNamedElement sne, String name)
    {
        // filtered
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (name != null)
            for (char c : name.toCharArray())
            {
                if (first)
                {
                    if (Character.isLetter(c))
                    {
                        sb.append(c);
                        first = false;
                    }
                }
                else if (Character.isLetter(c) || c == '_' || Character.isDigit(c))
                {
                    sb.append(c);
                }
            }
        String fname = sb.length() == 0 ? sne.getClass().getName() : sb.toString();
        
        // missing?
        List<SNamedElement> snes = new ArrayList<SNamedElement>();
        if (sne instanceof SBlock && ((SBlock) sne).getOwningSystem() != null)
            snes.addAll(((SBlock) sne).getOwningSystem().getOwnedBlocks());
        else if (sne instanceof SComponent && ((SComponent) sne).getOwningPackage() != null)
        {
            snes.addAll(((SComponent) sne).getOwningPackage().getComponents());
            snes.addAll(((SComponent) sne).getOwningPackage().getDomains());
        }
        else if (sne instanceof SDomain && ((SDomain) sne).getOwningPackage() != null)
        {
            snes.addAll(((SDomain) sne).getOwningPackage().getComponents());
            snes.addAll(((SDomain) sne).getOwningPackage().getDomains());
        }
        
        if (!isPresent(fname, snes))
        {
            sne.setName(fname);
            return;
        }
        int i = 0;
        while (true)
        {
            String nname = fname + (i++);
            if (!isPresent(nname, snes))
            {
                sne.setName(nname);
                return;
            }
        }
        
    }
    
    private static boolean isPresent(String name, List<SNamedElement> snes)
    {
        if (name != null)
            for (SNamedElement sne : snes)
                if (name.equals(sne.getName()))
                    return true;
        return false;
    }
}
