package com.engisis.sysphs.serialization.simulink;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.stateflow.SChart;
import com.engisis.sysphs.language.stateflow.SData;
import com.engisis.sysphs.language.stateflow.SDataScope;
import com.engisis.sysphs.language.stateflow.SEvent;
import com.engisis.sysphs.language.stateflow.SIdentifiedElement;
import com.engisis.sysphs.language.stateflow.SInstance;
import com.engisis.sysphs.language.stateflow.SJunction;
import com.engisis.sysphs.language.stateflow.SLinkNode;
import com.engisis.sysphs.language.stateflow.SMachine;
import com.engisis.sysphs.language.stateflow.SState;
import com.engisis.sysphs.language.stateflow.SStateflow;
import com.engisis.sysphs.language.stateflow.STarget;
import com.engisis.sysphs.language.stateflow.STransition;
import com.engisis.sysphs.language.stateflow.STreeNode;
import com.engisis.sysphs.util.XMLWriter;

/**
 * Writes the Stateflow model in MDL
 * 
 * @author barbau
 *
 */
public class StateflowXMLWriter extends XMLWriter
{
    
    public StateflowXMLWriter(XMLStreamWriter xmlsw)
    {
        super(xmlsw);
    }
    
    public void positionState(SState sstate) throws XMLStreamException
    {
        if (sstate.getOwningTreeNode() != null)
        {
            int pos = sstate.getOwningTreeNode().getTreeNode().indexOf(sstate);
            int w = 100;
            int h = 40;
            int m = 20;
            int x1 = (m + m * pos) + (pos * w);
            int x2 = w;
            int y1 = m;
            int y2 = h;
            String position = "[" + x1 + " " + y1 + " " + x2 + " " + y2 + "]";
            property("position", position);
        }
    }
    
    public void visit(SChart object) throws XMLStreamException
    {
        startElement("chart");
        attribute("id", String.valueOf(object.getId()));
        
        if (object.getName() != null)
            property("name", object.getName());
        property("viewObj", String.valueOf(object.getId()));
        property("toolbarMode", "LIBRARY_TOOLBAR");
        property("decomposition", "CLUSTER_CHART");
        property("chartFileNumber", String.valueOf(object.getOwningMachine().getChart().indexOf(object) + 1));
        property("saturateOnIntegerOverflow", "1");
        property("userSpecifiedStateTransitionExecutionOrder", "1");
        property("disableImplicitCasting", "1");
        property("actionLanguage", "2");
        
        startElement("Children");
        
        for (STreeNode streenode : object.getTreeNode())
            streenode.accept(getDispatcher());
        for (SLinkNode slinknode : object.getLinkNode())
            slinknode.accept(getDispatcher());
        
        endElement();
        
        endElement();
    }
    
    public void visit(SData object) throws XMLStreamException
    {
        startElement("data");
        attribute("SSID", String.valueOf(object.getId()));
        if (object.getName() != null)
            attribute("name ", object.getName());
        
        if (object.getScope() == SDataScope.INPUT)
            property("scope", "INPUT_DATA");
        else if (object.getScope() == SDataScope.OUTPUT)
            property("scope", "OUTPUT_DATA");
        else if (object.getScope() == SDataScope.CONSTANT)
            property("scope", "CONSTANT_DATA");
        if (object.getValue() != null)
        {
            startElement("props");
            startElement("P");
            attribute("Name", "initialValue");
            object.getValue().accept(getDispatcher());
            endElement();
            endElement();
        }
        endElement();
    }
    
    public void visit(SEvent object) throws XMLStreamException
    {
        startElement("event");
        attribute("id", String.valueOf(object.getId()));
        if (object.getName() != null)
            attribute("name", String.valueOf(object.getName()));
        endElement();
    }
    
    public void visit(SExpressionValue object) throws XMLStreamException
    {
        characters(object.getValue());
    }
    
    public void visit(SInstance object) throws XMLStreamException
    {
        startElement("instance");
        attribute("id", String.valueOf(object.getId()));
        
        if (object.getName() != null)
        {
            property("name", object.getName());
        }
        if (object.getMachine() != null)
        {
            property("machine", String.valueOf(object.getMachine().getId()));
        }
        if (object.getChart() != null)
        {
            property("chart", String.valueOf(object.getChart().getId()));
        }
        endElement();
    }
    
    public void visit(SJunction object) throws XMLStreamException
    {
        startElement("junction");
        attribute("SSID", String.valueOf(object.getId()));
        endElement();
    }
    
    public void visit(SMachine object) throws XMLStreamException
    {
        startElement("machine");
        
        attribute("id", String.valueOf(object.getId()));
        
        property("created", new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date()));
        property("isLibrary", "1");
        property("sfVersion", "76014001.002");
        
        startElement("Children");
        if (object.getTarget() != null)
            object.getTarget().accept(getDispatcher());
        
        for (SChart schart : object.getChart())
            schart.accept(getDispatcher());
        
        endElement();
        
        endElement();
    }
    
    public void visit(SDoubleValue object) throws XMLStreamException
    {
        characters(String.valueOf(object.getValue()));
    }
    
    public void visit(SState object) throws XMLStreamException
    {
        startElement("state");
        attribute("SSID", String.valueOf(object.getId()));
        String label = object.getLabel() == null ? object.getName() : object.getName() + "\n" + object.getLabel();
        property("labelString", label);
        positionState(object);
        property("subviewer", String.valueOf(object.getOwningTreeNode().getId()));
        property("type", "OR_STATE");
        property("decomposition", "CLUSTER_STATE");
        if (object.getTreeNode().size() != 0 || object.getTreeNode().size() != 0)
        {
            startElement("Children");
            for (STreeNode streenode : object.getTreeNode())
                streenode.accept(getDispatcher());
            for (SLinkNode slinknode : object.getLinkNode())
                slinknode.accept(getDispatcher());
            endElement();
        }
        endElement();
    }
    
    public void visit(SStateflow object) throws XMLStreamException
    {
        startElement("Stateflow");
        if (object.getMachine() != null)
            object.getMachine().accept(getDispatcher());
        for (SInstance sinstance : object.getInstance())
            sinstance.accept(getDispatcher());
        endElement();
    }
    
    public void visit(STarget object) throws XMLStreamException
    {
        startElement("target");
        attribute("id", String.valueOf(object.getId()));
        attribute("name", "sfun");
        property("description", "Default Simulink S-Function Target.");
        endElement();
    }
    
    public void visit(STransition object) throws XMLStreamException
    {
        startElement("transition");
        attribute("SSID", String.valueOf(object.getId()));
        
        if (object.getLabel() != null)
        {
            property("labelString", object.getLabel());
        }
        
        startElement("src");
        if (object.getSrc() != null)
        {
            property("SSID", String.valueOf(((SIdentifiedElement) object.getSrc()).getId()));
        }
        endElement();
        
        startElement("dst");
        if (object.getDst() != null)
        {
            property("SSID", String.valueOf(((SIdentifiedElement) object.getDst()).getId()));
        }
        endElement();
        
        if (object.getSrc() != null)
            property("executionOrder", String.valueOf(object.getSrc().getOutgoing().indexOf(object) + 1));
        else
            property("executionOrder", "1");
        
        endElement();
    }
    
    private void property(String name, String value) throws XMLStreamException
    {
        startElement("P");
        attribute("Name", name);
        characters(value);
        endElement();
    }
}
