package com.engisis.sysphs.serialization.simulink;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import com.engisis.sysphs.language.stateflow.SChartBlock;

/**
 * Writes the Stateflow part of Simulink model in XML
 * 
 * @author barbau
 *
 */
public class SimulinkStateflowXMLWriter extends SimulinkXMLWriter
{
    
    public SimulinkStateflowXMLWriter(XMLStreamWriter xmlsw)
    {
        super(xmlsw);
    }
    
    public void visit(SChartBlock object) throws XMLStreamException
    {
        introBlock();
        attribute("BlockType", "SubSystem");
        defaultBlock(object);
        if (object.getSystem() != null)
        {
            property("Ports", "[" + object.getSystem().getInports().size() + ","
                    + object.getSystem().getOutports().size() + "]");
            positionBlock(object);
            property("LibraryVersion", "1.266");
            property("ErrorFcn", "Stateflow.Translate.translate");
            property("PermitHierarchicalResolution", "ExplicitOnly");
            property("TreatAsAtomicUnit", "on");
            property("RequestExecContextInheritance", "off");
            property("SFBlockType", "Chart");
            object.getSystem().accept(getDispatcher());
        }
        outroBlock();
    }
    
}
