/**
 */
package com.engisis.sysphs.language.stateflow.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;

import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SElement;
import com.engisis.sysphs.language.simulink.SNamedElement;
import com.engisis.sysphs.language.simulink.SSubsystem;
import com.engisis.sysphs.language.simulink.SSystem;
import com.engisis.sysphs.language.stateflow.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see com.engisis.sysphs.language.stateflow.StateflowPackage
 * @generated
 */
public class StateflowSwitch<T> extends Switch<T> {
	/**
     * The cached model package
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static StateflowPackage modelPackage;

	/**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public StateflowSwitch() {
        if (modelPackage == null)
        {
            modelPackage = StateflowPackage.eINSTANCE;
        }
    }

	/**
     * Checks whether this is a switch for the given package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
        return ePackage == modelPackage;
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID)
        {
            case StateflowPackage.SSTATEFLOW:
            {
                SStateflow sStateflow = (SStateflow)theEObject;
                T result = caseSStateflow(sStateflow);
                if (result == null) result = caseSElement(sStateflow);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SMACHINE:
            {
                SMachine sMachine = (SMachine)theEObject;
                T result = caseSMachine(sMachine);
                if (result == null) result = caseSIdentifiedElement(sMachine);
                if (result == null) result = caseSNamedElement(sMachine);
                if (result == null) result = caseSElement(sMachine);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SCHART:
            {
                SChart sChart = (SChart)theEObject;
                T result = caseSChart(sChart);
                if (result == null) result = caseSTreeNode(sChart);
                if (result == null) result = caseSIdentifiedElement(sChart);
                if (result == null) result = caseSNamedElement(sChart);
                if (result == null) result = caseSElement(sChart);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SSTATE:
            {
                SState sState = (SState)theEObject;
                T result = caseSState(sState);
                if (result == null) result = caseSTreeNode(sState);
                if (result == null) result = caseSConnectNode(sState);
                if (result == null) result = caseSIdentifiedElement(sState);
                if (result == null) result = caseSNamedElement(sState);
                if (result == null) result = caseSElement(sState);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SJUNCTION:
            {
                SJunction sJunction = (SJunction)theEObject;
                T result = caseSJunction(sJunction);
                if (result == null) result = caseSLinkNode(sJunction);
                if (result == null) result = caseSConnectNode(sJunction);
                if (result == null) result = caseSIdentifiedElement(sJunction);
                if (result == null) result = caseSNamedElement(sJunction);
                if (result == null) result = caseSElement(sJunction);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.STRANSITION:
            {
                STransition sTransition = (STransition)theEObject;
                T result = caseSTransition(sTransition);
                if (result == null) result = caseSLinkNode(sTransition);
                if (result == null) result = caseSIdentifiedElement(sTransition);
                if (result == null) result = caseSNamedElement(sTransition);
                if (result == null) result = caseSElement(sTransition);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SDATA:
            {
                SData sData = (SData)theEObject;
                T result = caseSData(sData);
                if (result == null) result = caseSLinkNode(sData);
                if (result == null) result = caseSIdentifiedElement(sData);
                if (result == null) result = caseSNamedElement(sData);
                if (result == null) result = caseSElement(sData);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SEVENT:
            {
                SEvent sEvent = (SEvent)theEObject;
                T result = caseSEvent(sEvent);
                if (result == null) result = caseSLinkNode(sEvent);
                if (result == null) result = caseSIdentifiedElement(sEvent);
                if (result == null) result = caseSNamedElement(sEvent);
                if (result == null) result = caseSElement(sEvent);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SINSTANCE:
            {
                SInstance sInstance = (SInstance)theEObject;
                T result = caseSInstance(sInstance);
                if (result == null) result = caseSIdentifiedElement(sInstance);
                if (result == null) result = caseSNamedElement(sInstance);
                if (result == null) result = caseSElement(sInstance);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SCONNECT_NODE:
            {
                SConnectNode sConnectNode = (SConnectNode)theEObject;
                T result = caseSConnectNode(sConnectNode);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SIDENTIFIED_ELEMENT:
            {
                SIdentifiedElement sIdentifiedElement = (SIdentifiedElement)theEObject;
                T result = caseSIdentifiedElement(sIdentifiedElement);
                if (result == null) result = caseSNamedElement(sIdentifiedElement);
                if (result == null) result = caseSElement(sIdentifiedElement);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SLINK_NODE:
            {
                SLinkNode sLinkNode = (SLinkNode)theEObject;
                T result = caseSLinkNode(sLinkNode);
                if (result == null) result = caseSIdentifiedElement(sLinkNode);
                if (result == null) result = caseSNamedElement(sLinkNode);
                if (result == null) result = caseSElement(sLinkNode);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.STREE_NODE:
            {
                STreeNode sTreeNode = (STreeNode)theEObject;
                T result = caseSTreeNode(sTreeNode);
                if (result == null) result = caseSIdentifiedElement(sTreeNode);
                if (result == null) result = caseSNamedElement(sTreeNode);
                if (result == null) result = caseSElement(sTreeNode);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SCHART_BLOCK:
            {
                SChartBlock sChartBlock = (SChartBlock)theEObject;
                T result = caseSChartBlock(sChartBlock);
                if (result == null) result = caseSSubsystem(sChartBlock);
                if (result == null) result = caseSBlock(sChartBlock);
                if (result == null) result = caseSNamedElement(sChartBlock);
                if (result == null) result = caseSElement(sChartBlock);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.SCHART_SYSTEM:
            {
                SChartSystem sChartSystem = (SChartSystem)theEObject;
                T result = caseSChartSystem(sChartSystem);
                if (result == null) result = caseSSystem(sChartSystem);
                if (result == null) result = caseSNamedElement(sChartSystem);
                if (result == null) result = caseSElement(sChartSystem);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case StateflowPackage.STARGET:
            {
                STarget sTarget = (STarget)theEObject;
                T result = caseSTarget(sTarget);
                if (result == null) result = caseSIdentifiedElement(sTarget);
                if (result == null) result = caseSNamedElement(sTarget);
                if (result == null) result = caseSElement(sTarget);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SStateflow</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SStateflow</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSStateflow(SStateflow object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SMachine</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SMachine</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSMachine(SMachine object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SChart</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SChart</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSChart(SChart object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SState</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SState</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSState(SState object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SJunction</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SJunction</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSJunction(SJunction object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>STransition</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>STransition</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSTransition(STransition object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SData</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SData</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSData(SData object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SEvent</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SEvent</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSEvent(SEvent object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SInstance</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SInstance</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSInstance(SInstance object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SConnect Node</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SConnect Node</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSConnectNode(SConnectNode object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>SIdentified Element</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SIdentified Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSIdentifiedElement(SIdentifiedElement object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>SLink Node</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SLink Node</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSLinkNode(SLinkNode object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>STree Node</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>STree Node</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSTreeNode(STreeNode object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>SChart Block</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SChart Block</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSChartBlock(SChartBlock object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SChart System</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SChart System</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSChartSystem(SChartSystem object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>STarget</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>STarget</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSTarget(STarget object) {
        return null;
    }

				/**
     * Returns the result of interpreting the object as an instance of '<em>SElement</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SElement</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSElement(SElement object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>SNamed Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SNamed Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSNamedElement(SNamedElement object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>SBlock</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SBlock</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSBlock(SBlock object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>SSubsystem</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SSubsystem</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSSubsystem(SSubsystem object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>SSystem</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>SSystem</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSSystem(SSystem object)
    {
        return null;
    }

                /**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
	@Override
	public T defaultCase(EObject object) {
        return null;
    }

} //StateflowSwitch
