/**
 */
package com.engisis.sysphs.language.simulink;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import com.engisis.sysphs.language.simscape.SConnectionPortBlock;
import com.engisis.sysphs.language.simscape.SLocation;

import edu.emory.mathcs.backport.java.util.Collections;

/**
 * <!-- begin-user-doc --> A representation of the model object
 * '<em><b>SSystem</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.engisis.sysphs.language.simulink.SSystem#getOwnedLines <em>Owned Lines</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simulink.SSystem#getOwningSubsystem <em>Owning Subsystem</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simulink.SSystem#getOwningModel <em>Owning Model</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simulink.SSystem#getSystemparameters <em>Systemparameters</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simulink.SSystem#getSid <em>Sid</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simulink.SSystem#getOwnedBlocks <em>Owned Blocks</em>}</li>
 * </ul>
 *
 * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSSystem()
 * @model kind="class"
 * @generated
 */
public class SSystem extends SNamedElement
{
    /**
     * The cached value of the '{@link #getOwnedLines() <em>Owned Lines</em>}' containment reference list.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getOwnedLines()
     * @generated
     * @ordered
     */
    protected EList<SLine> ownedLines;
    
    /**
     * The cached value of the '{@link #getSystemparameters()
     * <em>Systemparameters</em>}' containment reference list. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getSystemparameters()
     * @generated
     * @ordered
     */
    protected EList<SSystemParameter> systemparameters;
    
    /**
     * The default value of the '{@link #getSid() <em>Sid</em>}' attribute. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getSid()
     * @generated
     * @ordered
     */
    protected static final int SID_EDEFAULT = 0;
    
    /**
     * The cached value of the '{@link #getSid() <em>Sid</em>}' attribute. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #getSid()
     * @generated
     * @ordered
     */
    protected int sid = SID_EDEFAULT;
    
    /**
     * The cached value of the '{@link #getOwnedBlocks() <em>Owned Blocks</em>}' containment reference list.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getOwnedBlocks()
     * @generated
     * @ordered
     */
    protected EList<SBlock> ownedBlocks;
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    protected SSystem()
    {
        super();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return SimulinkPackage.Literals.SSYSTEM;
    }
    
    /**
     * Returns the value of the '<em><b>Owned Lines</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simulink.SLine}.
     * <!-- begin-user-doc
     * -->
     * <p>
     * If the meaning of the '<em>Owned Lines</em>' containment reference list
     * isn't clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owned Lines</em>' containment reference list.
     * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSSystem_OwnedLines()
     * @model containment="true"
     * @generated
     */
    public EList<SLine> getOwnedLines()
    {
        if (ownedLines == null)
        {
            ownedLines = new BasicInternalEList<SLine>(SLine.class);
        }
        return ownedLines;
    }
    
    /**
     * Returns the value of the '<em><b>Owning Subsystem</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.simulink.SSubsystem#getSystem <em>System</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owning Subsystem</em>' container reference
     * isn't clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owning Subsystem</em>' container reference.
     * @see #setOwningSubsystem(SSubsystem)
     * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSSystem_OwningSubsystem()
     * @see com.engisis.sysphs.language.simulink.SSubsystem#getSystem
     * @model opposite="system" transient="false"
     * @generated
     */
    public SSubsystem getOwningSubsystem()
    {
        if (eContainerFeatureID() != SimulinkPackage.SSYSTEM__OWNING_SUBSYSTEM) return null;
        return (SSubsystem)eInternalContainer();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetOwningSubsystem(SSubsystem newOwningSubsystem, NotificationChain msgs)
    {
        msgs = eBasicSetContainer((InternalEObject)newOwningSubsystem, SimulinkPackage.SSYSTEM__OWNING_SUBSYSTEM, msgs);
        return msgs;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simulink.SSystem#getOwningSubsystem <em>Owning Subsystem</em>}' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Owning Subsystem</em>' container reference.
     * @see #getOwningSubsystem()
     * @generated
     */
    public void setOwningSubsystem(SSubsystem newOwningSubsystem)
    {
        if (newOwningSubsystem != eInternalContainer() || (eContainerFeatureID() != SimulinkPackage.SSYSTEM__OWNING_SUBSYSTEM && newOwningSubsystem != null))
        {
            if (EcoreUtil.isAncestor(this, newOwningSubsystem))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newOwningSubsystem != null)
                msgs = ((InternalEObject)newOwningSubsystem).eInverseAdd(this, SimulinkPackage.SSUBSYSTEM__SYSTEM, SSubsystem.class, msgs);
            msgs = basicSetOwningSubsystem(newOwningSubsystem, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }
    
    /**
     * Returns the value of the '<em><b>Owning Model</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.simulink.SModel#getSystem <em>System</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owning Model</em>' container reference isn't
     * clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owning Model</em>' container reference.
     * @see #setOwningModel(SModel)
     * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSSystem_OwningModel()
     * @see com.engisis.sysphs.language.simulink.SModel#getSystem
     * @model opposite="system" transient="false"
     * @generated
     */
    public SModel getOwningModel()
    {
        if (eContainerFeatureID() != SimulinkPackage.SSYSTEM__OWNING_MODEL) return null;
        return (SModel)eInternalContainer();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetOwningModel(SModel newOwningModel, NotificationChain msgs)
    {
        msgs = eBasicSetContainer((InternalEObject)newOwningModel, SimulinkPackage.SSYSTEM__OWNING_MODEL, msgs);
        return msgs;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simulink.SSystem#getOwningModel <em>Owning Model</em>}' container reference.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @param value the new value of the '<em>Owning Model</em>' container reference.
     * @see #getOwningModel()
     * @generated
     */
    public void setOwningModel(SModel newOwningModel)
    {
        if (newOwningModel != eInternalContainer() || (eContainerFeatureID() != SimulinkPackage.SSYSTEM__OWNING_MODEL && newOwningModel != null))
        {
            if (EcoreUtil.isAncestor(this, newOwningModel))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newOwningModel != null)
                msgs = ((InternalEObject)newOwningModel).eInverseAdd(this, SimulinkPackage.SMODEL__SYSTEM, SModel.class, msgs);
            msgs = basicSetOwningModel(newOwningModel, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }
    
    /**
     * Returns the value of the '<em><b>Systemparameters</b></em>' containment
     * reference list. The list contents are of type
     * {@link com.engisis.sysphs.language.simulink.SSystemParameter}. <!--
     * begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Systemparameters</em>' containment reference
     * list isn't clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @return the value of the '<em>Systemparameters</em>' containment
     *         reference list.
     * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSSystem_Systemparameters()
     * @model containment="true"
     * @generated
     */
    public EList<SSystemParameter> getSystemparameters()
    {
        if (systemparameters == null)
        {
            systemparameters = new BasicInternalEList<SSystemParameter>(SSystemParameter.class);
        }
        return systemparameters;
    }
    
    /**
     * Returns the value of the '<em><b>Sid</b></em>' attribute. <!--
     * begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Sid</em>' attribute isn't clear, there really
     * should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @return the value of the '<em>Sid</em>' attribute.
     * @see #setSid(int)
     * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSSystem_Sid()
     * @model
     * @generated
     */
    public int getSid()
    {
        return sid;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simulink.SSystem#getSid <em>Sid</em>}' attribute.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @param value the new value of the '<em>Sid</em>' attribute.
     * @see #getSid()
     * @generated
     */
    public void setSid(int newSid)
    {
        sid = newSid;
    }
    
    /**
     * Returns the value of the '<em><b>Owned Blocks</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simulink.SBlock}.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.simulink.SBlock#getOwningSystem <em>Owning System</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owned Blocks</em>' containment reference isn't
     * clear, there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owned Blocks</em>' containment reference list.
     * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSSystem_OwnedBlocks()
     * @see com.engisis.sysphs.language.simulink.SBlock#getOwningSystem
     * @model opposite="owningSystem" containment="true"
     * @generated
     */
    public EList<SBlock> getOwnedBlocks()
    {
        if (ownedBlocks == null)
        {
            ownedBlocks = new BasicInternalEList<SBlock>(SBlock.class);
        }
        return ownedBlocks;
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case SimulinkPackage.SSYSTEM__OWNING_SUBSYSTEM:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetOwningSubsystem((SSubsystem)otherEnd, msgs);
            case SimulinkPackage.SSYSTEM__OWNING_MODEL:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetOwningModel((SModel)otherEnd, msgs);
            case SimulinkPackage.SSYSTEM__OWNED_BLOCKS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getOwnedBlocks()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case SimulinkPackage.SSYSTEM__OWNED_LINES:
                return ((InternalEList<?>)getOwnedLines()).basicRemove(otherEnd, msgs);
            case SimulinkPackage.SSYSTEM__OWNING_SUBSYSTEM:
                return basicSetOwningSubsystem(null, msgs);
            case SimulinkPackage.SSYSTEM__OWNING_MODEL:
                return basicSetOwningModel(null, msgs);
            case SimulinkPackage.SSYSTEM__SYSTEMPARAMETERS:
                return ((InternalEList<?>)getSystemparameters()).basicRemove(otherEnd, msgs);
            case SimulinkPackage.SSYSTEM__OWNED_BLOCKS:
                return ((InternalEList<?>)getOwnedBlocks()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs)
    {
        switch (eContainerFeatureID())
        {
            case SimulinkPackage.SSYSTEM__OWNING_SUBSYSTEM:
                return eInternalContainer().eInverseRemove(this, SimulinkPackage.SSUBSYSTEM__SYSTEM, SSubsystem.class, msgs);
            case SimulinkPackage.SSYSTEM__OWNING_MODEL:
                return eInternalContainer().eInverseRemove(this, SimulinkPackage.SMODEL__SYSTEM, SModel.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case SimulinkPackage.SSYSTEM__OWNED_LINES:
                return getOwnedLines();
            case SimulinkPackage.SSYSTEM__OWNING_SUBSYSTEM:
                return getOwningSubsystem();
            case SimulinkPackage.SSYSTEM__OWNING_MODEL:
                return getOwningModel();
            case SimulinkPackage.SSYSTEM__SYSTEMPARAMETERS:
                return getSystemparameters();
            case SimulinkPackage.SSYSTEM__SID:
                return getSid();
            case SimulinkPackage.SSYSTEM__OWNED_BLOCKS:
                return getOwnedBlocks();
        }
        return super.eGet(featureID, resolve, coreType);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case SimulinkPackage.SSYSTEM__OWNED_LINES:
                getOwnedLines().clear();
                getOwnedLines().addAll((Collection<? extends SLine>)newValue);
                return;
            case SimulinkPackage.SSYSTEM__OWNING_SUBSYSTEM:
                setOwningSubsystem((SSubsystem)newValue);
                return;
            case SimulinkPackage.SSYSTEM__OWNING_MODEL:
                setOwningModel((SModel)newValue);
                return;
            case SimulinkPackage.SSYSTEM__SYSTEMPARAMETERS:
                getSystemparameters().clear();
                getSystemparameters().addAll((Collection<? extends SSystemParameter>)newValue);
                return;
            case SimulinkPackage.SSYSTEM__SID:
                setSid((Integer)newValue);
                return;
            case SimulinkPackage.SSYSTEM__OWNED_BLOCKS:
                getOwnedBlocks().clear();
                getOwnedBlocks().addAll((Collection<? extends SBlock>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case SimulinkPackage.SSYSTEM__OWNED_LINES:
                getOwnedLines().clear();
                return;
            case SimulinkPackage.SSYSTEM__OWNING_SUBSYSTEM:
                setOwningSubsystem((SSubsystem)null);
                return;
            case SimulinkPackage.SSYSTEM__OWNING_MODEL:
                setOwningModel((SModel)null);
                return;
            case SimulinkPackage.SSYSTEM__SYSTEMPARAMETERS:
                getSystemparameters().clear();
                return;
            case SimulinkPackage.SSYSTEM__SID:
                setSid(SID_EDEFAULT);
                return;
            case SimulinkPackage.SSYSTEM__OWNED_BLOCKS:
                getOwnedBlocks().clear();
                return;
        }
        super.eUnset(featureID);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case SimulinkPackage.SSYSTEM__OWNED_LINES:
                return ownedLines != null && !ownedLines.isEmpty();
            case SimulinkPackage.SSYSTEM__OWNING_SUBSYSTEM:
                return getOwningSubsystem() != null;
            case SimulinkPackage.SSYSTEM__OWNING_MODEL:
                return getOwningModel() != null;
            case SimulinkPackage.SSYSTEM__SYSTEMPARAMETERS:
                return systemparameters != null && !systemparameters.isEmpty();
            case SimulinkPackage.SSYSTEM__SID:
                return sid != SID_EDEFAULT;
            case SimulinkPackage.SSYSTEM__OWNED_BLOCKS:
                return ownedBlocks != null && !ownedBlocks.isEmpty();
        }
        return super.eIsSet(featureID);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sid: ");
        result.append(sid);
        result.append(')');
        return result.toString();
    }
    
    public List<SInport> getInports()
    {
        List<SInport> inports = new LinkedList<SInport>();
        for (SBlock sblock : getOwnedBlocks())
            if (sblock instanceof SInport)
                inports.add((SInport) sblock);
        return Collections.unmodifiableList(inports);
    }
    
    public List<SOutport> getOutports()
    {
        List<SOutport> outports = new LinkedList<SOutport>();
        for (SBlock sblock : getOwnedBlocks())
            if (sblock instanceof SOutport)
                outports.add((SOutport) sblock);
        return Collections.unmodifiableList(outports);
    }
    
    public List<SConnectionPortBlock> getLConnectionPorts()
    {
        List<SConnectionPortBlock> ret = new LinkedList<SConnectionPortBlock>();
        for (SBlock sblock : getOwnedBlocks())
            if (sblock instanceof SConnectionPortBlock)
            {
                SConnectionPortBlock scpb = (SConnectionPortBlock) sblock;
                if (scpb.getLocation() == SLocation.LEFT)
                    ret.add(scpb);
            }
        return Collections.unmodifiableList(ret);
    }
    
    public List<SConnectionPortBlock> getRConnectionPorts()
    {
        List<SConnectionPortBlock> ret = new LinkedList<SConnectionPortBlock>();
        for (SBlock sblock : getOwnedBlocks())
            if (sblock instanceof SConnectionPortBlock)
            {
                SConnectionPortBlock scpb = (SConnectionPortBlock) sblock;
                if (scpb.getLocation() == SLocation.RIGHT)
                    ret.add(scpb);
            }
        return Collections.unmodifiableList(ret);
    }
    
    public String getPath()
    {
        // Can't be a model
        if (getOwningSubsystem() != null)
            return getOwningSubsystem().getPath();
        return "";
    }
    
    public SLine getLine(SBlock sourceBlock, SBlock sourcePort)
    {
        for (SLine sline : getOwnedLines())
            if (sline != null && sline.getSource() != null && sline.getSource().getBlock() == sourceBlock
                    && sline.getSource().getPort() == sourcePort)
                return sline;
        SLine ret = SimulinkFactory.eINSTANCE.createSLine();
        SConnectionPoint ssource = SimulinkFactory.eINSTANCE.createSConnectionPoint();
        ssource.setBlock(sourceBlock);
        ssource.setPort(sourcePort);
        ret.setSource(ssource);
        getOwnedLines().add(ret);
        return ret;
    }
    
    public String generateSID()
    {
        if (getOwningSubsystem() != null && getOwningSubsystem().getOwningSystem() != null)
            return getOwningSubsystem().getOwningSystem().generateSID();
        return String.valueOf(++sid);
    }
    
    public SBlock getBlockByName(String[] name)
    {
        if (name == null || name.length == 0)
            return null;
        for (SBlock sb : getOwnedBlocks())
        {
            SBlock ret = sb.getBlockByName(name);
            if (ret != null)
                return ret;
        }
        return null;
    }
    
} // SSystem
