/**
 */
package com.engisis.sysphs.language.simulink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.BasicInternalEList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>SFunction</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.engisis.sysphs.language.simulink.SFunction#getAssignments <em>Assignments</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simulink.SFunction#getVariables <em>Variables</em>}</li>
 * </ul>
 *
 * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSFunction()
 * @model kind="class" abstract="true"
 * @generated
 */
public abstract class SFunction extends SSystem {
	/**
     * The cached value of the '{@link #getAssignments() <em>Assignments</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getAssignments()
     * @generated
     * @ordered
     */
	protected EList<SFVariableAssignment> assignments;

	/**
     * The cached value of the '{@link #getVariables() <em>Variables</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getVariables()
     * @generated
     * @ordered
     */
	protected EList<SFVariable> variables;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SFunction() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return SimulinkPackage.Literals.SFUNCTION;
    }

	/**
     * Returns the value of the '<em><b>Assignments</b></em>' reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simulink.SFVariableAssignment}.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Assignments</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Assignments</em>' reference list.
     * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSFunction_Assignments()
     * @model
     * @generated
     */
	public EList<SFVariableAssignment> getAssignments() {
        if (assignments == null)
        {
            assignments = new BasicInternalEList<SFVariableAssignment>(SFVariableAssignment.class);
        }
        return assignments;
    }

	/**
     * Returns the value of the '<em><b>Variables</b></em>' reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simulink.SFVariable}.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Variables</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Variables</em>' reference list.
     * @see com.engisis.sysphs.language.simulink.SimulinkPackage#getSFunction_Variables()
     * @model
     * @generated
     */
	public EList<SFVariable> getVariables() {
        if (variables == null)
        {
            variables = new BasicInternalEList<SFVariable>(SFVariable.class);
        }
        return variables;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID)
        {
            case SimulinkPackage.SFUNCTION__ASSIGNMENTS:
                return getAssignments();
            case SimulinkPackage.SFUNCTION__VARIABLES:
                return getVariables();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID)
        {
            case SimulinkPackage.SFUNCTION__ASSIGNMENTS:
                getAssignments().clear();
                getAssignments().addAll((Collection<? extends SFVariableAssignment>)newValue);
                return;
            case SimulinkPackage.SFUNCTION__VARIABLES:
                getVariables().clear();
                getVariables().addAll((Collection<? extends SFVariable>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID)
        {
            case SimulinkPackage.SFUNCTION__ASSIGNMENTS:
                getAssignments().clear();
                return;
            case SimulinkPackage.SFUNCTION__VARIABLES:
                getVariables().clear();
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID)
        {
            case SimulinkPackage.SFUNCTION__ASSIGNMENTS:
                return assignments != null && !assignments.isEmpty();
            case SimulinkPackage.SFUNCTION__VARIABLES:
                return variables != null && !variables.isEmpty();
        }
        return super.eIsSet(featureID);
    }

	public List<SFInputVariable> getInputs()
    {
        List<SFInputVariable> ret = new ArrayList<SFInputVariable>();
        for (SFVariable svar : getVariables())
            if (svar instanceof SFInputVariable)
                ret.add((SFInputVariable)svar);
        return Collections.unmodifiableList(ret);
    }
    
    public List<SFContinuousStateVariable> getContinuousStates()
    {
        List<SFContinuousStateVariable> ret = new ArrayList<SFContinuousStateVariable>();
        for (SFVariable svar : getVariables())
            if (svar instanceof SFContinuousStateVariable)
                ret.add((SFContinuousStateVariable)svar);
        return Collections.unmodifiableList(ret);
    }
    
    public List<SFDiscreteStateVariable> getDiscreteStates()
    {
        List<SFDiscreteStateVariable> ret = new ArrayList<SFDiscreteStateVariable>();
        for (SFVariable svar : getVariables())
            if (svar instanceof SFDiscreteStateVariable)
                ret.add((SFDiscreteStateVariable)svar);
        return Collections.unmodifiableList(ret);
    }
    
    public List<SFDWorkVariable> getDWorkStates()
    {
        List<SFDWorkVariable> ret = new ArrayList<SFDWorkVariable>();
        for (SFVariable svar : getVariables())
            if (svar instanceof SFDWorkVariable)
                ret.add((SFDWorkVariable)svar);
        return Collections.unmodifiableList(ret);
    }
    
    public List<SFOutputVariable> getOutputs()
    {
        List<SFOutputVariable> ret = new ArrayList<SFOutputVariable>();
        for (SFVariable svar : getVariables())
            if (svar instanceof SFOutputVariable)
                ret.add((SFOutputVariable)svar);
        return Collections.unmodifiableList(ret);
    }
    
    public List<SFParameter> getParameters()
    {
        List<SFParameter> ret = new ArrayList<SFParameter>();
        for (SFVariable svar : getVariables())
            if (svar instanceof SFParameter)
                ret.add((SFParameter)svar);
        return Collections.unmodifiableList(ret);
    }

} // SFunction
