/**
 */
package com.engisis.sysphs.language.simscape;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import com.engisis.sysphs.language.simulink.SNamedElement;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>SDomain</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.engisis.sysphs.language.simscape.SDomain#getVariables <em>Variables</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SDomain#getParameters <em>Parameters</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.simscape.SDomain#getOwningPackage <em>Owning Package</em>}</li>
 * </ul>
 *
 * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSDomain()
 * @model kind="class"
 * @generated
 */
public class SDomain extends SNamedElement
{
    /**
     * The cached value of the '{@link #getVariables() <em>Variables</em>}' containment reference list.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getVariables()
     * @generated
     * @ordered
     */
    protected EList<SVariable> variables;
    
    /**
     * The cached value of the '{@link #getParameters() <em>Parameters</em>}' containment reference list.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @see #getParameters()
     * @generated
     * @ordered
     */
    protected EList<SParameter> parameters;
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    protected SDomain()
    {
        super();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return SimscapePackage.Literals.SDOMAIN;
    }
    
    /**
     * Returns the value of the '<em><b>Variables</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simscape.SVariable}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Variables</em>' reference isn't clear, there
     * really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Variables</em>' containment reference list.
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSDomain_Variables()
     * @model containment="true"
     * @generated
     */
    public EList<SVariable> getVariables()
    {
        if (variables == null)
        {
            variables = new BasicInternalEList<SVariable>(SVariable.class);
        }
        return variables;
    }
    
    /**
     * Returns the value of the '<em><b>Parameters</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.simscape.SParameter}.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Parameters</em>' reference isn't clear, there
     * really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Parameters</em>' containment reference list.
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSDomain_Parameters()
     * @model containment="true"
     * @generated
     */
    public EList<SParameter> getParameters()
    {
        if (parameters == null)
        {
            parameters = new BasicInternalEList<SParameter>(SParameter.class);
        }
        return parameters;
    }
    
    /**
     * Returns the value of the '<em><b>Owning Package</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.simscape.SPackage#getDomains <em>Domains</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owning Package</em>' reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owning Package</em>' container reference.
     * @see #setOwningPackage(SPackage)
     * @see com.engisis.sysphs.language.simscape.SimscapePackage#getSDomain_OwningPackage()
     * @see com.engisis.sysphs.language.simscape.SPackage#getDomains
     * @model opposite="domains" transient="false"
     * @generated
     */
    public SPackage getOwningPackage()
    {
        if (eContainerFeatureID() != SimscapePackage.SDOMAIN__OWNING_PACKAGE) return null;
        return (SPackage)eInternalContainer();
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetOwningPackage(SPackage newOwningPackage, NotificationChain msgs)
    {
        msgs = eBasicSetContainer((InternalEObject)newOwningPackage, SimscapePackage.SDOMAIN__OWNING_PACKAGE, msgs);
        return msgs;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.simscape.SDomain#getOwningPackage <em>Owning Package</em>}' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Owning Package</em>' container reference.
     * @see #getOwningPackage()
     * @generated
     */
    public void setOwningPackage(SPackage newOwningPackage)
    {
        if (newOwningPackage != eInternalContainer() || (eContainerFeatureID() != SimscapePackage.SDOMAIN__OWNING_PACKAGE && newOwningPackage != null))
        {
            if (EcoreUtil.isAncestor(this, newOwningPackage))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newOwningPackage != null)
                msgs = ((InternalEObject)newOwningPackage).eInverseAdd(this, SimscapePackage.SPACKAGE__DOMAINS, SPackage.class, msgs);
            msgs = basicSetOwningPackage(newOwningPackage, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID,
            NotificationChain msgs)
    {
        switch (featureID)
        {
            case SimscapePackage.SDOMAIN__OWNING_PACKAGE:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetOwningPackage((SPackage)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID,
            NotificationChain msgs)
    {
        switch (featureID)
        {
            case SimscapePackage.SDOMAIN__VARIABLES:
                return ((InternalEList<?>)getVariables()).basicRemove(otherEnd, msgs);
            case SimscapePackage.SDOMAIN__PARAMETERS:
                return ((InternalEList<?>)getParameters()).basicRemove(otherEnd, msgs);
            case SimscapePackage.SDOMAIN__OWNING_PACKAGE:
                return basicSetOwningPackage(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs)
    {
        switch (eContainerFeatureID())
        {
            case SimscapePackage.SDOMAIN__OWNING_PACKAGE:
                return eInternalContainer().eInverseRemove(this, SimscapePackage.SPACKAGE__DOMAINS, SPackage.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case SimscapePackage.SDOMAIN__VARIABLES:
                return getVariables();
            case SimscapePackage.SDOMAIN__PARAMETERS:
                return getParameters();
            case SimscapePackage.SDOMAIN__OWNING_PACKAGE:
                return getOwningPackage();
        }
        return super.eGet(featureID, resolve, coreType);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case SimscapePackage.SDOMAIN__VARIABLES:
                getVariables().clear();
                getVariables().addAll((Collection<? extends SVariable>)newValue);
                return;
            case SimscapePackage.SDOMAIN__PARAMETERS:
                getParameters().clear();
                getParameters().addAll((Collection<? extends SParameter>)newValue);
                return;
            case SimscapePackage.SDOMAIN__OWNING_PACKAGE:
                setOwningPackage((SPackage)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case SimscapePackage.SDOMAIN__VARIABLES:
                getVariables().clear();
                return;
            case SimscapePackage.SDOMAIN__PARAMETERS:
                getParameters().clear();
                return;
            case SimscapePackage.SDOMAIN__OWNING_PACKAGE:
                setOwningPackage((SPackage)null);
                return;
        }
        super.eUnset(featureID);
    }
    
    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case SimscapePackage.SDOMAIN__VARIABLES:
                return variables != null && !variables.isEmpty();
            case SimscapePackage.SDOMAIN__PARAMETERS:
                return parameters != null && !parameters.isEmpty();
            case SimscapePackage.SDOMAIN__OWNING_PACKAGE:
                return getOwningPackage() != null;
        }
        return super.eIsSet(featureID);
    }
    
    public String getQualifiedName()
    {
        if (getOwningPackage() != null)
            return getOwningPackage().getQualifiedName() + "." + getName();
        return getName();
    }
    
    public SMember getMember(String name)
    {
    	if (name == null || name.isEmpty())
    		throw new IllegalArgumentException("you must provide a name");
    	for(SVariable svariable : getVariables())
    		if (svariable.getName().equals(name))
    			return svariable;
    	for(SParameter sparameter : getParameters())
    		if (sparameter.getName().equals(name))
    			return sparameter;
    	return null;
    }
    
} // SDomain
