grammar Modelica;

// taken from openmodelica grammar, then changed after Modelica 3.3 grammar

ALGORITHM	: 'algorithm'	;
AND			: 'and'	;
ANNOTATION	: 'annotation'	;
BLOCK		: 'block'	;
BREAK		: 'break'	;
CODE		: 'Code'		;
CLASS		: 'class'	;
CONNECT		: 'connect'	;
CONNECTOR	: 'connector'	;
CONSTANT	: 'constant'	;
CONSTRAINEDBY : 'constrainedby' ;
DISCRETE	: 'discrete'	;
DER         : 'der';
DOT         : '.';
EACH		: 'each'	;
ELSE		: 'else'	;
ELSEIF		: 'elseif'	;
ELSEWHEN	: 'elsewhen'	;
END			: 'end'		;
ENUMERATION	: 'enumeration'	;
EQUATION	: 'equation'	;
ENCAPSULATED	: 'encapsulated';
EXPANDABLE  : 'expandable';
EXTENDS		: 'extends'	;
EXTERNAL	: 'external'	;
FALSE		: 'false'	;
FINAL		: 'final'	;
FLOW		: 'flow'	;
FOR		: 'for'		;
FUNCTION	: 'function'	;
IF		: 'if'		;
IMPORT		: 'import'	;
IMPURE		: 'impure'	;
IN		: 'in'		;
INITIAL		: 'initial'	;
INNER		: 'inner'	;
INPUT		: 'input'	;
LOOP		: 'loop'	;
MODEL		: 'model'	;
NOT		: 'not'		;
OPERATOR	: 'operator'	;
OUTER		: 'outer'	;
OVERLOAD    : 'overload';
OR		: 'or'		;
OUTPUT		: 'output'	;
PACKAGE		: 'package'	;
PARAMETER	: 'parameter'	;
PARTIAL		: 'partial'	;
PROTECTED	: 'protected'	;
PUBLIC		: 'public'	;
PURE		: 'pure'	;
RECORD		: 'record'	;
REDECLARE	: 'redeclare'	;
REPLACEABLE	: 'replaceable'	;
RESULTS		: 'results'	;
RETURN		: 'return'  ;
STREAM		: 'stream'	;
THEN		: 'then'	;
TRUE		: 'true'	;
TYPE		: 'type'	;
UNSIGNED_REAL	: 'unsigned_real';
WHEN		: 'when'	;
WHILE		: 'while'	;
WITHIN		: 'within' 	;

LPAR		: '('	;
RPAR		: ')'	;
LBRACK		: '['	;
RBRACK		: ']'	;
LBRACE		: '{'	;
RBRACE		: '}'	;
EQUALS		: '='	;
ASSIGN		: ':='	;
PLUS		: '+'	;
MINUS		: '-'	;
STAR		: '*'	;
SLASH		: '/'	;
POWER		: '^'	;
PLUS_EW     : '.+'  ;
MINUS_EW	: '.-'	;
STAR_EW		: '.*'	;
SLASH_EW	: './'	;
POWER_EW	: '.^'	;

COMMA		: ','	;
LESS		: '<'	;
LESSEQ		: '<='	;
GREATER		: '>'	;
GREATEREQ	: '>='	;
EQEQ		: '=='	;
LESSGT		: '<>'	;
COLON		: ':'	;
SEMICOLON	: ';'	;

WS  :  [ \t\r\n\u000C]+ -> skip
    ;

IDENT:
		NONDIGIT (NONDIGIT | DIGIT)* | QIDENT
		;

QIDENT:
         '\'' (QCHAR | SESCAPE) (QCHAR | SESCAPE)* '\'' ;

fragment
NONDIGIT : 	[a-zA-Z_];

STRING : '"' (SCHAR | SESCAPE)* '"';

fragment
SCHAR :	~["\\];

fragment
QCHAR :	DIGIT | NONDIGIT|'!' | '#' | '$' | '%' | '&' | '(' | ')' | '*' | '+' | 
        ',"' | '-' | '.' | '/' | ':' | ';' | '<' | '>' | '=' | '?' | '@' | '[' |
        ']' | '^' | '{' | '}' | '|' | '~' | ' ';

fragment
SESCAPE : '\\' ('\\' | '"' | '\'' | '?' | 'a' | 'b' | 'f' | 'n' | 'r' | 't' | 'v');

fragment
DIGIT : [0-9];

fragment
UNSIGNED_INTEGER :
        (DIGIT)+;

UNSIGNED_NUMBER : UNSIGNED_INTEGER ('.' UNSIGNED_INTEGER? )?
                  (('e'|'E') ('+' | '-')? UNSIGNED_INTEGER)?;

COMMENT
    :   '/*' .*? '*/' -> skip
    ;

LINE_COMMENT
    :   '//' ~[\r\n]* -> skip
    ;

// B.2

stored_definition :
		(WITHIN (name_path)? SEMICOLON)?
		((FINAL)? class_definition SEMICOLON)*
		EOF
		;

class_definition :
		(ENCAPSULATED)? class_prefixes class_specifier
		;

class_prefixes :
		(PARTIAL)? 
        ( CLASS | MODEL | (OPERATOR)? RECORD | BLOCK | ( EXPANDABLE )? CONNECTOR | 
          TYPE | PACKAGE | (PURE | IMPURE)? (OPERATOR)? FUNCTION )
		;

class_specifier:
        IDENT string_comment? composition END IDENT |
        IDENT EQUALS base_prefix name_path ( array_subscripts )? ( class_modification )? string_comment? annotation?|
        IDENT EQUALS ENUMERATION LPAR (enum_list? | COLON) RPAR string_comment? annotation?|
        IDENT EQUALS DER LPAR name_path COMMA IDENT (COMMA IDENT)* RPAR string_comment? annotation?|
        EXTENDS IDENT (class_modification)? string_comment? composition END IDENT
        ;

base_prefix:
		type_prefix
		;

name_list:
		name_path (COMMA name_path)*
		;

enum_list :
		enumeration_literal ( COMMA enumeration_literal)*
		;

enumeration_literal :
		IDENT string_comment? annotation?
		;

composition :
		element_list
		(	PUBLIC element_list|
			PROTECTED element_list|
                        equation_section|
                        algorithm_section
                )*
		( EXTERNAL
                    ( language_specification )?
                    ( external_function_call )?
                    ( annotation )? SEMICOLON
                    ( annotation SEMICOLON )? )?
		;

language_specification :
		STRING
		;

external_function_call :
		( component_reference EQUALS )?
		IDENT LPAR ( expression_list )? RPAR
		;

element_list :
		(element SEMICOLON)*
		;

element :
			import_clause
		|	extends_clause
		|	(REDECLARE)? (FINAL)? (INNER)? (OUTER)?
		(	(class_definition | component_clause)
			|(REPLACEABLE ( class_definition | component_clause )
				(constraining_clause string_comment? annotation?)?
			 )
		)
		;

import_clause :
		IMPORT ((IDENT EQUALS name_path) | 
                (name_path (DOT (STAR|(LBRACE import_list RBRACE)))?)) string_comment? annotation?
		;

import_list :
                IDENT (COMMA IDENT)?;

extends_clause :
		EXTENDS name_path class_modification? annotation?
		;

constraining_clause :
		CONSTRAINEDBY name_path class_modification?
		;

component_clause :
		type_prefix type_specifier array_subscripts? component_list
		;

type_prefix :
		(FLOW|STREAM)?		
		(DISCRETE|PARAMETER|CONSTANT)?
		(INPUT|OUTPUT)?
		;

type_specifier :
		name_path
		;

component_list :
		component_declaration (COMMA component_declaration)*
		;

component_declaration :
		declaration conditional_attribute? string_comment? annotation?
		;

conditional_attribute:
        IF expression
        ;

declaration :
		IDENT array_subscripts? modification?
		;

modification :
		(	class_modification ( EQUALS expression )?
		|	EQUALS expression
		|	ASSIGN expression
		)
		;

class_modification :
		LPAR argument_list? RPAR
		;

argument_list :
		argument (COMMA argument)*
		;

argument :
		(element_modification_or_replaceable
		| element_redeclaration
		)
		;

element_modification_or_replaceable:
        EACH? FINAL? (element_modification | element_replaceable)
    ;

element_modification :
		component_reference modification? string_comment?
	;

element_redeclaration :
		REDECLARE EACH? FINAL?
		(	(short_class_definition | component_clause1) | element_replaceable )
		;

element_replaceable:
        REPLACEABLE ( short_class_definition | component_clause1 )
				(constraining_clause)?
    ;
component_clause1 :
		type_prefix type_specifier component_declaration1
		;

component_declaration1 :
        declaration string_comment? annotation?
    ;

short_class_definition : 
                           class_prefixes IDENT EQUALS
                           (base_prefix name_path array_subscripts? class_modification? string_comment? annotation?)|
                           (ENUMERATION LBRACE (enum_list|COLON) RBRACE string_comment? annotation?);

equation_section:
                    INITIAL? EQUATION (equation SEMICOLON)*;

algorithm_section:
                    INITIAL? ALGORITHM (statement SEMICOLON)*;


equation :
		(   simple_expression EQUALS expression
		|	if_equation
		|	for_equation
		|	connect_clause
		|	when_equation
		|   component_reference function_call_args
		)
		string_comment? annotation?
		;

statement :
		(   simple_expression ((ASSIGN expression) |function_call_args)
		|	LPAR expression_list RPAR ASSIGN component_reference function_call_args
        |       BREAK
        |       RETURN
		|	if_statement
		|	for_statement
		|	while_statement
		|	when_statement
		)
		string_comment? annotation?
		;

if_equation :
		IF expression THEN (equation SEMICOLON)*
                (ELSEIF expression THEN (equation SEMICOLON)*)*
                (ELSE (equation SEMICOLON)* )?
		END IF
		;

if_statement :
		IF expression THEN (statement SEMICOLON)*
                (ELSEIF expression THEN (statement SEMICOLON)*)*
                (ELSE (statement SEMICOLON)* )?
		END IF
		;

for_equation :
		FOR for_indices LOOP
		(equation SEMICOLON)*
		END FOR
		;

for_statement :
		FOR for_indices LOOP
		(statement SEMICOLON)*
		END FOR
		;

for_indices :
        for_index (COMMA for_index)*
    ;

for_index:
        IDENT (IN expression)?
;

while_statement :
		WHILE expression LOOP
		(statement SEMICOLON)*
		END WHILE
		;

when_equation :
		WHEN expression THEN (equation SEMICOLON)*
                ELSEWHEN expression THEN (equation SEMICOLON)*
		END WHEN
		;

when_statement :
		WHEN expression THEN (statement SEMICOLON)*
		ELSEWHEN expression THEN (statement SEMICOLON)*
		END WHEN
		;

connect_clause :
		CONNECT LPAR connector_ref COMMA connector_ref RPAR
		;

connector_ref :
		IDENT ( array_subscripts )? ( DOT IDENT ( array_subscripts )? )*
		;

expression :
		( simple_expression
                | IF expression THEN expression (ELSEIF expression THEN expression)* ELSE expression
		)
		;

simple_expression :
		logical_expression
		( COLON logical_expression
			( COLON logical_expression
			)?
		)?
		;

logical_expression :
		logical_term ( OR logical_term )*
		;

logical_term :
		logical_factor ( AND logical_factor )*
		;

logical_factor :
		( NOT )? relation
		;

relation :
		arithmetic_expression ( rel_op arithmetic_expression )?
		;

rel_op :
		( LESS | LESSEQ | GREATER | GREATEREQ | EQEQ | LESSGT )
		;

arithmetic_expression :
		add_op? term (add_op term)*
		;

add_op :
           PLUS|MINUS|PLUS_EW|MINUS_EW;

term :
		factor ( mul_op factor )*
		;

mul_op:
          STAR | SLASH | STAR_EW | SLASH_EW;

factor :
		primary ( ( POWER | POWER_EW ) primary )?
		;

primary :
		( UNSIGNED_NUMBER
		| STRING
		| FALSE
		| TRUE
		| (name_path |DER|INITIAL) function_call_args
        | component_reference
		| LPAR output_expression_list RPAR
		| LBRACK expression_list (SEMICOLON expression_list)* RBRACK
		| LBRACE function_arguments RBRACE
		| END
		)
    ;

name_path :
		IDENT (DOT IDENT)*
		;

component_reference :
		DOT? IDENT array_subscripts? (DOT IDENT array_subscripts?)*
		;

function_call_args :
		LPAR function_arguments? RPAR
		;

function_arguments :
                       (function_argument ((COMMA function_arguments)|(FOR for_indices) )?)|
                       named_arguments
		;

named_arguments :
		named_argument ( COMMA named_argument)*
		;

named_argument :
		IDENT EQUALS function_argument
		;

function_argument:
                     (FUNCTION IDENT LBRACE named_arguments? RBRACE)|expression;

output_expression_list:
                          expression? (COMMA expression?)*;

expression_list :
		expression (COMMA expression_list)*
		;

array_subscripts :
		LBRACK subscript ( COMMA subscript )* RBRACK
	;

subscript :
		expression | COLON
		;

string_comment :
		STRING (PLUS STRING)+
;

annotation :
		ANNOTATION class_modification
		;
