package com.engisis.sysphs.test;

import java.io.IOException;

import javax.xml.stream.XMLStreamException;

import org.apache.log4j.Logger;
import org.junit.Test;

import com.engisis.sysphs.SysMLToSimulationTranslationManager;
import com.engisis.xmiutil.UMLModelErrorException;

public class GenerationTest extends BaseTest
{
    static final Logger log = Logger.getLogger(GenerationTest.class);
    
    private String circuitblock = "TestCaseCircuit::Circuit";
    private String circuittemperatureblock = "TestCaseCircuitTemperature::CircuitTemperature";
    private String signalprocessorblock = "TestCaseSignalProcessor::SignalProcessor";
    private String signalprocessormdblock = "TestCaseSignalProcessor::SourceToSink";
    
    private String statemachineblock = "TestCaseStateMachine::StateMachineBlock";
    private String signalphysicalblock = "TestCaseSignalPhysical::SignalPhysicalSystem";
    private String filterblock = "TestCaseFilter::FilterSystem";
    private String pressuresystemblock = "TestCasePressureSystem::PressureSystem1";
    private String twotankssystemmd = "Data::ConnectedTanksddd";
    private String humidifiersystemblock = "TestCaseHumidifier::Environment";
    private String humidifiersystemmdblock = "TestCaseHumidifier::HumidifierSystem";
    private String SMblock = "Data::RootBlock";
    private String cruisecontrolblock = "Data::TotalSystem";
    private String cruisecontrolpaperblock = "Model::CruiseControlTotalSystemScenario1";
    
    private String newmappingsblock = "Data::System";
    private String signallibrarytestblock = "Data::Test::Test";
    private String circuitlibraryblock = "Data::Circuit";
    private String acclibraryblock = "Data::CircuitACCurrent";
    private String acvlibraryblock = "Data::CircuitACVoltage";
    private String dcclibraryblock = "Data::CircuitDCCurrent";
    private String dcvlibraryblock = "Data::CircuitDCVoltage";
    
    public GenerationTest()
    {
        super("MD");
    }
    
    @Test
    public void testCircuitSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/Circuit.xmi").getPath(), null);
        circuitSysML.setInputRootName(circuitblock);
        
        translateModelicaF(circuitSysML, getModelicaOptions(), "CirM");
        
        translateSimulinkF(circuitSysML, getSimscapeCreateOptions(), "CirCr");
        translateSimulinkF(circuitSysML, getSimscapeReuseOptions(), "CirRe");
    }
    
    @Test
    public void testCircuitMDSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CircuitMD.xmi").getPath(), null);
        circuitSysML.setInputRootName(circuitblock);
        
        translateModelicaFRF(circuitSysML, getModelicaOptions(), "MDCM");
        
        translateSimulinkFRF(circuitSysML, getSimscapeCreateOptions(), "MDCS");
    }
    
    /*
     * @Test public void testSignalProcessorUML() throws UMLModelErrorException,
     * IOException, XMLStreamException { SysML2Simulation signalprocessorUML =
     * new SysML2Simulation(GenerationTest.class.getResource(
     * "/UML/UseCaseSignalProcessor.xmi").getPath());
     * signalprocessorUML.setRootClass(signalprocessorblock);
     * 
     * roundtripModelica(signalprocessorUML, getModelicaOptions()1);
     * roundtripModelica(signalprocessorUML, getModelicaOptions()2);
     * 
     * roundtripSimulink(signalprocessorUML, getSimulinkOptions()); }
     */
    @Test
    public void testSignalProcessorSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalprocessorSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalProcessor.xmi").getPath(), null);
        signalprocessorSysML.setInputRootName(signalprocessorblock);
        
        translateModelicaF(signalprocessorSysML, getModelicaOptions(), "SPM");
        
        translateSimulinkF(signalprocessorSysML, getSimulinkOptions(), "SPSF2");
    }
    
    @Test
    public void testSignalProcessorMDSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalprocessorSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalProcessorMD.xmi").getPath(), null);
        signalprocessorSysML.setInputRootName(signalprocessormdblock);
        
        translateModelicaFRF(signalprocessorSysML, getModelicaOptions(), "MDSPM");
        
        translateSimulinkFRF(signalprocessorSysML, getSimulinkOptions(), "MDSPS");
    }
    
    @Test
    public void testFilterSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager filterSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/Filter.xmi").getPath(), null);
        filterSysML.setInputRootName(filterblock);
        
        translateModelicaF(filterSysML, getModelicaOptions(), "FM");
        
        translateSimulinkF(filterSysML, getSimulinkOptions(), "FSF2");
    }
    
    @Test
    public void testCircuitTemperatureSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuittemperatureSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CircuitTemperature.xmi").getPath(), null);
        circuittemperatureSysML.setInputRootName(circuittemperatureblock);
        
        translateModelicaF(circuittemperatureSysML, getModelicaOptions(), "CTM");
        
        translateSimulinkF(circuittemperatureSysML, getSimscapeCreateOptions(), "CTCr");
        translateSimulinkF(circuittemperatureSysML, getSimscapeReuseOptions(), "CTRe");
    }
    
    @Test
    public void testStateMachineSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager statemachineSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/StateMachine.xmi").getPath(), null);
        statemachineSysML.setInputRootName(statemachineblock);
        
        translateModelicaF(statemachineSysML, getModelicaOptions(), "SSM");
        translateSimulinkF(statemachineSysML, getSimulinkOptions(), "SSSF2");
    }
    
    @Test
    public void testPressureSystemSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager pressureSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/PressureSystem.xmi").getPath(), null);
        pressureSysML.setInputRootName(pressuresystemblock);
        
        translateModelicaF(pressureSysML, getModelicaOptions(), "PSM");
        translateSimulinkF(pressureSysML, getSimscapeCreateOptions(), "PSCr");
    }
    
    @Test
    public void testTwoTanksSystemMDSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager pressureSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/TwoTanksSystemMD.xmi").getPath(), null);
        pressureSysML.setInputRootName(twotankssystemmd);
        
        translateModelicaFRF(pressureSysML, getModelicaOptions(), "MDTTSM");
        translateSimulinkFRF(pressureSysML, getSimscapeCreateOptions(), "MDTTSS");
    }
    
    @Test
    public void testHumidifierSystemSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/HumidifierSystemLibrary.xmi").getPath(),
                null);
        humidifierSysML.setInputRootName(humidifiersystemblock);
        
        translateModelicaF(humidifierSysML, getModelicaOptions(), "HSM");
        translateSimulinkF(humidifierSysML, getSimulinkOptions(), "HSSF2");
    }
    
    @Test
    public void testHumidifierSystemMDSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/HumidifierSystemMD.xmi").getPath(), null);
        humidifierSysML.setInputRootName(humidifiersystemmdblock);
        
        translateModelicaFRF(humidifierSysML, getModelicaOptions(), "MDHSM");
        translateSimulinkFRF(humidifierSysML, getSimulinkOptions(), "MDHSS");
    }
    
    @Test
    public void testSignalPhysicalSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalphysical = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalPhysicalModel.xmi").getPath(),
                null);
        signalphysical.setInputRootName(signalphysicalblock);
        
        translateModelicaF(signalphysical, getModelicaOptions(), "S2MM");
        translateSimulinkF(signalphysical, getSimscapeCreateOptions(), "S2MCr");
    }
    
    @Test
    public void testSMSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SM.xmi").getPath(), null);
        sm.setInputRootName(SMblock);
        
        translateModelicaF(sm, getModelicaOptions(), "SMS");
        translateSimulinkF(sm, getSimulinkOptions(), "SMSF2");
    }
    
    @Test
    public void testCruiseControlSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CruiseControl.xmi").getPath(), null);
        sm.setInputRootName(cruisecontrolblock);
        
        translateModelicaF(sm, getModelicaOptions(), "CCM");
        translateSimulinkF(sm, getSimscapeCreateOptions(), "CCCr");
    }
    
    @Test
    public void testCruiseControlPaperSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CruiseControlPaper.xmi").getPath(), null);
        sm.setPreprocessing(true);
        sm.setInputRootName(cruisecontrolpaperblock);
        
        translateModelicaFRF(sm, getModelicaOptions(), "CCPM");
        translateSimulinkFRF(sm, getSimscapeCreateOptions(), "CCPCr");
    }
    
    @Test
    public void testCruiseControlPaperRoundtripSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CruiseControlPaper.xmi").getPath(), null);
        sm.setPreprocessing(true);
        sm.setInputRootName(cruisecontrolpaperblock);
        
        translateModelicaFR(sm, getModelicaOptions(), "CCPM");
        translateSimulinkFR(sm, getSimscapeCreateOptions(), "CCPCr");
    }
    
    @Test
    public void testNewMappingsSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/NewFeatures.xmi").getPath(), null);
        sm.setInputRootName(newmappingsblock);
        sm.setPreprocessing(true);
        
        translateModelicaF(sm, getModelicaOptions(), "NMN");
        translateSimulinkF(sm, getSimscapeCreateOptions(), "NMCr");
    }
    
    @Test
    public void testSignalLibraryTestSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalLibraryTest.xmi").getPath(), null);
        sm.setInputRootName(signallibrarytestblock);
        
        translateModelicaF(sm, getModelicaOptions(), "LTM");
        translateSimulinkF(sm, getSimulinkOptions(), "LTSF2");
    }
    
    @Test
    public void testCircuitLibraryTestSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CircuitLibrary.xmi").getPath(), null);
        sm.setInputRootName(circuitlibraryblock);
        translateModelicaF(sm, getModelicaOptions(), "CLM");
        translateSimulinkF(sm, getSimscapeReuseOptions(), "CLS");
    }
    
    @Test
    public void testPhysicalLibraryACCTestSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/PhysicalLibraryTest.xmi").getPath(),
                null);
        sm.setInputRootName(acclibraryblock);
        translateModelicaF(sm, getModelicaOptions(), "ACCM");
        translateSimulinkF(sm, getSimscapeReuseOptions(), "ACCS");
    }
    
    @Test
    public void testPhysicalLibraryACVTestSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/PhysicalLibraryTest.xmi").getPath(),
                null);
        sm.setInputRootName(acvlibraryblock);
        translateModelicaF(sm, getModelicaOptions(), "ACVM");
        translateSimulinkF(sm, getSimscapeReuseOptions(), "ACVS");
    }
    
    @Test
    public void testPhysicalLibraryDCCTestSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/PhysicalLibraryTest.xmi").getPath(),
                null);
        sm.setInputRootName(dcclibraryblock);
        translateModelicaF(sm, getModelicaOptions(), "DCCM");
        translateSimulinkF(sm, getSimscapeReuseOptions(), "DCCS");
    }
    
    @Test
    public void testPhysicalLibraryDCVTestSysML() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager sm = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/PhysicalLibraryTest.xmi").getPath(),
                null);
        sm.setInputRootName(dcvlibraryblock);
        translateModelicaF(sm, getModelicaOptions(), "DCVM");
        translateSimulinkF(sm, getSimscapeReuseOptions(), "DCVS");
    }
    
    @Test
    public void testSimulinkSF() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalprocessorSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalProcessor.xmi").getPath(), null);
        signalprocessorSysML.setInputRootName(signalprocessorblock);
        
        // roundtripSimulink(signalprocessorSysML, getSimulinkOptions(), "SSF");
        translateSimulinkFRF(signalprocessorSysML, getSimulinkOptions(), "SSF");
    }
    
    @Test
    public void testSimulinkSM() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/HumidifierSystemLibrary.xmi").getPath(),
                null);
        humidifierSysML.setInputRootName(humidifiersystemblock);
        
        // roundtripSimulink(humidifierSysML, getSimulinkOptions(), "SSM");
        translateSimulinkFRF(humidifierSysML, getSimulinkOptions(), "SSM");
    }
    
    @Test
    public void testSimulinkPI() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/Circuit.xmi").getPath(), null);
        circuitSysML.setInputRootName(circuitblock);
        
        // roundtripSimulink(circuitSysML, getSimscapeCreateOptions(), "SPI");
        translateSimulinkFRF(circuitSysML, getSimscapeCreateOptions(), "SPI");
    }
    
    @Test
    public void testSimulinkCC() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CruiseControl.xmi").getPath(), null);
        circuitSysML.setInputRootName(cruisecontrolblock);
        
        // roundtripSimulink(circuitSysML, getSimscapeCreateOptions(), "SPI");
        translateSimulinkFRF(circuitSysML, getSimscapeCreateOptions(), "SCC");
    }
    
    @Test
    public void testSimulinkHS() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/HumidifierSystemLibrary.xmi").getPath(),
                null);
        humidifierSysML.setInputRootName(humidifiersystemblock);
        
        translateSimulinkFRF(humidifierSysML, getSimulinkOptions(), "SHS");
    }
    
    @Test
    public void testModelicaSF() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager signalprocessorSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/SignalProcessor.xmi").getPath(), null);
        signalprocessorSysML.setInputRootName(signalprocessorblock);
        
        // roundtripModelica(signalprocessorSysML, getModelicaOptions(), "MSF");
        translateModelicaFRF(signalprocessorSysML, getModelicaOptions(), "MSF");
    }
    
    @Test
    public void testModelicaPI() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/Circuit.xmi").getPath(), null);
        circuitSysML.setInputRootName(circuitblock);
        
        // roundtripModelica(circuitSysML, getModelicaOptions(), "MPI");
        translateModelicaFRF(circuitSysML, getModelicaOptions(), "MPI");
    }
    
    @Test
    public void testModelicaCC() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager circuitSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/CruiseControl.xmi").getPath(), null);
        circuitSysML.setInputRootName(cruisecontrolblock);
        
        // roundtripModelica(circuitSysML, getModelicaOptions(), "MPI");
        translateModelicaFRF(circuitSysML, getModelicaOptions(), "MCC");
    }
    
    @Test
    public void testModelicaHS() throws UMLModelErrorException, IOException, XMLStreamException
    {
        SysMLToSimulationTranslationManager humidifierSysML = new SysMLToSimulationTranslationManager(
                SysMLToSimulationTranslationManager.class.getResource("/SysML/HumidifierSystemLibrary.xmi").getPath(),
                null);
        humidifierSysML.setInputRootName(humidifiersystemblock);
        
        translateModelicaFRF(humidifierSysML, getModelicaOptions(), "MHS");
    }
}
