package com.engisis.sysphs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;

import com.engisis.sysphs.SysMLToSimulationTranslationManager;
import com.engisis.xmiutil.EMFUtil;
import com.engisis.xmiutil.UMLModelErrorException;

public class LibrarySummary
{
    public static void main(String[] args) throws FileNotFoundException, UMLModelErrorException
    {
        File fp = new File(SysMLToSimulationTranslationManager.class.getResource("/SysML/SysPhSProfile.xmi").getPath());
        File fl = new File(SysMLToSimulationTranslationManager.class.getResource("/SysML/SysPhSLibrary.xmi").getPath());
        ResourceSet rs = EMFUtil.createBasicResourceSet();
        EMFUtil.loadResource(rs, URI.createURI("http://www.omg.org/spec/SysML/20161101/SysML.xmi"), null);
        EMFUtil.loadResource(rs, URI.createFileURI(fp.getAbsolutePath()), null);
        Resource rl = EMFUtil.loadResource(rs, URI.createFileURI(fl.getAbsolutePath()), null);
        SysPhSUtil sysphsutil = new SysPhSUtil(rs);
        
        TreeIterator<EObject> ti = rl.getAllContents();
        while (ti.hasNext())
        {
            EObject eo = ti.next();
            if (!(eo instanceof Namespace))
            {
                ti.prune();
                continue;
            }
            if (eo instanceof Class)
            {
                Class uclass = (Class) eo;
                if (uclass.isStereotypeApplied(sysphsutil.getSimulinkBlock())
                        || uclass.isStereotypeApplied(sysphsutil.getModelicaBlock()))
                {
                    StringBuilder sb = new StringBuilder();
                    sb.append(uclass.getName());
                    sb.append("--");
                    if (uclass.isStereotypeApplied(sysphsutil.getSimulinkBlock()))
                        sb.append(uclass.getValue(sysphsutil.getSimulinkBlock(), "name"));
                    sb.append("--");
                    if (uclass.isStereotypeApplied(sysphsutil.getModelicaBlock()))
                        sb.append(uclass.getValue(sysphsutil.getModelicaBlock(), "name"));
                    sb.append("\n");
                    for (Property uproperty : uclass.getAllAttributes())
                    {
                        sb.append("\t");
                        sb.append(uproperty.getName());
                        if (uproperty.isStereotypeApplied(sysphsutil.getMultidimensionalElement()))
                        {
                            sb.append("[");
                            List<Object> dims = (List<Object>) uproperty
                                    .getValue(sysphsutil.getMultidimensionalElement(), "dimensions");
                            for (int i = 0; i < dims.size(); i++)
                            {
                                if (i != 0)
                                    sb.append(",");
                                sb.append(dims.get(i));
                            }
                            sb.append("]");
                        }
                        sb.append("--");
                        if (uproperty.isStereotypeApplied(sysphsutil.getSimulinkPort()))
                            sb.append(uproperty.getValue(sysphsutil.getSimulinkPort(), "name"));
                        else if (uproperty.isStereotypeApplied(sysphsutil.getSimulinkParameter()))
                        {
                            sb.append(uproperty.getValue(sysphsutil.getSimulinkParameter(), "name"));
                            sb.append("=");
                            sb.append(uproperty.getValue(sysphsutil.getSimulinkParameter(), "value"));
                        }
                        sb.append("--");
                        if (uproperty.isStereotypeApplied(sysphsutil.getModelicaPort()))
                            sb.append(uproperty.getValue(sysphsutil.getModelicaPort(), "name"));
                        else if (uproperty.isStereotypeApplied(sysphsutil.getModelicaParameter()))
                        {
                            sb.append(uproperty.getValue(sysphsutil.getModelicaParameter(), "name"));
                            sb.append("=");
                            sb.append(uproperty.getValue(sysphsutil.getModelicaParameter(), "value"));
                        }
                        sb.append("\n");
                    }
                    System.out.print(sb.toString());
                }
            }
        }
    }
}
