/**
 */
package com.engisis.sysphs.language.stateflow;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>STree Node</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.engisis.sysphs.language.stateflow.STreeNode#getTreeNode <em>Tree Node</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.stateflow.STreeNode#getLinkNode <em>Link Node</em>}</li>
 *   <li>{@link com.engisis.sysphs.language.stateflow.STreeNode#getOwningTreeNode <em>Owning Tree Node</em>}</li>
 * </ul>
 *
 * @see com.engisis.sysphs.language.stateflow.StateflowPackage#getSTreeNode()
 * @model kind="class" abstract="true"
 * @generated
 */
public abstract class STreeNode extends SIdentifiedElement
{
    /**
     * The cached value of the '{@link #getTreeNode() <em>Tree Node</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTreeNode()
     * @generated
     * @ordered
     */
    protected EList<STreeNode> treeNode;
    /**
     * The cached value of the '{@link #getLinkNode() <em>Link Node</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLinkNode()
     * @generated
     * @ordered
     */
    protected EList<SLinkNode> linkNode;
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected STreeNode()
    {
        super();
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return StateflowPackage.Literals.STREE_NODE;
    }
    
    /**
     * Returns the value of the '<em><b>Tree Node</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.stateflow.STreeNode}.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.stateflow.STreeNode#getOwningTreeNode <em>Owning Tree Node</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Tree Node</em>' containment reference list isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Tree Node</em>' containment reference list.
     * @see com.engisis.sysphs.language.stateflow.StateflowPackage#getSTreeNode_TreeNode()
     * @see com.engisis.sysphs.language.stateflow.STreeNode#getOwningTreeNode
     * @model opposite="owningTreeNode" containment="true"
     * @generated
     */
    public EList<STreeNode> getTreeNode()
    {
        if (treeNode == null)
        {
            treeNode = new BasicInternalEList<STreeNode>(STreeNode.class);
        }
        return treeNode;
    }
    
    /**
     * Returns the value of the '<em><b>Link Node</b></em>' containment reference list.
     * The list contents are of type {@link com.engisis.sysphs.language.stateflow.SLinkNode}.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.stateflow.SLinkNode#getOwningTreeNode <em>Owning Tree Node</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Link Node</em>' containment reference list isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Link Node</em>' containment reference list.
     * @see com.engisis.sysphs.language.stateflow.StateflowPackage#getSTreeNode_LinkNode()
     * @see com.engisis.sysphs.language.stateflow.SLinkNode#getOwningTreeNode
     * @model opposite="owningTreeNode" containment="true"
     * @generated
     */
    public EList<SLinkNode> getLinkNode()
    {
        if (linkNode == null)
        {
            linkNode = new BasicInternalEList<SLinkNode>(SLinkNode.class);
        }
        return linkNode;
    }
    
    /**
     * Returns the value of the '<em><b>Owning Tree Node</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link com.engisis.sysphs.language.stateflow.STreeNode#getTreeNode <em>Tree Node</em>}'.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Owning Tree Node</em>' container reference isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Owning Tree Node</em>' container reference.
     * @see #setOwningTreeNode(STreeNode)
     * @see com.engisis.sysphs.language.stateflow.StateflowPackage#getSTreeNode_OwningTreeNode()
     * @see com.engisis.sysphs.language.stateflow.STreeNode#getTreeNode
     * @model opposite="treeNode" transient="false"
     * @generated
     */
    public STreeNode getOwningTreeNode()
    {
        if (eContainerFeatureID() != StateflowPackage.STREE_NODE__OWNING_TREE_NODE) return null;
        return (STreeNode)eInternalContainer();
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetOwningTreeNode(STreeNode newOwningTreeNode, NotificationChain msgs)
    {
        msgs = eBasicSetContainer((InternalEObject)newOwningTreeNode, StateflowPackage.STREE_NODE__OWNING_TREE_NODE, msgs);
        return msgs;
    }
    
    /**
     * Sets the value of the '{@link com.engisis.sysphs.language.stateflow.STreeNode#getOwningTreeNode <em>Owning Tree Node</em>}' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Owning Tree Node</em>' container reference.
     * @see #getOwningTreeNode()
     * @generated
     */
    public void setOwningTreeNode(STreeNode newOwningTreeNode)
    {
        if (newOwningTreeNode != eInternalContainer() || (eContainerFeatureID() != StateflowPackage.STREE_NODE__OWNING_TREE_NODE && newOwningTreeNode != null))
        {
            if (EcoreUtil.isAncestor(this, newOwningTreeNode))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newOwningTreeNode != null)
                msgs = ((InternalEObject)newOwningTreeNode).eInverseAdd(this, StateflowPackage.STREE_NODE__TREE_NODE, STreeNode.class, msgs);
            msgs = basicSetOwningTreeNode(newOwningTreeNode, msgs);
            if (msgs != null) msgs.dispatch();
        }
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case StateflowPackage.STREE_NODE__TREE_NODE:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getTreeNode()).basicAdd(otherEnd, msgs);
            case StateflowPackage.STREE_NODE__LINK_NODE:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getLinkNode()).basicAdd(otherEnd, msgs);
            case StateflowPackage.STREE_NODE__OWNING_TREE_NODE:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetOwningTreeNode((STreeNode)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case StateflowPackage.STREE_NODE__TREE_NODE:
                return ((InternalEList<?>)getTreeNode()).basicRemove(otherEnd, msgs);
            case StateflowPackage.STREE_NODE__LINK_NODE:
                return ((InternalEList<?>)getLinkNode()).basicRemove(otherEnd, msgs);
            case StateflowPackage.STREE_NODE__OWNING_TREE_NODE:
                return basicSetOwningTreeNode(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs)
    {
        switch (eContainerFeatureID())
        {
            case StateflowPackage.STREE_NODE__OWNING_TREE_NODE:
                return eInternalContainer().eInverseRemove(this, StateflowPackage.STREE_NODE__TREE_NODE, STreeNode.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case StateflowPackage.STREE_NODE__TREE_NODE:
                return getTreeNode();
            case StateflowPackage.STREE_NODE__LINK_NODE:
                return getLinkNode();
            case StateflowPackage.STREE_NODE__OWNING_TREE_NODE:
                return getOwningTreeNode();
        }
        return super.eGet(featureID, resolve, coreType);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case StateflowPackage.STREE_NODE__TREE_NODE:
                getTreeNode().clear();
                getTreeNode().addAll((Collection<? extends STreeNode>)newValue);
                return;
            case StateflowPackage.STREE_NODE__LINK_NODE:
                getLinkNode().clear();
                getLinkNode().addAll((Collection<? extends SLinkNode>)newValue);
                return;
            case StateflowPackage.STREE_NODE__OWNING_TREE_NODE:
                setOwningTreeNode((STreeNode)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case StateflowPackage.STREE_NODE__TREE_NODE:
                getTreeNode().clear();
                return;
            case StateflowPackage.STREE_NODE__LINK_NODE:
                getLinkNode().clear();
                return;
            case StateflowPackage.STREE_NODE__OWNING_TREE_NODE:
                setOwningTreeNode((STreeNode)null);
                return;
        }
        super.eUnset(featureID);
    }
    
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case StateflowPackage.STREE_NODE__TREE_NODE:
                return treeNode != null && !treeNode.isEmpty();
            case StateflowPackage.STREE_NODE__LINK_NODE:
                return linkNode != null && !linkNode.isEmpty();
            case StateflowPackage.STREE_NODE__OWNING_TREE_NODE:
                return getOwningTreeNode() != null;
        }
        return super.eIsSet(featureID);
    }
    
    public SChart getChart()
    {
        STreeNode owner = getOwningTreeNode();
        if (owner == null)
            return null;
        if (owner instanceof SChart)
            return (SChart) owner;
        return ((SState) owner).getChart();
    }
    
    public String getTreeNodeString()
    {
        // owner, first owned, next, previous
        int owner = 0, owned = 0, pre = 0, nex = 0;
        
        if (getOwningTreeNode() != null)
        {
            owner = getOwningTreeNode().getId();
            // get list of node of the same type
            List<STreeNode> list = new LinkedList<STreeNode>();
            for (STreeNode streenode : getOwningTreeNode().getTreeNode())
                if (streenode.getClass() == this.getClass())
                    list.add(streenode);
            
            for (int i = 0; i < list.size(); i++)
            {
                if (list.get(i) == this)
                {
                    if (i - 1 >= 0)
                        pre = list.get(i - 1).getId();
                    if (i + 1 < list.size())
                        nex = list.get(i + 1).getId();
                    break;
                }
            }
        }
        
        if (getTreeNode().size() != 0)
            owned = getTreeNode().get(0).getId();
        
        return "[" + owner + " " + owned + " " + pre + " " + nex + "]";
    }
    
    public void setID()
    {
    	SStateflow stateflow = getStateflow();
    	if (stateflow != null)
    		setId(stateflow.generateID());
    	else
    		throw new RuntimeException("Wrong usage!!!");
    }
    
    public SStateflow getStateflow()
    {
    	if (getOwningTreeNode() != null)
    		return getOwningTreeNode().getStateflow();
    	return null;
    }
    
} // STreeNode
