// adapted from https://github.com/ericharley/matlab-parser/blob/master/MATLAB.g4
// doesn't support anonymous functions

grammar MATLAB;
import MATLABCore;

file:
    function+ 
    ;

function  : 
    f_def_line stmt_end ( statement stmt_end)* END? stmt_end?
    ;

f_def_line:
    FUNCTION ID EQ ID f_input?|	
    FUNCTION ID f_input
    ;

f_input:
    LPAREN (ID (COMMA ID)*)? RPAREN
    ;

state_label:
	(entry_action|during_action|exit_action|on_action|bind_action)+
	;
	
entry_action:
	('entry'|'en') COLON (assignment stmt_end)+
	;
	
during_action:
	('during'|'du') COLON (assignment stmt_end)+
	;
	
exit_action:
	('exit'|'ex') COLON (assignment stmt_end)+
	;
	
on_action:
	('on') ID COLON (assignment stmt_end)+
	;

bind_action:
	'bind' ID+
	;
	
transition_label:
	(event_or_message condition? | condition) condition_action? transition_action?
	;
	
event_or_message:
	reference
	;
	
condition:
	LSBRACE expr RSBRACE
	;
	
condition_action:
	LBRACE expr RBRACE
	;
	
transition_action:
	LEFTDIV expr
	;
	
statement : 
    assignment |
    expr |
    command_form |
    for_command |
    if_command |
    global_command |
    while_command |
    return_command 
    ;	

assignment : 
    reference EQ expr
    ;

command_form : 
    ID command_args
    ;

command_args : 
    ID+ // FIXME!!
    ;

for_command : 
    FOR ID EQ expr stmt_end
    (statement stmt_end)*
    END 
    ;

if_command : 
    IF expr stmt_end
    (statement stmt_end)*
    END 
    ;

global_command: 
    GLOBAL ID+
    ;

while_command : 
    WHILE expr stmt_end
    (statement stmt_end)*
    END 
    ;

return_command : 
    RETURNS
    ;

BREAK	   : 'break';
CASE	   : 'case';
CATCH	   : 'catch';
CONTINUE   : 'continue';
ELSE	   : 'else';
ELSEIF	   : 'elseif';
END	   : 'end';
FOR	   : 'for';
FUNCTION   : 'function';
GLOBAL	   : 'global';
IF	   : 'if';
OTHERWISE  : 'otherwise';
PERSISTENT : 'persistent';
RETURNS	   : 'return';
SWITCH	   : 'switch';
TRY	   : 'try';
VARARGIN   : 'varargin';
WHILE	   : 'while';
CLEAR	   : 'clear';

ENDS	  : END SEMI? ;