/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.uml2.common.util.UnionEObjectEList;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceOperations
extends NamedElementOperations {
    protected NamespaceOperations() {
    }

    public static boolean validateMembersDistinguishable(Namespace namespace, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (diagnostics != null) {
            EList<NamedElement> namespaceMembers = namespace.getMembers();
            block0: for (NamedElement member : namespaceMembers) {
                for (NamedElement otherMember : namespaceMembers) {
                    if (member == otherMember || member.isDistinguishableFrom(otherMember, namespace)) continue;
                    result = false;
                    diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 12, UMLPlugin.INSTANCE.getString("_UI_Namespace_MemberDistinguishable_diagnostic", NamespaceOperations.getMessageSubstitutions(context, member, namespace)), new Object[]{member}));
                    continue block0;
                }
            }
            if (!result) {
                diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 12, UMLPlugin.INSTANCE.getString("_UI_Namespace_MembersDistinguishable_diagnostic", NamespaceOperations.getMessageSubstitutions(context, namespace)), new Object[]{namespace}));
            }
        } else {
            result = namespace.membersAreDistinguishable();
        }
        return result;
    }

    public static boolean validateCannotImportSelf(Namespace namespace, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateCannotImportOwnedMembers(Namespace namespace, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static ElementImport createElementImport(Namespace namespace, PackageableElement element, VisibilityKind visibility) {
        if (element == null || namespace.getImportedElements().contains(element)) {
            throw new IllegalArgumentException(String.valueOf(element));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.valueOf(visibility));
        }
        ElementImport elementImport = namespace.createElementImport(element);
        elementImport.setVisibility(visibility);
        return elementImport;
    }

    public static PackageImport createPackageImport(Namespace namespace, Package package_, VisibilityKind visibility) {
        if (package_ == null || namespace.getImportedPackages().contains(package_)) {
            throw new IllegalArgumentException(String.valueOf(package_));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.valueOf(visibility));
        }
        PackageImport packageImport = namespace.createPackageImport(package_);
        packageImport.setVisibility(visibility);
        return packageImport;
    }

    public static EList<PackageableElement> getImportedElements(Namespace namespace) {
        UniqueEList.FastCompare<PackageableElement> importedElements = new UniqueEList.FastCompare<PackageableElement>();
        for (ElementImport elementImport : namespace.getElementImports()) {
            PackageableElement importedElement = elementImport.getImportedElement();
            if (importedElement == null) continue;
            importedElements.add(importedElement);
        }
        return ECollections.unmodifiableEList(importedElements);
    }

    public static EList<Package> getImportedPackages(Namespace namespace) {
        UniqueEList.FastCompare<Package> importedPackages = new UniqueEList.FastCompare<Package>();
        for (PackageImport packageImport : namespace.getPackageImports()) {
            Package importedPackage = packageImport.getImportedPackage();
            if (importedPackage == null) continue;
            importedPackages.add(importedPackage);
        }
        return ECollections.unmodifiableEList(importedPackages);
    }

    public static EList<PackageableElement> getImportedMembers(Namespace namespace) {
        EList<PackageableElement> importedMembers = new UniqueEList.FastCompare<PackageableElement>();
        for (ElementImport elementImport : namespace.getElementImports()) {
            PackageableElement importedElement = elementImport.getImportedElement();
            if (importedElement == null) continue;
            importedMembers.add(importedElement);
        }
        for (PackageImport packageImport : namespace.getPackageImports()) {
            Package importedPackage = packageImport.getImportedPackage();
            if (importedPackage == null) continue;
            importedMembers.addAll(importedPackage.visibleMembers());
        }
        importedMembers = NamespaceOperations.importMembers(namespace, importedMembers);
        return new UnionEObjectEList<PackageableElement>((InternalEObject)((Object)namespace), UMLPackage.Literals.NAMESPACE__IMPORTED_MEMBER, importedMembers.size(), importedMembers.toArray());
    }

    protected static EList<String> getNamesOfMember(Namespace namespace, NamedElement element, EList<Namespace> namespaces, EList<String> namesOfMember) {
        if (!namespaces.contains(namespace)) {
            namespaces.add(namespace);
            if (namespace.getOwnedMembers().contains(element)) {
                String name = element.getName();
                if (!NamespaceOperations.isEmpty(name)) {
                    namesOfMember.add(name);
                }
            } else {
                UniqueEList<String> elementImportNames = new UniqueEList<String>();
                for (ElementImport elementImport : namespace.getElementImports()) {
                    String name;
                    if (elementImport.getImportedElement() != element || NamespaceOperations.isEmpty(name = elementImport.getName())) continue;
                    elementImportNames.add(name);
                }
                if (elementImportNames.isEmpty()) {
                    for (PackageImport packageImport : namespace.getPackageImports()) {
                        Package importedPackage = packageImport.getImportedPackage();
                        if (importedPackage == null || !importedPackage.visibleMembers().contains(element)) continue;
                        NamespaceOperations.getNamesOfMember(importedPackage, element, namespaces, namesOfMember);
                    }
                } else {
                    namesOfMember.addAll(elementImportNames);
                }
            }
        }
        return namesOfMember;
    }

    public static EList<String> getNamesOfMember(Namespace namespace, NamedElement element) {
        return ECollections.unmodifiableEList(NamespaceOperations.getNamesOfMember(namespace, element, new UniqueEList.FastCompare<Namespace>(), new UniqueEList<String>()));
    }

    public static boolean membersAreDistinguishable(Namespace namespace) {
        EList<NamedElement> namespaceMembers = namespace.getMembers();
        for (NamedElement member : namespaceMembers) {
            for (NamedElement otherMember : namespaceMembers) {
                if (member == otherMember || member.isDistinguishableFrom(otherMember, namespace)) continue;
                return false;
            }
        }
        return true;
    }

    public static EList<NamedElement> getOwnedMembers(Namespace namespace) {
        return namespace.getOwnedMembers();
    }

    public static EList<PackageableElement> importMembers(Namespace namespace, EList<PackageableElement> imps) {
        EList<NamedElement> members;
        UniqueEList.FastCompare<PackageableElement> importMembers = new UniqueEList.FastCompare<PackageableElement>();
        EList<NamedElement> ownedMembers = namespace.getOwnedMembers();
        HashMap memberNames = new HashMap();
        for (NamedElement ownedMember : ownedMembers) {
            for (String name : namespace.getNamesOfMember(ownedMember)) {
                members = (UniqueEList.FastCompare<NamedElement>)memberNames.get(name);
                if (members == null) {
                    members = new UniqueEList.FastCompare<NamedElement>();
                    memberNames.put(name, members);
                }
                members.add(ownedMember);
            }
        }
        for (PackageableElement imp : imps) {
            for (String name : namespace.getNamesOfMember(imp)) {
                members = (EList)memberNames.get(name);
                if (members == null) {
                    members = new UniqueEList.FastCompare();
                    memberNames.put(name, members);
                }
                members.add(imp);
            }
        }
        block4: for (PackageableElement imp : imps) {
            EClass impEClass = imp.eClass();
            for (String name : namespace.getNamesOfMember(imp)) {
                EList members2 = (EList)memberNames.get(name);
                if (members2.size() <= 1) continue;
                for (NamedElement member : members2) {
                    EClass memberEClass;
                    if (member != imp && ((memberEClass = member.eClass()).isSuperTypeOf(impEClass) || impEClass.isSuperTypeOf(memberEClass))) continue block4;
                }
            }
            importMembers.add(imp);
        }
        return ECollections.unmodifiableEList(importMembers);
    }

    public static EList<PackageableElement> excludeCollisions(Namespace namespace, EList<PackageableElement> imps) {
        UniqueEList.FastCompare<PackageableElement> excludeCollisions = new UniqueEList.FastCompare<PackageableElement>();
        HashMap<String, UniqueEList.FastCompare<PackageableElement>> memberNames = new HashMap<String, UniqueEList.FastCompare<PackageableElement>>();
        for (PackageableElement imp : imps) {
            for (String name : namespace.getNamesOfMember(imp)) {
                UniqueEList.FastCompare<PackageableElement> members = (UniqueEList.FastCompare<PackageableElement>)memberNames.get(name);
                if (members == null) {
                    members = new UniqueEList.FastCompare<PackageableElement>();
                    memberNames.put(name, members);
                }
                members.add(imp);
            }
        }
        block2: for (PackageableElement imp : imps) {
            EClass impEClass = imp.eClass();
            for (String name : namespace.getNamesOfMember(imp)) {
                EList members = (EList)memberNames.get(name);
                if (members.size() <= 1) continue;
                for (NamedElement member : members) {
                    EClass memberEClass;
                    if (member != imp && ((memberEClass = member.eClass()).isSuperTypeOf(impEClass) || impEClass.isSuperTypeOf(memberEClass))) continue block2;
                }
            }
            excludeCollisions.add(imp);
        }
        return ECollections.unmodifiableEList(excludeCollisions);
    }
}

