/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.operations.ElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplicityElementOperations
extends ElementOperations {
    protected MultiplicityElementOperations() {
    }

    public static boolean validateLowerGe0(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        int lowerBound = multiplicityElement.lowerBound();
        if (lowerBound < 0) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 58, UMLPlugin.INSTANCE.getString("_UI_MultiplicityElement_LowerGE0_diagnostic", MultiplicityElementOperations.getMessageSubstitutions(context, multiplicityElement)), new Object[]{multiplicityElement, new Integer(lowerBound)}));
            }
        }
        return result;
    }

    public static boolean validateUpperGeLower(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        int upperBound = 1;
        ValueSpecification upperValue = multiplicityElement.getUpperValue();
        if (upperValue != null) {
            try {
                upperBound = upperValue.unlimitedValue();
            }
            catch (UnsupportedOperationException uoe) {
                return result;
            }
        }
        if (upperBound != -1) {
            int lowerBound = 1;
            ValueSpecification lowerValue = multiplicityElement.getLowerValue();
            if (lowerValue != null) {
                try {
                    lowerBound = lowerValue.integerValue();
                }
                catch (UnsupportedOperationException uoe) {
                    return result;
                }
            }
            if (upperBound < lowerBound) {
                result = false;
                if (diagnostics != null) {
                    diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 57, UMLPlugin.INSTANCE.getString("_UI_MultiplicityElement_UpperGELower_diagnostic", MultiplicityElementOperations.getMessageSubstitutions(context, multiplicityElement)), new Object[]{multiplicityElement, new Integer(upperBound)}));
                }
            }
        }
        return result;
    }

    public static boolean validateValueSpecificationNoSideEffects(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateValueSpecificationConstant(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateLowerIsInteger(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateUpperIsUnlimitedNatural(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static int getLower(MultiplicityElement multiplicityElement) {
        return multiplicityElement.lowerBound();
    }

    public static int getUpper(MultiplicityElement multiplicityElement) {
        return multiplicityElement.upperBound();
    }

    public static boolean isMultivalued(MultiplicityElement multiplicityElement) {
        int upperBound = multiplicityElement.upperBound();
        return upperBound == -1 || upperBound > 1;
    }

    public static boolean includesMultiplicity(MultiplicityElement multiplicityElement, MultiplicityElement M) {
        if (multiplicityElement.lowerBound() <= M.lowerBound()) {
            int upperBound = multiplicityElement.upperBound();
            if (upperBound == -1) {
                return true;
            }
            int mUpperBound = M.upperBound();
            return mUpperBound == -1 ? false : upperBound >= mUpperBound;
        }
        return false;
    }

    public static int lowerBound(MultiplicityElement multiplicityElement) {
        ValueSpecification lowerValue = multiplicityElement.getLowerValue();
        if (lowerValue != null) {
            try {
                return lowerValue.integerValue();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return 1;
    }

    public static int upperBound(MultiplicityElement multiplicityElement) {
        ValueSpecification upperValue = multiplicityElement.getUpperValue();
        if (upperValue != null) {
            try {
                return upperValue.unlimitedValue();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return 1;
    }

    public static boolean compatibleWith(MultiplicityElement multiplicityElement, MultiplicityElement other) {
        return other != null && other.includesMultiplicity(multiplicityElement);
    }

    public static boolean is(MultiplicityElement multiplicityElement, int lowerbound, int upperbound) {
        return multiplicityElement.lowerBound() == lowerbound && multiplicityElement.upperBound() == upperbound;
    }

    public static void setLower(MultiplicityElement multiplicityElement, int newLower) {
        ValueSpecification lowerValue = multiplicityElement.getLowerValue();
        ((LiteralInteger)(lowerValue instanceof LiteralInteger ? lowerValue : multiplicityElement.createLowerValue(null, null, UMLPackage.Literals.LITERAL_INTEGER))).setValue(newLower);
    }

    public static void setUpper(MultiplicityElement multiplicityElement, int newUpper) {
        ValueSpecification upperValue = multiplicityElement.getUpperValue();
        ((LiteralUnlimitedNatural)(upperValue instanceof LiteralUnlimitedNatural ? upperValue : multiplicityElement.createUpperValue(null, null, UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL))).setValue(newUpper);
    }
}

