/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.injection;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.injection.ProfileInjector;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultProfileInjector
implements ProfileInjector {
    public void inject(Profile profile, Model model) {
        model.setDependencies(this.injectDependencies(profile.getDependencies(), model.getDependencies()));
        this.injectModules(profile, model);
        model.setRepositories(ModelUtils.mergeRepositoryLists(profile.getRepositories(), model.getRepositories()));
        model.setPluginRepositories(ModelUtils.mergeRepositoryLists(profile.getPluginRepositories(), model.getPluginRepositories()));
        this.injectReporting(profile, model);
        this.injectDependencyManagement(profile, model);
        this.injectDistributionManagement(profile, model);
        this.injectBuild(profile, model);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)model.getProperties());
        props.putAll((Map<?, ?>)profile.getProperties());
        model.setProperties(props);
    }

    private void injectBuild(Profile profile, Model model) {
        BuildBase profileBuild = profile.getBuild();
        Build modelBuild = model.getBuild();
        if (profileBuild != null) {
            if (modelBuild == null) {
                modelBuild = new Build();
                model.setBuild(modelBuild);
            }
            if (profileBuild.getDirectory() != null) {
                modelBuild.setDirectory(profileBuild.getDirectory());
            }
            if (profileBuild.getDefaultGoal() != null) {
                modelBuild.setDefaultGoal(profileBuild.getDefaultGoal());
            }
            if (profileBuild.getFinalName() != null) {
                modelBuild.setFinalName(profileBuild.getFinalName());
            }
            ModelUtils.mergeFilterLists(modelBuild.getFilters(), profileBuild.getFilters());
            ModelUtils.mergeResourceLists(modelBuild.getResources(), profileBuild.getResources());
            ModelUtils.mergeResourceLists(modelBuild.getTestResources(), profileBuild.getTestResources());
            this.injectPlugins(profileBuild, modelBuild);
            PluginManagement profilePM = profileBuild.getPluginManagement();
            PluginManagement modelPM = modelBuild.getPluginManagement();
            if (modelPM == null) {
                modelBuild.setPluginManagement(profilePM);
            } else {
                this.injectPlugins(profilePM, modelPM);
            }
        }
    }

    protected void injectPlugins(PluginContainer profileContainer, PluginContainer modelContainer) {
        if (profileContainer == null || modelContainer == null) {
            return;
        }
        List<Plugin> modelPlugins = modelContainer.getPlugins();
        if (modelPlugins == null) {
            modelContainer.setPlugins(profileContainer.getPlugins());
        } else if (profileContainer.getPlugins() != null) {
            ArrayList<Plugin> mergedPlugins = new ArrayList<Plugin>();
            Map<String, Plugin> profilePlugins = profileContainer.getPluginsAsMap();
            for (Plugin modelPlugin : modelPlugins) {
                Plugin profilePlugin = profilePlugins.get(modelPlugin.getKey());
                if (profilePlugin == null || mergedPlugins.contains(profilePlugin)) continue;
                Plugin mergedPlugin = modelPlugin;
                this.injectPluginDefinition(profilePlugin, modelPlugin);
                mergedPlugins.add(mergedPlugin);
            }
            List results = ModelUtils.orderAfterMerge(mergedPlugins, modelPlugins, profileContainer.getPlugins());
            modelContainer.setPlugins(results);
            modelContainer.flushPluginMap();
        }
    }

    private void injectPluginDefinition(Plugin profilePlugin, Plugin modelPlugin) {
        if (profilePlugin == null || modelPlugin == null) {
            return;
        }
        if (profilePlugin.isExtensions()) {
            modelPlugin.setExtensions(true);
        }
        if (profilePlugin.getVersion() != null) {
            modelPlugin.setVersion(profilePlugin.getVersion());
        }
        modelPlugin.setDependencies(this.injectDependencies(profilePlugin.getDependencies(), modelPlugin.getDependencies()));
        this.injectConfigurationContainer(profilePlugin, modelPlugin);
        List<PluginExecution> modelExecutions = modelPlugin.getExecutions();
        if (modelExecutions == null || modelExecutions.isEmpty()) {
            modelPlugin.setExecutions(profilePlugin.getExecutions());
        } else {
            LinkedHashMap<String, PluginExecution> executions = new LinkedHashMap<String, PluginExecution>();
            Map<String, PluginExecution> profileExecutions = profilePlugin.getExecutionsAsMap();
            for (PluginExecution pluginExecution : modelExecutions) {
                PluginExecution profileExecution = profileExecutions.get(pluginExecution.getId());
                if (profileExecution != null) {
                    this.injectConfigurationContainer(profileExecution, pluginExecution);
                    if (profileExecution.getPhase() != null) {
                        pluginExecution.setPhase(profileExecution.getPhase());
                    }
                    List<String> profileGoals = profileExecution.getGoals();
                    List<String> modelGoals = pluginExecution.getGoals();
                    ArrayList<String> goals = new ArrayList<String>();
                    if (modelGoals != null && !modelGoals.isEmpty()) {
                        goals.addAll(modelGoals);
                    }
                    if (profileGoals != null) {
                        for (String goal : profileGoals) {
                            if (goals.contains(goal)) continue;
                            goals.add(goal);
                        }
                    }
                    pluginExecution.setGoals(goals);
                }
                executions.put(pluginExecution.getId(), pluginExecution);
            }
            for (Map.Entry entry : profileExecutions.entrySet()) {
                String id = (String)entry.getKey();
                if (executions.containsKey(id)) continue;
                executions.put(id, (PluginExecution)entry.getValue());
            }
            modelPlugin.setExecutions(new ArrayList<PluginExecution>(executions.values()));
            modelPlugin.flushExecutionMap();
        }
    }

    private Xpp3Dom merge(Xpp3Dom dominant, Xpp3Dom recessive) {
        Xpp3Dom dominantCopy = dominant == null ? null : new Xpp3Dom(dominant);
        return Xpp3Dom.mergeXpp3Dom(dominantCopy, recessive);
    }

    private void injectConfigurationContainer(ConfigurationContainer profileContainer, ConfigurationContainer modelContainer) {
        Xpp3Dom configuration = (Xpp3Dom)profileContainer.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)modelContainer.getConfiguration();
        configuration = this.merge(configuration, parentConfiguration);
        modelContainer.setConfiguration(configuration);
    }

    private void injectModules(Profile profile, Model model) {
        List<String> profileModules;
        ArrayList<String> modules = new ArrayList<String>();
        List<String> modelModules = model.getModules();
        if (modelModules != null && !modelModules.isEmpty()) {
            modules.addAll(modelModules);
        }
        if ((profileModules = profile.getModules()) != null) {
            for (String module : profileModules) {
                if (modules.contains(module)) continue;
                modules.add(module);
            }
        }
        model.setModules(modules);
    }

    private void injectDistributionManagement(Profile profile, Model model) {
        DistributionManagement pDistMgmt = profile.getDistributionManagement();
        DistributionManagement mDistMgmt = model.getDistributionManagement();
        if (mDistMgmt == null) {
            model.setDistributionManagement(pDistMgmt);
        } else if (pDistMgmt != null) {
            if (pDistMgmt.getRepository() != null) {
                mDistMgmt.setRepository(pDistMgmt.getRepository());
            }
            if (pDistMgmt.getSnapshotRepository() != null) {
                mDistMgmt.setSnapshotRepository(pDistMgmt.getSnapshotRepository());
            }
            if (StringUtils.isNotEmpty(pDistMgmt.getDownloadUrl())) {
                mDistMgmt.setDownloadUrl(pDistMgmt.getDownloadUrl());
            }
            if (pDistMgmt.getRelocation() != null) {
                mDistMgmt.setRelocation(pDistMgmt.getRelocation());
            }
            if (pDistMgmt.getSite() != null) {
                mDistMgmt.setSite(pDistMgmt.getSite());
            }
        }
    }

    private void injectDependencyManagement(Profile profile, Model model) {
        DependencyManagement modelDepMgmt = model.getDependencyManagement();
        DependencyManagement profileDepMgmt = profile.getDependencyManagement();
        if (profileDepMgmt != null) {
            if (modelDepMgmt == null) {
                model.setDependencyManagement(profileDepMgmt);
            } else {
                LinkedHashMap<String, Dependency> depsMap = new LinkedHashMap<String, Dependency>();
                List<Dependency> deps = modelDepMgmt.getDependencies();
                if (deps != null) {
                    for (Dependency dependency : deps) {
                        depsMap.put(dependency.getManagementKey(), dependency);
                    }
                }
                if ((deps = profileDepMgmt.getDependencies()) != null) {
                    for (Dependency dependency : deps) {
                        depsMap.put(dependency.getManagementKey(), dependency);
                    }
                }
                modelDepMgmt.setDependencies(new ArrayList<Dependency>(depsMap.values()));
            }
        }
    }

    private void injectReporting(Profile profile, Model model) {
        Reporting profileReporting = profile.getReporting();
        Reporting modelReporting = model.getReporting();
        if (profileReporting != null) {
            if (modelReporting == null) {
                model.setReporting(profileReporting);
            } else {
                if (StringUtils.isEmpty(modelReporting.getOutputDirectory())) {
                    modelReporting.setOutputDirectory(profileReporting.getOutputDirectory());
                }
                LinkedHashMap<String, ReportPlugin> mergedReportPlugins = new LinkedHashMap<String, ReportPlugin>();
                Map<String, ReportPlugin> profileReportersByKey = profileReporting.getReportPluginsAsMap();
                List<ReportPlugin> modelReportPlugins = modelReporting.getPlugins();
                if (modelReportPlugins != null) {
                    for (ReportPlugin reportPlugin : modelReportPlugins) {
                        String inherited = reportPlugin.getInherited();
                        if (!StringUtils.isEmpty(inherited) && !Boolean.valueOf(inherited).booleanValue()) continue;
                        ReportPlugin profileReportPlugin = profileReportersByKey.get(reportPlugin.getKey());
                        ReportPlugin mergedReportPlugin = reportPlugin;
                        if (profileReportPlugin != null) {
                            mergedReportPlugin = profileReportPlugin;
                            this.mergeReportPlugins(profileReportPlugin, reportPlugin);
                        } else if (StringUtils.isEmpty(inherited)) {
                            mergedReportPlugin.unsetInheritanceApplied();
                        }
                        mergedReportPlugins.put(mergedReportPlugin.getKey(), mergedReportPlugin);
                    }
                }
                for (Map.Entry entry : profileReportersByKey.entrySet()) {
                    String key = (String)entry.getKey();
                    if (mergedReportPlugins.containsKey(key)) continue;
                    mergedReportPlugins.put(key, (ReportPlugin)entry.getValue());
                }
                modelReporting.setPlugins(new ArrayList<ReportPlugin>(mergedReportPlugins.values()));
                modelReporting.flushReportPluginMap();
            }
        }
    }

    private void mergeReportPlugins(ReportPlugin dominant, ReportPlugin recessive) {
        if (StringUtils.isEmpty(recessive.getVersion())) {
            recessive.setVersion(dominant.getVersion());
        }
        Xpp3Dom dominantConfig = (Xpp3Dom)dominant.getConfiguration();
        Xpp3Dom recessiveConfig = (Xpp3Dom)recessive.getConfiguration();
        recessive.setConfiguration(this.merge(dominantConfig, recessiveConfig));
        LinkedHashMap<String, ReportSet> mergedReportSets = new LinkedHashMap<String, ReportSet>();
        Map<String, ReportSet> dominantReportSetsById = dominant.getReportSetsAsMap();
        for (ReportSet recessiveReportSet : recessive.getReportSets()) {
            List<String> dominantRSReports;
            ReportSet dominantReportSet = dominantReportSetsById.get(recessiveReportSet.getId());
            ReportSet merged = recessiveReportSet;
            if (dominantReportSet == null) continue;
            merged = recessiveReportSet;
            Xpp3Dom dominantRSConfig = (Xpp3Dom)dominantReportSet.getConfiguration();
            Xpp3Dom mergedRSConfig = (Xpp3Dom)merged.getConfiguration();
            merged.setConfiguration(this.merge(dominantRSConfig, mergedRSConfig));
            List<String> mergedReports = merged.getReports();
            if (mergedReports == null) {
                mergedReports = new ArrayList<String>();
                merged.setReports(mergedReports);
            }
            if ((dominantRSReports = dominantReportSet.getReports()) != null) {
                for (String report : dominantRSReports) {
                    if (mergedReports.contains(report)) continue;
                    mergedReports.add(report);
                }
            }
            mergedReportSets.put(merged.getId(), merged);
        }
        for (Map.Entry<String, ReportSet> entry : dominantReportSetsById.entrySet()) {
            String key = entry.getKey();
            if (mergedReportSets.containsKey(key)) continue;
            mergedReportSets.put(key, entry.getValue());
        }
        recessive.setReportSets(new ArrayList<ReportSet>(mergedReportSets.values()));
        recessive.flushReportSetMap();
    }

    private List injectDependencies(List profileDeps, List modelDeps) {
        LinkedHashMap<String, Dependency> depsMap = new LinkedHashMap<String, Dependency>();
        if (modelDeps != null) {
            for (Dependency dependency : modelDeps) {
                depsMap.put(dependency.getManagementKey(), dependency);
            }
        }
        if (profileDeps != null) {
            for (Dependency dependency : profileDeps) {
                depsMap.put(dependency.getManagementKey(), dependency);
            }
        }
        return new ArrayList(depsMap.values());
    }
}

