/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.xmiutil;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;

public class XMIReferenceFinder
implements Runnable {
    static final Logger log = Logger.getLogger(XMIReferenceFinder.class);
    private HashSet<URI> references = new HashSet();
    private XMLStreamReader xmlr;
    private Map<String, String> objectmap;
    private Map<URI, URI> locationmap;
    private List<URI> baseuris;

    public XMIReferenceFinder(InputStream inputstream, Map<String, String> objectmap, Map<URI, URI> locationmap, URI baseuri, List<URI> paths) throws XMLStreamException, FactoryConfigurationError {
        this.objectmap = objectmap;
        this.locationmap = locationmap;
        this.baseuris = new ArrayList<URI>(paths != null ? paths.size() : 1);
        this.baseuris.add(baseuri);
        if (paths != null) {
            this.baseuris.addAll(paths);
        }
        XMLInputFactory xmlif = XMLInputFactory.newFactory();
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        this.xmlr = xmlif.createXMLStreamReader(inputstream);
    }

    @Override
    public void run() {
        try {
            block5: while (this.xmlr.hasNext()) {
                int eventType = this.xmlr.next();
                switch (eventType) {
                    case 1: {
                        block6: for (int i = 0; i < this.xmlr.getAttributeCount(); ++i) {
                            URI uri;
                            String name = this.xmlr.getAttributeLocalName(i);
                            String value = this.xmlr.getAttributeValue(i);
                            if (!"href".equals(name) || value == null) continue;
                            if (this.objectmap.containsKey(value)) {
                                value = this.objectmap.get(value);
                            }
                            if ((uri = URI.createURI(value).trimFragment().trimQuery()).lastSegment() == null) continue;
                            if (uri.hasRelativePath()) {
                                for (URI baseuri : this.baseuris) {
                                    URI resuri = uri.resolve(baseuri);
                                    if (!resuri.isFile() || !new File(resuri.toFileString()).exists()) continue;
                                    String suri = resuri.toString();
                                    if (suri.contains("!") && !suri.startsWith("jar:")) {
                                        suri = "jar:" + suri;
                                    }
                                    this.references.add(URI.createURI(suri));
                                    continue block6;
                                }
                                continue;
                            }
                            URI urimap = this.locationmap.get(uri);
                            if (urimap != null) {
                                this.references.add(urimap);
                                continue;
                            }
                            log.debug("No location mapping found for " + uri);
                        }
                        continue block5;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.error("Error while parsing the file", e);
        }
    }

    public HashSet<URI> getReferences() {
        return this.references;
    }
}

