/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.xmiutil;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;

public class XMIPostWriter
implements Runnable {
    private static final Logger log = Logger.getLogger(XMIPostWriter.class);
    private static final String INDENT = "  ";
    private InputStream is;
    private String file;
    private Hashtable<String, String> locationsmap;
    private Hashtable<String, String> idmaps;
    private Hashtable<String, String> nsmaps;
    private Set<String> nsfilter_bl;
    private Set<String> nsfilter_wl;
    private Set<QName> elfilter_bl;
    private Set<QName> elfilter_wl;

    public XMIPostWriter(InputStream is, String file, Hashtable<String, String> locationsmap, Hashtable<String, String> idmaps, Hashtable<String, String> nsmaps, Set<String> nsfilter_bl, Set<String> nsfilter_wl, Set<QName> elfilter_bl, Set<QName> elfilter_wl) throws FileNotFoundException {
        this.is = is;
        this.file = file;
        this.locationsmap = locationsmap;
        this.idmaps = idmaps;
        this.nsmaps = nsmaps;
        this.nsfilter_bl = nsfilter_bl;
        this.nsfilter_wl = nsfilter_wl;
        this.elfilter_bl = elfilter_bl;
        this.elfilter_wl = elfilter_wl;
        log.debug("Namespaces mappings");
        if (nsmaps != null) {
            for (Map.Entry<String, String> nsent : nsmaps.entrySet()) {
                log.debug(nsent.getKey() + "->" + nsent.getValue());
            }
        }
        log.debug("Locations mappings");
        if (locationsmap != null) {
            for (Map.Entry<String, String> locent : locationsmap.entrySet()) {
                log.debug(locent.getKey() + "->" + locent.getValue());
            }
        }
    }

    @Override
    public void run() {
        log.info("Starting postwriter");
        int skip = 0;
        log.info("Opening file stream to " + this.file);
        StringBuilder sb = new StringBuilder();
        String str = null;
        XMLOutputFactory xmlof = XMLOutputFactory.newFactory();
        int indent = 0;
        try (FileOutputStream fos = new FileOutputStream(this.file);){
            XMLStreamWriter xmlw = xmlof.createXMLStreamWriter(fos);
            XMLInputFactory xmlif = XMLInputFactory.newFactory();
            xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            XMLStreamReader xmlr = xmlif.createXMLStreamReader(this.is);
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                switch (eventType) {
                    case 1: {
                        String ans_;
                        boolean bskip;
                        String ans;
                        int i;
                        String ns = xmlr.getNamespaceURI();
                        String pr = xmlr.getPrefix();
                        QName el = xmlr.getName();
                        String ln = xmlr.getLocalName();
                        if (ns != null && this.nsmaps.containsKey(ns)) {
                            ns = this.nsmaps.get(ns);
                            el = new QName(ns, ln);
                        }
                        if (skip == 0) {
                            boolean bskip2 = false;
                            if (ns != null) {
                                String ns_ = ns;
                                if (this.nsfilter_wl != null && this.nsfilter_wl.stream().noneMatch(s -> ns_.matches((String)s))) {
                                    log.debug("Namespace " + ns_ + " not in whitelist " + this.nsfilter_wl.stream().collect(Collectors.joining(" ")));
                                    bskip2 = true;
                                }
                                if (this.nsfilter_bl != null && this.nsfilter_bl.stream().anyMatch(s -> ns_.matches((String)s))) {
                                    log.debug("Namespace " + ns_ + " in blacklist " + this.nsfilter_bl.stream().collect(Collectors.joining(" ")));
                                    bskip2 = true;
                                }
                            }
                            QName el_ = el;
                            if (this.elfilter_wl != null && this.elfilter_wl.stream().noneMatch(qn -> el_.equals(qn))) {
                                log.debug("Element " + el_ + " not in whitelist " + this.elfilter_wl.stream().map(qn -> qn.toString()).collect(Collectors.joining(" ")));
                                bskip2 = true;
                            }
                            if (this.elfilter_bl != null && this.elfilter_bl.stream().anyMatch(qn -> el_.equals(qn))) {
                                log.debug("Element " + el_ + " in blacklist " + this.elfilter_bl.stream().map(qn -> qn.toString()).collect(Collectors.joining(" ")));
                                bskip2 = true;
                            }
                            if (bskip2) {
                                ++skip;
                            }
                        } else {
                            ++skip;
                        }
                        if (skip > 0) break;
                        str = sb.toString().trim();
                        if (!str.isEmpty()) {
                            for (i = 0; i < indent; ++i) {
                                xmlw.writeCharacters(INDENT);
                            }
                            xmlw.writeCharacters(str + "\n");
                            sb.setLength(0);
                        }
                        for (i = 0; i < indent; ++i) {
                            xmlw.writeCharacters(INDENT);
                        }
                        if (ns != null) {
                            xmlw.writeStartElement(pr, ln, ns);
                        } else {
                            xmlw.writeStartElement(ln);
                        }
                        for (i = 0; i < xmlr.getNamespaceCount(); ++i) {
                            String rep;
                            ans = xmlr.getNamespaceURI(i);
                            if (this.nsmaps != null && (rep = this.nsmaps.get(ans)) != null) {
                                ans = rep;
                            }
                            bskip = false;
                            ans_ = ans;
                            if (this.nsfilter_wl != null && this.nsfilter_wl.stream().noneMatch(s -> ans_.matches((String)s))) {
                                log.debug("Namespace " + ans + " not in whitelist " + this.nsfilter_wl.stream().collect(Collectors.joining(" ")));
                                bskip = true;
                            }
                            if (this.nsfilter_bl != null && this.nsfilter_bl.stream().anyMatch(s -> ans_.matches((String)s))) {
                                log.debug("Namespace " + ans + " in blacklist " + this.nsfilter_bl.stream().collect(Collectors.joining(" ")));
                                bskip = true;
                            }
                            if (bskip) continue;
                            String apr = xmlr.getNamespacePrefix(i);
                            xmlw.writeNamespace(apr, ans);
                        }
                        for (i = 0; i < xmlr.getAttributeCount(); ++i) {
                            ans = xmlr.getAttributeNamespace(i);
                            bskip = false;
                            if (ans != null) {
                                String rep;
                                if (this.nsmaps != null && (rep = this.nsmaps.get(ans)) != null) {
                                    ans = rep;
                                }
                                ans_ = ans;
                                if (this.nsfilter_wl != null && this.nsfilter_wl.stream().noneMatch(s -> ans_.matches((String)s))) {
                                    log.debug("Namespace " + ans + " not in whitelist " + this.nsfilter_wl.stream().collect(Collectors.joining(" ")));
                                    bskip = true;
                                }
                                if (this.nsfilter_bl != null && this.nsfilter_bl.stream().anyMatch(s -> ans_.matches((String)s))) {
                                    log.debug("Namespace " + ans + " in blacklist " + this.nsfilter_bl.stream().collect(Collectors.joining(" ")));
                                    bskip = true;
                                }
                            }
                            if (bskip) continue;
                            String aln = xmlr.getAttributeLocalName(i);
                            String av = xmlr.getAttributeValue(i);
                            if ("href".equals(aln)) {
                                int idx;
                                String rep;
                                if (this.idmaps != null && (rep = this.idmaps.get(av)) != null) {
                                    av = rep;
                                }
                                if (this.locationsmap != null && (idx = av.indexOf("#")) > 0 && av.length() > idx) {
                                    String loc = av.substring(0, idx);
                                    if (this.locationsmap.containsKey(loc)) {
                                        av = this.locationsmap.get(loc) + "#" + av.substring(idx + 1);
                                    } else {
                                        String fn = URI.createURI(loc).lastSegment();
                                        if (this.locationsmap.containsKey(fn)) {
                                            av = this.locationsmap.get(fn) + "#" + av.substring(idx + 1);
                                        }
                                    }
                                }
                            }
                            if (ans != null) {
                                xmlw.writeAttribute(ans, aln, av);
                                continue;
                            }
                            xmlw.writeAttribute(aln, av);
                        }
                        xmlw.writeCharacters("\n");
                        ++indent;
                        break;
                    }
                    case 2: {
                        if (skip > 0) {
                            --skip;
                            break;
                        }
                        str = sb.toString().trim();
                        if (!str.isEmpty()) {
                            for (int i = 0; i < indent; ++i) {
                                xmlw.writeCharacters(INDENT);
                            }
                            xmlw.writeCharacters(str + "\n");
                            sb.setLength(0);
                        }
                        --indent;
                        for (int i = 0; i < indent; ++i) {
                            xmlw.writeCharacters(INDENT);
                        }
                        xmlw.writeEndElement();
                        xmlw.writeCharacters("\n");
                        break;
                    }
                    case 3: {
                        if (skip > 0) break;
                        xmlw.writeProcessingInstruction(xmlr.getPITarget(), xmlr.getPIData());
                        break;
                    }
                    case 4: {
                        String txt;
                        if (skip > 0 || (txt = xmlr.getText().trim()).length() == 0) break;
                        sb.append(txt);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 7: {
                        xmlw.writeStartDocument();
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        if (skip > 0) break;
                        sb.append(xmlr.getText());
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        if (skip > 0) break;
                        xmlw.writeCData(xmlr.getText());
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.error("Error while parsing the file", e);
        }
        catch (IOException e) {
            log.error("Error while parsing the file", e);
        }
        log.info("Finished postwriter");
    }
}

