/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.xmiutil;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class CoreConfiguration {
    private static final Logger log = Logger.getLogger(CoreConfiguration.class);
    public static final String PROPERTYFILE = "properties.config";
    private static List<String[]> values;

    protected static List<String[]> getValues() {
        if (values == null) {
            CoreConfiguration.loadPropertyFile();
        }
        return values;
    }

    private static synchronized void loadPropertyFile() {
        if (values != null) {
            return;
        }
        values = new LinkedList<String[]>();
        InputStream is = CoreConfiguration.class.getClassLoader().getResourceAsStream(PROPERTYFILE);
        if (is == null) {
            log.warn("properties.config not found");
            return;
        }
        String line = null;
        int skipped = 0;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            while ((line = br.readLine()) != null) {
                String[] spl = line.split("\\t");
                if (spl.length == 0 || spl[0].startsWith("#")) {
                    ++skipped;
                    continue;
                }
                values.add(spl);
            }
        }
        catch (IOException e) {
            log.error("Error reading property file", e);
        }
    }
}

