/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.util;

import com.engisis.xmiutil.EMFUtil;
import com.engisis.xmiutil.SysMLUtil;
import com.engisis.xmiutil.UMLModelErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class SysPhSUtil
extends SysMLUtil {
    private static final Logger log = Logger.getLogger(SysPhSUtil.class);
    public static final String SYSPHS_LANGUAGE = "sysphs";
    private Stereotype sinitialvaluesspec;
    private Class sconservedsubstance;
    private Class srealsignalin;
    private Class srealsignalout;
    private Stereotype sphsvariable;
    private Stereotype sphsconstant;
    private Stereotype smultidimelement;
    private Stereotype sinitialvalueref;
    private Stereotype ssimulationvertex;
    private Stereotype smodelicablock;
    private Stereotype smodelicaport;
    private Stereotype smodelicaparameter;
    private Stereotype ssimulinkblock;
    private Stereotype ssimulinkport;
    private Stereotype ssimulinkparameter;
    private List<LibraryComponent> lscomponents;
    private List<LibraryComponent> lmcomponents;
    public static final URI nsSysPhS = URI.createURI("https://www.omg.org/spec/SysPhS/20200925");
    private static final URI nsSysPhSExtended = URI.createURI(nsSysPhS + "/SysPhSExtended");
    private static final URI nsSysPhSPlatformProfile = URI.createURI(nsSysPhS + "/SysPhSPlatformProfile");
    public static final String nameSysPhSProfile = "SysPhSProfile.xmi";
    public static final String nameSysPhSLibrary = "SysPhSLibrary.xmi";

    public SysPhSUtil(ResourceSet rs) throws UMLModelErrorException {
        super(rs);
        this.loadSysPhS();
        this.loadSysPhSExtended();
        this.loadSysPhSPlatform();
    }

    public void loadSysPhS() throws UMLModelErrorException {
        this.sphsvariable = this.loadStereotype(nsSysPhS, "PhSVariable");
        this.sphsconstant = this.loadStereotype(nsSysPhS, "PhSConstant");
    }

    public void loadSysPhSExtended() throws UMLModelErrorException {
        if (this.getResourceSet().getResource(nsSysPhSExtended, false) != null) {
            this.sinitialvalueref = this.loadStereotype(nsSysPhSExtended, "InitialValueReference");
            this.ssimulationvertex = this.loadStereotype(nsSysPhSExtended, "SimulationVertex");
            this.sinitialvaluesspec = this.loadStereotype(nsSysPhSExtended, "InitialValuesSpecification");
        }
    }

    public void loadSysPhSPlatform() throws UMLModelErrorException {
        Resource r = this.getResourceSet().getResources().stream().filter(_r -> _r.getURI().lastSegment().equals(nameSysPhSLibrary)).findFirst().orElse(null);
        if (r != null) {
            this.smultidimelement = this.loadStereotype(nsSysPhSPlatformProfile, "MultidimensionalElement");
            this.smodelicablock = this.loadStereotype(nsSysPhSPlatformProfile, "ModelicaBlock");
            this.smodelicaparameter = this.loadStereotype(nsSysPhSPlatformProfile, "ModelicaParameter");
            this.smodelicaport = this.loadStereotype(nsSysPhSPlatformProfile, "ModelicaPort");
            this.ssimulinkblock = this.loadStereotype(nsSysPhSPlatformProfile, "SimulinkBlock");
            this.ssimulinkparameter = this.loadStereotype(nsSysPhSPlatformProfile, "SimulinkParameter");
            this.ssimulinkport = this.loadStereotype(nsSysPhSPlatformProfile, "SimulinkPort");
            this.lscomponents = new LinkedList<LibraryComponent>();
            this.lmcomponents = new LinkedList<LibraryComponent>();
            TreeIterator<EObject> ti = r.getAllContents();
            while (ti.hasNext()) {
                EObject eo = (EObject)ti.next();
                if (!(eo instanceof Namespace)) {
                    ti.prune();
                    continue;
                }
                if (!(eo instanceof Class)) continue;
                Class uclass = (Class)eo;
                this.processLibraryComponent(this.lmcomponents, uclass, this.smodelicablock, this.smodelicaparameter, this.smodelicaport);
                this.processLibraryComponent(this.lscomponents, uclass, this.ssimulinkblock, this.ssimulinkparameter, this.ssimulinkport);
                if ("ConservedSubstance".equals(uclass.getName()) || "ConservedQuantityKind".equals(uclass.getName())) {
                    this.sconservedsubstance = uclass;
                    continue;
                }
                if ("RealSignalInElement".equals(uclass.getName())) {
                    this.srealsignalin = uclass;
                    continue;
                }
                if (!"RealSignalOutElement".equals(uclass.getName())) continue;
                this.srealsignalout = uclass;
            }
        } else {
            log.error("Could not locate the library in loaded files");
        }
    }

    private void processLibraryComponent(List<LibraryComponent> list, Class uclass, Stereotype stclass, Stereotype stparameter, Stereotype stport) {
        if (uclass.isStereotypeApplied(stclass)) {
            String name = (String)uclass.getValue(stclass, "name");
            if (name == null) {
                name = uclass.getName();
            }
            LibraryComponent lc = new LibraryComponent(uclass, name);
            for (Property uproperty : this.getAllAttributes(uclass)) {
                if (uproperty.isStereotypeApplied(stparameter)) {
                    name = (String)uproperty.getValue(stparameter, "name");
                    if (name == null) {
                        name = uproperty.getName();
                    }
                    String value = (String)uproperty.getValue(stparameter, "value");
                    LibraryParameter lp = new LibraryParameter(uproperty, name, value);
                    lc.parameters.add(lp);
                    continue;
                }
                if (!uproperty.isStereotypeApplied(stport)) continue;
                name = (String)uproperty.getValue(stport, "name");
                if (name == null) {
                    name = uproperty.getName();
                }
                LibraryPort lp = new LibraryPort((Port)uproperty, name);
                lc.ports.add(lp);
            }
            list.add(lc);
        }
    }

    public Stereotype getInitialValuesSpecification() {
        return this.sinitialvaluesspec;
    }

    public Stereotype getPhSVariable() {
        return this.sphsvariable;
    }

    public Stereotype getPhSConstant() {
        return this.sphsconstant;
    }

    public Stereotype getMultidimensionalElement() {
        return this.smultidimelement;
    }

    public Stereotype getInitialValueReference() {
        return this.sinitialvalueref;
    }

    public Stereotype getSimulationVertex() {
        return this.ssimulationvertex;
    }

    public Class getConservedSubstance() {
        return this.sconservedsubstance;
    }

    public Class getRealSignalIn() {
        return this.srealsignalin;
    }

    public Class getRealSignalOut() {
        return this.srealsignalout;
    }

    public Stereotype getModelicaBlock() {
        return this.smodelicablock;
    }

    public Stereotype getModelicaParameter() {
        return this.smodelicaparameter;
    }

    public Stereotype getModelicaPort() {
        return this.smodelicaport;
    }

    public Stereotype getSimulinkBlock() {
        return this.ssimulinkblock;
    }

    public Stereotype getSimulinkParameter() {
        return this.ssimulinkparameter;
    }

    public Stereotype getSimulinkPort() {
        return this.ssimulinkport;
    }

    public List<LibraryComponent> getSimulinkComponents() {
        return Collections.unmodifiableList(this.lscomponents);
    }

    public List<LibraryComponent> getModelicaComponents() {
        return Collections.unmodifiableList(this.lmcomponents);
    }

    public List<Property> getOwnedPhSProperties(Classifier uclassifier) {
        Set<Property> lp = this.getOwnedAttributes(uclassifier);
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property uproperty : lp) {
            if (!uproperty.isStereotypeApplied(this.getFlowProperty()) || !uproperty.isStereotypeApplied(this.sphsvariable) && !this.isSimBlock((Classifier)uproperty.getType())) continue;
            properties.add(uproperty);
        }
        return properties;
    }

    public boolean isPhSProperty(Property uproperty) {
        if (uproperty == null) {
            return false;
        }
        if (!uproperty.isStereotypeApplied(this.getFlowProperty())) {
            return false;
        }
        if (uproperty.getType() instanceof DataType && uproperty.isStereotypeApplied(this.sphsvariable)) {
            return true;
        }
        return uproperty.getType() instanceof Classifier && this.isSimBlock((Classifier)uproperty.getType());
    }

    public boolean isSimBlock(Classifier uclassifier) {
        if (uclassifier == null) {
            return false;
        }
        for (Classifier ugeneral : uclassifier.getGenerals()) {
            if (ugeneral == this.sconservedsubstance) {
                return true;
            }
            if (!this.isSimBlock(ugeneral)) continue;
            return true;
        }
        return false;
    }

    public List<Property> getAllPhSProperties(Classifier uclassifier) {
        Set<Property> lp = this.getAllCorrectedAttributes(uclassifier);
        ArrayList<Property> ret = new ArrayList<Property>();
        for (Property uproperty : lp) {
            if (!this.isPhSProperty(uproperty)) continue;
            ret.add(uproperty);
        }
        return ret;
    }

    public List<Property> getSimVariables(Property uproperty) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (uproperty.getType() instanceof Class) {
            for (Property property : this.getAllAttributes((Class)uproperty.getType())) {
                if (!property.isStereotypeApplied(this.getPhSVariable())) continue;
                properties.add(property);
            }
        }
        return properties;
    }

    public static List<Classifier> getAllCompatibleTypes(Classifier uclassifier) {
        LinkedList<Classifier> ret = new LinkedList<Classifier>();
        if (uclassifier == null) {
            return ret;
        }
        ret.add(uclassifier);
        for (Classifier general : uclassifier.getGenerals()) {
            ret.addAll(SysPhSUtil.getAllCompatibleTypes(general));
        }
        return ret;
    }

    public void removeSimProperty(List<Property> properties) {
        int i = 0;
        while (i != properties.size()) {
            if (properties.get(i).isStereotypeApplied(this.getFlowProperty())) {
                properties.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static void setName(NamedElement ne, String name) {
        String nname;
        if (name == null) {
            ne.setName(null);
            return;
        }
        String rname = name.length() == 0 ? "_" + ne.getClass().getName() : name;
        LinkedList<NamedElement> nes = new LinkedList<NamedElement>();
        Namespace ns = ne.getNamespace();
        if (ns != null) {
            nes.addAll(ns.getOwnedMembers());
        }
        if (!SysPhSUtil.isPresent(rname, nes)) {
            ne.setName(rname);
            return;
        }
        int i = 0;
        while (SysPhSUtil.isPresent(nname = rname + i++, nes)) {
        }
        ne.setName(nname);
    }

    private static boolean isPresent(String name, List<NamedElement> nes) {
        if (name != null) {
            for (NamedElement ne : nes) {
                if (!name.equals(ne.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public String joinProperties(List<Property> properties, String separator) {
        if (properties == null || separator == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < properties.size(); ++i) {
            List dims;
            Property p = properties.get(i);
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(this.getName(p));
            if (!p.isStereotypeApplied(this.smultidimelement) || !(p.getValue(this.smultidimelement, "dimensions") instanceof List) || (dims = (List)p.getValue(this.smultidimelement, "dimensions")).size() != 1 || !((Integer)dims.get(0)).equals(1)) continue;
            sb.append("[1]");
        }
        return sb.toString();
    }

    public static Resource createSysPhSModel(ResourceSet rs, URI uri, List<URI> lpath) {
        Resource r = SysMLUtil.createSysMLModel(rs, uri, lpath);
        Model model = r.getContents().stream().filter(e -> e instanceof Model).findFirst().orElse(null);
        if (model != null) {
            Resource sysphs = EMFUtil.loadResource(rs, nsSysPhS.appendSegment(nameSysPhSProfile), lpath);
            if (sysphs != null) {
                TreeIterator<EObject> ti = sysphs.getAllContents();
                while (ti.hasNext()) {
                    EObject eo = (EObject)ti.next();
                    if (eo instanceof Profile && ((Profile)eo).getURI().equals(nsSysPhS.toString())) {
                        model.applyProfile((Profile)eo);
                        log.info("Applying SysPhS profile");
                        break;
                    }
                    if (eo instanceof Package) continue;
                    ti.prune();
                }
            } else {
                log.error("Unable to locate the SysPhS profile");
            }
            Resource sysphslibrary = EMFUtil.loadResource(rs, nsSysPhS.appendSegment(nameSysPhSLibrary), lpath);
            if (sysphslibrary != null) {
                TreeIterator<EObject> ti = sysphslibrary.getAllContents();
                while (ti.hasNext()) {
                    EObject eo = (EObject)ti.next();
                    if (eo instanceof Profile && (((Profile)eo).getURI().equals(nsSysPhSPlatformProfile.toString()) || ((Profile)eo).getURI().equals(nsSysPhSExtended.toString()))) {
                        model.applyProfile((Profile)eo);
                        log.info("Applying SysPhS platform profile");
                        break;
                    }
                    if (eo instanceof Package) continue;
                    ti.prune();
                }
            }
            if (sysphslibrary == null) {
                log.error("Unable to locate the SysPhS library");
            }
        }
        return r;
    }

    public static Resource getSimulationLibrary(ResourceSet rs, URI file, List<URI> paths) {
        return EMFUtil.loadResourceWithDependencies(rs, nsSysPhS.appendSegment(nameSysPhSLibrary), paths);
    }

    public class LibraryPort {
        private Port port;
        private String name;

        private LibraryPort(Port port, String name) {
            this.port = port;
            this.name = name;
        }

        public Port getPort() {
            return this.port;
        }

        public String getName() {
            return this.name;
        }
    }

    public class LibraryParameter {
        private Property property;
        private String name;
        private String value;

        private LibraryParameter(Property property, String name, String value) {
            this.property = property;
            this.name = name;
            this.value = value;
        }

        public Property getProperty() {
            return this.property;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public class LibraryComponent {
        private String name;
        private Class clas;
        private List<LibraryParameter> parameters = new LinkedList<LibraryParameter>();
        private List<LibraryPort> ports = new LinkedList<LibraryPort>();

        private LibraryComponent(Class clas, String name) {
            this.clas = clas;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Class getClas() {
            return this.clas;
        }

        public List<LibraryParameter> getParameters() {
            return Collections.unmodifiableList(this.parameters);
        }

        public List<LibraryPort> getPorts() {
            return Collections.unmodifiableList(this.ports);
        }

        public List<LibraryPort> getInputPorts() {
            LinkedList<LibraryPort> ret = new LinkedList<LibraryPort>();
            for (LibraryPort lp : this.ports) {
                EnumerationLiteral el;
                Object o;
                Set<Property> lfp;
                if (!(lp.getPort().getType() instanceof Classifier) || (lfp = SysPhSUtil.this.getAllFlowProperties((Classifier)lp.getPort().getType())).size() != 1 || !((o = lfp.iterator().next().getValue(SysPhSUtil.this.getFlowProperty(), "direction")) instanceof EnumerationLiteral) || (!(el = (EnumerationLiteral)o).getName().equals("in") || lp.getPort().isConjugated()) && (!el.getName().equals("out") || !lp.getPort().isConjugated())) continue;
                ret.add(lp);
            }
            return Collections.unmodifiableList(ret);
        }

        public List<LibraryPort> getOutputPorts() {
            LinkedList<LibraryPort> ret = new LinkedList<LibraryPort>();
            for (LibraryPort lp : this.ports) {
                EnumerationLiteral el;
                Object o;
                Set<Property> lfp;
                if (!(lp.getPort().getType() instanceof Classifier) || (lfp = SysPhSUtil.this.getAllFlowProperties((Classifier)lp.getPort().getType())).size() != 1 || !((o = lfp.iterator().next().getValue(SysPhSUtil.this.getFlowProperty(), "direction")) instanceof EnumerationLiteral) || (!(el = (EnumerationLiteral)o).getName().equals("out") || lp.getPort().isConjugated()) && (!el.getName().equals("in") || !lp.getPort().isConjugated())) continue;
                ret.add(lp);
            }
            return Collections.unmodifiableList(ret);
        }
    }
}

