/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.simulink;

import com.engisis.sysphs.language.simulink.SDoubleValue;
import com.engisis.sysphs.language.simulink.SExpressionValue;
import com.engisis.sysphs.language.stateflow.SChart;
import com.engisis.sysphs.language.stateflow.SData;
import com.engisis.sysphs.language.stateflow.SDataScope;
import com.engisis.sysphs.language.stateflow.SEvent;
import com.engisis.sysphs.language.stateflow.SIdentifiedElement;
import com.engisis.sysphs.language.stateflow.SInstance;
import com.engisis.sysphs.language.stateflow.SJunction;
import com.engisis.sysphs.language.stateflow.SLinkNode;
import com.engisis.sysphs.language.stateflow.SMachine;
import com.engisis.sysphs.language.stateflow.SState;
import com.engisis.sysphs.language.stateflow.SStateflow;
import com.engisis.sysphs.language.stateflow.STarget;
import com.engisis.sysphs.language.stateflow.STransition;
import com.engisis.sysphs.language.stateflow.STreeNode;
import com.engisis.sysphs.util.XMLWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StateflowXMLWriter
extends XMLWriter {
    public StateflowXMLWriter(XMLStreamWriter xmlsw) {
        super(xmlsw);
    }

    public void positionState(SState sstate) throws XMLStreamException {
        if (sstate.getOwningTreeNode() != null) {
            int pos = sstate.getOwningTreeNode().getTreeNode().indexOf(sstate);
            int w = 100;
            int h = 40;
            int m = 20;
            int x1 = m + m * pos + pos * w;
            int x2 = w;
            int y1 = m;
            int y2 = h;
            String position = "[" + x1 + " " + y1 + " " + x2 + " " + y2 + "]";
            this.property("position", position);
        }
    }

    public void visit(SChart object) throws XMLStreamException {
        this.startElement("chart");
        this.attribute("id", String.valueOf(object.getId()));
        if (object.getName() != null) {
            this.property("name", object.getName());
        }
        this.property("viewObj", String.valueOf(object.getId()));
        this.property("toolbarMode", "LIBRARY_TOOLBAR");
        this.property("decomposition", "CLUSTER_CHART");
        this.property("chartFileNumber", String.valueOf(object.getOwningMachine().getChart().indexOf(object) + 1));
        this.property("saturateOnIntegerOverflow", "1");
        this.property("userSpecifiedStateTransitionExecutionOrder", "1");
        this.property("disableImplicitCasting", "1");
        this.property("actionLanguage", "2");
        this.startElement("Children");
        for (STreeNode streenode : object.getTreeNode()) {
            streenode.accept(this.getDispatcher());
        }
        for (SLinkNode slinknode : object.getLinkNode()) {
            slinknode.accept(this.getDispatcher());
        }
        this.endElement();
        this.endElement();
    }

    public void visit(SData object) throws XMLStreamException {
        this.startElement("data");
        this.attribute("SSID", String.valueOf(object.getId()));
        if (object.getName() != null) {
            this.attribute("name ", object.getName());
        }
        if (object.getScope() == SDataScope.INPUT) {
            this.property("scope", "INPUT_DATA");
        } else if (object.getScope() == SDataScope.OUTPUT) {
            this.property("scope", "OUTPUT_DATA");
        } else if (object.getScope() == SDataScope.CONSTANT) {
            this.property("scope", "CONSTANT_DATA");
        }
        if (object.getValue() != null) {
            this.startElement("props");
            this.startElement("P");
            this.attribute("Name", "initialValue");
            object.getValue().accept(this.getDispatcher());
            this.endElement();
            this.endElement();
        }
        this.endElement();
    }

    public void visit(SEvent object) throws XMLStreamException {
        this.startElement("event");
        this.attribute("id", String.valueOf(object.getId()));
        if (object.getName() != null) {
            this.attribute("name", String.valueOf(object.getName()));
        }
        this.endElement();
    }

    public void visit(SExpressionValue object) throws XMLStreamException {
        this.characters(object.getValue());
    }

    public void visit(SInstance object) throws XMLStreamException {
        this.startElement("instance");
        this.attribute("id", String.valueOf(object.getId()));
        if (object.getName() != null) {
            this.property("name", object.getName());
        }
        if (object.getMachine() != null) {
            this.property("machine", String.valueOf(object.getMachine().getId()));
        }
        if (object.getChart() != null) {
            this.property("chart", String.valueOf(object.getChart().getId()));
        }
        this.endElement();
    }

    public void visit(SJunction object) throws XMLStreamException {
        this.startElement("junction");
        this.attribute("SSID", String.valueOf(object.getId()));
        this.endElement();
    }

    public void visit(SMachine object) throws XMLStreamException {
        this.startElement("machine");
        this.attribute("id", String.valueOf(object.getId()));
        this.property("created", new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date()));
        this.property("isLibrary", "1");
        this.property("sfVersion", "76014001.002");
        this.startElement("Children");
        if (object.getTarget() != null) {
            object.getTarget().accept(this.getDispatcher());
        }
        for (SChart schart : object.getChart()) {
            schart.accept(this.getDispatcher());
        }
        this.endElement();
        this.endElement();
    }

    public void visit(SDoubleValue object) throws XMLStreamException {
        this.characters(String.valueOf(object.getValue()));
    }

    public void visit(SState object) throws XMLStreamException {
        this.startElement("state");
        this.attribute("SSID", String.valueOf(object.getId()));
        String label = object.getLabel() == null ? object.getName() : object.getName() + "\n" + object.getLabel();
        this.property("labelString", label);
        this.positionState(object);
        this.property("subviewer", String.valueOf(object.getOwningTreeNode().getId()));
        this.property("type", "OR_STATE");
        this.property("decomposition", "CLUSTER_STATE");
        if (object.getTreeNode().size() != 0 || object.getTreeNode().size() != 0) {
            this.startElement("Children");
            for (STreeNode streenode : object.getTreeNode()) {
                streenode.accept(this.getDispatcher());
            }
            for (SLinkNode slinknode : object.getLinkNode()) {
                slinknode.accept(this.getDispatcher());
            }
            this.endElement();
        }
        this.endElement();
    }

    public void visit(SStateflow object) throws XMLStreamException {
        this.startElement("Stateflow");
        if (object.getMachine() != null) {
            object.getMachine().accept(this.getDispatcher());
        }
        for (SInstance sinstance : object.getInstance()) {
            sinstance.accept(this.getDispatcher());
        }
        this.endElement();
    }

    public void visit(STarget object) throws XMLStreamException {
        this.startElement("target");
        this.attribute("id", String.valueOf(object.getId()));
        this.attribute("name", "sfun");
        this.property("description", "Default Simulink S-Function Target.");
        this.endElement();
    }

    public void visit(STransition object) throws XMLStreamException {
        this.startElement("transition");
        this.attribute("SSID", String.valueOf(object.getId()));
        if (object.getLabel() != null) {
            this.property("labelString", object.getLabel());
        }
        this.startElement("src");
        if (object.getSrc() != null) {
            this.property("SSID", String.valueOf(((SIdentifiedElement)((Object)object.getSrc())).getId()));
        }
        this.endElement();
        this.startElement("dst");
        if (object.getDst() != null) {
            this.property("SSID", String.valueOf(((SIdentifiedElement)((Object)object.getDst())).getId()));
        }
        this.endElement();
        if (object.getSrc() != null) {
            this.property("executionOrder", String.valueOf(object.getSrc().getOutgoing().indexOf(object) + 1));
        } else {
            this.property("executionOrder", "1");
        }
        this.endElement();
    }

    private void property(String name, String value) throws XMLStreamException {
        this.startElement("P");
        this.attribute("Name", name);
        this.characters(value);
        this.endElement();
    }
}

