/*
 * Decompiled with CFR 0.152.
 */
package com.engisis.sysphs.serialization.simulink;

import com.engisis.sysphs.language.simscape.SComponent;
import com.engisis.sysphs.language.simscape.SDomain;
import com.engisis.sysphs.language.simscape.SPackage;
import com.engisis.sysphs.language.simulink.SBlock;
import com.engisis.sysphs.language.simulink.SFunction1;
import com.engisis.sysphs.language.simulink.SFunction1Block;
import com.engisis.sysphs.language.simulink.SFunction2;
import com.engisis.sysphs.language.simulink.SFunction2Block;
import com.engisis.sysphs.language.simulink.SLibrary;
import com.engisis.sysphs.language.simulink.SModel;
import com.engisis.sysphs.language.simulink.SReference;
import com.engisis.sysphs.language.simulink.SSubsystem;
import com.engisis.sysphs.language.simulink.SSystem;
import com.engisis.sysphs.language.stateflow.SStateflow;
import com.engisis.sysphs.serialization.simulink.SimscapeWriter;
import com.engisis.sysphs.serialization.simulink.SimulinkMDLWriter;
import com.engisis.sysphs.serialization.simulink.SimulinkSF1Writer;
import com.engisis.sysphs.serialization.simulink.SimulinkSF2Writer;
import com.engisis.sysphs.serialization.simulink.SimulinkSimscapeMDLWriter;
import com.engisis.sysphs.serialization.simulink.SimulinkSimscapeXMLWriter;
import com.engisis.sysphs.serialization.simulink.SimulinkStateflowMDLWriter;
import com.engisis.sysphs.serialization.simulink.SimulinkStateflowXMLWriter;
import com.engisis.sysphs.serialization.simulink.SimulinkXMLWriter;
import com.engisis.sysphs.serialization.simulink.StateflowMDLWriter;
import com.engisis.sysphs.serialization.simulink.StateflowXMLWriter;
import com.engisis.sysphs.translation.simulink.SysMLToSimulinkTranslator;
import com.engisis.sysphs.util.Dispatcher;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;

public class SimulinkSerializer {
    private static final Logger log = Logger.getLogger(SimulinkSerializer.class);
    private String dir;

    public String serialize(String directory, SModel smodel, SLibrary slibrary, SStateflow sstateflow, SPackage spackage, SysMLToSimulinkTranslator.Format format) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("The directory can't be null");
        }
        if (smodel == null) {
            throw new IllegalArgumentException("The model can't be null");
        }
        if (slibrary == null) {
            throw new IllegalArgumentException("The library can't be null");
        }
        if (sstateflow == null) {
            throw new IllegalArgumentException("The stateflow can't be null");
        }
        this.dir = directory;
        if (slibrary.getSystem().getOwnedBlocks().size() != 0 || sstateflow.getMachine().getChart().size() != 0) {
            if (format == SysMLToSimulinkTranslator.Format.XML) {
                this.saveXML(slibrary, sstateflow);
            } else {
                this.saveMDL(slibrary, sstateflow);
            }
        }
        String filename = null;
        filename = format == SysMLToSimulinkTranslator.Format.XML ? this.saveXML(smodel, null) : this.saveMDL(smodel, null);
        this.saveSFunctions(smodel);
        if (spackage != null) {
            this.saveSimscape(spackage);
        }
        return filename;
    }

    private String saveMDL(SModel smodel, SStateflow sstateflow) {
        String filename = this.dir + File.separator + smodel.getName() + ".mdl";
        try {
            log.debug("Saving model to " + filename);
            FileWriter fw = new FileWriter(filename);
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.addVisitor(new SimulinkMDLWriter(fw));
            dispatcher.addVisitor(new SimulinkStateflowMDLWriter(fw));
            dispatcher.addVisitor(new SimulinkSimscapeMDLWriter(fw));
            smodel.accept(dispatcher);
            if (sstateflow != null && sstateflow.getMachine().getChart().size() != 0) {
                Dispatcher dispatcher2 = new Dispatcher();
                dispatcher2.addVisitor(new StateflowMDLWriter(fw));
                sstateflow.accept(dispatcher2);
            }
            fw.close();
        }
        catch (Exception e) {
            log.error("Can't save the file at the location " + filename, e);
        }
        return filename;
    }

    private String saveXML(SModel smodel, SStateflow sstateflow) {
        String filename = this.dir + File.separator + smodel.getName() + ".slx";
        try {
            log.debug("Saving model to " + filename);
            XMLOutputFactory xmlof = XMLOutputFactory.newFactory();
            StringWriter sw = new StringWriter();
            XMLStreamWriter xmlsw = xmlof.createXMLStreamWriter(sw);
            xmlsw.writeStartDocument("utf-8", "1.0");
            xmlsw.writeStartElement("ModelInformation");
            xmlsw.writeAttribute("Version", "0.9");
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.addVisitor(new SimulinkXMLWriter(xmlsw));
            dispatcher.addVisitor(new SimulinkStateflowXMLWriter(xmlsw));
            dispatcher.addVisitor(new SimulinkSimscapeXMLWriter(xmlsw));
            smodel.accept(dispatcher);
            if (sstateflow != null && sstateflow.getMachine().getChart().size() != 0) {
                Dispatcher dispatcher2 = new Dispatcher();
                dispatcher2.addVisitor(new StateflowXMLWriter(xmlsw));
                sstateflow.accept(dispatcher2);
            }
            xmlsw.writeEndElement();
            xmlsw.writeEndDocument();
            xmlsw.flush();
            xmlsw.close();
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedOutputStream bod = new BufferedOutputStream(fos);
            ZipOutputStream zos = new ZipOutputStream(bod);
            zos.putNextEntry(new ZipEntry("simulink/blockdiagram.xml"));
            zos.write(sw.toString().getBytes());
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry("[Content_Types].xml"));
            zos.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>".getBytes());
            zos.write("<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">".getBytes());
            zos.write("<Default ContentType=\"image/png\" Extension=\"png\"/>".getBytes());
            zos.write("<Default ContentType=\"application/vnd.openxmlformats-package.relationships+xml\" Extension=\"rels\"/>".getBytes());
            zos.write("<Default ContentType=\"application/vnd.mathworks.simulink.mdl+xml\" Extension=\"xml\"/>".getBytes());
            zos.write("<Override ContentType=\"application/vnd.openxmlformats-package.core-properties+xml\" PartName=\"/metadata/coreProperties.xml\"/>".getBytes());
            zos.write("<Override ContentType=\"application/vnd.mathworks.package.coreProperties+xml\" PartName=\"/metadata/mwcoreProperties.xml\"/>".getBytes());
            zos.write("</Types>".getBytes());
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry("_rels/.rels"));
            zos.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>".getBytes());
            zos.write("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">".getBytes());
            zos.write("<Relationship Id=\"blockDiagram\" Target=\"simulink/blockdiagram.xml\" Type=\"http://schemas.mathworks.com/simulink/2010/relationships/blockDiagram\"/>".getBytes());
            zos.write("</Relationships>".getBytes());
            zos.close();
        }
        catch (IOException e) {
            log.error("Can't save the file at the location " + filename, e);
        }
        catch (XMLStreamException e) {
            log.error("Can't save the file at the location " + filename, e);
        }
        return filename;
    }

    private void saveSFunctions(SModel smodel) {
        Stack<SSystem> ssystems = new Stack<SSystem>();
        HashSet<SSystem> processed = new HashSet<SSystem>();
        ssystems.add(smodel.getSystem());
        while (!ssystems.isEmpty()) {
            SSystem ss = (SSystem)ssystems.pop();
            processed.add(ss);
            for (SBlock sb : ss.getOwnedBlocks()) {
                SSystem ss2;
                Dispatcher dispatcher;
                FileWriter fw;
                String target;
                if (sb instanceof SFunction1Block) {
                    SFunction1 sf1 = ((SFunction1Block)sb).getSfunction();
                    if (sf1.getName().equals("sf_sfun")) continue;
                    target = this.dir + File.separator + sf1.getName() + ".m";
                    log.debug("Saving sfunction to " + target);
                    try {
                        fw = new FileWriter(target);
                        dispatcher = new Dispatcher();
                        dispatcher.addVisitor(new SimulinkSF1Writer(fw));
                        sf1.accept(dispatcher);
                        fw.close();
                    }
                    catch (IOException e) {
                        log.error("Unable to save SFunction " + target, e);
                    }
                    continue;
                }
                if (sb instanceof SFunction2Block) {
                    SFunction2 sf2 = ((SFunction2Block)sb).getSfunction();
                    target = this.dir + File.separator + sf2.getName() + ".m";
                    log.debug("Saving sfunction to " + target);
                    try {
                        fw = new FileWriter(target);
                        dispatcher = new Dispatcher();
                        dispatcher.addVisitor(new SimulinkSF2Writer(fw));
                        sf2.accept(dispatcher);
                        fw.close();
                    }
                    catch (IOException e) {
                        log.error("Unable to save SFunction " + target, e);
                    }
                    continue;
                }
                if (sb instanceof SSubsystem) {
                    ss2 = ((SSubsystem)sb).getSystem();
                    if (processed.contains(ss2)) continue;
                    ssystems.push(ss2);
                    continue;
                }
                if (!(sb instanceof SReference) || processed.contains(ss2 = ((SReference)sb).getSystem())) continue;
                ssystems.push(ss2);
            }
        }
    }

    private void saveSimscape(SPackage spackage) throws IOException {
        Dispatcher dispatcher;
        StringWriter sw;
        FileWriter fw;
        String dtarget = this.dir + File.separator + "+" + spackage.getName();
        File dir = new File(dtarget);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException("The target must be a directory:" + dtarget);
            }
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".ssc") || file.delete()) continue;
                log.warn("Unable to delete file " + file.getAbsolutePath());
            }
        } else if (!dir.mkdir()) {
            throw new IOException("Unable to create the directory " + dir.getAbsolutePath());
        }
        for (SDomain sdomain : spackage.getDomains()) {
            try {
                String target = dtarget + File.separator + sdomain.getName() + ".ssc";
                log.info("Saving domain into " + target);
                fw = new FileWriter(target);
                sw = new StringWriter();
                dispatcher = new Dispatcher();
                dispatcher.addVisitor(new SimscapeWriter(sw));
                sdomain.accept(dispatcher);
                fw.write(sw.toString());
                fw.close();
                log.info("Saved domain into " + target);
            }
            catch (IOException e) {
                log.error("Can't save the element " + sdomain.getName(), e);
                throw e;
            }
        }
        for (SComponent scomponent : spackage.getComponents()) {
            try {
                String target = dtarget + File.separator + scomponent.getName() + ".ssc";
                log.info("Saving component into " + target);
                fw = new FileWriter(target);
                sw = new StringWriter();
                dispatcher = new Dispatcher();
                dispatcher.addVisitor(new SimscapeWriter(sw));
                scomponent.accept(dispatcher);
                fw.write(sw.toString());
                fw.close();
                log.info("Saved component into " + target);
            }
            catch (IOException e) {
                log.error("Can't save the element " + scomponent.getName(), e);
                throw e;
            }
        }
    }
}

